#region Using declarations

using System;

#endregion

//This namespace holds Add ons in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.AddOns
{
    public class Sim22_HaUtilities
    {
	    public enum HeikenAshiCalculationType
        {
            None,
	        DanValcu,
            //DanValcuSmoothed,
            SylvainVervoort,
            //SylvainVervoortSmoothed
        }

	    public enum HeikenAshiSmoothingType
	    {
	        None,
            EMA,
            HMA,
            SMA,     
	    }
        public struct HeikenAshiValues
        {
            public double HaOpen;
            public double HaHigh;
            public double HaLow;
            public double HaClose;
        }

        public struct OhlcValues
        {
            public double Open;
            public double High;
            public double Low;
            public double Close;
        }

        public HeikenAshiValues GetHeikenAshi(HeikenAshiCalculationType heikenAshiCalculationType, ISeries<HeikenAshiValues> heikenAshiSeries, ISeries<OhlcValues> ohlcValues)
	    {
            HeikenAshiValues haValues = new HeikenAshiValues();

            double weightedPrice0 = (ohlcValues[0].Open + ohlcValues[0].High + ohlcValues[0].Low + ohlcValues[0].Close) * 0.25;
            double weightedPrice1 = (ohlcValues[1].Open + ohlcValues[1].High + ohlcValues[1].Low + ohlcValues[1].Close) * 0.25;

            switch (heikenAshiCalculationType)
            {
	            case HeikenAshiCalculationType.DanValcu:
                    haValues.HaOpen = ((heikenAshiSeries[1].HaOpen + heikenAshiSeries[1].HaClose) * 0.5); // Calculate the open
                    haValues.HaHigh = (Math.Max(ohlcValues[0].High, haValues.HaOpen)); // Calculate the high
                    haValues.HaLow = (Math.Min(ohlcValues[0].Low, haValues.HaOpen)); // Calculate the low
                    haValues.HaClose = weightedPrice0; // Calculate the close
                    break;
                case HeikenAshiCalculationType.SylvainVervoort:
                    haValues.HaOpen = (heikenAshiSeries[1].HaOpen + weightedPrice1) * 0.5; // Calculate the open
                    haValues.HaHigh = Math.Max(ohlcValues[0].High, haValues.HaOpen); // Calculate the high
                    haValues.HaLow = Math.Min(ohlcValues[0].Low, haValues.HaOpen); // Calculate the low
                    haValues.HaClose = (weightedPrice0 + haValues.HaOpen + haValues.HaHigh + haValues.HaLow) * 0.25;// Calculate the close
                    break;
            }
            //else if (heikenAshiCalculationType == anaHeikinAshiType.Dan_Valcu_Smoothed)
            //{
            //    HAOpen.Set((HAOpen[1] + HAClose[1]) * 0.5); // Calculate the open
            //    HAHigh.Set(Math.Max(HighMA[0], HAOpen[0])); // Calculate the high
            //    HALow.Set(Math.Min(LowMA[0], HAOpen[0])); // Calculate the low
            //    HAClose.Set((OpenMA[0] + HighMA[0] + LowMA[0] + CloseMA[0]) * 0.25); // Calculate the close
            //}
            //else if (heikenAshiCalculationType == anaHeikinAshiType.Sylvain_Vervoort_Smoothed)
            //{
            //    HAOpen.Set((HAOpen[1] + (OpenMA[1] + HighMA[1] + LowMA[1] + CloseMA[1]) * 0.25) * 0.5); // Calculate the open
            //    HAHigh.Set(Math.Max(HighMA[0], HAOpen[0])); // Calculate the high
            //    HALow.Set(Math.Min(LowMA[0], HAOpen[0])); // Calculate the low
            //    HAClose.Set((((OpenMA[0] + HighMA[0] + LowMA[0] + CloseMA[0]) * 0.25) + HAOpen[0] + HAHigh[0] + HALow[0]) * 0.25);// Calculate the close
            //}
            return haValues;

	    }
	}
	
}
