#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.Indicators;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Strategies in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Strategies
{
	public class DeltaStrategyTest : Strategy
	{
		NinjaTrader.NinjaScript.Indicators.Sim22.Sim22_DeltaV3 myDeltaSeries;
			
		GaplessEmaTypeEnum emaType = GaplessEmaTypeEnum.None;
		
		NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaCalculationTypeEnum calcType = NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaCalculationTypeEnum.BidAsk;
		NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaCotType cotType = NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaCotType.None;			
		NinjaTrader.NinjaScript.AddOns.Sim22_HaUtilities.HeikenAshiCalculationType haType = NinjaTrader.NinjaScript.AddOns.Sim22_HaUtilities.HeikenAshiCalculationType.None;
		NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaTradeSizeFilterTypeEnum sizeFilter = NinjaTrader.NinjaScript.AddOns.Sim22_DeltaUtilities.DeltaTradeSizeFilterTypeEnum.None;
		DeltaV3BarWidthTypeEnum deltaV3BarType = DeltaV3BarWidthTypeEnum.Auto;
		
		// See here: http://ninjatrader.com/support/helpGuides/nt8/en-us/?developing_for__tick_replay.htm
			
		protected override void OnStateChange()
		{
			
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Strategy here.";
				Name										= "DeltaStrategyTest";
				Calculate									= Calculate.OnEachTick;
				EntriesPerDirection							= 1;
				EntryHandling								= EntryHandling.AllEntries;
				IsExitOnSessionCloseStrategy				= true;
				ExitOnSessionCloseSeconds					= 30;
				IsFillLimitOnTouch							= false;
				MaximumBarsLookBack							= MaximumBarsLookBack.TwoHundredFiftySix;
				OrderFillResolution							= OrderFillResolution.Standard;
				Slippage									= 0;
				StartBehavior								= StartBehavior.WaitUntilFlat;
				TimeInForce									= TimeInForce.Gtc;
				TraceOrders									= false;
				RealtimeErrorHandling						= RealtimeErrorHandling.StopCancelClose;
				StopTargetHandling							= StopTargetHandling.PerEntryExecution;
				BarsRequiredToTrade							= 20;
				// Disable this property for performance gains in Strategy Analyzer optimizations
				// See the Help Guide for additional information
				IsInstantiatedOnEachOptimizationIteration	= true;
			}
			else if (State == State.Configure)
			{
				// you should always use try-catch statement to catch exceptions and avoid crashing NT8.
				try
				{
					// Instantiated once so it frees up resources :)
					// Adjust these values to your taste.
					// Tested only with these settings.
					myDeltaSeries = Sim22_DeltaV3(deltaV3BarType, calcType, cotType, true, false, false, emaType, 1, sizeFilter, 1, haType, false, false, false);
				
					AddChartIndicator(myDeltaSeries); // optional
				}
				// Print the exception to the output box.
				catch (Exception ex) {Print(Name + " State.Configure: " + ex);}
			}
		}

		protected override void OnBarUpdate()
		{
			double myDelta = myDeltaSeries.DeltaClose[0];
			
			// Do something with this delta value
		}
	}
}
