//+------------------------------------------------------------------+
//|                                          MAadaptive (rsi+r2).mq4 |
//|                                                                  |
//| based on MA adaptive R2 and                                      |
//|          MA adaptive RSI by Perry Kaufman                        |
//+------------------------------------------------------------------+
#property copyright "copyleft mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_color2 Red

//
//
//
//
//

extern int MAadaptive.rsi.period = 20;
extern int MAadaptive.rsi.price  = PRICE_CLOSE;
extern int MAadaptive.r2.period  = 20;
extern int MAadaptive.r2.price   = PRICE_CLOSE;

//
//
//
//
//

double buffer1[];
double buffer2[];
double prices1[];
double prices2[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(4);
      SetIndexBuffer(0,buffer1);
      SetIndexBuffer(1,buffer2);
      SetIndexBuffer(2,prices1);
      SetIndexBuffer(3,prices2);
   return(0);
}
int deinit() { return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int      countedBars=IndicatorCounted();
   int      i,limit;

   if (countedBars<0) return(-1);
   if (countedBars>0) countedBars--;
         limit = Bars-countedBars;

   //
   //
   //
   //
   //

      
   for(i = limit; i >=0; i--)
   {
      prices1[i] = iMA(NULL,0,1,0,MODE_SMA,MAadaptive.rsi.price,i);
      prices2[i] = iMA(NULL,0,1,0,MODE_SMA,MAadaptive.r2.price ,i);
      
      //
      //
      //
      //
      //
      
      if (i>Bars-MAadaptive.rsi.period)  buffer1[i]=prices1[i];
      else           
      {
         double sc = 2.0*MathAbs(iRSI(NULL,0,MAadaptive.rsi.period,MAadaptive.rsi.price,i)/100.0-0.5);
         buffer1[i] = buffer1[i+1] + sc*(prices1[i]-buffer1[i+1]);
      }         
      if (i>Bars-MAadaptive.r2.period)  buffer2[i]=prices2[i];
      else           
      {
         double r2 = MathPow(iCorrelation(prices2,MAadaptive.r2.period,i),2);
         buffer2[i] = buffer2[i+1] + r2*(prices2[i]-buffer2[i+1]);
      }
   }
   
   //
   //
   //
   //
   //
   
   return(0);
}



//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double iCorrelation(double& array[],int period,int i)
{
   int matches = 0;
   for (int k=0; k<period; k++)
   {
      if (array[i+k] <= array[i+k+1]) continue;
      matches++;
   }
   return (2.0*matches/period-1);
}