#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using System.Windows.Forms;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
   	///	28 February 2010. Version 1.0 Posted by MXASJ
	///	4 March 2010. Version 2.0 posted by MXASJ. 
	///	27 March 2010. v2.10 MXASJ Changed code to solve 'Add' issue with second dataseries.
	///	30 March 2010. v3.00 MXASJ Modified to be a RATIO indicator and changed name to Ratio2Instrument
	/// 7 April 2010.  v3.10 MXASJ Added a few ideas from kdorden's indicators
	/// 13 May 2010.   v3.11 MXASJ Added error checks and cleaned up the code.
	/// 16 May 2010.   v3.12 MXASJ More code cleamup. Posted at BMT Indicators section.
	
    [Description("Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.")]
    public class Ratio2Instrument : Indicator
    {
        
            private int nominatorQuantity			= 1; 	// Default setting for Quantity
            private int denominatorQuantity 		= 1; 	// Default setting for denominatorQuantity
            private string denominatorInstrument 	= @""; 	// Default setting for denominatorInstrument
		
			private double			ratioRough;
			private DataSeries 		myRatio;
			
			private int 			barValue; 
       

        
        protected override void Initialize()///////////////////////////////////////////////////
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.SlateGray), PlotStyle.Line, "Ratio"));
            CalculateOnBarClose	= true;
			BarsRequired		= 0;
            Overlay				= false;
			barValue			=  Math.Max(1, base.BarsPeriod.Value);
			Add(denominatorInstrument, BarsPeriod.Id, barValue);
			myRatio 			= new DataSeries(this);
			
        }
		protected override void OnStartUp()////////////////////////////////////////////////////
		{
		if (denominatorInstrument == "")
			{
				Log("ERROR: INDICATOR Ratio2Instrument. Denominator Instrument field is blank.", LogLevel.Error);
				Print(Time[0] + " ERROR: INDICATOR Ratio2Instrument. Denominator Instrument field is blank.");
				MessageBox.Show("ERROR: INDICATOR Ratio2Instrument. Denominator Instrument field is blank");
				return;
			}
		}	
		private void RatioCalculator()
		{
			try
			{
			ratioRough = (Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity);
			myRatio.Set(Math.Round(ratioRough, 2));
			}
			catch (Exception e)
			{
			Print(Time[0]+ " Indicator Ratio2Instrument on " + Instrument.FullName+ " Error: Ratio Calculation Error "
				+ e.ToString());
			}
		}
        
        protected override void OnBarUpdate()////////////////////////////////////////////////
        {
            if (denominatorInstrument == ""||denominatorInstrument == Instrument.FullName) return;
			if (CurrentBars[0] < 1) return;
			if (CurrentBars[1] < 1) return;
			
			RatioCalculator();
			try
			{
				Value.Set(myRatio[0]);
			}
			catch (Exception e)
			{
				Print(Time[0] + " Indicator Ratio2Instrument on " + Instrument.FullName+ " Error: Error on Value.Set(myRatio[0]) "
				+ e.ToString());
			}
			
        }
		
		public override string ToString()
		{
			// For the chart label.
				return Name + " (" + Instrument.FullName + "*" + nominatorQuantity + " / " + denominatorInstrument + "*"
				+ denominatorQuantity + ")";
		}
		

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MyRatio
        {
            get { return myRatio; }
        }

        [Description("Quantity of the primary instrument or nominator")]
        [GridCategory("Parameters")]
        public int NominatorQuantity
        {
            get { return nominatorQuantity; }
            set { nominatorQuantity = Math.Max(1, value); }
        }

        [Description("Quantity of the second instrument or denominator")]
        [GridCategory("Parameters")]
        public int DenominatorQuantity
        {
            get { return denominatorQuantity; }
            set { denominatorQuantity = Math.Max(1, value); }
        }

        [Description("Second instrument or denominator")]
        [GridCategory("Parameters")]
        public string DenominatorInstrument
        {
            get { return denominatorInstrument; }
            set { denominatorInstrument = value; }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Ratio2Instrument[] cacheRatio2Instrument = null;

        private static Ratio2Instrument checkRatio2Instrument = new Ratio2Instrument();

        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        public Ratio2Instrument Ratio2Instrument(string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            return Ratio2Instrument(Input, denominatorInstrument, denominatorQuantity, nominatorQuantity);
        }

        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        public Ratio2Instrument Ratio2Instrument(Data.IDataSeries input, string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            if (cacheRatio2Instrument != null)
                for (int idx = 0; idx < cacheRatio2Instrument.Length; idx++)
                    if (cacheRatio2Instrument[idx].DenominatorInstrument == denominatorInstrument && cacheRatio2Instrument[idx].DenominatorQuantity == denominatorQuantity && cacheRatio2Instrument[idx].NominatorQuantity == nominatorQuantity && cacheRatio2Instrument[idx].EqualsInput(input))
                        return cacheRatio2Instrument[idx];

            lock (checkRatio2Instrument)
            {
                checkRatio2Instrument.DenominatorInstrument = denominatorInstrument;
                denominatorInstrument = checkRatio2Instrument.DenominatorInstrument;
                checkRatio2Instrument.DenominatorQuantity = denominatorQuantity;
                denominatorQuantity = checkRatio2Instrument.DenominatorQuantity;
                checkRatio2Instrument.NominatorQuantity = nominatorQuantity;
                nominatorQuantity = checkRatio2Instrument.NominatorQuantity;

                if (cacheRatio2Instrument != null)
                    for (int idx = 0; idx < cacheRatio2Instrument.Length; idx++)
                        if (cacheRatio2Instrument[idx].DenominatorInstrument == denominatorInstrument && cacheRatio2Instrument[idx].DenominatorQuantity == denominatorQuantity && cacheRatio2Instrument[idx].NominatorQuantity == nominatorQuantity && cacheRatio2Instrument[idx].EqualsInput(input))
                            return cacheRatio2Instrument[idx];

                Ratio2Instrument indicator = new Ratio2Instrument();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.DenominatorInstrument = denominatorInstrument;
                indicator.DenominatorQuantity = denominatorQuantity;
                indicator.NominatorQuantity = nominatorQuantity;
                Indicators.Add(indicator);
                indicator.SetUp();

                Ratio2Instrument[] tmp = new Ratio2Instrument[cacheRatio2Instrument == null ? 1 : cacheRatio2Instrument.Length + 1];
                if (cacheRatio2Instrument != null)
                    cacheRatio2Instrument.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheRatio2Instrument = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Ratio2Instrument Ratio2Instrument(string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            return _indicator.Ratio2Instrument(Input, denominatorInstrument, denominatorQuantity, nominatorQuantity);
        }

        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        public Indicator.Ratio2Instrument Ratio2Instrument(Data.IDataSeries input, string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            return _indicator.Ratio2Instrument(input, denominatorInstrument, denominatorQuantity, nominatorQuantity);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Ratio2Instrument Ratio2Instrument(string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            return _indicator.Ratio2Instrument(Input, denominatorInstrument, denominatorQuantity, nominatorQuantity);
        }

        /// <summary>
        /// Plots the ratio between two Instruments. Calculated as Closes[0][0]*nominatorQuantity)/(Closes[1][0]*denominatorQuantity.
        /// </summary>
        /// <returns></returns>
        public Indicator.Ratio2Instrument Ratio2Instrument(Data.IDataSeries input, string denominatorInstrument, int denominatorQuantity, int nominatorQuantity)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Ratio2Instrument(input, denominatorInstrument, denominatorQuantity, nominatorQuantity);
        }
    }
}
#endregion
