#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
using NinjaTrader.Cbi;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    [Description("(Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system")]
	[Gui.Design.DisplayName("BrooksBars")]
	public class BrooksBars : Indicator
    {
		
        #region Variables
		private int H = 0;
		private int L = 0;
		private int brooksH = 0;
		private int brooksHprev = 0;
		private int brooksL = 0;
		private int brooksLprev = 0;
		private string LabelH = "H";
		private string LabelL = "L";
		private bool drawLabel = true; // drawLabel on/off
		private int numofLabels = 3; // x labels on Cart
		private bool outsidebar = false; // Outsidebar labeling depends on prior bars on/off 
		private int textTicksOffset = 2; // Default setting for text ticks offset from bars
		private Font textFont	= new Font("Courier", 9, FontStyle.Regular);
		private Color textColorH = Color.DimGray; // Color of H
		private Color textColorL = Color.DimGray; // Color of L
		//===== Inside Bar =====================
		private bool drawInsideBar		= true;
		private int insideOffset		= 0;
		private int insideCalc			= 2;
		private Color insideColor		= Color.Gray;
		private double insidePosL		= 0;
		private double insidePosH		= 0;
		
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			PaintPriceMarkers 	= false;
			Overlay				= true;		
			CalculateOnBarClose = true;
		}

        protected override void OnBarUpdate()	
        {			
			if (CurrentBar == 0)
			{
				return;
			}

			if (drawLabel == true) // show all history labels
			{
				LabelH = "H"+CurrentBar;
				LabelL = "L"+CurrentBar;
			}
			else // drawLabel on
			{
				{
					if (brooksHprev == numofLabels)
					{
						brooksH = 1;
					}
					else
					{
						brooksH = brooksHprev + 1;
					}
						LabelH = "H"+brooksH;
				}
				{
					if (brooksLprev == numofLabels)
					{
						brooksL = 1;
					}
					else
					{
						brooksL = brooksLprev + 1;
					}
						LabelL = "L"+brooksL;
				}
			}
			//===============================  OUTSIDEBAR
			if (High[0] > High[1] && Low[0] < Low[1] && FirstTickOfBar) // outside bar
			{
				if ( outsidebar == true) // Outsidebar labeling depends on prior labeling
				{
					if (L == 1 && Close[0] > Open[0] && FirstTickOfBar) // outside H
					{
						DrawText(LabelH, false, "H", 0, High[0] + TextTicksOffset * TickSize, 0, textColorH, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						DrawText(LabelL, false, "O", 0, Low[0] - TextTicksOffset * TickSize, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						H = 1;
						L = 0;
						brooksHprev = brooksH;
					}
					else if (H == 1 && Close[0] < Open[0] && FirstTickOfBar)// outside L
					{	
						DrawText(LabelL, false, "L", 0, Low[0] - TextTicksOffset * TickSize, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						DrawText(LabelH, false, "O", 0, High[0] + TextTicksOffset * TickSize, 0, textColorH, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						H = 0;
						L = 1;
						brooksLprev = brooksL;
					}
					else  if (FirstTickOfBar) // Outsidebar labeling starts neutral with H and L
					{
						DrawText(LabelH, false, "O", 0, High[0] + TextTicksOffset * TickSize, 0, textColorH, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						DrawText(LabelL, false, "O", 0, Low[0] - TextTicksOffset * TickSize, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						H = 1;
						L = 1;
						brooksHprev = brooksH;
						brooksLprev = brooksL;	
					}
				}
				else if (FirstTickOfBar) // Outsidebar labeling starts neutral with H and L
				{
					DrawText(LabelH, false, "O", 0, High[0] + TextTicksOffset * TickSize, 0, textColorH, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
					DrawText(LabelL, false, "O", 0, Low[0] - TextTicksOffset * TickSize, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
					H = 1;
					L = 1;
					brooksHprev = brooksH;	
					brooksLprev = brooksL;	
				}	
			}
			//======================= "H" BARS ===========================================
			else if (High[0] > High[1] && L == 1 && FirstTickOfBar) // H bar
			{
				DrawText(LabelH, false, "H", 0, High[0] + TextTicksOffset * TickSize, 0, textColorH, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
				H = 1;
				L = 0;
				brooksHprev = brooksH;	
			}
			//================== "L" BARS   ===============================================
			else if (Low[0] < Low[1] && H == 1 && FirstTickOfBar) // L bar
			{
				DrawText(LabelL, false, "L", 0, Low[0] - TextTicksOffset * TickSize, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
				H = 0;
				L = 1;
				brooksLprev = brooksL;
			}
			
			//================= INSIDE BAR ==============
			if (drawInsideBar)
			{
				insidePosL = Low[1] + (insideCalc * TickSize);
				insidePosH = High[1] - (insideCalc * TickSize);
			
				if (High[0] < High[1] && Low[0] > Low[1])
				{
					DrawTriangleDown("Insidedn"+CurrentBar,false,0, High[0]+(insideOffset * TickSize),insideColor);
					DrawTriangleUp("Insideup"+CurrentBar,false,0,Low[0]-(insideOffset * TickSize),insideColor);
				}
				else
				{
					if ((High[0] == High[1]) && (Low [0] >= insidePosL))
					{
						//DrawText("Inside1"+CurrentBar,false, "I", 0, insidePos, 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						DrawTriangleDown("Insidedn"+CurrentBar,false,0, High[0]+(insideOffset * TickSize),insideColor);
						DrawTriangleUp("Insideup"+CurrentBar,false,0,Low[0]-(insideOffset * TickSize),insideColor);
					}
					if ((Low[0] == Low[1]) && (High[0] <= insidePosH))
					{
						//DrawText("test1"+CurrentBar,false, insidePosH.ToString(), 0, High[0], 0, textColorL, textFont, StringAlignment.Center, Color.Transparent, Color.Transparent, 0);
						DrawTriangleDown("Insidedn"+CurrentBar,false,0, High[0]+(insideOffset * TickSize),insideColor);
						DrawTriangleUp("Insideup"+CurrentBar,false,0,Low[0]-(insideOffset * TickSize),insideColor);					
					}
				}
			}
		//----last 
		}


        #region Properties
		
		[Description("Draws labels on all bars....'false' limits to # of recent bars")]
        [Category("Setup Chart")]
		[Gui.Design.DisplayName("1. Draw All Bars")]
        public bool DrawLabel
        {
            get { return drawLabel; }
            set { drawLabel = value; }
        }
		
		[Description("Set to True only if you don't want to see all of Brooks bar labels... this controls the # of recent bars to show labels...ONLY works if above is 'false' ")]
        [Category("Setup Chart")]
		[Gui.Design.DisplayName("2. Draw only last n Bars")]
        public int NumofLabels
        {
            get { return numofLabels; }
            set { numofLabels = Math.Max(1, value); }
        }
		
		[Description("Flag Inside Bars")]
        [Category("Setup Chart")]
		[Gui.Design.DisplayName("3. Flag Inside Bars")]
        public bool DrawInsidebar
        {
            get { return drawInsideBar; }
            set { drawInsideBar = value; }
        }
		
		[Description("# of Tick Diff for Inside Bar Calc")]
        [Category("Setup Chart")]
		[Gui.Design.DisplayName("4. Inside Calc")]
        public int InsideCalc
        {
            get { return insideCalc; }
            set { insideCalc = Math.Max(1, value); }
        }
		
		[Description("Default Prints 'O' at High/Low on all outside bars....True = indicator tries to select H or L value based on prior bar....    ")]
        [Category("Setup Chart")]
		[Gui.Design.DisplayName("5. OutSide Bar AutoCalc")]
        public bool Outsidebar
        {
            get { return outsidebar; }
            set { outsidebar = value; }
        }

		
		
		//=====================================================
		[Description("# of Ticks...Move Inside Bar flag 'x' # of ticks from High/Low of the bar")]
		[Gui.Design.DisplayName("Inside Flag Offset")]
        [Category("Visual")]
        public int InsideOffset
        {
            get { return insideOffset; }
            set { insideOffset = Math.Max(-1, value); }
        }
		
		
		[Description("Moves Brooks Text # of ticks from high/low of the bar")]
		[Gui.Design.DisplayName("Text Label Offset")]
        [Category("Visual")]
        public int TextTicksOffset
        {
            get { return textTicksOffset; }
            set { textTicksOffset = Math.Max(1, value); }
        }
		
		[XmlIgnore()]
		[Description("")]
		[Gui.Design.DisplayName("Text Font")]
        [Category("Visual")]
		public Font TextFont
		{
			get { return textFont; }
			set { textFont = value; }
		}
		[Browsable(false)]
		public string textFontSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableFont.ToString(textFont); }
			set { textFont = NinjaTrader.Gui.Design.SerializableFont.FromString(value); }
		}
		
		[Description("Color of H")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Text ColorH")]
        public Color TextColorH
        {
            get { return textColorH; }
            set { textColorH = value; }
        }
		[Browsable(false)]
		public string TextColorHSerialise
		{
			get { return Gui.Design.SerializableColor.ToString(textColorH); }
			set { textColorH = Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Description("Color of L")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Text ColorL")]
        public Color TextColorL
        {
            get { return textColorL; }
            set { textColorL = value; }
		}
		[Browsable(false)]
		public string TextColorLSerialise
		{
			get { return Gui.Design.SerializableColor.ToString(textColorL); }
			set { textColorL = Gui.Design.SerializableColor.FromString(value); }
		}	
		
		[Description("Color of Inside Bar Flag")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("InsideBar Color")]
        public Color InsideeColor
        {
            get { return insideColor; }
            set { insideColor = value; }
        }
		[Browsable(false)]
		public string InsideColorSerialise
		{
			get { return Gui.Design.SerializableColor.ToString(insideColor); }
			set { insideColor = Gui.Design.SerializableColor.FromString(value); }
		}

		
		#endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BrooksBars[] cacheBrooksBars = null;

        private static BrooksBars checkBrooksBars = new BrooksBars();

        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        public BrooksBars BrooksBars()
        {
            return BrooksBars(Input);
        }

        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        public BrooksBars BrooksBars(Data.IDataSeries input)
        {
            if (cacheBrooksBars != null)
                for (int idx = 0; idx < cacheBrooksBars.Length; idx++)
                    if (cacheBrooksBars[idx].EqualsInput(input))
                        return cacheBrooksBars[idx];

            lock (checkBrooksBars)
            {
                if (cacheBrooksBars != null)
                    for (int idx = 0; idx < cacheBrooksBars.Length; idx++)
                        if (cacheBrooksBars[idx].EqualsInput(input))
                            return cacheBrooksBars[idx];

                BrooksBars indicator = new BrooksBars();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                BrooksBars[] tmp = new BrooksBars[cacheBrooksBars == null ? 1 : cacheBrooksBars.Length + 1];
                if (cacheBrooksBars != null)
                    cacheBrooksBars.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBrooksBars = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BrooksBars BrooksBars()
        {
            return _indicator.BrooksBars(Input);
        }

        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        public Indicator.BrooksBars BrooksBars(Data.IDataSeries input)
        {
            return _indicator.BrooksBars(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BrooksBars BrooksBars()
        {
            return _indicator.BrooksBars(Input);
        }

        /// <summary>
        /// (Ver 1.5   01/25/2011   Photog53)   BrooksBars....for learning Al Brooks system
        /// </summary>
        /// <returns></returns>
        public Indicator.BrooksBars BrooksBars(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BrooksBars(input);
        }
    }
}
#endregion
