// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
// This was modified from the NinjaTrader Indicator BuySellPressure version 1.0

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// This indicator is a real-time indicator and does not plot against historical data. 
	/// Plots a histogram splitting volume between trades at higher than last bar higher or lower than last bar lower.
	/// </summary>
	[Description("This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.")]
	[Gui.Design.DisplayName("BuySellVolASZ")]
	public class BuySellVolASZ : Indicator
	{
		#region Variables
		private int activeBar = -1;
		private System.Collections.ArrayList alBuys = new System.Collections.ArrayList();
		private System.Collections.ArrayList alSells = new System.Collections.ArrayList();
		private System.Collections.ArrayList alVolume = new System.Collections.ArrayList();
		private double buys = 0;
		private double sells = 0;
		private	double volume = 0;
		private bool firstPaint = true;
		private double previousVol = 0;
		
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(new Pen(Color.Blue, 3), PlotStyle.Bar, "Sells"));
			Add(new Plot(new Pen(Color.Gold, 3), PlotStyle.Bar, "Buys"));
			CalculateOnBarClose = false;
			DisplayInDataBox = true;
			PaintPriceMarkers = false;
			PlotsConfigurable = true;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (CurrentBar < activeBar)
			{
				Values[0].Set((double)alSells[CurrentBar]);
				Values[1].Set((double)alBuys[CurrentBar]);
				return;
			}
			else if (CurrentBar != activeBar)
			{
				previousVol = 0;
				alBuys.Insert(Math.Max(activeBar, 0), Historical ? 0 : buys);
				alSells.Insert(Math.Max(activeBar, 0), Historical ? 0 : sells);
				buys = 0;
				sells = 0;
				activeBar = CurrentBar;
			}
			if (firstPaint)
				firstPaint = false;
			else
			{
				double tradeVol = previousVol == 0 ? Volume[0] : Volume[0] - previousVol;
				if (tradeVol<0)
					tradeVol=0;
				if (Input[0] >= High[1])
					buys += tradeVol;
				else if (Input[0] <= Low[1])
					sells += tradeVol;
				
				
			}
			previousVol = Volume[0];
			if (!firstPaint && !Historical)
			{
			
				Values[0].Set(sells);
				Values[1].Set(sells+buys);
			}
		}
	}
}
	


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BuySellVolASZ[] cacheBuySellVolASZ = null;

        private static BuySellVolASZ checkBuySellVolASZ = new BuySellVolASZ();

        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        public BuySellVolASZ BuySellVolASZ()
        {
            return BuySellVolASZ(Input);
        }

        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        public BuySellVolASZ BuySellVolASZ(Data.IDataSeries input)
        {

            if (cacheBuySellVolASZ != null)
                for (int idx = 0; idx < cacheBuySellVolASZ.Length; idx++)
                    if (cacheBuySellVolASZ[idx].EqualsInput(input))
                        return cacheBuySellVolASZ[idx];

            BuySellVolASZ indicator = new BuySellVolASZ();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.SetUp();

            BuySellVolASZ[] tmp = new BuySellVolASZ[cacheBuySellVolASZ == null ? 1 : cacheBuySellVolASZ.Length + 1];
            if (cacheBuySellVolASZ != null)
                cacheBuySellVolASZ.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheBuySellVolASZ = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BuySellVolASZ BuySellVolASZ()
        {
            return _indicator.BuySellVolASZ(Input);
        }

        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        public Indicator.BuySellVolASZ BuySellVolASZ(Data.IDataSeries input)
        {
            return _indicator.BuySellVolASZ(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BuySellVolASZ BuySellVolASZ()
        {
            return _indicator.BuySellVolASZ(Input);
        }

        /// <summary>
        /// This indicator is a real-time indicator and does not plot against historical data. Plots a histogram splitting volume between trades at the ask or higher and trades at the bid and lower.
        /// </summary>
        /// <returns></returns>
        public Indicator.BuySellVolASZ BuySellVolASZ(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BuySellVolASZ(input);
        }

    }
}
#endregion
