#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
/// <summary>
/// Indicateur STPMT d'E.Lefort
/// </summary>
[Description("Indicator STPMT from Eric Lefort")]
public class STPMT : Indicator
{
#region Variables
// Wizard generated variables
private int periodM = 9; // Default setting for PeriodM (Periode de la Moyenne mobile simple de la STPMT)
// User defined variables (add any user defined variables below)
private DataSeries K1;
private DataSeries K2;
private DataSeries K3;
private DataSeries K4;
private DataSeries nom1;
private DataSeries nom2;
private DataSeries nom3;
private DataSeries nom4;
private DataSeries den1;
private DataSeries den2;
private DataSeries den3;
private DataSeries den4;
#endregion

/// <summary>
/// This method is used to configure the indicator and is called once before any bar data is loaded.
/// </summary>
protected override void Initialize()
{
    Add(new Plot(new Pen(Color.Red, 2), "Stpmt"));
	Add(new Plot(new Pen(Color.Blue, 2), "MM9_Stpmt"));
	Add(new Plot(Color.MediumSeaGreen, PlotStyle.Line, "Stoch1"));
	Plots[2].Pen.DashStyle = DashStyle.Dot;
	Add(new Plot(Color.LightSalmon, PlotStyle.Line, "Stoch2"));
	Plots[3].Pen.DashStyle = DashStyle.Dot;
	Add(new Plot(Color.Brown, PlotStyle.Line, "Stoch3"));
	Plots[4].Pen.DashStyle = DashStyle.Dot;
	Add(new Plot(Color.Navy, PlotStyle.Line, "Stoch4"));
	Plots[5].Pen.DashStyle = DashStyle.Dot;
	Add(new Line(Color.FromKnownColor(KnownColor.Gray), 60, "Ligne60"));
	Add(new Line(Color.FromKnownColor(KnownColor.Gray), 40, "Ligne40"));
	
	CalculateOnBarClose = false;
	Overlay 			= false;
	PriceTypeSupported	= false;
	AutoScale 			= true;

	K1 = new DataSeries(this);
	K2 = new DataSeries(this);
	K3 = new DataSeries(this);
	K4 = new DataSeries(this);

}

/// <summary>
/// Called on each bar update event (incoming tick)
/// </summary>
protected override void OnBarUpdate()
{
	double nom;
	double den;
	
	nom=Close[0] - MIN(Low, 5)[0];
	den=MAX(High, 5)[0] - MIN(Low, 5)[0];
	K1.Set(100 * nom / (den == 0 ? 1.0 : den));
	Stoch1.Set(SMA(K1, 3)[0]);

	// Calcule le Stochastique (14,3)
	nom=Close[0] - MIN(Low, 14)[0];
	den=MAX(High, 14)[0] - MIN(Low, 14)[0];
	K2.Set(100 * nom / (den == 0 ? 1.0 : den));
	Stoch2.Set(SMA(K2, 3)[0]);

	// Calcule le Stochastique (45,14)
	nom=Close[0] - MIN(Low, 45)[0];
	den=MAX(High, 45)[0] - MIN(Low, 45)[0];
	K3.Set(100 * nom / (den == 0 ? 1.0 : den));
	Stoch3.Set(SMA(K3, 14)[0]);

	// Calcule le Stochastique (75,20)
	nom=Close[0] - MIN(Low, 75)[0];
	den=MAX(High, 75)[0] - MIN(Low, 75)[0];
	K4.Set(100 * nom / (den == 0 ? 1.0 : den));
	Stoch4.Set(SMA(K4, 20)[0]);

	// Calcule l'indicateur STPMT (formule d'E.Lefort)

	Stpmt.Set((4.1*Stoch1[0]+2.5*Stoch2[0]+Stoch3[0]+4.0*Stoch4[0])/11.6);

	// Calcule la moyenne mobile simple 9 périodes du STPMT

	MM9_Stpmt.Set(SMA(Stpmt,periodM)[0]);
}

#region Properties
[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries Stpmt
{
get { return Values[0]; }
}

[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries MM9_Stpmt
{
get { return Values[1]; }
}

[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries Stoch1
{
get { return Values[2]; }
}

[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries Stoch2
{
get { return Values[3]; }
}

[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries Stoch3
{
get { return Values[4]; }
}

[Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
[XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
public DataSeries Stoch4
{
get { return Values[5]; }
}

[Description("Periode de la moyenne mobile de la STPMT")]
[Category("Parameters")]
public int PeriodM
{
get { return periodM; }
set { periodM = Math.Max(1, value); }
}
#endregion
}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private STPMT[] cacheSTPMT = null;

        private static STPMT checkSTPMT = new STPMT();

        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        public STPMT STPMT(int periodM)
        {
            return STPMT(Input, periodM);
        }

        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        public STPMT STPMT(Data.IDataSeries input, int periodM)
        {
            checkSTPMT.PeriodM = periodM;
            periodM = checkSTPMT.PeriodM;

            if (cacheSTPMT != null)
                for (int idx = 0; idx < cacheSTPMT.Length; idx++)
                    if (cacheSTPMT[idx].PeriodM == periodM && cacheSTPMT[idx].EqualsInput(input))
                        return cacheSTPMT[idx];

            STPMT indicator = new STPMT();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.PeriodM = periodM;
            indicator.SetUp();

            STPMT[] tmp = new STPMT[cacheSTPMT == null ? 1 : cacheSTPMT.Length + 1];
            if (cacheSTPMT != null)
                cacheSTPMT.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheSTPMT = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.STPMT STPMT(int periodM)
        {
            return _indicator.STPMT(Input, periodM);
        }

        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        public Indicator.STPMT STPMT(Data.IDataSeries input, int periodM)
        {
            return _indicator.STPMT(input, periodM);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.STPMT STPMT(int periodM)
        {
            return _indicator.STPMT(Input, periodM);
        }

        /// <summary>
        /// Indicator STPMT from Eric Lefort
        /// </summary>
        /// <returns></returns>
        public Indicator.STPMT STPMT(Data.IDataSeries input, int periodM)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.STPMT(input, periodM);
        }

    }
}
#endregion
