#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("")]
    public class Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch : Indicator
    {
        #region Variables
 
			private double AskPrice = 0;
			private double BidPrice = 0;
			private double LastPrice = 0;
		
			private double AskVolume = 0;
			private double BidVolume = 0;
			private double LastVolume = 0;
		
			private double CurrentAskVolume = 0;
			private double CurrentBidVolume = 0;
			private double CurrentNeutralVolume = 0;
		
			private double DeltaVolume = 0;
			private double TotalDeltaVolume = 0;
			private double CurrentDeltaVolume = 0;
			
        #endregion

    
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Green, 6), PlotStyle.Bar, "DeltaUp"));
			Add(new Plot(new Pen(Color.Red, 6), PlotStyle.Bar, "DeltaDown"));
			
            Add(new Line(Color.FromKnownColor(KnownColor.DimGray), 0, "Zero"));
			
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

		
        protected override void OnMarketData(MarketDataEventArgs e)
			
        {	
			
			if (e.MarketDataType == MarketDataType.Ask)AskPrice = e.Price;
			
            if (e.MarketDataType == MarketDataType.Bid)BidPrice = e.Price;
			
			if (e.MarketDataType == MarketDataType.Last)LastPrice = e.Price;
			
			if (e.MarketDataType == MarketDataType.Ask)AskVolume = e.Volume;
			
            if (e.MarketDataType == MarketDataType.Bid)BidVolume = e.Volume;
			
			if (e.MarketDataType == MarketDataType.Last)LastVolume = e.Volume;
			
			if (e.MarketDataType != MarketDataType.Last)return;
		
		
			if((LastPrice >= AskPrice) && (AskPrice!=0)) CurrentAskVolume = LastVolume;
			else if((LastPrice <= BidPrice) && (BidPrice!=0)) CurrentBidVolume = LastVolume;
			
			
			CurrentDeltaVolume = (CurrentAskVolume - CurrentBidVolume);
			
			TotalDeltaVolume += (CurrentAskVolume - CurrentBidVolume); 
			
			CurrentAskVolume = 0;
			CurrentBidVolume = 0;
			
		}
		
		
        protected override void OnBarUpdate()
			
        {
			
			if (FirstTickOfBar) // FirstTickOfBar Toggles After 1st Data Tick has been processed but before 2nd tick arrives.
			
				{ 	
					TotalDeltaVolume = CurrentDeltaVolume;
					DeltaVolume = 0;
				}
				
			DeltaVolume = TotalDeltaVolume ;
			
			if(DeltaVolume > 0){Values[0].Set(DeltaVolume);Values[1].Set(0);}
				
			if(DeltaVolume < 0){Values[0].Set(0);Values[1].Set(DeltaVolume);}
			
			if(DeltaVolume == 0){Values[0].Set(0);Values[1].Set(0);}
				
		}

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries VolumeUp
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries VolumeDown
        {
            get { return Values[2]; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[] cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch = null;

        private static Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch checkSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch = new Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch()
        {
            return Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Data.IDataSeries input)
        {
            if (cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch != null)
                for (int idx = 0; idx < cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch.Length; idx++)
                    if (cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[idx].EqualsInput(input))
                        return cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[idx];

            lock (checkSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch)
            {
                if (cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch != null)
                    for (int idx = 0; idx < cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch.Length; idx++)
                        if (cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[idx].EqualsInput(input))
                            return cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[idx];

                Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch indicator = new Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[] tmp = new Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch[cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch == null ? 1 : cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch.Length + 1];
                if (cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch != null)
                    cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch()
        {
            return _indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Data.IDataSeries input)
        {
            return _indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch()
        {
            return _indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Sample_NT7_OnMarketData_Delta_Volume_Indicator_With_Patch(input);
        }
    }
}
#endregion
