// 
// Copyright (C) 2007, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// by Big Mike (ctrlbrk) www.bigmiketrading.com 06/19/2009 version 1.0
	/// </summary>
	
	
	
	[Description("Volume Graph with LinRegSlopeSFX method (v1.0)")]
	[Gui.Design.DisplayName("VolumeGraph (v2.0)")]
	public class VolumeGraph : Indicator
	{
		
		#region Variables
		
		private int avglength = 14;
		private int slopelength = 7;
		private bool exponential = true;
		
		#endregion
		
		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(new Pen(Color.LightSteelBlue, 2), PlotStyle.Line, "Avg"));
			Add(new Plot(new Pen(Color.DodgerBlue, 3), PlotStyle.Bar, "UpVolume"));
			Add(new Plot(new Pen(Color.Crimson, 3), PlotStyle.Bar, "DownVolume"));
			
			CalculateOnBarClose = true;  // will not work on false
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (CurrentBar < 2) return;
			
			if (!CalculateOnBarClose)
				CalculateOnBarClose = true;
			
			if (LinRegSlopeSFX(Exponential, SlopeLength, 1)[0] > 0)
				UpVolume.Set(Volume[0]);
			else
				DownVolume.Set(Volume[0]);
			
			Avg.Set(EMA(EMA(Volume, AvgLength), AvgLength)[0]);
			
		}
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Avg
		{
			get { return Values[0]; }
		}
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries UpVolume
		{
			get { return Values[1]; }
		}
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries DownVolume
		{
			get { return Values[2]; }
		}
		
		[Description("Avg smoothing length for line")]
        [Category("Parameters")]
        public int AvgLength
        {
            get { return avglength; }
            set { avglength = Math.Max(1, value); }
        }
		[Description("Slope length for coloring")]
        [Category("Parameters")]
        public int SlopeLength
        {
            get { return slopelength; }
            set { slopelength = Math.Max(1, value); }
        }
		[Description("Color based on exponential")]
        [Category("Parameters")]
        public bool Exponential
        {
            get { return exponential; }
            set { exponential = value; }
        }
		
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private VolumeGraph[] cacheVolumeGraph = null;

        private static VolumeGraph checkVolumeGraph = new VolumeGraph();

        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        public VolumeGraph VolumeGraph(int avgLength, bool exponential, int slopeLength)
        {
            return VolumeGraph(Input, avgLength, exponential, slopeLength);
        }

        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        public VolumeGraph VolumeGraph(Data.IDataSeries input, int avgLength, bool exponential, int slopeLength)
        {
            checkVolumeGraph.AvgLength = avgLength;
            avgLength = checkVolumeGraph.AvgLength;
            checkVolumeGraph.Exponential = exponential;
            exponential = checkVolumeGraph.Exponential;
            checkVolumeGraph.SlopeLength = slopeLength;
            slopeLength = checkVolumeGraph.SlopeLength;

            if (cacheVolumeGraph != null)
                for (int idx = 0; idx < cacheVolumeGraph.Length; idx++)
                    if (cacheVolumeGraph[idx].AvgLength == avgLength && cacheVolumeGraph[idx].Exponential == exponential && cacheVolumeGraph[idx].SlopeLength == slopeLength && cacheVolumeGraph[idx].EqualsInput(input))
                        return cacheVolumeGraph[idx];

            VolumeGraph indicator = new VolumeGraph();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.AvgLength = avgLength;
            indicator.Exponential = exponential;
            indicator.SlopeLength = slopeLength;
            indicator.SetUp();

            VolumeGraph[] tmp = new VolumeGraph[cacheVolumeGraph == null ? 1 : cacheVolumeGraph.Length + 1];
            if (cacheVolumeGraph != null)
                cacheVolumeGraph.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheVolumeGraph = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeGraph VolumeGraph(int avgLength, bool exponential, int slopeLength)
        {
            return _indicator.VolumeGraph(Input, avgLength, exponential, slopeLength);
        }

        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeGraph VolumeGraph(Data.IDataSeries input, int avgLength, bool exponential, int slopeLength)
        {
            return _indicator.VolumeGraph(input, avgLength, exponential, slopeLength);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeGraph VolumeGraph(int avgLength, bool exponential, int slopeLength)
        {
            return _indicator.VolumeGraph(Input, avgLength, exponential, slopeLength);
        }

        /// <summary>
        /// Volume Graph with LinRegSlopeSFX method (v1.0)
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeGraph VolumeGraph(Data.IDataSeries input, int avgLength, bool exponential, int slopeLength)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VolumeGraph(input, avgLength, exponential, slopeLength);
        }

    }
}
#endregion
