#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// S&C magazine September 2010. Getting Clear With Short-Term Swings
    /// </summary>
    [Description("S&C magazine September 2010. Getting Clear With Short-Term Swings")]
    public class ShortTermSwings : Indicator
    {
        #region Variables
		
        private Color      colorDown = Color.Red;
        private Color      colorUp   = Color.Green;
        private bool       paintBars = false;
        private DataSeries trend     = null;

        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.Black, PlotStyle.Line, "Trend Line"));
            Overlay		= true;
			trend       = new DataSeries(this);
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if(CurrentBar == 0)
			{
				Trend.Set(Close[0] >= Open[0] ? 1 : -1);
				Value.Set(Trend[0] == 1 ? Low[0] : High[0]);
				return;
			}
			
			if(Trend[1] == 1)
			{
				double higherLow = Math.Max(Value[1], Low[0]);
				
				if (High[0] < higherLow - TickSize * 0.01)
				{
					Trend.Set(-1);
					Value.Set(High[0]);
				}
				else
				{
					Trend.Set(1);
					Value.Set(higherLow);
				}
			}
			else
			{
				double lowerHigh = Math.Min(Value[1], High[0]);

				if (Low[0] > lowerHigh + TickSize * 0.01)
				{
					Trend.Set(1);
					Value.Set(Low[0]);
				}
				else
				{
					Trend.Set(-1);
					Value.Set(lowerHigh);
				}
			}
			
			PlotColors[0][0] = Trend[0] == 1 ? ColorUp : ColorDown;

            if (PaintBars)
                BarColor = PlotColors[0][0];
        }

        #region Properties
        [Browsable(false)]	
        [XmlIgnore]		
        public DataSeries Trend
        {
            get { return trend; }
        }

        [Description("UpTrend Color")]
        [Category("Colors")]
        public Color ColorUp
        {
            get { return colorUp; }
            set { colorUp = value; }
        }

        [Browsable(false)]
        public string UpColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(colorUp); }
            set { colorUp = Gui.Design.SerializableColor.FromString(value); }
        }

        [Description("DownTrend Color")]
        [Category("Colors")]
        public Color ColorDown
        {
            get { return colorDown; }
            set { colorDown = value; }
        }

        [Browsable(false)]
        public string DownColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(colorDown); }
            set { colorDown = Gui.Design.SerializableColor.FromString(value); }
        }

        [Description("Paint Bars?")]
        [Category("Colors")]
        public bool PaintBars
        {
            get { return paintBars; }
            set { paintBars = value; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ShortTermSwings[] cacheShortTermSwings = null;

        private static ShortTermSwings checkShortTermSwings = new ShortTermSwings();

        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        public ShortTermSwings ShortTermSwings()
        {
            return ShortTermSwings(Input);
        }

        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        public ShortTermSwings ShortTermSwings(Data.IDataSeries input)
        {
            if (cacheShortTermSwings != null)
                for (int idx = 0; idx < cacheShortTermSwings.Length; idx++)
                    if (cacheShortTermSwings[idx].EqualsInput(input))
                        return cacheShortTermSwings[idx];

            lock (checkShortTermSwings)
            {
                if (cacheShortTermSwings != null)
                    for (int idx = 0; idx < cacheShortTermSwings.Length; idx++)
                        if (cacheShortTermSwings[idx].EqualsInput(input))
                            return cacheShortTermSwings[idx];

                ShortTermSwings indicator = new ShortTermSwings();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                ShortTermSwings[] tmp = new ShortTermSwings[cacheShortTermSwings == null ? 1 : cacheShortTermSwings.Length + 1];
                if (cacheShortTermSwings != null)
                    cacheShortTermSwings.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheShortTermSwings = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ShortTermSwings ShortTermSwings()
        {
            return _indicator.ShortTermSwings(Input);
        }

        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        public Indicator.ShortTermSwings ShortTermSwings(Data.IDataSeries input)
        {
            return _indicator.ShortTermSwings(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ShortTermSwings ShortTermSwings()
        {
            return _indicator.ShortTermSwings(Input);
        }

        /// <summary>
        /// S&C magazine September 2010. Getting Clear With Short-Term Swings
        /// </summary>
        /// <returns></returns>
        public Indicator.ShortTermSwings ShortTermSwings(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ShortTermSwings(input);
        }
    }
}
#endregion
