#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
	/// ECO2New2(Ergodic Candlestick Oscilator.  The ECO2New2 is a Momentum Oscillator that is not affected by opening gaps.  See William Blau's Momentum/Direction/Divergence book  "
    /// v 1.0 - 7/3/2009 (systrader): Branched version for Sharky (from ECO2New2)
    /// </summary>
    [Description("ECO2New2 - Sharky Package v1.0")]
    [Gui.Design.DisplayName("ECO2New2 (Sharky Pkg)")]
	/* 
	V1.1 - Fixed Plot Overflow problem.  Code was not skipping enough warm-up bars and was getting an overflow on some charts
											- now skips 10 bars
	Adapted from Blau's Momentum/Direction/Divergence by zoltran (Wes S.) 
	
					// Formula for Candlestick oscilator from Blaus book is 
				//                      EMA(EMA(close-open),r),s)
				//    CSI(r,s)= 100 x  --------------------------
				//                        EMA(EMA(high-low),r),s)
				//
				// The 'Ergodic' version adds signal line, wich is a 5 bar ema of the CSI
				//


	Trading Ergodics with the Trend - Rules

   1. Enter or hold position only when slope of ECO2New2 Signal line has the same direction as the trend
   2. Stand aside when slope of ECO2New2 Signal Line is in the opposite direction of trend
   3. Enter or exit position when ECO2New2 and its Signal Line cross
   4. Take note when the ECO2New2 is 'inside' it's signal line.  This indicates failing momemntum
	   This is what the magenta dot signifies

	
	
	*/ 
    public class ECO2New2_SharkyPkg : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int fast = 7; // Default setting for Fast 3
            private int slow = 21; // Default setting for Slow 13
            private int signalLen = 4; // Default setting for SignalLen 5
        // User defined variables (add any user defined variables below)
		DataSeries				fastEma;
		DataSeries				fastAbsEma;
		DataSeries				slowEma;
		DataSeries				slowAbsEma;
		DataSeries				closeopen;
		DataSeries				highlow;
		DataSeries				eco;
		DataSeries				average;
		bool					histogramType = true;
		private bool		showText = false; // sharky 1.0 changed to def false
		private bool		textOnLeft = false;
		private TextPosition bPosition = TextPosition.BottomLeft;
		private TextPosition tPosition = TextPosition.TopLeft;
//		double average;
//		double eco;
		private bool		showEntries = false; // sharky 1.0 changed to def false
		private bool		alerts = false;
		private int	edownbar	=	0;
		private int	edownplot	=	0;
		private int	triangleDn	=	0;
		private int	eupbar	=	0;
		private int	eupplot	=	0;
		private int	triangleUp	=	0;

        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {

			// The add statements are in this odd order so that 'z' order of the plots works right... 
						// Fading dot plots on top of the Signal 
			               // Signal plot on top of the Main indicator
			
			// 
			
			Add(new Plot(new Pen(Color.Transparent, 2), PlotStyle.Dot,	"Fading"));	   		// Values[0]
            Add(new Plot(new Pen(Color.Transparent, 2), PlotStyle.Line, "Signal")); 			// Values[1]			
            Add(new Plot(new Pen(Color.LimeGreen, 3),	PlotStyle.Line,	"Rising"));		// Values[2]
            Add(new Plot(new Pen(Color.Red,3), PlotStyle.Line,	"Falling"));		// Values[3]
			Add(new Plot(new Pen(Color.White, 3), PlotStyle.Line, "Main"));		  		// Values[4]			
            Add(new Plot(new Pen(Color.DarkGreen, 4), PlotStyle.Bar,	"RisingHistogram"));		// Values[5]			
            Add(new Plot(new Pen(Color.Crimson, 4), PlotStyle.Bar,	"FallingHistogram"));		// Values[6]
//
			Add(new Line(Color.FromKnownColor(KnownColor.White), 0, "Zero"));			
			Add(new Line(Color.FromKnownColor(KnownColor.LimeGreen), 20, "OverBought"));			
			Add(new Line(Color.FromKnownColor(KnownColor.Red), -20, "OverSold"));			
			

            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
			DrawOnPricePanel = false;
 
			// Init user data series
			closeopen 			= new DataSeries(this);	 
			highlow  			= new DataSeries(this);	// Init the data series
			fastEma 			= new DataSeries(this); 
			fastAbsEma 			= new DataSeries(this);
			slowEma 			= new DataSeries(this);
			slowAbsEma 			= new DataSeries(this);
			eco					= new DataSeries(this);
			average				= new DataSeries(this);	
			this.BarsRequired   = 1; //Slow+SignalLen+2;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar <3 ) return;
			closeopen.Set(Close[0]-Open[0]);					// Store the result of close - open
			highlow.Set(High[0] - Low[0]);						// Store the result of high - low            

			if (CurrentBar < Slow+Fast+1)
			
			{
				for (int index = 0; index <= 6; index++) 
				{
					Values[index].Reset();
				}					
				fastEma.Reset(); 
				fastAbsEma.Reset();
				slowEma.Reset();
				slowAbsEma.Reset();
				eco.Reset();
				average.Reset();	
				
				return	;		// Skip number of bars used for the ECO2New2 and it's EMA. .. warm up time  Overkill, but safe
			}
			else
			{

				// Formula for Candlestick oscilator from Blaus book is 
				//                      EMA(EMA(close-open),r),s)
				//    CSI(r,s)= 100 x  --------------------------
				//                        EMA(EMA(high-low),r),s)
				//
				// The 'Ergodic' version adds signal line, wich is a 5 bar ema of the CSI
				//
				
				eco.Set(100 * EMA(EMA(closeopen,slow),fast)[0] / EMA(EMA(highlow,slow),fast)[0]) ;

				if (CurrentBar > Slow+Fast+SignalLen+2)
					average.Set(EMA(eco,SignalLen)[0]);	    // Take a 5 bar EMA of the ECO2New2 (stored in collection Values[4]				
				Values[1].Set(average[0]);						// Plot the Signal Line				
				Values[4].Set(eco[0]);							// Plot main ECO2New2 line 
				
// The following code does the multicolor paints using extra plots for each color				
				Values[2].Reset();									// Reset other lines to 0
				Values[3].Reset();				
				Values[5].Reset();		
				Values[6].Reset();	
				
			if (eco[0]>eco[1])    // Plot green bars for rising eco, red for falling		
				{
//					if (eco[1]<eco[2]) Values[2].Set(1,eco[1]);//   connect prior secgment Paint falling eco  if (CurrentBar > Slow+Fast+SignalLen)
					Values[2].Set(eco[0]); 						    //    Paint Rising ECO2New2 Line
 				}
				else if (eco[0]<eco[1])
				{
//					if (eco[1]> eco[2])Values[3].Set(1,eco[1]);	//   connect prior secgment Paint falling eco
					Values[3].Set(eco[0]);						//    Paint falling eco			 
				}
			if (HistogramType)	
			{	
			if (eco[0]>0 ) Values[5].Set(eco[0]);						//    Paint histogram above zero
				else	Values[6].Set(eco[0]);							//    Paint histogram below zero	
			}
			
			else
				
 			{
				if (Rising(eco)) Values[5].Set(eco[0]);						//    Paint histogram Rising
				else	Values[6].Set(eco[0]);						//    Paint histogram Falling
			}
				
				
				if (eco[0]<0 && average[0] < eco[0]) Values[0].Set(average[0]); // Plot the 'Fading' dots if signal is outside of the ECO2New2
				if (eco[0]>0 && average[0] > eco[0]) Values[0].Set(average[0]); // This indicates declining momentum
////					else Values[1].Set(eco[0]);							//defautls to same as eco 

			
 
//--Text Box Info--//
				
			double ECOminus = Math.Abs(eco[1]-eco[0]);
			double ECOplus = Math.Abs(eco[0]-eco[1]);	
			
			if(textOnLeft)			
			{bPosition = TextPosition.BottomLeft;
			tPosition = TextPosition.TopLeft;}
			else
			{bPosition = TextPosition.BottomRight;
			tPosition = TextPosition.TopRight;}
						
			if(showText)
			{
				if(eco[0]<eco[1])
			DrawTextFixed("EcoDown", " ECO Diff -" + ECOminus.ToString("0.00"), bPosition, Color.Black, new Font("Arial Narrow", 12), Color.Crimson, Color.Red, 10);
				else
			RemoveDrawObject("EcoDown");
				
				if(eco[0]>eco[1])
			DrawTextFixed("EcoUp", " ECO Diff +" + ECOplus.ToString("0.00"), bPosition, Color.Black, new Font("Arial Narrow", 12), Color.DarkGreen, Color.LimeGreen, 10);
				else
			RemoveDrawObject("EcoUp");
			
			if(eco[0]<0 && average[0]<0 && eco[0]<average[0])
			DrawTextFixed("Short", " SHORT", tPosition, Color.Black, new Font("Arial Narrow", 12), Color.Crimson, Color.Orange, 10);
				else
			RemoveDrawObject("Short");
			
			if(eco[0]>0 && average[0]>0 && eco[0]>average[0])
			DrawTextFixed("Long", " LONG", tPosition, Color.Black, new Font("Arial Narrow", 12), Color.Crimson, Color.Orange, 10);
				else
			RemoveDrawObject("Long");
			
			if(eco[0]>0 && average[0]>0 && eco[0]<average[0] || eco[0]<0 && average[0]<0 && eco[0]>average[0])
			DrawTextFixed("Fading", " FADING", tPosition, Color.Black, new Font("Arial Narrow", 12), Color.Crimson, Color.Orange, 10);
				else
			RemoveDrawObject("Fading");
			}
			
//Triangle Plotting//
			
			if(average[0] > 0 || average[0] < eco[0] || eco[0] > 0)
		triangleDn = 0;
			if(average[0] < 0 || average[0] > eco[0] || eco[0] < 0)
		triangleUp = 0;
			
	if(showEntries)					
{	

if(CrossBelow(average, 0, 1) && eco[0] < average[0] && triangleDn == 0 || CrossAbove(average, eco, 1) && average[0] < 0 && triangleDn == 0)	
{DrawTriangleDown("EcoDT", true, 0, 0, Color.Transparent);
if (alerts == true)					
Alert("DnTrend",NinjaTrader.Cbi.Priority.Medium,"Dn Trend Pending","Drip.wav",6,Color.Black,Color.Yellow);	
edownbar = CurrentBar;
edownplot = 1;}
	
if(edownplot == 1 && CurrentBar == edownbar + 1)
{RemoveDrawObject("EcoDT");
edownplot = 0;
if(eco[1] < average[1] && average[1] < 0 && triangleDn == 0)
{DrawTriangleDown(CurrentBar.ToString() + "EcoDTSolid", true, 1, 0, Color.Red);
	if(eco[1] > eco[2] || average[1] > average[2])
		DrawTriangleDown(CurrentBar.ToString() + "EcoDTSolidDark", true, 1, 0, Color.LightSalmon);
triangleDn = 1;
if (alerts == true)					
Alert("DnTrendFinal",NinjaTrader.Cbi.Priority.Medium,"Dn Trend","Alert2.wav",6,Color.Black,Color.Yellow);}
}

	


if(CrossAbove(average, 0, 1) && eco[0] > average[0] && triangleUp == 0 || CrossBelow(average, eco, 1) && average[0] > 0 && triangleUp == 0)
{DrawTriangleUp("EcoUT", true, 0, 0, Color.Transparent);
if (alerts == true)					
Alert("UpTrend",NinjaTrader.Cbi.Priority.Medium,"Up Trend Pending","Drip.wav",6,Color.Black,Color.Yellow);	
eupbar = CurrentBar;
eupplot = 1;}

if(eupplot == 1 && CurrentBar == eupbar + 1)
{RemoveDrawObject("EcoUT");
eupplot = 0;
if(eco[1] > average[1] && average[1] > 0 && triangleUp == 0)
{DrawTriangleUp(CurrentBar.ToString() + "EcoUTSolid", true, 1, 0, Color.Green);
	if(eco[1] < eco[2] || average[1] < average[2])
		DrawTriangleUp(CurrentBar.ToString() + "EcoUTSolidDark", true, 1, 0, Color.GreenYellow);
triangleUp = 1;
if (alerts == true)					
Alert("UpTrendFinal",NinjaTrader.Cbi.Priority.Medium,"Up Trend","Alert2.wav",6,Color.Black,Color.Yellow);}
}
}
			
			
			
			}
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Main
        {
            get { return Values[4]; }
        }
		
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Fading
        {
            get { return Values[0]; }
        }		

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Signal
        {
            get { return Values[1]; }
        }

        [Description("Fast EMA")]
        [Category("Parameters")]
        public int Fast
        {
            get { return fast; }
            set { fast = Math.Max(1, value); }
        }

        [Description("Slow EMA")]
        [Category("Parameters")]
        public int Slow
        {
            get { return slow; }
            set { slow = Math.Max(1, value); }
        }

        [Description("Signal EMA")]
        [Category("Parameters")]
        public int SignalLen
        {
            get { return signalLen; }
            set { signalLen = Math.Max(1, value); }
        }
        [Description("Histogram Paint Type. True = Green/Red Above/Below 0.  False = Histogram Color shows Rising/Falling ECO")]
        [Category("Display Parameters")]
        public bool HistogramType
        {
            get { return histogramType; }
            set { histogramType = value; }
        }		
		 [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ECORising
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ECOFalling
        {
            get { return Values[3]; }
        }
		
		[Description("Show Text Info.")]
        [Category("Display Parameters")]
        public bool ShowText
        {
            get { return showText; }
            set { showText = value; }
        }
		
		[Description("Text on left of chart? For those with no right margin.")]
        [Category("Display Parameters")]
        public bool TextOnLeft
        {
            get { return textOnLeft; }
            set { textOnLeft = value; }
        }
		
		[Description("Show Entry Triangles")]
        [Category("Display Parameters")]
        public bool ShowEntries
        {
            get { return showEntries; }
            set { showEntries = value; }
        }
		
		[Description("Sound alert warning.")]
		[Gui.Design.DisplayName ("Turn sound alert on?")]
        [Category("Display Parameters")]
        public bool Alerts
        {
            get { return alerts; }
            set { alerts = value; }
        }
		
		public bool SellSignal
		{
			get{return (triangleDn == 1);}
		}
		public bool BuySignal
		{
			get{return (triangleUp == 1);}
		}		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ECO2New2_SharkyPkg[] cacheECO2New2_SharkyPkg = null;

        private static ECO2New2_SharkyPkg checkECO2New2_SharkyPkg = new ECO2New2_SharkyPkg();

        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        public ECO2New2_SharkyPkg ECO2New2_SharkyPkg(int fast, int signalLen, int slow)
        {
            return ECO2New2_SharkyPkg(Input, fast, signalLen, slow);
        }

        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        public ECO2New2_SharkyPkg ECO2New2_SharkyPkg(Data.IDataSeries input, int fast, int signalLen, int slow)
        {
            checkECO2New2_SharkyPkg.Fast = fast;
            fast = checkECO2New2_SharkyPkg.Fast;
            checkECO2New2_SharkyPkg.SignalLen = signalLen;
            signalLen = checkECO2New2_SharkyPkg.SignalLen;
            checkECO2New2_SharkyPkg.Slow = slow;
            slow = checkECO2New2_SharkyPkg.Slow;

            if (cacheECO2New2_SharkyPkg != null)
                for (int idx = 0; idx < cacheECO2New2_SharkyPkg.Length; idx++)
                    if (cacheECO2New2_SharkyPkg[idx].Fast == fast && cacheECO2New2_SharkyPkg[idx].SignalLen == signalLen && cacheECO2New2_SharkyPkg[idx].Slow == slow && cacheECO2New2_SharkyPkg[idx].EqualsInput(input))
                        return cacheECO2New2_SharkyPkg[idx];

            ECO2New2_SharkyPkg indicator = new ECO2New2_SharkyPkg();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Fast = fast;
            indicator.SignalLen = signalLen;
            indicator.Slow = slow;
            indicator.SetUp();

            ECO2New2_SharkyPkg[] tmp = new ECO2New2_SharkyPkg[cacheECO2New2_SharkyPkg == null ? 1 : cacheECO2New2_SharkyPkg.Length + 1];
            if (cacheECO2New2_SharkyPkg != null)
                cacheECO2New2_SharkyPkg.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheECO2New2_SharkyPkg = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ECO2New2_SharkyPkg ECO2New2_SharkyPkg(int fast, int signalLen, int slow)
        {
            return _indicator.ECO2New2_SharkyPkg(Input, fast, signalLen, slow);
        }

        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        public Indicator.ECO2New2_SharkyPkg ECO2New2_SharkyPkg(Data.IDataSeries input, int fast, int signalLen, int slow)
        {
            return _indicator.ECO2New2_SharkyPkg(input, fast, signalLen, slow);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ECO2New2_SharkyPkg ECO2New2_SharkyPkg(int fast, int signalLen, int slow)
        {
            return _indicator.ECO2New2_SharkyPkg(Input, fast, signalLen, slow);
        }

        /// <summary>
        /// ECO2New2 - Sharky Package v1.0
        /// </summary>
        /// <returns></returns>
        public Indicator.ECO2New2_SharkyPkg ECO2New2_SharkyPkg(Data.IDataSeries input, int fast, int signalLen, int slow)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ECO2New2_SharkyPkg(input, fast, signalLen, slow);
        }

    }
}
#endregion
