// <summary>
/// TSSuperTrendV2 Indicator
/// Version 2.2
/// Visual options for bar colors added by Elliott Wave 12/08.
/// Version 2.3 
/// Fixed VWMA issue
/// Added Sound Alerts
/// http://www.ninjatrader.com/support/forum/showthread.php?t=11844&page=8   line 162 etc
/// TJ added BIP=1 modification
/// </summary>
using System;
using System.ComponentModel;
using System.Drawing;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using TSSuperTrendV2.Utility;

namespace NinjaTrader.Indicator
{
    [Description("MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)")]
    public class mtfTSST5r : Indicator
    {
        private int _length = 8;
        private double _multiplier = 2.618;
        private IDataSeries _avg;
        private double _offset;
        private MovingAverageType _maType = MovingAverageType.TEMA;
        private SuperTrendMode _smode = SuperTrendMode.Adaptive;
        private int _smooth = 8;
        private Color _barColorUp = Color.Blue;
        private Color _barColorDown = Color.Red;
        private Color _tempColor;
        private Color _prevColor;
        private double _th;
        private double _tl = double.MaxValue;
        private bool _playAlert = false;
        private string _longAlert = string.Empty;
        private string _shortAlert = string.Empty;
        private int _thisbar = -1;

        private DataSeries eVal;
		private DataSeries eTrend;        
		
        protected override void Initialize()
        {
			Add(PeriodType.Range, 5);  // BarsInProgress index = 1
            Add(new Plot(Color.LightGreen, PlotStyle.Dot, "UpTrend"));
            Add(new Plot(Color.MistyRose, PlotStyle.Dot, "DownTrend"));
			Plots[0].Pen.Width = 3;
			Plots[1].Pen.Width = 3;
            Overlay = true;

            eVal = new DataSeries(this);
			eTrend = new DataSeries(this);            
        }

        protected override void OnBarUpdate()
        {
			{ 	if (BarsInProgress == 1)  //Better Renko
			//	return;
			
           				 if (CurrentBars[1] < 20)
							return;
           							 {
                if (_smooth > 1 && _avg == null)
                    switch (_maType)
                    {
                        case MovingAverageType.SMA:
                            _avg = SMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.SMMA:
                            _avg = SMMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.TMA:
                            _avg = TMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.WMA:
                            _avg = WMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.VWMA:
                            _avg = VWMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.TEMA:
                            _avg = TEMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.HMA:
                            _avg = HMA(BarsArray[1], _smooth);
                            break;
                        case MovingAverageType.VMA:
                            _avg = VMA(BarsArray[1], _smooth, _smooth);
                            break;
                        default:
                            _avg = EMA(BarsArray[1], _smooth);
                            break;
                    }
                else
                    _avg = Input;

                eVal.Set(0);
                eTrend.Set(0);
                UpTrend.Set(Input[0]);
                DownTrend.Set(Input[0]);
                return;
            }

            switch (_smode)
            {
                case SuperTrendMode.ATR:
                    _offset = ATR(_length)[0] * Multiplier;
                    break;
                case SuperTrendMode.Adaptive:
                    _offset = ATR(_length)[0] * HomodyneDiscriminator(Input)[0] / 10;
                    break;
                default:
                    _offset = Dtt(_length, Multiplier);
                    break;
            }

            if (FirstTickOfBar)
                _prevColor = _tempColor;

            eTrend.Set(Close[0] > DownTrend[1] ? 1 : Close[0] < UpTrend[1] ? -1 : eTrend[1]);

            if (eTrend[0] == 1 && eTrend[1] == -1)
            {
                _th = High[0];
                UpTrend.Set(Math.Max(_avg[0] - _offset, _tl));
                eVal.Set(UpTrend[0]);
                if (Plots[0].PlotStyle == PlotStyle.Line) UpTrend.Set(1, DownTrend[1]);
                _tempColor = _barColorUp;
            }
            else if (eTrend[0] == -1 && eTrend[1] == 1)
            {
                _tl = Low[0];
                DownTrend.Set(Math.Min(_avg[0] + _offset, _th));
                eVal.Set(DownTrend[0]);
                if (Plots[1].PlotStyle == PlotStyle.Line) DownTrend.Set(1, UpTrend[1]);
                _tempColor = _barColorDown;

            }
            else
            {
                if (eTrend[0] == 1)
                {
                    UpTrend.Set((_avg[0] - _offset) > UpTrend[1] ? (_avg[0] - _offset) : UpTrend[1]);
                    eVal.Set(UpTrend[0]);
                    _th = Math.Max(_th, High[0]);
                }
                else
                {
                    DownTrend.Set((_avg[0] + _offset) < DownTrend[1] ? (_avg[0] + _offset) : DownTrend[1]);
                    eVal.Set(DownTrend[0]);
                    _tl = Math.Min(_tl, Low[0]);
                }
                RemoveDrawObject(CurrentBar.ToString());
                _tempColor = _prevColor;
            }
			
			//DrawText(CurrentBar.ToString(), eTrend[0].ToString(), 0, Low[0], Color.White);
        }
		}
        private double Dtt(int nDay, double mult)
        {
            double hh = MAX(Highs[1], nDay)[0];
            double hc = MAX(Closes[1], nDay)[0];
            double ll = MIN(Lows[1], nDay)[0];
            double lc = MIN(Closes[1], nDay)[0];
            return mult * Math.Max((hh - lc), (hc - ll));
        }
		

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries UpTrend
        {
            get
            {
                Update();
                return Values[0];
            }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DownTrend
        {
            get
            {
                Update();
                return Values[1];
            }
        }

        [Description("SuperTrendMode")]
        [Category("Parameters")]
        [Gui.Design.DisplayName("01. SuperTrend Mode")]
        public SuperTrendMode StMode
        {
            get { return _smode; }
            set { _smode = value; }
        }

        [Description("ATR/DT Period")]
        [Category("Parameters")]
        [Gui.Design.DisplayName("02. Period")]
        public int Length
        {
            get { return _length; }
            set { _length = Math.Max(1, value); }
        }

        [Description("ATR Multiplier")]
        [Category("Parameters")]
        [Gui.Design.DisplayName("03. Multiplier")]
        public double Multiplier
        {
            get { return _multiplier; }
            set { _multiplier = Math.Max(0.0001, value); }
        }

        [Description("Moving Average Type for smoothing")]
        [Category("Parameters")]
        [Gui.Design.DisplayName("04. Moving Average Type")]
        public MovingAverageType MaType
        {
            get { return _maType; }
            set { _maType = value; }
        }

        [Description("Smoothing Period")]
        [Category("Parameters")]
        [Gui.Design.DisplayName("05. SmoothingPeriod (MA)")]
        public int Smooth
        {
            get { return _smooth; }
            set { _smooth = Math.Max(1, value); }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Exp_Trend
        {
            get { Update(); return eTrend; }
        }
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Exp_Val
        {
            get { Update(); return eVal; }
        }

        #endregion
    }
}

namespace mtfTSST5r.Utility
{
    public enum SuperTrendMode
    {
        ATR,
        DualThrust,
        Adaptive
    }

    public enum MovingAverageType
    {
        SMA,
        SMMA,
        TMA,
        WMA,
        VWMA,
        TEMA,
        HMA,
        EMA,
        VMA
    }
}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private mtfTSST5r[] cachemtfTSST5r = null;

        private static mtfTSST5r checkmtfTSST5r = new mtfTSST5r();

        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        public mtfTSST5r mtfTSST5r(int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            return mtfTSST5r(Input, length, maType, multiplier, smooth, stMode);
        }

        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        public mtfTSST5r mtfTSST5r(Data.IDataSeries input, int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            if (cachemtfTSST5r != null)
                for (int idx = 0; idx < cachemtfTSST5r.Length; idx++)
                    if (cachemtfTSST5r[idx].Length == length && cachemtfTSST5r[idx].MaType == maType && Math.Abs(cachemtfTSST5r[idx].Multiplier - multiplier) <= double.Epsilon && cachemtfTSST5r[idx].Smooth == smooth && cachemtfTSST5r[idx].StMode == stMode && cachemtfTSST5r[idx].EqualsInput(input))
                        return cachemtfTSST5r[idx];

            lock (checkmtfTSST5r)
            {
                checkmtfTSST5r.Length = length;
                length = checkmtfTSST5r.Length;
                checkmtfTSST5r.MaType = maType;
                maType = checkmtfTSST5r.MaType;
                checkmtfTSST5r.Multiplier = multiplier;
                multiplier = checkmtfTSST5r.Multiplier;
                checkmtfTSST5r.Smooth = smooth;
                smooth = checkmtfTSST5r.Smooth;
                checkmtfTSST5r.StMode = stMode;
                stMode = checkmtfTSST5r.StMode;

                if (cachemtfTSST5r != null)
                    for (int idx = 0; idx < cachemtfTSST5r.Length; idx++)
                        if (cachemtfTSST5r[idx].Length == length && cachemtfTSST5r[idx].MaType == maType && Math.Abs(cachemtfTSST5r[idx].Multiplier - multiplier) <= double.Epsilon && cachemtfTSST5r[idx].Smooth == smooth && cachemtfTSST5r[idx].StMode == stMode && cachemtfTSST5r[idx].EqualsInput(input))
                            return cachemtfTSST5r[idx];

                mtfTSST5r indicator = new mtfTSST5r();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Length = length;
                indicator.MaType = maType;
                indicator.Multiplier = multiplier;
                indicator.Smooth = smooth;
                indicator.StMode = stMode;
                Indicators.Add(indicator);
                indicator.SetUp();

                mtfTSST5r[] tmp = new mtfTSST5r[cachemtfTSST5r == null ? 1 : cachemtfTSST5r.Length + 1];
                if (cachemtfTSST5r != null)
                    cachemtfTSST5r.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachemtfTSST5r = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.mtfTSST5r mtfTSST5r(int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            return _indicator.mtfTSST5r(Input, length, maType, multiplier, smooth, stMode);
        }

        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        public Indicator.mtfTSST5r mtfTSST5r(Data.IDataSeries input, int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            return _indicator.mtfTSST5r(input, length, maType, multiplier, smooth, stMode);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.mtfTSST5r mtfTSST5r(int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            return _indicator.mtfTSST5r(Input, length, maType, multiplier, smooth, stMode);
        }

        /// <summary>
        /// MTF BIP=1  5 Range modification of TradingStudies.com (Vertsion 2.3)
        /// </summary>
        /// <returns></returns>
        public Indicator.mtfTSST5r mtfTSST5r(Data.IDataSeries input, int length, MovingAverageType maType, double multiplier, int smooth, SuperTrendMode stMode)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.mtfTSST5r(input, length, maType, multiplier, smooth, stMode);
        }
    }
}
#endregion
