#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

	#region Enums Chart Type
		public enum xcMovAvg_ChartType {Minute, Tick, Range}
	#endregion

	#region Enums Moving Avg
		public enum xcMovAvg_maType
			{
				SMA,
				EMA,
				HMA,
				WMA
				//BMTCollectiveMA,
				//LineOnClose
			};
	//====================================================
	#endregion
		

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("(Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period")]
    public class xcMovAvg : Indicator
    {
        #region Variables
		
        	private xcMovAvg_ChartType chartType	= xcMovAvg_ChartType.Minute;	// default minute
			private int altPeriod				= 5;
			private xcMovAvg_maType maType		= xcMovAvg_maType.EMA;					//default EMA
			private int maPeriod				= 20;

		//===============================================
			private double _altMA				= 0;
		
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen (Color.FromKnownColor(KnownColor.ForestGreen), 3), PlotStyle.Line, "Plot0"));
			Plots[0].Pen.DashStyle = DashStyle.Dot;
			
			CalculateOnBarClose	= true;
			DisplayInDataBox	= false;
			Overlay				= true;		
			PaintPriceMarkers	= false;
		
			Add(PeriodType.Minute, altPeriod);  // BarsInProgress index = 1
			Add(PeriodType.Tick, altPeriod);   // BarsInProgress index = 2
			Add(PeriodType.Range, altPeriod);   // BarsInProgress index = 3


				
		}

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            
			//========================================
			if (BarsInProgress == 1)  //Minute Chart
			{
				if (chartType == xcMovAvg_ChartType.Minute)
				{
					if (maType == xcMovAvg_maType.SMA)
						_altMA = (SMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.EMA)
						_altMA = (EMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.HMA)
						_altMA = (HMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.WMA)
						_altMA = (WMA(Input, maPeriod) [0]);
					//else if (maType == xcMovAvg_maType.BMTCollectiveMA)
					//	_altMA = (BMTCollectiveMA() [0]);
					//else if (maType == xcMovAvg_maType.LineOnClose)
					//	_altMA = (LineOnClose() [0]);
					//-----default value of EMA
					else
						_altMA = (EMA(Input, maPeriod) [0]);
					
				}
			}
			
			//==========================================
			if (BarsInProgress == 2)    //TickChart
			{
				if (chartType == xcMovAvg_ChartType.Tick)
				{	
					if (maType == xcMovAvg_maType.SMA)
						_altMA = (SMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.EMA)
						_altMA = (EMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.HMA)
						_altMA = (HMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.WMA)
						_altMA = (WMA(Input, maPeriod) [0]);
					//else if (maType == xcMovAvg_maType.BMTCollectiveMA)
					//	_altMA = (BMTCollectiveMA() [0]);
					//else if (maType == xcMovAvg_maType.LineOnClose)
					//	_altMA = (LineOnClose() [0]);
					//-----default value of EMA
					else
						_altMA = (EMA(Input, maPeriod) [0]);

				}
			}
			
			
			//===================================================
			if (BarsInProgress == 3) // Range Chart
			{
				if (chartType == xcMovAvg_ChartType.Range)
				{
					if (maType == xcMovAvg_maType.SMA)
						_altMA = (SMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.EMA)
						_altMA = (EMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.HMA)
						_altMA = (HMA(Input, maPeriod) [0]);
					else if (maType == xcMovAvg_maType.WMA)
						_altMA = (WMA(Input, maPeriod) [0]);
					//else if (maType == xcMovAvg_maType.BMTCollectiveMA)
					//	_altMA = (BMTCollectiveMA() [0]);
					//else if (maType == xcMovAvg_maType.LineOnClose)
					//	_altMA = (LineOnClose() [0]);
					//-----default value of EMA
					else
						_altMA = (EMA(Input, maPeriod) [0]);
				}
			}

			
			
			
			//=========================================
			if (BarsInProgress == 0)	// Plots on Current Chart
			{
				if (CurrentBar > maPeriod)
				{
					Plot0.Set(_altMA);
				}
			}
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Description("")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("1. Alt Chart Type")]
        public xcMovAvg_ChartType ChartType
        {
            get { return chartType; }
            set { chartType = value; }
        }
		
        [Description("")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("2. Alt Chart Period")]
        public int AltPeriod
        {
            get { return altPeriod; }
            set { altPeriod = Math.Max(1, value); }
        }
        [Description("")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("3. MovAvg Type")]
        public xcMovAvg_maType MaType
        {
            get { return maType; }
            set { maType = value; }
        }
		
        [Description("")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("4. MovAvg Period")]
        public int MaPeriod
        {
            get { return maPeriod; }
            set { maPeriod = Math.Max(1, value); }
        }
		
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private xcMovAvg[] cachexcMovAvg = null;

        private static xcMovAvg checkxcMovAvg = new xcMovAvg();

        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        public xcMovAvg xcMovAvg(int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            return xcMovAvg(Input, altPeriod, chartType, maPeriod, maType);
        }

        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        public xcMovAvg xcMovAvg(Data.IDataSeries input, int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            if (cachexcMovAvg != null)
                for (int idx = 0; idx < cachexcMovAvg.Length; idx++)
                    if (cachexcMovAvg[idx].AltPeriod == altPeriod && cachexcMovAvg[idx].ChartType == chartType && cachexcMovAvg[idx].MaPeriod == maPeriod && cachexcMovAvg[idx].MaType == maType && cachexcMovAvg[idx].EqualsInput(input))
                        return cachexcMovAvg[idx];

            lock (checkxcMovAvg)
            {
                checkxcMovAvg.AltPeriod = altPeriod;
                altPeriod = checkxcMovAvg.AltPeriod;
                checkxcMovAvg.ChartType = chartType;
                chartType = checkxcMovAvg.ChartType;
                checkxcMovAvg.MaPeriod = maPeriod;
                maPeriod = checkxcMovAvg.MaPeriod;
                checkxcMovAvg.MaType = maType;
                maType = checkxcMovAvg.MaType;

                if (cachexcMovAvg != null)
                    for (int idx = 0; idx < cachexcMovAvg.Length; idx++)
                        if (cachexcMovAvg[idx].AltPeriod == altPeriod && cachexcMovAvg[idx].ChartType == chartType && cachexcMovAvg[idx].MaPeriod == maPeriod && cachexcMovAvg[idx].MaType == maType && cachexcMovAvg[idx].EqualsInput(input))
                            return cachexcMovAvg[idx];

                xcMovAvg indicator = new xcMovAvg();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AltPeriod = altPeriod;
                indicator.ChartType = chartType;
                indicator.MaPeriod = maPeriod;
                indicator.MaType = maType;
                Indicators.Add(indicator);
                indicator.SetUp();

                xcMovAvg[] tmp = new xcMovAvg[cachexcMovAvg == null ? 1 : cachexcMovAvg.Length + 1];
                if (cachexcMovAvg != null)
                    cachexcMovAvg.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachexcMovAvg = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.xcMovAvg xcMovAvg(int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            return _indicator.xcMovAvg(Input, altPeriod, chartType, maPeriod, maType);
        }

        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        public Indicator.xcMovAvg xcMovAvg(Data.IDataSeries input, int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            return _indicator.xcMovAvg(input, altPeriod, chartType, maPeriod, maType);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.xcMovAvg xcMovAvg(int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            return _indicator.xcMovAvg(Input, altPeriod, chartType, maPeriod, maType);
        }

        /// <summary>
        /// (Ver 1.5   02/18/2011)   by Photog53    Plots Moving Avg from alternate Chart.  Select Alt chart type and alternate time period.  Will plot that specific data on current chart of different type/time period
        /// </summary>
        /// <returns></returns>
        public Indicator.xcMovAvg xcMovAvg(Data.IDataSeries input, int altPeriod, xcMovAvg_ChartType chartType, int maPeriod, xcMovAvg_maType maType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.xcMovAvg(input, altPeriod, chartType, maPeriod, maType);
        }
    }
}
#endregion
