// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Collections;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region Global Enums

public enum anaPlotAlignCD29 {Left, Right, DoNotPlot}
public enum anaSessionTypeCD29 {ETH, RTH}
public enum anaSessionCountCD29 {First, Second, Third}

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Current Open, High, Low and Fibonacci Levels.
	/// </summary>
	[Description("anaCurrentDayOHLV29.")]
	public class anaCurrentDayOHLV29 : Indicator
	{
		#region Variables
		private	SolidBrush[]		brushes					= { new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black)};
		private DateTime 			sessionBegin			= Cbi.Globals.MinDate;
		private DateTime 			sessionEnd 				= Cbi.Globals.MinDate;
		private DateTime			plotStart				= Cbi.Globals.MinDate;
		private DateTime			cacheSessionBeginTmp   	= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionDate		= Cbi.Globals.MinDate;
		private DateTime			sessionDateTmp			= Cbi.Globals.MinDate;
		private DateTime			currentDate				= Cbi.Globals.MinDate;
		private DateTime			highTime				= Cbi.Globals.MinDate;
		private DateTime			lowTime					= Cbi.Globals.MinDate;
		private double				currentOpen				= 0;
		private	double				currentHigh				= double.MinValue;
		private	double				currentLow				= double.MaxValue;
		private double				currentMidline			= 0;
		private double				fib786					= 0;
		private double				fib618					= 0;
		private double				fib382					= 0;
		private double				fib236					= 0;
		private SolidBrush			textBrush				= new SolidBrush(Color.Red);
		private Font				textFont				= new Font("Arial", 12);
		private string				errorData1				= "Current Day OHL can only be displayed on intraday charts.";
		private	string				errorData2				= "Insufficient historical data to calculate OHL of current day. Please increase chart look back period.";
        private float				errorTextWidth			= 0;
        private float				errorTextHeight			= 0;
		private bool				plotOHL					= false;
		private bool				periodOpen				= false;
		private bool				init					= false;
		private bool				skipPublicHoliday		= false; 
		private bool				isPublicHoliday			= false; 
		private bool				rthOHL					= false;
		private bool				showCurrentOpen			= true;
		private bool				showFibonacci			= true;
		private ArrayList			newSessionBarIdxArr1	= new ArrayList();
		private anaPlotAlignCD29	plotLabels				= anaPlotAlignCD29.Right;
		private anaSessionTypeCD29	currentSession			= anaSessionTypeCD29.ETH;
		private anaSessionCountCD29 activeSession			= anaSessionCountCD29.Second;
		private Data.PivotRange		pivotRangeType1			= PivotRange.Daily;
		private	StringFormat		stringFormatFar			= new StringFormat();
		private	StringFormat		stringFormatNear		= new StringFormat();
		private	StringFormat		stringFormatCenter		= new StringFormat();
		private int					numberOfSessions		= 1;
		private int					sessionCount			= 0;
		private int					width					= 15;
		private int					labelPosition			= 10;
		private DateTime			publicHoliday0			= new DateTime (2009,01,19);
		private DateTime			publicHoliday1			= new DateTime (2009,02,16);
		private DateTime			publicHoliday2			= new DateTime (2009,05,25);
		private DateTime			publicHoliday3			= new DateTime (2009,07,03);
		private DateTime			publicHoliday4			= new DateTime (2009,09,07);
		private DateTime			publicHoliday5			= new DateTime (2009,11,26);
		private DateTime			publicHoliday6			= new DateTime (2010,01,18);
		private DateTime			publicHoliday7			= new DateTime (2010,02,15);
		private DateTime			publicHoliday8			= new DateTime (2010,05,31);
		private DateTime			publicHoliday9			= new DateTime (2010,07,05);
		private DateTime			publicHoliday10			= new DateTime (2010,09,06);
		private DateTime			publicHoliday11			= new DateTime (2010,11,25);
		private DateTime[]			publicHoliday			= new DateTime [12];

		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			
			Add(new Plot(new Pen(Color.PeachPuff,1), PlotStyle.Line,"D-Open "));
			Add(new Plot(new Pen(Color.Lime,1), PlotStyle.Line,"D-High "));
			Add(new Plot(new Pen(Color.OrangeRed,1), PlotStyle.Line,"D-Low "));
			Add(new Plot(new Pen(Color.MediumSpringGreen,1), PlotStyle.Line,"D-Mid "));
			Add(new Plot(new Pen(Color.Yellow,1), PlotStyle.Line,"D-78,6 "));
			Add(new Plot(new Pen(Color.Yellow,1), PlotStyle.Line,"D-61,8 "));
			Add(new Plot(new Pen(Color.Yellow,1), PlotStyle.Line,"D-38,2 "));
			Add(new Plot(new Pen(Color.Yellow,1), PlotStyle.Line,"D-23,6 "));
			
			Plots[0].Pen.DashStyle = DashStyle.Solid;
			Plots[1].Pen.DashStyle = DashStyle.Solid;
			Plots[2].Pen.DashStyle = DashStyle.Solid;
			Plots[3].Pen.DashStyle = DashStyle.Solid;
			Plots[4].Pen.DashStyle = DashStyle.Solid;
			Plots[5].Pen.DashStyle = DashStyle.Solid;
			Plots[6].Pen.DashStyle = DashStyle.Solid;
			Plots[7].Pen.DashStyle = DashStyle.Solid;

			for(int i=0; i<10; i++)
				publicHoliday[i] = Cbi.Globals.MinDate;

			AutoScale						= false;
			Overlay							= true;
			ZOrder							= 1;
			stringFormatNear.Alignment 		= StringAlignment.Near;
			stringFormatCenter.Alignment 	= StringAlignment.Center;
			stringFormatFar.Alignment		= StringAlignment.Far;
			
			// Defining all instruments for which this indicator can be used. Indicator will not show on any instruments not listed here!
			
			if(Instrument == null)
				return;
		}

		/// <summary>
		/// </summary>
		protected override void OnStartUp()
		{
			publicHoliday[0] = publicHoliday0;
			publicHoliday[1] = publicHoliday1;
			publicHoliday[2] = publicHoliday2;
			publicHoliday[3] = publicHoliday3;
			publicHoliday[4] = publicHoliday4;
			publicHoliday[5] = publicHoliday5;
			publicHoliday[6] = publicHoliday6;
			publicHoliday[7] = publicHoliday7;
			publicHoliday[8] = publicHoliday8;
			publicHoliday[9] = publicHoliday9;
			publicHoliday[10] = publicHoliday10;
			publicHoliday[11] = publicHoliday11;
			
			if (currentSession == anaSessionTypeCD29.ETH)
				rthOHL = false;
			else
				rthOHL = true;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (Bars == null)
				return; 
			if (!Data.BarsType.GetInstance(Bars.Period.Id).IsIntraday)
			{
				textBrush.Color = ChartControl.AxisColor;
				DrawTextFixed("errortag1", errorData1, TextPosition.Center, textBrush.Color, textFont, Color.Transparent,Color.Transparent,0);
				return;
			}
			if (CurrentBar == 0)
			{	
				currentDate = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
				Bars.Session.GetNextBeginEnd(Time[0], out sessionBegin, out sessionEnd);
				plotStart = sessionEnd;
				if (plotStart.DayOfWeek == DayOfWeek.Saturday)
					plotStart = plotStart.AddDays(2);
				return;
			}
			
			DateTime lastBarTimeStamp1 = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
			if (lastBarTimeStamp1 != currentDate)
			{	
				if (FirstTickOfBar)
				{
					sessionCount = 1;
					periodOpen = false;
					init = false;
				}
				if (numberOfSessions == 1 || !rthOHL || (rthOHL && activeSession == anaSessionCountCD29.First))
				{
					periodOpen = true;
					init = true;
					if (!skipPublicHoliday || rthOHL)
					{
						currentOpen		= Open[0];
						currentHigh		= High[0];
						currentLow		= Low[0];
						highTime		= Time[0];
						lowTime			= Time[0];
					}
					else
					{
						if (High[0] >= currentHigh)
						{
							currentHigh = High[0];
							highTime = Time[0];
						}
						if (Low[0] <= currentLow)
						{
							currentLow = Low[0];
							lowTime = Time[0];
						}
					}
				}
				currentDate = lastBarTimeStamp1;
				skipPublicHoliday = false;
				for (int i =0; i<12; i++)
				{
					if (publicHoliday[i].Date == currentDate)
						skipPublicHoliday = true;
				}
				plotOHL = true;
			}
			else if (Bars.FirstBarOfSession)
			{
				if (FirstTickOfBar)
				{
					sessionCount = sessionCount +1;
					numberOfSessions = Math.Min(3, Math.Max(sessionCount, numberOfSessions));
				}
				if (!rthOHL)
				{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime = Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow = Low[0];
						lowTime = Time[0];
					}
				}
				else if (rthOHL && ((sessionCount == 2 && activeSession == anaSessionCountCD29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountCD29.Third)))
				{
					currentOpen		= Open[0];
					currentHigh		= High[0];
					currentLow		= Low[0];
					highTime		= Time[0];
					lowTime			= Time[0];
					periodOpen		= true;
					init 			= true;
				}
				else
					periodOpen = false;
			}
			else if (periodOpen)
			{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime = Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow = Low[0];
						lowTime = Time[0];
					}
			}

			if (plotOHL && init && !(rthOHL && activeSession == anaSessionCountCD29.Third && numberOfSessions == 2))
			{
				CurrentHigh.Set(currentHigh);
   			  	CurrentLow.Set(currentLow);
				CurrentMidline.Set(Math.Round((currentLow + 0.5*(currentHigh-currentLow))/TickSize)* TickSize);
				if (ShowCurrentOpen)
					CurrentOpen.Set(currentOpen);
				if (ShowFibonacci && lowTime >= highTime)				
				{	
					Fib786.Set(Math.Round((currentLow + 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
					Fib618.Set(Math.Round((currentLow + 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentLow + 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib236.Set(Math.Round((currentLow + 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
				}
				else if (ShowFibonacci)
				{
					Fib236.Set(Math.Round((currentHigh - 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentHigh - 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib618.Set(Math.Round((currentHigh - 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib786.Set(Math.Round((currentHigh - 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
				}	
			}
			else
			{
				CurrentHigh.Set(0);
   			  	CurrentLow.Set(0);
				CurrentMidline.Set(0);
				CurrentOpen.Set(0);
				Fib786.Set(0); 
				Fib618.Set(0); 
				Fib382.Set(0); 
				Fib236.Set(0);
			}
		}


		#region Properties
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session")]
		public anaSessionTypeCD29 CurrentSession
		{
			get { return currentSession; }
			set { currentSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session for RTH")]
		public anaSessionCountCD29 ActiveSession
		{
			get { return activeSession; }
			set { activeSession = value; }
		}

		/// <summary>
		/// </summary>
		[Description("Option to show CurrentOpen")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Current Open")]
		public bool ShowCurrentOpen 
		{
			get { return showCurrentOpen; }
			set { showCurrentOpen = value; }
		}
		
		[Description("Option to show Fibonacci Lines")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Fibonacci Retracements")]
		public bool ShowFibonacci 
		{
			get { return showFibonacci; }
			set { showFibonacci = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option where to plot labels")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Position")]
		public anaPlotAlignCD29 PlotLabels
		{
			get { return plotLabels; }
			set { plotLabels = value; }
		}
			
		/// <summary>
		/// </summary>
		[Description("Label distance from line.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Offset")]
		public int LabelPosition
		{
			get { return labelPosition; }
			set { labelPosition = Math.Max(1, value); }
		}
	
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentOpen
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentHigh
		{
			get { return Values[1]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentLow
		{
			get { return Values[2]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentMidline
		{
			get { return Values[3]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib786
		{
			get { return Values[4]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib618
		{
			get { return Values[5]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib382
		{
			get { return Values[6]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib236
		{
			get { return Values[7]; }
		}

		/// <summary>
		/// </summary>
		[Description("Width of the OHL lines as # of bars.")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width")]
		public int Width
		{
			get { return width; }
			set { width = Math.Max(1, value); }
		}
		
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
        [GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 01 /No Trade Date")]
		public DateTime PublicHoliday0
		{
			get { return publicHoliday0;}
			set { publicHoliday0 = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 02 /No Trade Date")]
		public DateTime PublicHoliday1
		{
			get { return publicHoliday1;}
			set { publicHoliday1 = value;}
		}	
		
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 03 /No Trade Date")]
		public DateTime PublicHoliday2
		{
			get { return publicHoliday2;}
			set { publicHoliday2 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 04 /No Trade Date")]
		public DateTime PublicHoliday3
		{
			get { return publicHoliday3;}
			set { publicHoliday3 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 05 /No Trade Date")]
		public DateTime PublicHoliday4
		{
			get { return publicHoliday4;}
			set { publicHoliday4 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 06 /No Trade Date")]
		public DateTime PublicHoliday5
		{
			get { return publicHoliday5;}
			set { publicHoliday5 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 07 /No Trade Date")]
		public DateTime PublicHoliday6
		{
			get { return publicHoliday6;}
			set { publicHoliday6 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 08 /No Trade Date")]
		public DateTime PublicHoliday7
		{
			get { return publicHoliday7;}
			set { publicHoliday7 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 09 /No Trade Date")]
		public DateTime PublicHoliday8
		{
			get { return publicHoliday8;}
			set { publicHoliday8 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 10 /No Trade Date")]
		public DateTime PublicHoliday9
		{
			get { return publicHoliday9;}
			set { publicHoliday9 = value;}
		}	
		
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 11 /No Trade Date")]
		public DateTime PublicHoliday10
		{
			get { return publicHoliday10;}
			set { publicHoliday10 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 12 /No Trade Date")]
		public DateTime PublicHoliday11
		{
			get { return publicHoliday11;}
			set { publicHoliday11 = value;}
		}	
		
		#endregion

		
		#region Miscellaneous

		private DateTime GetLastBarSessionDate(DateTime time, Data.Bars bars, PivotRange pivotRange)
		{
			if (time > cacheSessionEndTmp)
			{
				isPublicHoliday = false;
				for (int i =0; i<12; i++)
				{
					if (publicHoliday[i].Date == sessionDateTmp)
						isPublicHoliday = true;
				}
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				
				if(cacheSessionDate != sessionDateTmp || (rthOHL && sessionCount == 1 && activeSession == anaSessionCountCD29.Second)
					|| (rthOHL && sessionCount ==2 && activeSession == anaSessionCountCD29.Third)) 
					{
						cacheSessionDate = sessionDateTmp;
						if ((!isPublicHoliday || rthOHL) && (newSessionBarIdxArr1.Count == 0 
							|| (newSessionBarIdxArr1.Count > 0 && CurrentBar > (int) newSessionBarIdxArr1[newSessionBarIdxArr1.Count - 1])))
								newSessionBarIdxArr1.Add(CurrentBar);
					}
			}
			return sessionDateTmp;
		}
		
		
		internal void InvalidateNow()
		{
			if (Disposed || ChartControl == null)
				return;

			ChartControl.Invalidate(true);
		}

		/// <summary>
        /// Overload this method to handle the termination of an indicator. Use this method to dispose of any resources vs overloading the Dispose() method.
		/// </summary>
		protected override void OnTermination()
		{
			textBrush.Dispose();
			foreach (SolidBrush solidBrush in brushes)
				solidBrush.Dispose();
			stringFormatCenter.Dispose();
			stringFormatFar.Dispose();	
			stringFormatNear.Dispose();
		}
	
		/// <summary>
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="bounds"></param>
		/// <param name="min"></param>
		/// <param name="max"></param>
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (Bars == null || ChartControl == null)
				return;

			// plot error if data not complete
			DateTime lastBarSessionBegin = Cbi.Globals.MinDate;
			DateTime lastBarSessionEnd = Cbi.Globals.MinDate;
			Bars.Session.GetNextBeginEnd(Bars.Get(Math.Min(Bars.Count - 1, this.LastBarIndexPainted)).Time, out lastBarSessionBegin, out lastBarSessionEnd);
			textBrush.Color = ChartControl.AxisColor;
			SizeF errorSize	= graphics.MeasureString(errorData2, textFont);
			errorTextWidth	= errorSize.Width + 5;
			errorTextHeight	= errorSize.Height + 5;
			if (Bars.Count > 0 && plotStart.Date >= lastBarSessionEnd.Date)
				graphics.DrawString(errorData2, textFont, textBrush, bounds.X + bounds.Width - errorTextWidth, bounds.Y + bounds.Height - errorTextHeight, stringFormatNear);
			
			int	barWidth = ChartControl.ChartStyle.GetBarPaintWidth(Bars.BarsData.ChartStyle.BarWidthUI);
			for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
			{
				SolidBrush		brush				= brushes[seriesCount];
				int				firstBarIdxToPaint	= -1;
				int				lastX				= -1;
				int				lastY				= -1;
				int				firstX				= -1;
				SmoothingMode	oldSmoothingMode	= graphics.SmoothingMode;
				Gui.Chart.Plot	plot				= Plots[seriesCount];
				DataSeries		series				= (DataSeries) Values[seriesCount];

				for (int i = newSessionBarIdxArr1.Count - 1; i >= 0; i--)
				{
					int prevSessionBreakIdx = (int) newSessionBarIdxArr1[i];
					if (prevSessionBreakIdx <= this.LastBarIndexPainted)
					{
						firstBarIdxToPaint = prevSessionBreakIdx;
						break;
					}
				}

				using (GraphicsPath	path = new GraphicsPath()) 
				{
					if (brush.Color != plot.Pen.Color)	
						brush = new SolidBrush(plot.Pen.Color);

					for (int idx = this.LastBarIndexPainted; idx >= Math.Max(this.FirstBarIndexPainted, this.LastBarIndexPainted - Width); idx--)
					{
						if (idx - Displacement < 0 || idx - Displacement >= Bars.Count || (!ChartControl.ShowBarsRequired && idx - Displacement < BarsRequired))
							continue;
						else if (!series.IsValidPlot(idx))
							continue;

						if (idx < firstBarIdxToPaint)
							break;

						double	val = series.Get(idx);
						int		x	= ChartControl.GetXByBarIdx(BarsArray[0], idx);
						int		y	= ChartControl.GetYByValue(this, val);

						if (lastX >= 0)
						{
							if (y != lastY) // Problem here is, that last bar of old day has date of new day
								y = lastY;
							path.AddLine(lastX - plot.Pen.Width / 2, lastY, x - plot.Pen.Width / 2, y);
						}
						lastX	= x;
						lastY	= y;
						if (idx == this.LastBarIndexPainted || idx == this.LastBarIndexPainted-1)
							firstX	= x;
					}

					graphics.SmoothingMode = SmoothingMode.AntiAlias;
					graphics.DrawPath(plot.Pen, path);
					graphics.SmoothingMode = oldSmoothingMode;
					if (PlotLabels == anaPlotAlignCD29.Right)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, firstX + LabelPosition + 20, lastY - ChartControl.Font.GetHeight() / 2, stringFormatNear);
					if (PlotLabels == anaPlotAlignCD29.Left)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, lastX - LabelPosition, lastY - ChartControl.Font.GetHeight() / 2, stringFormatFar);
				}
			}
		}

		private DateTime RoundUpTimeToPeriodTime(DateTime time, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Weekly)
			{
				DateTime periodStart = time.AddDays((6 - (((int) time.DayOfWeek) + 1) % 7));
				return periodStart.Date.AddDays(System.Math.Ceiling(System.Math.Ceiling(time.Date.Subtract(periodStart.Date).TotalDays) / 7) * 7).Date;
			}
			else if (pivotRange == PivotRange.Monthly)
			{
				DateTime result = new DateTime(time.Year, time.Month, 1); 
				return result.AddMonths(1).AddDays(-1);
			}
			else
				return time;
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaCurrentDayOHLV29[] cacheanaCurrentDayOHLV29 = null;

        private static anaCurrentDayOHLV29 checkanaCurrentDayOHLV29 = new anaCurrentDayOHLV29();

        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentDayOHLV29 anaCurrentDayOHLV29(anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return anaCurrentDayOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentDayOHLV29 anaCurrentDayOHLV29(Data.IDataSeries input, anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (cacheanaCurrentDayOHLV29 != null)
                for (int idx = 0; idx < cacheanaCurrentDayOHLV29.Length; idx++)
                    if (cacheanaCurrentDayOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentDayOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentDayOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentDayOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentDayOHLV29[idx].PublicHoliday0 == publicHoliday0 && cacheanaCurrentDayOHLV29[idx].PublicHoliday1 == publicHoliday1 && cacheanaCurrentDayOHLV29[idx].PublicHoliday10 == publicHoliday10 && cacheanaCurrentDayOHLV29[idx].PublicHoliday11 == publicHoliday11 && cacheanaCurrentDayOHLV29[idx].PublicHoliday2 == publicHoliday2 && cacheanaCurrentDayOHLV29[idx].PublicHoliday3 == publicHoliday3 && cacheanaCurrentDayOHLV29[idx].PublicHoliday4 == publicHoliday4 && cacheanaCurrentDayOHLV29[idx].PublicHoliday5 == publicHoliday5 && cacheanaCurrentDayOHLV29[idx].PublicHoliday6 == publicHoliday6 && cacheanaCurrentDayOHLV29[idx].PublicHoliday7 == publicHoliday7 && cacheanaCurrentDayOHLV29[idx].PublicHoliday8 == publicHoliday8 && cacheanaCurrentDayOHLV29[idx].PublicHoliday9 == publicHoliday9 && cacheanaCurrentDayOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentDayOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentDayOHLV29[idx].Width == width && cacheanaCurrentDayOHLV29[idx].EqualsInput(input))
                        return cacheanaCurrentDayOHLV29[idx];

            lock (checkanaCurrentDayOHLV29)
            {
                checkanaCurrentDayOHLV29.ActiveSession = activeSession;
                activeSession = checkanaCurrentDayOHLV29.ActiveSession;
                checkanaCurrentDayOHLV29.CurrentSession = currentSession;
                currentSession = checkanaCurrentDayOHLV29.CurrentSession;
                checkanaCurrentDayOHLV29.LabelPosition = labelPosition;
                labelPosition = checkanaCurrentDayOHLV29.LabelPosition;
                checkanaCurrentDayOHLV29.PlotLabels = plotLabels;
                plotLabels = checkanaCurrentDayOHLV29.PlotLabels;
                checkanaCurrentDayOHLV29.PublicHoliday0 = publicHoliday0;
                publicHoliday0 = checkanaCurrentDayOHLV29.PublicHoliday0;
                checkanaCurrentDayOHLV29.PublicHoliday1 = publicHoliday1;
                publicHoliday1 = checkanaCurrentDayOHLV29.PublicHoliday1;
                checkanaCurrentDayOHLV29.PublicHoliday10 = publicHoliday10;
                publicHoliday10 = checkanaCurrentDayOHLV29.PublicHoliday10;
                checkanaCurrentDayOHLV29.PublicHoliday11 = publicHoliday11;
                publicHoliday11 = checkanaCurrentDayOHLV29.PublicHoliday11;
                checkanaCurrentDayOHLV29.PublicHoliday2 = publicHoliday2;
                publicHoliday2 = checkanaCurrentDayOHLV29.PublicHoliday2;
                checkanaCurrentDayOHLV29.PublicHoliday3 = publicHoliday3;
                publicHoliday3 = checkanaCurrentDayOHLV29.PublicHoliday3;
                checkanaCurrentDayOHLV29.PublicHoliday4 = publicHoliday4;
                publicHoliday4 = checkanaCurrentDayOHLV29.PublicHoliday4;
                checkanaCurrentDayOHLV29.PublicHoliday5 = publicHoliday5;
                publicHoliday5 = checkanaCurrentDayOHLV29.PublicHoliday5;
                checkanaCurrentDayOHLV29.PublicHoliday6 = publicHoliday6;
                publicHoliday6 = checkanaCurrentDayOHLV29.PublicHoliday6;
                checkanaCurrentDayOHLV29.PublicHoliday7 = publicHoliday7;
                publicHoliday7 = checkanaCurrentDayOHLV29.PublicHoliday7;
                checkanaCurrentDayOHLV29.PublicHoliday8 = publicHoliday8;
                publicHoliday8 = checkanaCurrentDayOHLV29.PublicHoliday8;
                checkanaCurrentDayOHLV29.PublicHoliday9 = publicHoliday9;
                publicHoliday9 = checkanaCurrentDayOHLV29.PublicHoliday9;
                checkanaCurrentDayOHLV29.ShowCurrentOpen = showCurrentOpen;
                showCurrentOpen = checkanaCurrentDayOHLV29.ShowCurrentOpen;
                checkanaCurrentDayOHLV29.ShowFibonacci = showFibonacci;
                showFibonacci = checkanaCurrentDayOHLV29.ShowFibonacci;
                checkanaCurrentDayOHLV29.Width = width;
                width = checkanaCurrentDayOHLV29.Width;

                if (cacheanaCurrentDayOHLV29 != null)
                    for (int idx = 0; idx < cacheanaCurrentDayOHLV29.Length; idx++)
                        if (cacheanaCurrentDayOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentDayOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentDayOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentDayOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentDayOHLV29[idx].PublicHoliday0 == publicHoliday0 && cacheanaCurrentDayOHLV29[idx].PublicHoliday1 == publicHoliday1 && cacheanaCurrentDayOHLV29[idx].PublicHoliday10 == publicHoliday10 && cacheanaCurrentDayOHLV29[idx].PublicHoliday11 == publicHoliday11 && cacheanaCurrentDayOHLV29[idx].PublicHoliday2 == publicHoliday2 && cacheanaCurrentDayOHLV29[idx].PublicHoliday3 == publicHoliday3 && cacheanaCurrentDayOHLV29[idx].PublicHoliday4 == publicHoliday4 && cacheanaCurrentDayOHLV29[idx].PublicHoliday5 == publicHoliday5 && cacheanaCurrentDayOHLV29[idx].PublicHoliday6 == publicHoliday6 && cacheanaCurrentDayOHLV29[idx].PublicHoliday7 == publicHoliday7 && cacheanaCurrentDayOHLV29[idx].PublicHoliday8 == publicHoliday8 && cacheanaCurrentDayOHLV29[idx].PublicHoliday9 == publicHoliday9 && cacheanaCurrentDayOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentDayOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentDayOHLV29[idx].Width == width && cacheanaCurrentDayOHLV29[idx].EqualsInput(input))
                            return cacheanaCurrentDayOHLV29[idx];

                anaCurrentDayOHLV29 indicator = new anaCurrentDayOHLV29();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ActiveSession = activeSession;
                indicator.CurrentSession = currentSession;
                indicator.LabelPosition = labelPosition;
                indicator.PlotLabels = plotLabels;
                indicator.PublicHoliday0 = publicHoliday0;
                indicator.PublicHoliday1 = publicHoliday1;
                indicator.PublicHoliday10 = publicHoliday10;
                indicator.PublicHoliday11 = publicHoliday11;
                indicator.PublicHoliday2 = publicHoliday2;
                indicator.PublicHoliday3 = publicHoliday3;
                indicator.PublicHoliday4 = publicHoliday4;
                indicator.PublicHoliday5 = publicHoliday5;
                indicator.PublicHoliday6 = publicHoliday6;
                indicator.PublicHoliday7 = publicHoliday7;
                indicator.PublicHoliday8 = publicHoliday8;
                indicator.PublicHoliday9 = publicHoliday9;
                indicator.ShowCurrentOpen = showCurrentOpen;
                indicator.ShowFibonacci = showFibonacci;
                indicator.Width = width;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaCurrentDayOHLV29[] tmp = new anaCurrentDayOHLV29[cacheanaCurrentDayOHLV29 == null ? 1 : cacheanaCurrentDayOHLV29.Length + 1];
                if (cacheanaCurrentDayOHLV29 != null)
                    cacheanaCurrentDayOHLV29.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaCurrentDayOHLV29 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentDayOHLV29 anaCurrentDayOHLV29(anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentDayOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentDayOHLV29 anaCurrentDayOHLV29(Data.IDataSeries input, anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentDayOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showCurrentOpen, showFibonacci, width);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentDayOHLV29 anaCurrentDayOHLV29(anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentDayOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentDayOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentDayOHLV29 anaCurrentDayOHLV29(Data.IDataSeries input, anaSessionCountCD29 activeSession, anaSessionTypeCD29 currentSession, int labelPosition, anaPlotAlignCD29 plotLabels, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaCurrentDayOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showCurrentOpen, showFibonacci, width);
        }
    }
}
#endregion
