// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Collections;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region Global Enums

public enum anaPlotAlignCM29 {Left, Right, DoNotPlot}
public enum anaSessionTypeCM29 {ETH, RTH}
public enum anaSessionCountCM29 {First, Second, Third}

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Current Open, High, Low and Fibonacci Levels.
	/// </summary>
	[Description("anaCurrentMonthOHLV29.")]
	public class anaCurrentMonthOHLV29 : Indicator
	{
		#region Variables
		private	SolidBrush[]		brushes					= { new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black)};
		private	DateTime 			sessionBegin 			= Cbi.Globals.MinDate;
		private	DateTime 			sessionEnd 				= Cbi.Globals.MinDate;
		private	DateTime 			plotStart		 		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionBeginTmp   	= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp1		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp3		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionDate		= Cbi.Globals.MinDate;
		private DateTime			cacheMonthlyEndDate		= Cbi.Globals.MinDate;
		private DateTime			sessionDateTmp			= Cbi.Globals.MinDate;
		private DateTime			currentDate				= Cbi.Globals.MinDate;
		private DateTime			currentMonth			= Cbi.Globals.MinDate;
		private DateTime			highTime				= Cbi.Globals.MinDate;
		private DateTime			lowTime					= Cbi.Globals.MinDate;
		private double				currentOpen				= 0;
		private	double				currentHigh				= double.MinValue;
		private	double				currentLow				= double.MaxValue;
		private double				currentMidline			= 0;
		private double				fib786					= 0;
		private double				fib618					= 0;
		private double				fib382					= 0;
		private double				fib236					= 0;
		private SolidBrush			textBrush				= new SolidBrush(Color.Red);
		private Font				textFont				= new Font("Arial", 12);
		private	string				errorData2				= "Insufficient historical data to calculate OHL of current day. Please increase chart look back period.";
        private float				errorTextWidth			= 0;
        private float				errorTextHeight			= 0;
		private bool				plotOHL					= false;
		private bool				init					= false;
		private bool				periodOpen				= false;
		private bool				firstDayOfPeriod		= false;
		private bool				rthOHL					= false;
		private bool				showCurrentOpen			= true;
		private bool				showFibonacci			= true;
		private ArrayList			newSessionBarIdxArr1	= new ArrayList();
		private ArrayList			newSessionBarIdxArr3	= new ArrayList();
		private Data.PivotRange		pivotRangeType1			= PivotRange.Daily;
		private Data.PivotRange		pivotRangeType3			= PivotRange.Monthly;
		private anaPlotAlignCM29	plotLabels				= anaPlotAlignCM29.Right;
		private anaSessionTypeCM29	currentSession			= anaSessionTypeCM29.ETH;
		private anaSessionCountCM29 activeSession			= anaSessionCountCM29.Second;
		private	StringFormat		stringFormatFar			= new StringFormat();
		private	StringFormat		stringFormatNear		= new StringFormat();
		private	StringFormat		stringFormatCenter		= new StringFormat();
		private int					numberOfSessions		= 1;
		private int					sessionCount			= 0;
		private int					width					= 10;
		private int					labelPosition			= 10;

		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			
			Add(new Plot(new Pen(Color.White,1), PlotStyle.Line,"M-Open "));
			Add(new Plot(new Pen(Color.Lime,1), PlotStyle.Line,"M-High "));
			Add(new Plot(new Pen(Color.OrangeRed,1), PlotStyle.Line,"M-Low "));
			Add(new Plot(new Pen(Color.MediumSpringGreen,1), PlotStyle.Line,"M-Mid "));
			Add(new Plot(new Pen(Color.SandyBrown,1), PlotStyle.Line,"M-78,6 "));
			Add(new Plot(new Pen(Color.SandyBrown,1), PlotStyle.Line,"M-61,8 "));
			Add(new Plot(new Pen(Color.SandyBrown,1), PlotStyle.Line,"M-38,2 "));
			Add(new Plot(new Pen(Color.SandyBrown,1), PlotStyle.Line,"M-23,6 "));
			
			Plots[0].Pen.DashStyle = DashStyle.Solid;
			Plots[1].Pen.DashStyle = DashStyle.Solid;
			Plots[2].Pen.DashStyle = DashStyle.Solid;
			Plots[3].Pen.DashStyle = DashStyle.Solid;
			Plots[4].Pen.DashStyle = DashStyle.Solid;
			Plots[5].Pen.DashStyle = DashStyle.Solid;
			Plots[6].Pen.DashStyle = DashStyle.Solid;
			Plots[7].Pen.DashStyle = DashStyle.Solid;

			AutoScale						= false;
			Overlay							= true;
			stringFormatNear.Alignment 		= StringAlignment.Near;
			stringFormatCenter.Alignment 	= StringAlignment.Center;
			stringFormatFar.Alignment		= StringAlignment.Far;
			
			// Defining all instruments for which this indicator can be used. Indicator will not show on any instruments not listed here!
			
			if(Instrument == null)
				return;
		}

		/// <summary>
		/// </summary>
		protected override void OnStartUp()
		{
			if (currentSession == anaSessionTypeCM29.ETH)
				rthOHL = false;
			else
				rthOHL = true;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (Bars == null)
				return; 
			if (!Data.BarsType.GetInstance(Bars.Period.Id).IsIntraday && Bars.Period.Id != PeriodType.Day)
				return;
			if (Bars.Period.Id == PeriodType.Day && Bars.Period.Value > 1)
				return;

			if (CurrentBar == 0)
			{	
				currentDate = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
				currentMonth = GetLastBarSessionDate(Time[0], Bars, pivotRangeType3);
				Bars.Session.GetNextBeginEnd(Bars.Get(0).Time, out sessionBegin, out sessionEnd);
				plotStart = RoundUpTimeToPeriodTime(sessionEnd.Date, PivotRange.Monthly);
				return;
			}
			
			DateTime lastBarTimeStamp = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
			DateTime lastBarTimeStamp3 = GetLastBarSessionDate(Time[0], Bars, pivotRangeType3);
			if (lastBarTimeStamp3 != currentMonth)
			{	
				if (FirstTickOfBar)
				{
					firstDayOfPeriod = true;
					sessionCount = 1;
					periodOpen = false;
					init = false;
				}
				if (numberOfSessions == 1 || !rthOHL || (rthOHL && activeSession == anaSessionCountCM29.First))
				{
					periodOpen = true;
					init = true;
					currentOpen		= Open[0];
					currentHigh		= High[0];
					currentLow		= Low[0];
					highTime		= Time[0];
					lowTime			= Time[0];
				}
				currentDate = lastBarTimeStamp;
				currentMonth = lastBarTimeStamp3;
				plotOHL = true;
			}
			else if (lastBarTimeStamp != currentDate || Bars.Period.Id == PeriodType.Day)
			{
				if (FirstTickOfBar)
				{
					firstDayOfPeriod = false;
					sessionCount = 1;
				}
				if (numberOfSessions == 1 || !rthOHL || (rthOHL && activeSession == anaSessionCountCM29.First))
				{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime 	= Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow 	= Low[0];
						lowTime 	= Time[0];
					}
					periodOpen		= true;
					init			= true;
				}
				else
					periodOpen		= false;
				currentDate = lastBarTimeStamp;
			}
			else if (Bars.FirstBarOfSession)
			{
				if (FirstTickOfBar)
				{
					sessionCount = sessionCount +1;
					numberOfSessions = Math.Min(3, Math.Max(sessionCount, numberOfSessions));
				}
				if (!rthOHL|| (rthOHL && !firstDayOfPeriod && ((sessionCount == 2 && activeSession == anaSessionCountCM29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountCM29.Third))))
				{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime = Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow = Low[0];
						lowTime = Time[0];
					}
					periodOpen		= true;
					init			= true;
				}
				else if (rthOHL && firstDayOfPeriod && ((sessionCount == 2 && activeSession == anaSessionCountCM29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountCM29.Third)))
				{
					currentOpen		= Open[0];
					currentHigh		= High[0];
					currentLow		= Low[0];
					highTime		= Time[0];
					lowTime			= Time[0];
					periodOpen		= true;
					init 			= true;
				}
				else
					periodOpen = false;			}
			else if (periodOpen)
			{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime = Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow = Low[0];
						lowTime = Time[0];
					}
			}

			if (plotOHL && init && !(rthOHL && activeSession == anaSessionCountCM29.Third && numberOfSessions == 2))
			{
				CurrentHigh.Set(currentHigh);
   			  	CurrentLow.Set(currentLow);
				CurrentMidline.Set(Math.Round((currentLow + 0.5*(currentHigh-currentLow))/TickSize)* TickSize);
				if (ShowCurrentOpen)
					CurrentOpen.Set(currentOpen);
				if (ShowFibonacci && lowTime >= highTime)				
				{	
					Fib786.Set(Math.Round((currentLow + 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
					Fib618.Set(Math.Round((currentLow + 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentLow + 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib236.Set(Math.Round((currentLow + 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
				}
				else if (ShowFibonacci)
				{
					Fib236.Set(Math.Round((currentHigh - 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentHigh - 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib618.Set(Math.Round((currentHigh - 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib786.Set(Math.Round((currentHigh - 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
				}	
			}
			else
			{
				CurrentHigh.Set(0);
   			  	CurrentLow.Set(0);
				CurrentMidline.Set(0);
				CurrentOpen.Set(0);
				Fib786.Set(0); 
				Fib618.Set(0); 
				Fib382.Set(0); 
				Fib236.Set(0);
			}
		}


		#region Properties
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session")]
		public anaSessionTypeCM29 CurrentSession
		{
			get { return currentSession; }
			set { currentSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session for RTH")]
		public anaSessionCountCM29 ActiveSession
		{
			get { return activeSession; }
			set { activeSession = value; }
		}

		/// <summary>
		/// </summary>
		[Description("Option to show CurrentOpen")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Current Open")]
		public bool ShowCurrentOpen 
		{
			get { return showCurrentOpen; }
			set { showCurrentOpen = value; }
		}
		
		[Description("Option to show Fibonacci Lines")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Fibonacci Retracements")]
		public bool ShowFibonacci 
		{
			get { return showFibonacci; }
			set { showFibonacci = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option where to plot labels")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Position")]
		public anaPlotAlignCM29 PlotLabels
		{
			get { return plotLabels; }
			set { plotLabels = value; }
		}
			
		/// <summary>
		/// </summary>
		[Description("Label distance from line.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Offset")]
		public int LabelPosition
		{
			get { return labelPosition; }
			set { labelPosition = Math.Max(1, value); }
		}
	
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentOpen
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentHigh
		{
			get { return Values[1]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentLow
		{
			get { return Values[2]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentMidline
		{
			get { return Values[3]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib786
		{
			get { return Values[4]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib618
		{
			get { return Values[5]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib382
		{
			get { return Values[6]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib236
		{
			get { return Values[7]; }
		}

		/// <summary>
		/// </summary>
		[Description("Width of the OHL lines as # of bars.")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width")]
		public int Width
		{
			get { return width; }
			set { width = Math.Max(1, value); }
		}

		#endregion

		
		#region Miscellaneous

		private DateTime GetLastBarSessionDate(DateTime time, Data.Bars bars, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Daily && time > cacheSessionEndTmp1)
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp1);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				if(cacheSessionDate != sessionDateTmp) 
					{
						cacheSessionDate = sessionDateTmp;
						if (newSessionBarIdxArr1.Count == 0 || (newSessionBarIdxArr1.Count > 0 && CurrentBar > (int) newSessionBarIdxArr1[newSessionBarIdxArr1.Count - 1]))
								newSessionBarIdxArr1.Add(CurrentBar);
					}
			}
			else if (pivotRange == PivotRange.Monthly && time > cacheSessionEndTmp3) 
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp3);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				
				DateTime tmpMonthlyEndDate = RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Monthly);
				if (tmpMonthlyEndDate != cacheMonthlyEndDate || (rthOHL && firstDayOfPeriod && sessionCount == 1 && activeSession == anaSessionCountCM29.Second)
					|| (rthOHL && firstDayOfPeriod && sessionCount ==2 && activeSession == anaSessionCountCM29.Third))
				{
					cacheMonthlyEndDate = tmpMonthlyEndDate;
					if (newSessionBarIdxArr3.Count == 0 || (newSessionBarIdxArr3.Count > 0 && CurrentBar > (int) newSessionBarIdxArr3[newSessionBarIdxArr3.Count - 1]))
						newSessionBarIdxArr3.Add(CurrentBar);
				}
			}
			if (pivotRange == PivotRange.Monthly)
				return RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Monthly);
			else // if (pivot Range == PivotRange.Daily)
				return sessionDateTmp;
		}		
		
		internal void InvalidateNow()
		{
			if (Disposed || ChartControl == null)
				return;

			ChartControl.Invalidate(true);
		}

		/// <summary>
        /// Overload this method to handle the termination of an indicator. Use this method to dispose of any resources vs overloading the Dispose() method.
		/// </summary>
		protected override void OnTermination()
		{
			textBrush.Dispose();
			foreach (SolidBrush solidBrush in brushes)
				solidBrush.Dispose();
			stringFormatCenter.Dispose();
			stringFormatFar.Dispose();	
			stringFormatNear.Dispose();
		}
	
		/// <summary>
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="bounds"></param>
		/// <param name="min"></param>
		/// <param name="max"></param>
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (Bars == null || ChartControl == null)
				return;

			// plot error if data not complete
			DateTime lastBarSessionBegin = Cbi.Globals.MinDate;
			DateTime lastBarSessionEnd = Cbi.Globals.MinDate;
			Bars.Session.GetNextBeginEnd(Bars.Get(Math.Min(Bars.Count - 1, this.LastBarIndexPainted)).Time, out lastBarSessionBegin, out lastBarSessionEnd);
			textBrush.Color = ChartControl.AxisColor;
			SizeF errorSize	= graphics.MeasureString(errorData2, textFont);
			errorTextWidth	= errorSize.Width + 5;
			errorTextHeight	= errorSize.Height + 5;
			if (Bars.Count > 0 && plotStart.Date >= lastBarSessionEnd.Date)
				graphics.DrawString(errorData2, textFont, textBrush, bounds.X + bounds.Width - errorTextWidth, bounds.Y + bounds.Height - errorTextHeight, stringFormatNear);

			int	barWidth = ChartControl.ChartStyle.GetBarPaintWidth(Bars.BarsData.ChartStyle.BarWidthUI);
			for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
			{
				SolidBrush		brush				= brushes[seriesCount];
				int				firstBarIdxToPaint	= -1;
				int				lastX				= -1;
				int				lastY				= -1;
				int				firstX				= -1;
				SmoothingMode	oldSmoothingMode	= graphics.SmoothingMode;
				Gui.Chart.Plot	plot				= Plots[seriesCount];
				DataSeries		series				= (DataSeries) Values[seriesCount];

				for (int i = newSessionBarIdxArr3.Count - 1; i >= 0; i--)
				{
					int prevSessionBreakIdx = (int) newSessionBarIdxArr3[i];
					if (prevSessionBreakIdx <= this.LastBarIndexPainted)
					{
						firstBarIdxToPaint = prevSessionBreakIdx;
						break;
					}
				}

				using (GraphicsPath	path = new GraphicsPath()) 
				{
					if (brush.Color != plot.Pen.Color)	
						brush = new SolidBrush(plot.Pen.Color);

					for (int idx = this.LastBarIndexPainted; idx >= Math.Max(this.FirstBarIndexPainted, this.LastBarIndexPainted - Width); idx--)
					{
						if (idx - Displacement < 0 || idx - Displacement >= Bars.Count || (!ChartControl.ShowBarsRequired && idx - Displacement < BarsRequired))
							continue;
						else if (!series.IsValidPlot(idx))
							continue;

						if (idx < firstBarIdxToPaint)
							break;

						double	val = series.Get(idx);
						int		x	= ChartControl.GetXByBarIdx(BarsArray[0], idx);
						int		y	= ChartControl.GetYByValue(this, val);

						if (lastX >= 0)
						{
							if (y != lastY) // Problem here is, that last bar of old day has date of new day
								y = lastY;
							path.AddLine(lastX - plot.Pen.Width / 2, lastY, x - plot.Pen.Width / 2, y);
						}
						lastX	= x;
						lastY	= y;
						if (idx == this.LastBarIndexPainted || idx == this.LastBarIndexPainted-1)
							firstX	= x;
					}

					graphics.SmoothingMode = SmoothingMode.AntiAlias;
					graphics.DrawPath(plot.Pen, path);
					graphics.SmoothingMode = oldSmoothingMode;
					if (PlotLabels == anaPlotAlignCM29.Right)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, firstX + LabelPosition + 20, lastY - ChartControl.Font.GetHeight() / 2, stringFormatNear);
					if (PlotLabels == anaPlotAlignCM29.Left)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, lastX - LabelPosition, lastY - ChartControl.Font.GetHeight() / 2, stringFormatFar);
				}
			}
		}
		
		private DateTime RoundUpTimeToPeriodTime(DateTime time, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Weekly)
			{
				DateTime periodStart = time.AddDays((6 - (((int) time.DayOfWeek) + 1) % 7));
				return periodStart.Date.AddDays(System.Math.Ceiling(System.Math.Ceiling(time.Date.Subtract(periodStart.Date).TotalDays) / 7) * 7).Date;
			}
			else if (pivotRange == PivotRange.Monthly)
			{
				DateTime result = new DateTime(time.Year, time.Month, 1); 
				return result.AddMonths(1).AddDays(-1);
			}
			else
				return time;
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaCurrentMonthOHLV29[] cacheanaCurrentMonthOHLV29 = null;

        private static anaCurrentMonthOHLV29 checkanaCurrentMonthOHLV29 = new anaCurrentMonthOHLV29();

        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return anaCurrentMonthOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(Data.IDataSeries input, anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (cacheanaCurrentMonthOHLV29 != null)
                for (int idx = 0; idx < cacheanaCurrentMonthOHLV29.Length; idx++)
                    if (cacheanaCurrentMonthOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentMonthOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentMonthOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentMonthOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentMonthOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentMonthOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentMonthOHLV29[idx].Width == width && cacheanaCurrentMonthOHLV29[idx].EqualsInput(input))
                        return cacheanaCurrentMonthOHLV29[idx];

            lock (checkanaCurrentMonthOHLV29)
            {
                checkanaCurrentMonthOHLV29.ActiveSession = activeSession;
                activeSession = checkanaCurrentMonthOHLV29.ActiveSession;
                checkanaCurrentMonthOHLV29.CurrentSession = currentSession;
                currentSession = checkanaCurrentMonthOHLV29.CurrentSession;
                checkanaCurrentMonthOHLV29.LabelPosition = labelPosition;
                labelPosition = checkanaCurrentMonthOHLV29.LabelPosition;
                checkanaCurrentMonthOHLV29.PlotLabels = plotLabels;
                plotLabels = checkanaCurrentMonthOHLV29.PlotLabels;
                checkanaCurrentMonthOHLV29.ShowCurrentOpen = showCurrentOpen;
                showCurrentOpen = checkanaCurrentMonthOHLV29.ShowCurrentOpen;
                checkanaCurrentMonthOHLV29.ShowFibonacci = showFibonacci;
                showFibonacci = checkanaCurrentMonthOHLV29.ShowFibonacci;
                checkanaCurrentMonthOHLV29.Width = width;
                width = checkanaCurrentMonthOHLV29.Width;

                if (cacheanaCurrentMonthOHLV29 != null)
                    for (int idx = 0; idx < cacheanaCurrentMonthOHLV29.Length; idx++)
                        if (cacheanaCurrentMonthOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentMonthOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentMonthOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentMonthOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentMonthOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentMonthOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentMonthOHLV29[idx].Width == width && cacheanaCurrentMonthOHLV29[idx].EqualsInput(input))
                            return cacheanaCurrentMonthOHLV29[idx];

                anaCurrentMonthOHLV29 indicator = new anaCurrentMonthOHLV29();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ActiveSession = activeSession;
                indicator.CurrentSession = currentSession;
                indicator.LabelPosition = labelPosition;
                indicator.PlotLabels = plotLabels;
                indicator.ShowCurrentOpen = showCurrentOpen;
                indicator.ShowFibonacci = showFibonacci;
                indicator.Width = width;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaCurrentMonthOHLV29[] tmp = new anaCurrentMonthOHLV29[cacheanaCurrentMonthOHLV29 == null ? 1 : cacheanaCurrentMonthOHLV29.Length + 1];
                if (cacheanaCurrentMonthOHLV29 != null)
                    cacheanaCurrentMonthOHLV29.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaCurrentMonthOHLV29 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentMonthOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(Data.IDataSeries input, anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentMonthOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentMonthOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentMonthOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentMonthOHLV29 anaCurrentMonthOHLV29(Data.IDataSeries input, anaSessionCountCM29 activeSession, anaSessionTypeCM29 currentSession, int labelPosition, anaPlotAlignCM29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaCurrentMonthOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }
    }
}
#endregion
