// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Collections;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region Global Enums

public enum anaPlotAlignCW29 {Left, Right, DoNotPlot}
public enum anaSessionTypeCW29 {ETH, RTH}
public enum anaSessionCountCW29 {First, Second, Third}

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Current Open, High, Low and Fibonacci Levels.
	/// </summary>
	[Description("anaCurrentWeekOHLV29.")]
	public class anaCurrentWeekOHLV29 : Indicator
	{
		#region Variables
		private	SolidBrush[]		brushes					= { new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black)};
		private	DateTime 			sessionBegin 			= Cbi.Globals.MinDate;
		private	DateTime 			sessionEnd 				= Cbi.Globals.MinDate;
		private	DateTime 			plotStart		 		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionBeginTmp   	= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp1		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp2		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionDate		= Cbi.Globals.MinDate;
		private DateTime			cacheWeeklyEndDate		= Cbi.Globals.MinDate;
		private DateTime			sessionDateTmp			= Cbi.Globals.MinDate;
		private DateTime			currentDate				= Cbi.Globals.MinDate;
		private DateTime			currentWeek				= Cbi.Globals.MinDate;
		private DateTime			highTime				= Cbi.Globals.MinDate;
		private DateTime			lowTime					= Cbi.Globals.MinDate;
		private double				currentOpen				= 0;
		private	double				currentHigh				= double.MinValue;
		private	double				currentLow				= double.MaxValue;
		private double				currentMidline			= 0;
		private double				fib786					= 0;
		private double				fib618					= 0;
		private double				fib382					= 0;
		private double				fib236					= 0;
		private SolidBrush			textBrush				= new SolidBrush(Color.Red);
		private Font				textFont				= new Font("Arial", 12);
		private	string				errorData2				= "Insufficient historical data to calculate OHL of current day. Please increase chart look back period.";
        private float				errorTextWidth			= 0;
        private float				errorTextHeight			= 0;
		private bool				plotOHL					= false;
		private bool				init					= false;
		private bool				periodOpen				= false;
		private bool				firstDayOfPeriod		= false;
		private bool				rthOHL					= false;
		private bool				showCurrentOpen			= true;
		private bool				showFibonacci			= true;
		private ArrayList			newSessionBarIdxArr1	= new ArrayList();
		private ArrayList			newSessionBarIdxArr2	= new ArrayList();
		private Data.PivotRange		pivotRangeType1			= PivotRange.Daily;
		private Data.PivotRange		pivotRangeType2			= PivotRange.Weekly;
		private anaPlotAlignCW29	plotLabels				= anaPlotAlignCW29.Right;
		private anaSessionTypeCW29	currentSession			= anaSessionTypeCW29.ETH;
		private anaSessionCountCW29 activeSession			= anaSessionCountCW29.Second;
		private	StringFormat		stringFormatFar			= new StringFormat();
		private	StringFormat		stringFormatNear		= new StringFormat();
		private	StringFormat		stringFormatCenter		= new StringFormat();
		private int					numberOfSessions		= 1;
		private int					sessionCount			= 0;
		private int					width					= 15;
		private int					labelPosition			= 10;

		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			
			Add(new Plot(new Pen(Color.White,1), PlotStyle.Line,"W-Open "));
			Add(new Plot(new Pen(Color.Lime,1), PlotStyle.Line,"W-High "));
			Add(new Plot(new Pen(Color.OrangeRed,1), PlotStyle.Line,"W-Low "));
			Add(new Plot(new Pen(Color.MediumSpringGreen,1), PlotStyle.Line,"W-Mid "));
			Add(new Plot(new Pen(Color.Orange,1), PlotStyle.Line,"W-78,6 "));
			Add(new Plot(new Pen(Color.Orange,1), PlotStyle.Line,"W-61,8 "));
			Add(new Plot(new Pen(Color.Orange,1), PlotStyle.Line,"W-38,2 "));
			Add(new Plot(new Pen(Color.Orange,1), PlotStyle.Line,"W-23,6 "));
			
			Plots[0].Pen.DashStyle = DashStyle.Solid;
			Plots[1].Pen.DashStyle = DashStyle.Solid;
			Plots[2].Pen.DashStyle = DashStyle.Solid;
			Plots[3].Pen.DashStyle = DashStyle.Solid;
			Plots[4].Pen.DashStyle = DashStyle.Solid;
			Plots[5].Pen.DashStyle = DashStyle.Solid;
			Plots[6].Pen.DashStyle = DashStyle.Solid;
			Plots[7].Pen.DashStyle = DashStyle.Solid;

			AutoScale						= false;
			Overlay							= true;
			stringFormatNear.Alignment 		= StringAlignment.Near;
			stringFormatCenter.Alignment 	= StringAlignment.Center;
			stringFormatFar.Alignment		= StringAlignment.Far;
			
			// Defining all instruments for which this indicator can be used. Indicator will not show on any instruments not listed here!
			
			if(Instrument == null)
				return;
		}

		/// <summary>
		/// </summary>
		protected override void OnStartUp()
		{
			if (currentSession == anaSessionTypeCW29.ETH)
				rthOHL = false;
			else
				rthOHL = true;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (Bars == null)
				return; 
			if (!Data.BarsType.GetInstance(Bars.Period.Id).IsIntraday && Bars.Period.Id != PeriodType.Day)
				return;
			if (Bars.Period.Id == PeriodType.Day && Bars.Period.Value > 1)
				return;

			if (CurrentBar == 0)
			{	
				currentDate = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
				currentWeek = GetLastBarSessionDate(Time[0], Bars, pivotRangeType2);
				Bars.Session.GetNextBeginEnd(Time[0], out sessionBegin, out sessionEnd);
				plotStart = RoundUpTimeToPeriodTime(sessionEnd.Date, PivotRange.Weekly);
				return;
			}
			DateTime lastBarTimeStamp = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
			DateTime lastBarTimeStamp2 = GetLastBarSessionDate(Time[0], Bars, pivotRangeType2);
			if (lastBarTimeStamp2 != currentWeek)
			{	
				if (FirstTickOfBar)
				{
					firstDayOfPeriod = true;
					sessionCount = 1;
					periodOpen = false;
					init = false;
				}
				if (numberOfSessions == 1 || !rthOHL || (rthOHL && activeSession == anaSessionCountCW29.First))
				{
					periodOpen = true;
					init = true;
					currentOpen		= Open[0];
					currentHigh		= High[0];
					currentLow		= Low[0];
					highTime		= Time[0];
					lowTime			= Time[0];
				}
				currentDate = lastBarTimeStamp;
				currentWeek = lastBarTimeStamp2;
				plotOHL = true;
			}
			else if (lastBarTimeStamp != currentDate || Bars.Period.Id == PeriodType.Day)
			{
				if (FirstTickOfBar)
				{
					firstDayOfPeriod = false;
					sessionCount = 1;
				}
				if (numberOfSessions == 1 || !rthOHL || (rthOHL && activeSession == anaSessionCountCW29.First))
				{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime 	= Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow 	= Low[0];
						lowTime 	= Time[0];
					}
					periodOpen		= true;
					init			= true;
				}
				else
					periodOpen		= false;
				currentDate = lastBarTimeStamp;
			}
			else if (Bars.FirstBarOfSession)
			{
				if (FirstTickOfBar)
				{
					sessionCount = sessionCount +1;
					numberOfSessions = Math.Min(3, Math.Max(sessionCount, numberOfSessions));
				}
				if (!rthOHL|| (rthOHL && !firstDayOfPeriod && ((sessionCount == 2 && activeSession == anaSessionCountCW29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountCW29.Third))))
				{
					if (High[0] >= currentHigh)
					{
						currentHigh = High[0];
						highTime = Time[0];
					}
					if (Low[0] <= currentLow)
					{
						currentLow = Low[0];
						lowTime = Time[0];
					}
					periodOpen		= true;
					init			= true;
				}
				else if (rthOHL && firstDayOfPeriod && ((sessionCount == 2 && activeSession == anaSessionCountCW29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountCW29.Third)))
				{
					currentOpen		= Open[0];
					currentHigh		= High[0];
					currentLow		= Low[0];
					highTime		= Time[0];
					lowTime			= Time[0];
					periodOpen		= true;
					init 			= true;
				}
				else
					periodOpen = false;
			}	
			else if (periodOpen)
			{
				if (High[0] >= currentHigh)
				{
					currentHigh = High[0];
					highTime = Time[0];
				}
				if (Low[0] <= currentLow)
				{
					currentLow = Low[0];
					lowTime = Time[0];
				}
			}

			if (plotOHL && init && !(rthOHL && activeSession == anaSessionCountCW29.Third && numberOfSessions == 2))
			{
				CurrentHigh.Set(currentHigh);
   			  	CurrentLow.Set(currentLow);
				CurrentMidline.Set(Math.Round((currentLow + 0.5*(currentHigh-currentLow))/TickSize)* TickSize);
				if (ShowCurrentOpen)
					CurrentOpen.Set(currentOpen);
				if (ShowFibonacci && lowTime >= highTime)				
				{	
					Fib786.Set(Math.Round((currentLow + 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
					Fib618.Set(Math.Round((currentLow + 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentLow + 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib236.Set(Math.Round((currentLow + 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
				}
				else if (ShowFibonacci)
				{
					Fib236.Set(Math.Round((currentHigh - 0.236*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib382.Set(Math.Round((currentHigh - 0.382*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib618.Set(Math.Round((currentHigh - 0.618*(currentHigh-currentLow))/TickSize)*TickSize);
					Fib786.Set(Math.Round((currentHigh - 0.786*(currentHigh-currentLow))/TickSize)*TickSize); 
				}	
			}
			else
			{
				CurrentHigh.Set(0);
   			  	CurrentLow.Set(0);
				CurrentMidline.Set(0);
				CurrentOpen.Set(0);
				Fib786.Set(0); 
				Fib618.Set(0); 
				Fib382.Set(0); 
				Fib236.Set(0);
			}
		}


		#region Properties
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session")]
		public anaSessionTypeCW29 CurrentSession
		{
			get { return currentSession; }
			set { currentSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("RTH Session")]
		public anaSessionCountCW29 ActiveSession
		{
			get { return activeSession; }
			set { activeSession = value; }
		}

		/// <summary>
		/// </summary>
		[Description("Option to show CurrentOpen")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Current Open")]
		public bool ShowCurrentOpen 
		{
			get { return showCurrentOpen; }
			set { showCurrentOpen = value; }
		}
		
		[Description("Option to show Fibonacci Lines")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Fibonacci Retracements")]
		public bool ShowFibonacci 
		{
			get { return showFibonacci; }
			set { showFibonacci = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option where to plot labels")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Position")]
		public anaPlotAlignCW29 PlotLabels
		{
			get { return plotLabels; }
			set { plotLabels = value; }
		}
			
		/// <summary>
		/// </summary>
		[Description("Label distance from line.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Offset")]
		public int LabelPosition
		{
			get { return labelPosition; }
			set { labelPosition = Math.Max(1, value); }
		}
	
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentOpen
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentHigh
		{
			get { return Values[1]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentLow
		{
			get { return Values[2]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentMidline
		{
			get { return Values[3]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib786
		{
			get { return Values[4]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib618
		{
			get { return Values[5]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib382
		{
			get { return Values[6]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries Fib236
		{
			get { return Values[7]; }
		}

		/// <summary>
		/// </summary>
		[Description("Width of the OHL lines as # of bars.")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width")]
		public int Width
		{
			get { return width; }
			set { width = Math.Max(1, value); }
		}

		#endregion

		
		#region Miscellaneous

		private DateTime GetLastBarSessionDate(DateTime time, Data.Bars bars, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Daily && time > cacheSessionEndTmp1)
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp1);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				if(cacheSessionDate != sessionDateTmp) 
					{
						cacheSessionDate = sessionDateTmp;
						if (newSessionBarIdxArr1.Count == 0 || (newSessionBarIdxArr1.Count > 0 && CurrentBar > (int) newSessionBarIdxArr1[newSessionBarIdxArr1.Count - 1]))
								newSessionBarIdxArr1.Add(CurrentBar);
					}
			}
			else if (pivotRange == PivotRange.Weekly && time > cacheSessionEndTmp2) 
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp2);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				
				DateTime tmpWeeklyEndDate = RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Weekly);
				if (tmpWeeklyEndDate != cacheWeeklyEndDate || (rthOHL && firstDayOfPeriod && sessionCount == 1 && activeSession == anaSessionCountCW29.Second)
					|| (rthOHL && firstDayOfPeriod && sessionCount ==2 && activeSession == anaSessionCountCW29.Third)) 
					{
						cacheWeeklyEndDate = tmpWeeklyEndDate;
						if (newSessionBarIdxArr2.Count == 0 || (newSessionBarIdxArr2.Count > 0 && CurrentBar > (int) newSessionBarIdxArr2[newSessionBarIdxArr2.Count - 1]))
							newSessionBarIdxArr2.Add(CurrentBar);
					}
			}	
			if (pivotRange == PivotRange.Weekly) 
				return RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Weekly);
			else // if (pivot Range == PivotRange.Daily)
				return sessionDateTmp;
		}
		
		internal void InvalidateNow()
		{
			if (Disposed || ChartControl == null)
				return;

			ChartControl.Invalidate(true);
		}

		/// <summary>
        /// Overload this method to handle the termination of an indicator. Use this method to dispose of any resources vs overloading the Dispose() method.
		/// </summary>
		protected override void OnTermination()
		{
			textBrush.Dispose();
			foreach (SolidBrush solidBrush in brushes)
				solidBrush.Dispose();
			stringFormatCenter.Dispose();
			stringFormatFar.Dispose();	
			stringFormatNear.Dispose();
		}
	
		/// <summary>
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="bounds"></param>
		/// <param name="min"></param>
		/// <param name="max"></param>
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (Bars == null || ChartControl == null)
				return;

			// plot error if data not complete
			DateTime lastBarSessionBegin = Cbi.Globals.MinDate;
			DateTime lastBarSessionEnd = Cbi.Globals.MinDate;
			Bars.Session.GetNextBeginEnd(Bars.Get(Math.Min(Bars.Count - 1, this.LastBarIndexPainted)).Time, out lastBarSessionBegin, out lastBarSessionEnd);
			textBrush.Color = ChartControl.AxisColor;
			SizeF errorSize	= graphics.MeasureString(errorData2, textFont);
			errorTextWidth	= errorSize.Width + 5;
			errorTextHeight	= errorSize.Height + 5;
			if (Bars.Count > 0 && plotStart.Date >= lastBarSessionEnd.Date)
				graphics.DrawString(errorData2, textFont, textBrush, bounds.X + bounds.Width - errorTextWidth, bounds.Y + bounds.Height - errorTextHeight, stringFormatNear);

			int	barWidth = ChartControl.ChartStyle.GetBarPaintWidth(Bars.BarsData.ChartStyle.BarWidthUI);
			for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
			{
				SolidBrush		brush				= brushes[seriesCount];
				int				firstBarIdxToPaint	= -1;
				int				lastX				= -1;
				int				lastY				= -1;
				int				firstX				= -1;
				SmoothingMode	oldSmoothingMode	= graphics.SmoothingMode;
				Gui.Chart.Plot	plot				= Plots[seriesCount];
				DataSeries		series				= (DataSeries) Values[seriesCount];

				for (int i = newSessionBarIdxArr2.Count - 1; i >= 0; i--)
				{
					int prevSessionBreakIdx = (int) newSessionBarIdxArr2[i];
					if (prevSessionBreakIdx <= this.LastBarIndexPainted)
					{
						firstBarIdxToPaint = prevSessionBreakIdx;
						break;
					}
				}

				using (GraphicsPath	path = new GraphicsPath()) 
				{
					if (brush.Color != plot.Pen.Color)	
						brush = new SolidBrush(plot.Pen.Color);

					for (int idx = this.LastBarIndexPainted; idx >= Math.Max(this.FirstBarIndexPainted, this.LastBarIndexPainted - Width); idx--)
					{
						if (idx - Displacement < 0 || idx - Displacement >= Bars.Count || (!ChartControl.ShowBarsRequired && idx - Displacement < BarsRequired))
							continue;
						else if (!series.IsValidPlot(idx))
							continue;

						if (idx < firstBarIdxToPaint)
							break;

						double	val = series.Get(idx);
						int		x	= ChartControl.GetXByBarIdx(BarsArray[0], idx);
						int		y	= ChartControl.GetYByValue(this, val);

						if (lastX >= 0)
						{
							if (y != lastY) // Problem here is, that last bar of old day has date of new day
								y = lastY;
							path.AddLine(lastX - plot.Pen.Width / 2, lastY, x - plot.Pen.Width / 2, y);
						}
						lastX	= x;
						lastY	= y;
						if (idx == this.LastBarIndexPainted || idx == this.LastBarIndexPainted-1)
							firstX	= x;
					}

					graphics.SmoothingMode = SmoothingMode.AntiAlias;
					graphics.DrawPath(plot.Pen, path);
					graphics.SmoothingMode = oldSmoothingMode;
					if (PlotLabels == anaPlotAlignCW29.Right)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, firstX + LabelPosition + 20, lastY - ChartControl.Font.GetHeight() / 2, stringFormatNear);
					if (PlotLabels == anaPlotAlignCW29.Left)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, lastX - LabelPosition, lastY - ChartControl.Font.GetHeight() / 2, stringFormatFar);
				}
			}
		}
		
		private DateTime RoundUpTimeToPeriodTime(DateTime time, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Weekly)
			{
				DateTime periodStart = time.AddDays((6 - (((int) time.DayOfWeek) + 1) % 7));
				return periodStart.Date.AddDays(System.Math.Ceiling(System.Math.Ceiling(time.Date.Subtract(periodStart.Date).TotalDays) / 7) * 7).Date;
			}
			else if (pivotRange == PivotRange.Monthly)
			{
				DateTime result = new DateTime(time.Year, time.Month, 1); 
				return result.AddMonths(1).AddDays(-1);
			}
			else
				return time;
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaCurrentWeekOHLV29[] cacheanaCurrentWeekOHLV29 = null;

        private static anaCurrentWeekOHLV29 checkanaCurrentWeekOHLV29 = new anaCurrentWeekOHLV29();

        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return anaCurrentWeekOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        public anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(Data.IDataSeries input, anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (cacheanaCurrentWeekOHLV29 != null)
                for (int idx = 0; idx < cacheanaCurrentWeekOHLV29.Length; idx++)
                    if (cacheanaCurrentWeekOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentWeekOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentWeekOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentWeekOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentWeekOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentWeekOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentWeekOHLV29[idx].Width == width && cacheanaCurrentWeekOHLV29[idx].EqualsInput(input))
                        return cacheanaCurrentWeekOHLV29[idx];

            lock (checkanaCurrentWeekOHLV29)
            {
                checkanaCurrentWeekOHLV29.ActiveSession = activeSession;
                activeSession = checkanaCurrentWeekOHLV29.ActiveSession;
                checkanaCurrentWeekOHLV29.CurrentSession = currentSession;
                currentSession = checkanaCurrentWeekOHLV29.CurrentSession;
                checkanaCurrentWeekOHLV29.LabelPosition = labelPosition;
                labelPosition = checkanaCurrentWeekOHLV29.LabelPosition;
                checkanaCurrentWeekOHLV29.PlotLabels = plotLabels;
                plotLabels = checkanaCurrentWeekOHLV29.PlotLabels;
                checkanaCurrentWeekOHLV29.ShowCurrentOpen = showCurrentOpen;
                showCurrentOpen = checkanaCurrentWeekOHLV29.ShowCurrentOpen;
                checkanaCurrentWeekOHLV29.ShowFibonacci = showFibonacci;
                showFibonacci = checkanaCurrentWeekOHLV29.ShowFibonacci;
                checkanaCurrentWeekOHLV29.Width = width;
                width = checkanaCurrentWeekOHLV29.Width;

                if (cacheanaCurrentWeekOHLV29 != null)
                    for (int idx = 0; idx < cacheanaCurrentWeekOHLV29.Length; idx++)
                        if (cacheanaCurrentWeekOHLV29[idx].ActiveSession == activeSession && cacheanaCurrentWeekOHLV29[idx].CurrentSession == currentSession && cacheanaCurrentWeekOHLV29[idx].LabelPosition == labelPosition && cacheanaCurrentWeekOHLV29[idx].PlotLabels == plotLabels && cacheanaCurrentWeekOHLV29[idx].ShowCurrentOpen == showCurrentOpen && cacheanaCurrentWeekOHLV29[idx].ShowFibonacci == showFibonacci && cacheanaCurrentWeekOHLV29[idx].Width == width && cacheanaCurrentWeekOHLV29[idx].EqualsInput(input))
                            return cacheanaCurrentWeekOHLV29[idx];

                anaCurrentWeekOHLV29 indicator = new anaCurrentWeekOHLV29();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ActiveSession = activeSession;
                indicator.CurrentSession = currentSession;
                indicator.LabelPosition = labelPosition;
                indicator.PlotLabels = plotLabels;
                indicator.ShowCurrentOpen = showCurrentOpen;
                indicator.ShowFibonacci = showFibonacci;
                indicator.Width = width;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaCurrentWeekOHLV29[] tmp = new anaCurrentWeekOHLV29[cacheanaCurrentWeekOHLV29 == null ? 1 : cacheanaCurrentWeekOHLV29.Length + 1];
                if (cacheanaCurrentWeekOHLV29 != null)
                    cacheanaCurrentWeekOHLV29.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaCurrentWeekOHLV29 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentWeekOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(Data.IDataSeries input, anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentWeekOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            return _indicator.anaCurrentWeekOHLV29(Input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }

        /// <summary>
        /// anaCurrentWeekOHLV29.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaCurrentWeekOHLV29 anaCurrentWeekOHLV29(Data.IDataSeries input, anaSessionCountCW29 activeSession, anaSessionTypeCW29 currentSession, int labelPosition, anaPlotAlignCW29 plotLabels, bool showCurrentOpen, bool showFibonacci, int width)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaCurrentWeekOHLV29(input, activeSession, currentSession, labelPosition, plotLabels, showCurrentOpen, showFibonacci, width);
        }
    }
}
#endregion
