// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Collections;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region Global Enums

public enum anaPlotAlignPM29 {Left, Right, DoNotPlot}
public enum anaPivotStylesPM29 {Floor, Wide, Fibonacci, Jackson, Camarilla, Woodies}
public enum anaSessionTypePM29 {ETH, RTH}
public enum anaSessionCountPM29 {First, Second, Third}


#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Pivot Points.
	/// </summary>
	[Description("Monthly Session Pivots.")]
	public class anaPivotsMonthlyV29: Indicator
	{
		#region Variables
		private	SolidBrush[]		brushes					= { new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),  
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),
															new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),
															new SolidBrush(Color.Black)};
		private	DateTime 			firstBarSessionBegin 	= Cbi.Globals.MinDate;
		private	DateTime 			firstBarSessionEnd 		= Cbi.Globals.MinDate;
		private	DateTime 			plotStart		 		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionBeginTmp   	= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp1		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionEndTmp3		= Cbi.Globals.MinDate;
		private DateTime			cacheSessionDate		= Cbi.Globals.MinDate;
		private DateTime			cacheMonthlyEndDate		= Cbi.Globals.MinDate;
		private DateTime			currentDate				= Cbi.Globals.MinDate;
		private DateTime			priorDate				= Cbi.Globals.MinDate;
		private DateTime			currentMonth			= Cbi.Globals.MinDate;
		private	double				currentHigh				= double.MinValue;
		private	double				currentLow				= double.MaxValue;
		private	double				currentClose			= 0;
		private	double				priorCurrentHigh		= double.MinValue;
		private	double				priorCurrentLow			= double.MaxValue;
		private	double				priorCurrentClose		= 0;
		private	double				volSum					= 0;
		private	double				volPriceSum				= 0;
		private	double				currentVolSum			= 0;
		private	double				currentVolPriceSum		= 0;
		private Bars				dailyBars				= null;
		private SolidBrush			textBrush				= new SolidBrush(Color.Red);
		private Font				textFont				= new Font("Arial", 12);
		private string				errorData2				= "No daily data found. Please reload daily data or use CalcFromIntradayData.";
		private string				errorData3				= "Loading of daily data is incomplete. Please reload daily data or use CalcFromIntradayData.";
		private	string				errorData4				= "Insufficient historical data to calculate pivots. Please increase chart look back period.";
        private float				errorTextWidth			= 0;
        private float				errorTextHeight			= 0;
		private bool				existsHistDailyData		= false;
		private bool				isDailyDataLoaded		= false;
		private bool				plotPivots				= true;
		private bool				periodOpen				= false;
		private bool				firstDayOfPeriod		= false;
		private bool				skipPublicHoliday		= false; 
		private bool				isPublicHoliday			= false; 
		private bool				noDailyData				= false;
		private bool				noCurrentDailyBar		= false;
		private ArrayList			newSessionBarIdxArr1	= new ArrayList();
		private ArrayList			newSessionBarIdxArr3	= new ArrayList();
		private Data.PivotRange		pivotRangeType1			= PivotRange.Daily;
		private Data.PivotRange		pivotRangeType3			= PivotRange.Monthly;
		private HLCCalculationMode	priorDayHLC				= HLCCalculationMode.DailyBars;
		private anaPlotAlignPM29	plotLabels				= anaPlotAlignPM29.Right;
		private anaPivotStylesPM29 	pivotFormula			= anaPivotStylesPM29.Floor;
		private anaSessionTypePM29	pivotSession			= anaSessionTypePM29.ETH;
		private anaSessionCountPM29 activeSession			= anaSessionCountPM29.Second;
		private double				range					= 0;
		private	double				pp						= 0;
		private	double				r1						= 0;
		private	double				r2						= 0;
		private	double				r3						= 0;
		private	double				r4						= 0;
		private	double				s1						= 0;
		private	double				s2						= 0;
		private	double				s3						= 0;
		private	double				s4						= 0;
		private	double				rmid					= 0;
		private	double				r12mid					= 0;
		private	double				r23mid					= 0;
		private	double				r34mid					= 0;
		private	double				smid					= 0;
		private	double				s12mid					= 0;
		private	double				s23mid					= 0;
		private	double				s34mid					= 0;
		private double				midLine					= 0;
		private double				previousVWAP			= 0;
		private double				previousHigh			= 0;
		private double				previousLow				= 0;
		private double				previousClose			= 0;
		private DateTime			sessionDateTmp			= Cbi.Globals.MinDate;
		private DateTime			sessionDateDaily		= Cbi.Globals.MinDate;
		private	StringFormat		stringFormatCenter		= new StringFormat();
		private	StringFormat		stringFormatFar			= new StringFormat();
		private	StringFormat		stringFormatNear		= new StringFormat();
		private double				userDefinedClose		= 0;
		private double				userDefinedHigh			= 0;
		private double				userDefinedLow			= 0;
		private int					countDown				= 2;
		private int					numberOfSessions		= 1;
		private int					sessionCount			= 0;
		private int					width					= 15;
		private int 				labelPosition			= 10;
		private bool				rthPivots				= false;
		private bool				showMidpivots			= false;
		private DateTime			publicHoliday0			= new DateTime (2009,01,19);
		private DateTime			publicHoliday1			= new DateTime (2009,02,16);
		private DateTime			publicHoliday2			= new DateTime (2009,05,25);
		private DateTime			publicHoliday3			= new DateTime (2009,07,03);
		private DateTime			publicHoliday4			= new DateTime (2009,09,07);
		private DateTime			publicHoliday5			= new DateTime (2009,11,26);
		private DateTime			publicHoliday6			= new DateTime (2010,01,18);
		private DateTime			publicHoliday7			= new DateTime (2010,02,15);
		private DateTime			publicHoliday8			= new DateTime (2010,05,31);
		private DateTime			publicHoliday9			= new DateTime (2010,07,05);
		private DateTime			publicHoliday10			= new DateTime (2010,09,06);
		private DateTime			publicHoliday11			= new DateTime (2010,11,25);
		private DateTime[]			publicHoliday			= new DateTime [12];
			
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-PP "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R1 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S1 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R2 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S2 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R3 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S3 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R4 "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S4 "));
			
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-RMid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-SMid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R12Mid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S12Mid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R23Mid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S23Mid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-R34Mid "));
			Add(new Plot(new Pen(Color.GreenYellow,1), PlotStyle.Line,"M-S34Mid "));
	
			Add(new Plot(new Pen(Color.Lime,2), PlotStyle.Line,"PM-High "));
			Add(new Plot(new Pen(Color.OrangeRed,2), PlotStyle.Line,"PM-Low "));
			Add(new Plot(new Pen(Color.Yellow,2), PlotStyle.Line,"PM-Close "));
			Add(new Plot(new Pen(Color.MediumSpringGreen,1), PlotStyle.Line,"PM-Mid "));

			Add(new Plot(new Pen(Color.HotPink,1), PlotStyle.Line,"PM-VWAP"));

			Plots[0].Pen.DashStyle = DashStyle.Solid;
			Plots[1].Pen.DashStyle = DashStyle.Solid;
			Plots[2].Pen.DashStyle = DashStyle.Solid;
			Plots[3].Pen.DashStyle = DashStyle.Solid;
			Plots[4].Pen.DashStyle = DashStyle.Solid;
			Plots[5].Pen.DashStyle = DashStyle.Solid;
			Plots[6].Pen.DashStyle = DashStyle.Solid;
			Plots[7].Pen.DashStyle = DashStyle.Solid;
			Plots[8].Pen.DashStyle = DashStyle.Solid;
			Plots[9].Pen.DashStyle = DashStyle.Solid;
			Plots[10].Pen.DashStyle = DashStyle.Solid;
			Plots[11].Pen.DashStyle = DashStyle.Solid;
			Plots[12].Pen.DashStyle = DashStyle.Solid;
			Plots[13].Pen.DashStyle = DashStyle.Solid;
			Plots[14].Pen.DashStyle = DashStyle.Solid;
			Plots[15].Pen.DashStyle = DashStyle.Solid;
			Plots[16].Pen.DashStyle = DashStyle.Solid;
			Plots[17].Pen.DashStyle = DashStyle.Dot;
			Plots[18].Pen.DashStyle = DashStyle.Dot;
			Plots[19].Pen.DashStyle = DashStyle.Dot;
			Plots[20].Pen.DashStyle = DashStyle.Solid;
			Plots[21].Pen.DashStyle = DashStyle.Solid;
			
			AutoScale						= false;
			Overlay							= true;
			PriceTypeSupported				= false;
			ZOrder							= 0;
			stringFormatCenter.Alignment 	= StringAlignment.Center;
			stringFormatFar.Alignment		= StringAlignment.Far;
			stringFormatNear.Alignment 		= StringAlignment.Near;
		}

		/// <summary>
		/// </summary>
		protected override void OnStartUp()
		{
			publicHoliday[0] = publicHoliday0;
			publicHoliday[1] = publicHoliday1;
			publicHoliday[2] = publicHoliday2;
			publicHoliday[3] = publicHoliday3;
			publicHoliday[4] = publicHoliday4;
			publicHoliday[5] = publicHoliday5;
			publicHoliday[6] = publicHoliday6;
			publicHoliday[7] = publicHoliday7;
			publicHoliday[8] = publicHoliday8;
			publicHoliday[9] = publicHoliday9;
			publicHoliday[10] = publicHoliday10;
			publicHoliday[11] = publicHoliday11;
			
			if (pivotSession == anaSessionTypePM29.ETH)
				rthPivots = false;
			else
				rthPivots = true;
			if (PivotFormula == anaPivotStylesPM29.Jackson)
			{
				Plots[0].Name = "BP";
				Plots[1].Name = "D";
				Plots[2].Name = "B";
				Plots[3].Name = "RB1";
				Plots[4].Name = "SB1";
				Plots[5].Name = "D1";
				Plots[6].Name = "B1";
				Plots[7].Name = "RB2";
				Plots[8].Name = "SB2";
			}
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (Bars == null)
				return; 
			if (!Bars.BarsType.IsIntraday && Bars.Period.Id != PeriodType.Day)
				return;
			if (Bars.Period.Id == PeriodType.Day && Bars.Period.Value > 1)
				return;
			
			if (CurrentBar == 0)
			{	
				Bars.Session.GetNextBeginEnd(Bars.Get(0).Time, out firstBarSessionBegin, out firstBarSessionEnd);
				plotStart = RoundUpTimeToPeriodTime(firstBarSessionEnd.Date, PivotRange.Monthly);
				plotStart = plotStart.AddDays(1).AddMonths(1).AddDays(-1); 
			}

			if (!isDailyDataLoaded)
			{
				if (priorDayHLC == HLCCalculationMode.DailyBars && Bars.BarsType.IsIntraday) 
				{
					Enabled = false;
					System.Threading.ThreadPool.QueueUserWorkItem(new System.Threading.WaitCallback(GetBarsNow));
					return;
				}
				existsHistDailyData = false;
				isDailyDataLoaded	= true;
			}
			if (priorDayHLC == HLCCalculationMode.DailyBars && Bars.BarsType.IsIntraday && !existsHistDailyData)
			{
				textBrush.Color = ChartControl.AxisColor;
				DrawTextFixed("errortag2", errorData2, TextPosition.Center, textBrush.Color, textFont, Color.Transparent,Color.Transparent,0);
				return;
			}	

			IBar dailyBar;
			if (existsHistDailyData) 
			{
				noCurrentDailyBar = false;
				dailyBar = dailyBars.Get(dailyBars.GetBar(currentDate));
				if (dailyBar.Time.Date != currentDate)
				{
					noCurrentDailyBar = true;
					dailyBar = dailyBars.Get(dailyBars.GetBar(priorDate));
					if (dailyBar.Time.Date != priorDate)
					{
						noDailyData = true;
					}	
				}
			} 
			else 
				dailyBar = null;

			double	high		= (existsHistDailyData && !rthPivots) ? dailyBar.High : High[0];
			double	low			= (existsHistDailyData && !rthPivots) ? dailyBar.Low : Low[0];
			double	close		= existsHistDailyData ? dailyBar.Close : Close[0];

			DateTime lastBarTimeStamp1 = GetLastBarSessionDate(Time[0], Bars, pivotRangeType1);
			DateTime lastBarTimeStamp3 = GetLastBarSessionDate(Time[0], Bars, pivotRangeType3);
			if (lastBarTimeStamp3 != currentMonth || priorDayHLC == HLCCalculationMode.UserDefinedValues)
			{
				countDown = countDown -1;
				firstDayOfPeriod = true;
				sessionCount = 1;
				periodOpen = false;
				if (countDown <1 && existsHistDailyData && !skipPublicHoliday)
				{	
					currentClose = close;
					if (!rthPivots)
					{
						currentHigh = Math.Max(currentHigh, high);
						currentLow = Math.Min(currentLow, low);
					}
				}
				else if (countDown <1 && (!existsHistDailyData || rthPivots) && skipPublicHoliday && priorDayHLC != HLCCalculationMode.UserDefinedValues)
				{	
					if (!existsHistDailyData)	
						currentClose = priorCurrentClose;
					currentHigh = priorCurrentHigh;
					currentLow = priorCurrentLow;
				}
				priorDate = currentDate;
				currentDate = lastBarTimeStamp1;
				currentMonth = lastBarTimeStamp3;
				skipPublicHoliday = false;
				for (int i =0; i<12; i++)
				{
					if (publicHoliday[i].Date == currentDate)
						skipPublicHoliday = true;
				}
				if (countDown<0  || priorDayHLC == HLCCalculationMode.UserDefinedValues)
				{
					range = (currentHigh - currentLow);						
					if (PivotFormula == anaPivotStylesPM29.Fibonacci)
					{
						pp				= (currentHigh + currentLow + currentClose) / 3;
						s1				= pp - 0.382*range;
						r1				= pp + 0.382*range;
						s2				= pp - 0.618*range;
						r2				= pp + 0.618*range;
						s3				= pp - range;
						r3				= pp + range;
						s4				= pp - 1.382*range;
						r4				= pp + 1.382*range;
					}
					else if (PivotFormula == anaPivotStylesPM29.Jackson)
					{
						pp				= (currentHigh + currentLow + currentClose)/ 3;
						s1				= pp - 0.500*range;
						r1				= pp + 0.500*range;
						s2				= pp - 0.618*range;
						r2				= pp + 0.618*range;
						s3				= pp - range;
						r3				= pp + range;
						s4				= pp - 1.382*range;
						r4				= pp + 1.382*range;
					}
					else if (PivotFormula == anaPivotStylesPM29.Camarilla)
					{
						pp				= currentClose;
						s1				= currentClose - 1.1/12*range;
						r1				= currentClose + 1.1/12*range;
						s2				= currentClose - 1.1/6*range;
						r2				= currentClose + 1.1/6*range;
						s3				= currentClose - 1.1/4*range;
						r3				= currentClose + 1.1/4*range;
						s4				= currentClose - 1.1/2*range;
						r4				= currentClose + 1.1/2*range;
					}
					else
					{
						if (PivotFormula == anaPivotStylesPM29.Floor || PivotFormula == anaPivotStylesPM29.Wide)
							pp				= (currentHigh + currentLow + currentClose) / 3;
						else if (PivotFormula == anaPivotStylesPM29.Woodies)
							pp				= (currentHigh + currentLow + 2*currentClose) / 4;
						
						s1				= 2 * pp - currentHigh;
						r1				= 2 * pp - currentLow;
						s2				= pp - range;
						r2				= pp + range;
						if (PivotFormula == anaPivotStylesPM29.Floor || PivotFormula == anaPivotStylesPM29.Woodies)
						{
							s3				= s1 - range;
							r3				= r1 + range;
							s4				= s3 - (currentHigh - pp);
							r4				= r3 + (pp - currentLow);
						}
						else if (PivotFormula == anaPivotStylesPM29.Wide)
						{
							s3				= s2 - range;
							r3				= r2 + range;
							s4				= s3 - range;
							r4				= r3 + range;
						}
						smid			= 0.5*(pp+s1);
						rmid			= 0.5*(pp+r1);
						s12mid			= 0.5*(s1+s2);
						r12mid			= 0.5*(r1+r2);
						s23mid			= 0.5*(s2+s3);
						r23mid			= 0.5*(r2+r3);
						s34mid			= 0.5*(s3+s4);
						r34mid			= 0.5*(r3+r4);
					}
					previousHigh		= currentHigh;
					previousLow			= currentLow;
					previousClose		= currentClose;
					midLine				= (currentHigh + currentLow) / 2;
					if (volSum > double.Epsilon)
						previousVWAP	= currentVolPriceSum/currentVolSum;
					else
						previousVWAP	= 0;
					if (noDailyData)
						plotPivots = false;
					else 
						plotPivots = true;
				}	
				noDailyData = false;
				if (Bars.BarsType.IsIntraday && (!existsHistDailyData || (existsHistDailyData && rthPivots))) 
				{
					if ((numberOfSessions == 1 || !rthPivots || (rthPivots && activeSession == anaSessionCountPM29.First))
						&& (!rthPivots || !skipPublicHoliday))
					{
						if (!existsHistDailyData)	
							currentClose	= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
						currentHigh			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : high;
						currentLow			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : low;
						volSum				= 0;
						volPriceSum			= 0;
						currentVolSum		= volSum + Volume[0];
						currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
						periodOpen			= true;
					}
					else 
					{	
						volSum				= 0;
						volPriceSum			= 0;
						currentVolPriceSum 	= 0;
						currentVolSum		= 0;
						periodOpen			= false;
					}
				}
				else if (Bars.BarsType.IsIntraday)
				{	
					currentHigh 		= double.MinValue;
					currentLow 			= double.MaxValue;
					volSum				= 0;
					volPriceSum			= 0;
					currentVolSum		= volSum + Volume[0];
					currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
					periodOpen			= true;
				}
				else 
				{
					currentClose	= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
					currentHigh		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : high;
					currentLow		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : low;
					periodOpen		= false;
				}
			}
			else if (lastBarTimeStamp1 != currentDate || Bars.Period.Id == PeriodType.Day)
			{
				firstDayOfPeriod = false;
				sessionCount = 1;
				priorDate = currentDate;
				currentDate = lastBarTimeStamp1;
				skipPublicHoliday = false;
				for (int i =0; i<12; i++)
				{
					if (publicHoliday[i].Date == currentDate)
					{
						skipPublicHoliday = true;
						priorCurrentClose = currentClose;
						priorCurrentHigh = currentHigh;
						priorCurrentLow = currentLow;
					}
				}
				if (Bars.BarsType.IsIntraday && rthPivots && numberOfSessions > 1 && activeSession != anaSessionCountPM29.First)
					periodOpen = false;
				else if(!Bars.BarsType.IsIntraday)
					periodOpen = false;
				else
					periodOpen = true;
				if (countDown <1 && (existsHistDailyData || Bars.Period.Id == PeriodType.Day))
				{	
					currentClose = close;
					if (!rthPivots || Bars.Period.Id == PeriodType.Day)
					{
						currentHigh = Math.Max(currentHigh, high);
						currentLow = Math.Min(currentLow, low);
					}
					else if (activeSession == anaSessionCountPM29.First)
					{
						currentHigh			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : Math.Max(currentHigh, high);
						currentLow			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : Math.Min(currentLow, low);
					}
				}
				else if (periodOpen)
				{
					currentHigh			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : Math.Max(currentHigh, high);
					currentLow			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : Math.Min(currentLow, low);
					currentClose		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
				}	
				if (periodOpen) 
				{
					if (FirstTickOfBar)
					{
						volSum			= currentVolSum;
						volPriceSum		= currentVolPriceSum;
					}
					currentVolSum		= volSum + Volume[0];
					currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
				}	
			}
			else if (Bars.BarsType.IsIntraday && Bars.FirstBarOfSession)
			{
				if (FirstTickOfBar)
				{
					sessionCount = sessionCount + 1;
					numberOfSessions = Math.Min(3, Math.Max(sessionCount, numberOfSessions));
				}
				if (existsHistDailyData && !rthPivots) 
				{
					if (FirstTickOfBar)
					{
						volSum			= currentVolSum;
						volPriceSum		= currentVolPriceSum;
					}
					currentVolSum		= volSum + Volume[0];
					currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
					periodOpen			= true;
				}	
				else if ( rthPivots && firstDayOfPeriod && ((sessionCount == 2 && activeSession == anaSessionCountPM29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountPM29.Third)))
				{
					if (!existsHistDailyData)	
						currentClose	= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
					currentHigh			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : high;
					currentLow			= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : low;
					volSum				= 0;
					volPriceSum			= 0;
					currentVolSum		= volSum + Volume[0];
					currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
					periodOpen			= true;
				}
				else if (!rthPivots || ((sessionCount == 2 && activeSession == anaSessionCountPM29.Second)
					|| (sessionCount == 3 && activeSession == anaSessionCountPM29.Third)))
				{
					if (!existsHistDailyData)	
						currentClose	= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
					currentHigh		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : Math.Max(currentHigh, high);
					currentLow		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : Math.Min(currentLow, low);
					if (FirstTickOfBar)
					{
						volSum			= currentVolSum;
						volPriceSum		= currentVolPriceSum;
					}
					currentVolSum		= volSum + Volume[0];
					currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
					periodOpen		= true;
				}
				else 
					periodOpen = false;
			}
			else if (Bars.BarsType.IsIntraday && periodOpen)
			{	
				if (!existsHistDailyData || (existsHistDailyData && rthPivots)) 
				{
					if (!existsHistDailyData)
						currentClose	= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedClose : close;
					currentHigh		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedHigh : Math.Max(currentHigh, high);
					currentLow		= (priorDayHLC == HLCCalculationMode.UserDefinedValues) ? userDefinedLow : Math.Min(currentLow, low);
				}
				if (FirstTickOfBar)
				{
					volSum			= currentVolSum;
					volPriceSum		= currentVolPriceSum;
				}
				currentVolSum		= volSum + Volume[0];
				currentVolPriceSum	= volPriceSum + 0.5*Typical[0]*Volume[0];
			}
			
			if (plotPivots && currentDate != Cbi.Globals.MinDate && !(rthPivots && activeSession == anaSessionCountPM29.Third && numberOfSessions == 2))
			{
				pp = Math.Round(pp/TickSize)* TickSize;
				r1 = Math.Round(r1/TickSize)* TickSize;
				s1 = Math.Round(s1/TickSize)* TickSize;
				r2 = Math.Round(r2/TickSize)* TickSize;
				s2 = Math.Round(s2/TickSize)* TickSize;
				r3 = Math.Round(r3/TickSize)* TickSize;
				s3 = Math.Round(s3/TickSize)* TickSize;
				r4 = Math.Round(r4/TickSize)* TickSize;
				s4 = Math.Round(s4/TickSize)* TickSize;
				if (PivotFormula != anaPivotStylesPM29.Camarilla)
					PP.Set(pp);
				R1.Set(r1);
				S1.Set(s1);
				R2.Set(r2);
				S2.Set(s2);
				R3.Set(r3);
				S3.Set(s3);
				R4.Set(r4);
				S4.Set(s4);

				if (showMidpivots && PivotFormula != anaPivotStylesPM29.Camarilla && PivotFormula != anaPivotStylesPM29.Fibonacci)
				{
					rmid = Math.Round(rmid/TickSize)* TickSize;
					smid = Math.Round(smid/TickSize)* TickSize;
					r12mid = Math.Round(r12mid/TickSize)* TickSize;
					s12mid = Math.Round(s12mid/TickSize)* TickSize;
					r23mid = Math.Round(r23mid/TickSize)* TickSize;
					s23mid = Math.Round(s23mid/TickSize)* TickSize;
					r34mid = Math.Round(r34mid/TickSize)* TickSize;
					s34mid = Math.Round(s34mid/TickSize)* TickSize;
					RMid.Set(rmid);
					SMid.Set(smid);
					R12Mid.Set(r12mid);
					S12Mid.Set(s12mid);
					R23Mid.Set(r23mid);
					S23Mid.Set(s23mid);
					R34Mid.Set(r34mid);
					S34Mid.Set(s34mid);
				}	
				midLine = Math.Round(midLine/TickSize)* TickSize;
				PreviousHigh.Set(previousHigh);
				PreviousLow.Set(previousLow);
				PreviousClose.Set(previousClose);
				MidLine.Set(midLine);
				if (Instrument.MasterInstrument.InstrumentType != Cbi.InstrumentType.Index && 
				 	Instrument.MasterInstrument.InstrumentType != Cbi.InstrumentType.Currency && previousVWAP > double.Epsilon
					&& priorDayHLC != HLCCalculationMode.UserDefinedValues && Bars.BarsType.IsIntraday)
				{	
					previousVWAP = Math.Round(previousVWAP/TickSize)* TickSize;
					PVWAP.Set(previousVWAP);
				}
				else
					PVWAP.Reset();
			}
			else
			{	
				PP.Set(0);
				R1.Set(0);
				S1.Set(0);
				R2.Set(0);
				S2.Set(0);
				R3.Set(0);
				S3.Set(0);
				R4.Set(0);
				S4.Set(0);
				RMid.Set(0);
				SMid.Set(0);
				R12Mid.Set(0);
				S12Mid.Set(0);
				R23Mid.Set(0);
				S23Mid.Set(0);
				R34Mid.Set(0);
				S34Mid.Set(0);
				PreviousHigh.Set(0);
				PreviousLow.Set(0);
				PreviousClose.Set(0);
				MidLine.Set(0);
				PVWAP.Set(0);
			}
		}

		#region Properties

		/// <summary>
		/// </summary>
		[Description("Select the settlement or close price used for calculating pivots.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Settlement/Close")]
		public Data.HLCCalculationMode PriorDayHLC
		{
			get { return priorDayHLC; }
			set { priorDayHLC = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option to show MidPivots")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Show Midpivots")]
		public bool ShowMidpivots 
		{
			get { return showMidpivots; }
			set { showMidpivots = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option where to plot labels")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Position")]
		public anaPlotAlignPM29 PlotLabels
		{
			get { return plotLabels; }
			set { plotLabels = value; }
		}
			
		/// <summary>
		/// </summary>
		[Description("Width of the pivot lines as # of bars.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width")]
		public int Width
		{
			get { return width; }
			set { width = Math.Max(1, value); }
		}

		/// <summary>
		/// </summary>
		[Description("Label distance from line.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Offset")]
		public int LabelPosition
		{
			get { return labelPosition; }
			set { labelPosition = Math.Max(1, value); }
		}
		/// <summary>
		/// </summary>
		[Description("Pivot Formula Type")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Pivot Formula")]
		public anaPivotStylesPM29 PivotFormula
		{
			get { return pivotFormula; }
			set { pivotFormula = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating pivots")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session")]
		public anaSessionTypePM29 PivotSession
		{
			get { return pivotSession; }
			set { pivotSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating RTH pivots")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Session for RTH")]
		public anaSessionCountPM29 ActiveSession
		{
			get { return activeSession; }
			set { activeSession = value; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PP
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R1
		{
			get { return Values[1]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S1
		{
			get { return Values[2]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R2
		{
			get { return Values[3]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S2
		{
			get { return Values[4]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R3
		{
			get { return Values[5]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S3
		{
			get { return Values[6]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R4
		{
			get { return Values[7]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S4
		{
			get { return Values[8]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RMid
		{
			get { return Values[9]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries SMid
		{
			get { return Values[10]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R12Mid
		{
			get { return Values[11]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S12Mid
		{
			get { return Values[12]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R23Mid
		{
			get { return Values[13]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S23Mid
		{
			get { return Values[14]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries R34Mid
		{
			get { return Values[15]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries S34Mid
		{
			get { return Values[16]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PreviousHigh
		{
			get { return Values[17]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PreviousLow
		{
			get { return Values[18]; }
		}
			
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PreviousClose
		{
			get { return Values[19]; }
		}
			
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries MidLine
		{
			get { return Values[20]; }
		}
			
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PVWAP
		{
			get { return Values[21]; }
		}

		/// <summary>
		/// close value for user defined pivots calculation
		/// </summary>
		[Description("User defined prior session close value used for pivots calculation.")]
		[GridCategory("\rUser defined values")]
		public double UserDefinedClose
		{
			get { return userDefinedClose; }
			set { userDefinedClose = value; }
		}

		/// <summary>
		/// high value for user defined pivots calculation
		/// </summary>
		[Description("User defined prior session high value used for pivots calculation.")]
		[GridCategory("\rUser defined values")]
		public double UserDefinedHigh
		{
			get { return userDefinedHigh; }
			set { userDefinedHigh = value; }
		}

		/// <summary>
		/// low value for user defined pivots calculation
		/// </summary>
		[Description("User defined prior session low value used for pivots calculation.")]
		[GridCategory("\rUser defined values")]
		public double UserDefinedLow
		{
			get { return userDefinedLow; }
			set { userDefinedLow = value; }
		}

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
        [GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 01 /No Trade Date")]
		public DateTime PublicHoliday0
		{
			get { return publicHoliday0;}
			set { publicHoliday0 = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 02 /No Trade Date")]
		public DateTime PublicHoliday1
		{
			get { return publicHoliday1;}
			set { publicHoliday1 = value;}
		}	
		
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 03 /No Trade Date")]
		public DateTime PublicHoliday2
		{
			get { return publicHoliday2;}
			set { publicHoliday2 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 04 /No Trade Date")]
		public DateTime PublicHoliday3
		{
			get { return publicHoliday3;}
			set { publicHoliday3 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 05 /No Trade Date")]
		public DateTime PublicHoliday4
		{
			get { return publicHoliday4;}
			set { publicHoliday4 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 06 /No Trade Date")]
		public DateTime PublicHoliday5
		{
			get { return publicHoliday5;}
			set { publicHoliday5 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 07 /No Trade Date")]
		public DateTime PublicHoliday6
		{
			get { return publicHoliday6;}
			set { publicHoliday6 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 08 /No Trade Date")]
		public DateTime PublicHoliday7
		{
			get { return publicHoliday7;}
			set { publicHoliday7 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 09 /No Trade Date")]
		public DateTime PublicHoliday8
		{
			get { return publicHoliday8;}
			set { publicHoliday8 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 10 /No Trade Date")]
		public DateTime PublicHoliday9
		{
			get { return publicHoliday9;}
			set { publicHoliday9 = value;}
		}	
		
		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 11 /No Trade Date")]
		public DateTime PublicHoliday10
		{
			get { return publicHoliday10;}
			set { publicHoliday10 = value;}
		}	

		///<summary
		///</summary>
		[Description("Enter dates for public holidays with no session close.")]
		[GridCategory("Public Holidays")]
		[Gui.Design.DisplayNameAttribute("Holiday 12 /No Trade Date")]
		public DateTime PublicHoliday11
		{
			get { return publicHoliday11;}
			set { publicHoliday11 = value;}
		}	
		
		#endregion

		#region Miscellaneous

		/// <summary>
		/// Have the .GetBars() call in a seperate thread. Reason: NT internal pool locking would not work if called in main thread.
		/// </summary>
		/// <param name="state"></param>
		private void GetBarsNow(object state)
		{
			if (Disposed)
				return;

			dailyBars			= Data.Bars.GetBars(Bars.Instrument, new Period(PeriodType.Day, 1, Bars.Period.MarketDataType), Bars.From, Bars.To, (Session) Bars.Session.Clone(), Data.Bars.SplitAdjust, Data.Bars.DividendAdjust);
			existsHistDailyData	= (dailyBars.Count <= 1) ? false : true;
			isDailyDataLoaded	= true;
			Enabled				= true;

			Cbi.Globals.SynchronizeInvoke.AsyncInvoke(new System.Windows.Forms.MethodInvoker(InvalidateNow), null);
		}

		private DateTime GetLastBarSessionDate(DateTime time, Data.Bars bars, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Monthly && time > cacheSessionEndTmp3) 
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp3);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				DateTime tmpMonthlyEndDate = RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Monthly);
				if (tmpMonthlyEndDate != cacheMonthlyEndDate)
				{
					cacheMonthlyEndDate = tmpMonthlyEndDate;
					if (newSessionBarIdxArr3.Count == 0 || (newSessionBarIdxArr3.Count > 0 && CurrentBar > (int) newSessionBarIdxArr3[newSessionBarIdxArr3.Count - 1]))
						newSessionBarIdxArr3.Add(CurrentBar);
				}
			}
			else if (pivotRange == PivotRange.Daily && time > cacheSessionEndTmp1)
			{
				Bars.Session.GetNextBeginEnd(time, out cacheSessionBeginTmp, out cacheSessionEndTmp1);
				if (Bars.BarsType.IsIntraday)
					sessionDateTmp = Bars.GetTradingDayFromLocal(time);
				else
					sessionDateTmp = time.Date;
				if(cacheSessionDate != sessionDateTmp) 
				{
					cacheSessionDate = sessionDateTmp;
					if (newSessionBarIdxArr1.Count == 0 || (newSessionBarIdxArr1.Count > 0 && CurrentBar > (int) newSessionBarIdxArr1[newSessionBarIdxArr1.Count - 1]))
							newSessionBarIdxArr1.Add(CurrentBar);
				}
			}
			if (pivotRange == PivotRange.Monthly)
				return RoundUpTimeToPeriodTime(sessionDateTmp, PivotRange.Monthly);
			else // if (pivot Range == PivotRange.Daily)
				return sessionDateTmp;		
		}
		
		internal void InvalidateNow()
		{
			if (Disposed || ChartControl == null)
				return;

			ChartControl.Invalidate(true);
		}

		/// <summary>
        /// Overload this method to handle the termination of an indicator. Use this method to dispose of any resources vs overloading the Dispose() method.
		/// </summary>
		protected override void OnTermination()
		{
			if (dailyBars != null)
				dailyBars.Dispose();

			textBrush.Dispose();
			foreach (SolidBrush solidBrush in brushes)
				solidBrush.Dispose();
			stringFormatCenter.Dispose();
			stringFormatFar.Dispose();	
			stringFormatNear.Dispose();
		}
	
		/// <summary>
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="bounds"></param>
		/// <param name="min"></param>
		/// <param name="max"></param>
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (Bars == null || ChartControl == null)
				return;

			// plot error if data not complete
			DateTime lastBarSessionBegin = Cbi.Globals.MinDate;
			DateTime lastBarSessionEnd = Cbi.Globals.MinDate;
			Bars.Session.GetNextBeginEnd(Bars.Get(Math.Min(Bars.Count - 1, this.LastBarIndexPainted)).Time, out lastBarSessionBegin, out lastBarSessionEnd);
			textBrush.Color = ChartControl.AxisColor;
			SizeF errorSize	= graphics.MeasureString(errorData4, textFont);
			errorTextWidth	= errorSize.Width + 5;
			errorTextHeight	= errorSize.Height + 5;
			if (Bars.Count > 0 && plotStart.Date >= lastBarSessionEnd.Date && priorDayHLC != HLCCalculationMode.UserDefinedValues)
				graphics.DrawString(errorData4, textFont, textBrush, bounds.X + bounds.Width - errorTextWidth, bounds.Y + bounds.Height - errorTextHeight, stringFormatNear);
			
			int	barWidth = ChartControl.ChartStyle.GetBarPaintWidth(Bars.BarsData.ChartStyle.BarWidthUI);
			for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
			{
				SolidBrush		brush				= brushes[seriesCount];
				int				firstBarIdxToPaint	= -1;
				int				lastX				= -1;
				int				lastY				= -1;
				int				firstX				= -1;
				SmoothingMode	oldSmoothingMode	= graphics.SmoothingMode;
				Gui.Chart.Plot	plot				= Plots[seriesCount];
				DataSeries		series				= (DataSeries) Values[seriesCount];

				for (int i = newSessionBarIdxArr3.Count - 1; i >= 0; i--)
				{
					int prevSessionBreakIdx = (int) newSessionBarIdxArr3[i];
					if (prevSessionBreakIdx <= this.LastBarIndexPainted)
					{
						firstBarIdxToPaint = prevSessionBreakIdx;
						break;
					}
				}

				using (GraphicsPath	path = new GraphicsPath()) 
				{
					if (brush.Color != plot.Pen.Color)	
						brush = new SolidBrush(plot.Pen.Color);

					for (int idx = this.LastBarIndexPainted; idx >= Math.Max(this.FirstBarIndexPainted, this.LastBarIndexPainted - Width); idx--)
					{
						if (idx - Displacement < 0 || idx - Displacement >= Bars.Count || (!ChartControl.ShowBarsRequired && idx - Displacement < BarsRequired))
							continue;
						else if (!series.IsValidPlot(idx))
							continue;

						if (idx < firstBarIdxToPaint)
							break;

						double	val = series.Get(idx);
						int		x	= ChartControl.GetXByBarIdx(BarsArray[0], idx);
						int		y	= ChartControl.GetYByValue(this, val);

						if (lastX >= 0)
						{
							if (y != lastY) // Problem here is, that last bar of old day has date of new day
								y = lastY;
							path.AddLine(lastX - plot.Pen.Width / 2, lastY, x - plot.Pen.Width / 2, y);
						}
						lastX	= x;
						lastY	= y;
						if (idx == this.LastBarIndexPainted || idx == this.LastBarIndexPainted-1)
							firstX	= x;
					}

					graphics.SmoothingMode = SmoothingMode.AntiAlias;
					graphics.DrawPath(plot.Pen, path);
					graphics.SmoothingMode = oldSmoothingMode;
					if (PlotLabels == anaPlotAlignPM29.Right)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, firstX + LabelPosition + 20, lastY - ChartControl.Font.GetHeight() / 2, stringFormatNear);
					if (PlotLabels == anaPlotAlignPM29.Left)
					graphics.DrawString(plot.Name, ChartControl.Font, brush, lastX - LabelPosition, lastY - ChartControl.Font.GetHeight() / 2, stringFormatFar);
				}
			}
		}

		private DateTime RoundUpTimeToPeriodTime(DateTime time, PivotRange pivotRange)
		{
			if (pivotRange == PivotRange.Weekly)
			{
				DateTime periodStart = time.AddDays((6 - (((int) time.DayOfWeek) + 1) % 7));
				return periodStart.Date.AddDays(System.Math.Ceiling(System.Math.Ceiling(time.Date.Subtract(periodStart.Date).TotalDays) / 7) * 7).Date;
			}
			else if (pivotRange == PivotRange.Monthly)
			{
				DateTime result = new DateTime(time.Year, time.Month, 1); 
				return result.AddMonths(1).AddDays(-1);
			}
			else
				return time;
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaPivotsMonthlyV29[] cacheanaPivotsMonthlyV29 = null;

        private static anaPivotsMonthlyV29 checkanaPivotsMonthlyV29 = new anaPivotsMonthlyV29();

        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        public anaPivotsMonthlyV29 anaPivotsMonthlyV29(anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            return anaPivotsMonthlyV29(Input, activeSession, labelPosition, pivotFormula, pivotSession, plotLabels, priorDayHLC, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showMidpivots, userDefinedClose, userDefinedHigh, userDefinedLow, width);
        }

        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        public anaPivotsMonthlyV29 anaPivotsMonthlyV29(Data.IDataSeries input, anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            if (cacheanaPivotsMonthlyV29 != null)
                for (int idx = 0; idx < cacheanaPivotsMonthlyV29.Length; idx++)
                    if (cacheanaPivotsMonthlyV29[idx].ActiveSession == activeSession && cacheanaPivotsMonthlyV29[idx].LabelPosition == labelPosition && cacheanaPivotsMonthlyV29[idx].PivotFormula == pivotFormula && cacheanaPivotsMonthlyV29[idx].PivotSession == pivotSession && cacheanaPivotsMonthlyV29[idx].PlotLabels == plotLabels && cacheanaPivotsMonthlyV29[idx].PriorDayHLC == priorDayHLC && cacheanaPivotsMonthlyV29[idx].PublicHoliday0 == publicHoliday0 && cacheanaPivotsMonthlyV29[idx].PublicHoliday1 == publicHoliday1 && cacheanaPivotsMonthlyV29[idx].PublicHoliday10 == publicHoliday10 && cacheanaPivotsMonthlyV29[idx].PublicHoliday11 == publicHoliday11 && cacheanaPivotsMonthlyV29[idx].PublicHoliday2 == publicHoliday2 && cacheanaPivotsMonthlyV29[idx].PublicHoliday3 == publicHoliday3 && cacheanaPivotsMonthlyV29[idx].PublicHoliday4 == publicHoliday4 && cacheanaPivotsMonthlyV29[idx].PublicHoliday5 == publicHoliday5 && cacheanaPivotsMonthlyV29[idx].PublicHoliday6 == publicHoliday6 && cacheanaPivotsMonthlyV29[idx].PublicHoliday7 == publicHoliday7 && cacheanaPivotsMonthlyV29[idx].PublicHoliday8 == publicHoliday8 && cacheanaPivotsMonthlyV29[idx].PublicHoliday9 == publicHoliday9 && cacheanaPivotsMonthlyV29[idx].ShowMidpivots == showMidpivots && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedClose - userDefinedClose) <= double.Epsilon && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedHigh - userDefinedHigh) <= double.Epsilon && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedLow - userDefinedLow) <= double.Epsilon && cacheanaPivotsMonthlyV29[idx].Width == width && cacheanaPivotsMonthlyV29[idx].EqualsInput(input))
                        return cacheanaPivotsMonthlyV29[idx];

            lock (checkanaPivotsMonthlyV29)
            {
                checkanaPivotsMonthlyV29.ActiveSession = activeSession;
                activeSession = checkanaPivotsMonthlyV29.ActiveSession;
                checkanaPivotsMonthlyV29.LabelPosition = labelPosition;
                labelPosition = checkanaPivotsMonthlyV29.LabelPosition;
                checkanaPivotsMonthlyV29.PivotFormula = pivotFormula;
                pivotFormula = checkanaPivotsMonthlyV29.PivotFormula;
                checkanaPivotsMonthlyV29.PivotSession = pivotSession;
                pivotSession = checkanaPivotsMonthlyV29.PivotSession;
                checkanaPivotsMonthlyV29.PlotLabels = plotLabels;
                plotLabels = checkanaPivotsMonthlyV29.PlotLabels;
                checkanaPivotsMonthlyV29.PriorDayHLC = priorDayHLC;
                priorDayHLC = checkanaPivotsMonthlyV29.PriorDayHLC;
                checkanaPivotsMonthlyV29.PublicHoliday0 = publicHoliday0;
                publicHoliday0 = checkanaPivotsMonthlyV29.PublicHoliday0;
                checkanaPivotsMonthlyV29.PublicHoliday1 = publicHoliday1;
                publicHoliday1 = checkanaPivotsMonthlyV29.PublicHoliday1;
                checkanaPivotsMonthlyV29.PublicHoliday10 = publicHoliday10;
                publicHoliday10 = checkanaPivotsMonthlyV29.PublicHoliday10;
                checkanaPivotsMonthlyV29.PublicHoliday11 = publicHoliday11;
                publicHoliday11 = checkanaPivotsMonthlyV29.PublicHoliday11;
                checkanaPivotsMonthlyV29.PublicHoliday2 = publicHoliday2;
                publicHoliday2 = checkanaPivotsMonthlyV29.PublicHoliday2;
                checkanaPivotsMonthlyV29.PublicHoliday3 = publicHoliday3;
                publicHoliday3 = checkanaPivotsMonthlyV29.PublicHoliday3;
                checkanaPivotsMonthlyV29.PublicHoliday4 = publicHoliday4;
                publicHoliday4 = checkanaPivotsMonthlyV29.PublicHoliday4;
                checkanaPivotsMonthlyV29.PublicHoliday5 = publicHoliday5;
                publicHoliday5 = checkanaPivotsMonthlyV29.PublicHoliday5;
                checkanaPivotsMonthlyV29.PublicHoliday6 = publicHoliday6;
                publicHoliday6 = checkanaPivotsMonthlyV29.PublicHoliday6;
                checkanaPivotsMonthlyV29.PublicHoliday7 = publicHoliday7;
                publicHoliday7 = checkanaPivotsMonthlyV29.PublicHoliday7;
                checkanaPivotsMonthlyV29.PublicHoliday8 = publicHoliday8;
                publicHoliday8 = checkanaPivotsMonthlyV29.PublicHoliday8;
                checkanaPivotsMonthlyV29.PublicHoliday9 = publicHoliday9;
                publicHoliday9 = checkanaPivotsMonthlyV29.PublicHoliday9;
                checkanaPivotsMonthlyV29.ShowMidpivots = showMidpivots;
                showMidpivots = checkanaPivotsMonthlyV29.ShowMidpivots;
                checkanaPivotsMonthlyV29.UserDefinedClose = userDefinedClose;
                userDefinedClose = checkanaPivotsMonthlyV29.UserDefinedClose;
                checkanaPivotsMonthlyV29.UserDefinedHigh = userDefinedHigh;
                userDefinedHigh = checkanaPivotsMonthlyV29.UserDefinedHigh;
                checkanaPivotsMonthlyV29.UserDefinedLow = userDefinedLow;
                userDefinedLow = checkanaPivotsMonthlyV29.UserDefinedLow;
                checkanaPivotsMonthlyV29.Width = width;
                width = checkanaPivotsMonthlyV29.Width;

                if (cacheanaPivotsMonthlyV29 != null)
                    for (int idx = 0; idx < cacheanaPivotsMonthlyV29.Length; idx++)
                        if (cacheanaPivotsMonthlyV29[idx].ActiveSession == activeSession && cacheanaPivotsMonthlyV29[idx].LabelPosition == labelPosition && cacheanaPivotsMonthlyV29[idx].PivotFormula == pivotFormula && cacheanaPivotsMonthlyV29[idx].PivotSession == pivotSession && cacheanaPivotsMonthlyV29[idx].PlotLabels == plotLabels && cacheanaPivotsMonthlyV29[idx].PriorDayHLC == priorDayHLC && cacheanaPivotsMonthlyV29[idx].PublicHoliday0 == publicHoliday0 && cacheanaPivotsMonthlyV29[idx].PublicHoliday1 == publicHoliday1 && cacheanaPivotsMonthlyV29[idx].PublicHoliday10 == publicHoliday10 && cacheanaPivotsMonthlyV29[idx].PublicHoliday11 == publicHoliday11 && cacheanaPivotsMonthlyV29[idx].PublicHoliday2 == publicHoliday2 && cacheanaPivotsMonthlyV29[idx].PublicHoliday3 == publicHoliday3 && cacheanaPivotsMonthlyV29[idx].PublicHoliday4 == publicHoliday4 && cacheanaPivotsMonthlyV29[idx].PublicHoliday5 == publicHoliday5 && cacheanaPivotsMonthlyV29[idx].PublicHoliday6 == publicHoliday6 && cacheanaPivotsMonthlyV29[idx].PublicHoliday7 == publicHoliday7 && cacheanaPivotsMonthlyV29[idx].PublicHoliday8 == publicHoliday8 && cacheanaPivotsMonthlyV29[idx].PublicHoliday9 == publicHoliday9 && cacheanaPivotsMonthlyV29[idx].ShowMidpivots == showMidpivots && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedClose - userDefinedClose) <= double.Epsilon && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedHigh - userDefinedHigh) <= double.Epsilon && Math.Abs(cacheanaPivotsMonthlyV29[idx].UserDefinedLow - userDefinedLow) <= double.Epsilon && cacheanaPivotsMonthlyV29[idx].Width == width && cacheanaPivotsMonthlyV29[idx].EqualsInput(input))
                            return cacheanaPivotsMonthlyV29[idx];

                anaPivotsMonthlyV29 indicator = new anaPivotsMonthlyV29();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ActiveSession = activeSession;
                indicator.LabelPosition = labelPosition;
                indicator.PivotFormula = pivotFormula;
                indicator.PivotSession = pivotSession;
                indicator.PlotLabels = plotLabels;
                indicator.PriorDayHLC = priorDayHLC;
                indicator.PublicHoliday0 = publicHoliday0;
                indicator.PublicHoliday1 = publicHoliday1;
                indicator.PublicHoliday10 = publicHoliday10;
                indicator.PublicHoliday11 = publicHoliday11;
                indicator.PublicHoliday2 = publicHoliday2;
                indicator.PublicHoliday3 = publicHoliday3;
                indicator.PublicHoliday4 = publicHoliday4;
                indicator.PublicHoliday5 = publicHoliday5;
                indicator.PublicHoliday6 = publicHoliday6;
                indicator.PublicHoliday7 = publicHoliday7;
                indicator.PublicHoliday8 = publicHoliday8;
                indicator.PublicHoliday9 = publicHoliday9;
                indicator.ShowMidpivots = showMidpivots;
                indicator.UserDefinedClose = userDefinedClose;
                indicator.UserDefinedHigh = userDefinedHigh;
                indicator.UserDefinedLow = userDefinedLow;
                indicator.Width = width;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaPivotsMonthlyV29[] tmp = new anaPivotsMonthlyV29[cacheanaPivotsMonthlyV29 == null ? 1 : cacheanaPivotsMonthlyV29.Length + 1];
                if (cacheanaPivotsMonthlyV29 != null)
                    cacheanaPivotsMonthlyV29.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaPivotsMonthlyV29 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaPivotsMonthlyV29 anaPivotsMonthlyV29(anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            return _indicator.anaPivotsMonthlyV29(Input, activeSession, labelPosition, pivotFormula, pivotSession, plotLabels, priorDayHLC, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showMidpivots, userDefinedClose, userDefinedHigh, userDefinedLow, width);
        }

        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaPivotsMonthlyV29 anaPivotsMonthlyV29(Data.IDataSeries input, anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            return _indicator.anaPivotsMonthlyV29(input, activeSession, labelPosition, pivotFormula, pivotSession, plotLabels, priorDayHLC, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showMidpivots, userDefinedClose, userDefinedHigh, userDefinedLow, width);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaPivotsMonthlyV29 anaPivotsMonthlyV29(anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            return _indicator.anaPivotsMonthlyV29(Input, activeSession, labelPosition, pivotFormula, pivotSession, plotLabels, priorDayHLC, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showMidpivots, userDefinedClose, userDefinedHigh, userDefinedLow, width);
        }

        /// <summary>
        /// Monthly Session Pivots.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaPivotsMonthlyV29 anaPivotsMonthlyV29(Data.IDataSeries input, anaSessionCountPM29 activeSession, int labelPosition, anaPivotStylesPM29 pivotFormula, anaSessionTypePM29 pivotSession, anaPlotAlignPM29 plotLabels, Data.HLCCalculationMode priorDayHLC, DateTime publicHoliday0, DateTime publicHoliday1, DateTime publicHoliday10, DateTime publicHoliday11, DateTime publicHoliday2, DateTime publicHoliday3, DateTime publicHoliday4, DateTime publicHoliday5, DateTime publicHoliday6, DateTime publicHoliday7, DateTime publicHoliday8, DateTime publicHoliday9, bool showMidpivots, double userDefinedClose, double userDefinedHigh, double userDefinedLow, int width)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaPivotsMonthlyV29(input, activeSession, labelPosition, pivotFormula, pivotSession, plotLabels, priorDayHLC, publicHoliday0, publicHoliday1, publicHoliday10, publicHoliday11, publicHoliday2, publicHoliday3, publicHoliday4, publicHoliday5, publicHoliday6, publicHoliday7, publicHoliday8, publicHoliday9, showMidpivots, userDefinedClose, userDefinedHigh, userDefinedLow, width);
        }
    }
}
#endregion
