#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description("Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis")]
	public class Spearman : Indicator
	{
		#region Variables
		// Wizard generated variables
		private int period = 10;
		private int maPeriod = 3;
		private readonly SortedDictionary<int, double> unsorted = new SortedDictionary<int, double>();
		private double absum;
		
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "SpearmanRC"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Blue), PlotStyle.Line, "Average"));
			Add(new Line(Color.DarkGray, 50, "fifty"));
			Add(new Line(Color.DarkGray, -50, "minusFifty"));
			Overlay = false;
			BarsRequired = 2 * Period;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{

			if (unsorted.ContainsKey(CurrentBar))
				unsorted[CurrentBar] = Close[0];
			else
				unsorted.Add(CurrentBar, Close[0]);

			if (CurrentBar >= Period && unsorted.ContainsKey(CurrentBar - Period)) unsorted.Remove(CurrentBar - Period);
			if (CurrentBar < Period) return;

			int idx = unsorted.Count - 1;
			absum = 0;

			foreach (var item in unsorted.OrderBy(key => key.Value))
			{
				int diff = CurrentBar - idx - item.Key;
				idx--;
				absum += diff * diff;
				
			}
			SpearmanRC.Set((1 - (6 * absum) / (Period * (Period * Period - 1))) * 100);
			Average.Set(SMA(SpearmanRC, MaPeriod)[0]);
		
		}

		#region Properties
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public DataSeries SpearmanRC
		{
			get { return Values[0]; }
		}
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public DataSeries Average
		{
			get { return Values[1]; }
		}

		[Description("")]
		[GridCategory("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = value; }
		}
		
		[Description("")]
		[GridCategory("Parameters")]
		public int MaPeriod
		{
			get { return maPeriod; }
			set { maPeriod = value; }
		}

		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Spearman[] cacheSpearman = null;

        private static Spearman checkSpearman = new Spearman();

        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        public Spearman Spearman(int maPeriod, int period)
        {
            return Spearman(Input, maPeriod, period);
        }

        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        public Spearman Spearman(Data.IDataSeries input, int maPeriod, int period)
        {
            if (cacheSpearman != null)
                for (int idx = 0; idx < cacheSpearman.Length; idx++)
                    if (cacheSpearman[idx].MaPeriod == maPeriod && cacheSpearman[idx].Period == period && cacheSpearman[idx].EqualsInput(input))
                        return cacheSpearman[idx];

            lock (checkSpearman)
            {
                checkSpearman.MaPeriod = maPeriod;
                maPeriod = checkSpearman.MaPeriod;
                checkSpearman.Period = period;
                period = checkSpearman.Period;

                if (cacheSpearman != null)
                    for (int idx = 0; idx < cacheSpearman.Length; idx++)
                        if (cacheSpearman[idx].MaPeriod == maPeriod && cacheSpearman[idx].Period == period && cacheSpearman[idx].EqualsInput(input))
                            return cacheSpearman[idx];

                Spearman indicator = new Spearman();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MaPeriod = maPeriod;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                Spearman[] tmp = new Spearman[cacheSpearman == null ? 1 : cacheSpearman.Length + 1];
                if (cacheSpearman != null)
                    cacheSpearman.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSpearman = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Spearman Spearman(int maPeriod, int period)
        {
            return _indicator.Spearman(Input, maPeriod, period);
        }

        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        public Indicator.Spearman Spearman(Data.IDataSeries input, int maPeriod, int period)
        {
            return _indicator.Spearman(input, maPeriod, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Spearman Spearman(int maPeriod, int period)
        {
            return _indicator.Spearman(Input, maPeriod, period);
        }

        /// <summary>
        /// Stocks and Commodities February 2011  - The Spearman indicator for Technical Analysis
        /// </summary>
        /// <returns></returns>
        public Indicator.Spearman Spearman(Data.IDataSeries input, int maPeriod, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Spearman(input, maPeriod, period);
        }
    }
}
#endregion
