#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Adaptive Cyber Cycle (from Cybernetic Analysis by John Ehlers)")]
	public class AdaptiveCC : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		// User defined variables (add any user defined variables below)
		#endregion

		HilbertTransform2 _ht;

		//WMA _wmaPeriod;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));
			Add (new Plot (Color.Red, PlotStyle.Line, "Cyber Cycle"));
			Add (new Plot (Color.Blue, PlotStyle.Line, "Lag"));
			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;

			_ht = HilbertTransform2 (Input, Alpha);
			//_wmaPeriod = WMA (_ht.Period, 4);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (CurrentBar < 3)
				return;

			if (CurrentBar < 10)
				Value.Set ((Input [0] - 2 * Input [1] + Input [2]) / 4);
			else
			{
				double alpha1 = 2.0 / (_ht.Period [0] + 1);
				Value.Set (
					(1 - .5 * alpha1) * (1 - .5 * alpha1) * (_ht.Smooth [0] - 2 * _ht.Smooth [1] + _ht.Smooth [2]) +
					2 * (1 - alpha1) * Value [1] -
					(1 - alpha1) * (1 - alpha1) * Value [2]);
			}


			Lag.Set (Value [1]);
		}

		#region Properties

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Lag
		{
			get { return Values [1]; }
		}

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private AdaptiveCC [] cacheAdaptiveCC = null;

		private static AdaptiveCC checkAdaptiveCC = new AdaptiveCC ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCC AdaptiveCC (double alpha)
		{
			return AdaptiveCC (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCC AdaptiveCC (Data.IDataSeries input, double alpha)
		{
			checkAdaptiveCC.Alpha = alpha;
			alpha = checkAdaptiveCC.Alpha;

			if (cacheAdaptiveCC != null)
				for (int idx = 0; idx < cacheAdaptiveCC.Length; idx++)
					if (Math.Abs (cacheAdaptiveCC [idx].Alpha - alpha) <= double.Epsilon && cacheAdaptiveCC [idx].EqualsInput (input))
						return cacheAdaptiveCC [idx];

			AdaptiveCC indicator = new AdaptiveCC ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.SetUp ();

			AdaptiveCC [] tmp = new AdaptiveCC [cacheAdaptiveCC == null ? 1 : cacheAdaptiveCC.Length + 1];
			if (cacheAdaptiveCC != null)
				cacheAdaptiveCC.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheAdaptiveCC = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCC AdaptiveCC (double alpha)
		{
			return _indicator.AdaptiveCC (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCC AdaptiveCC (Data.IDataSeries input, double alpha)
		{
			return _indicator.AdaptiveCC (input, alpha);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCC AdaptiveCC (double alpha)
		{
			return _indicator.AdaptiveCC (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCC AdaptiveCC (Data.IDataSeries input, double alpha)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.AdaptiveCC (input, alpha);
		}

	}
}
#endregion
