#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Adaptive CCI")]
	public class AdaptiveCCI : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		// User defined variables (add any user defined variables below)
		#endregion

		HilbertTransform2 _ht;

		//WMA _wmaPeriod;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.LightGray, 200, "Level 2"));
			Add (new Line (Color.LightGray, 100, "Level 1"));
			Add (new Line (Color.DarkGray, 0, "Zero line"));
			Add (new Line (Color.LightGray, -100, "Level -1"));
			Add (new Line (Color.LightGray, -200, "Level -2"));

			Add (new Plot (Color.Red, PlotStyle.Line, "Cyber Cycle"));
			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;
			PriceType = PriceType.Typical;

			_ht = HilbertTransform2 (Input, Alpha);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (CurrentBar == 0)
				Value.Set (0);
			else
			{
				int period = (int) Math.Floor (_ht.Period [0]);

				double smatp = SMA (Input, period) [0];

				int len = Math.Min (CurrentBar, period - 1);

				double mean = 0;
				for (int idx = len; idx >= 0; idx--)
					mean += Math.Abs (Input [idx] - smatp);
				mean /= len;

				Value.Set ((Input [0] - smatp) / (mean == 0 ? 1 : 0.015 * mean));
			}
		}

		#region Properties

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private AdaptiveCCI [] cacheAdaptiveCCI = null;

		private static AdaptiveCCI checkAdaptiveCCI = new AdaptiveCCI ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCCI AdaptiveCCI (double alpha)
		{
			return AdaptiveCCI (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCCI AdaptiveCCI (Data.IDataSeries input, double alpha)
		{
			checkAdaptiveCCI.Alpha = alpha;
			alpha = checkAdaptiveCCI.Alpha;

			if (cacheAdaptiveCCI != null)
				for (int idx = 0; idx < cacheAdaptiveCCI.Length; idx++)
					if (Math.Abs (cacheAdaptiveCCI [idx].Alpha - alpha) <= double.Epsilon && cacheAdaptiveCCI [idx].EqualsInput (input))
						return cacheAdaptiveCCI [idx];

			AdaptiveCCI indicator = new AdaptiveCCI ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.SetUp ();

			AdaptiveCCI [] tmp = new AdaptiveCCI [cacheAdaptiveCCI == null ? 1 : cacheAdaptiveCCI.Length + 1];
			if (cacheAdaptiveCCI != null)
				cacheAdaptiveCCI.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheAdaptiveCCI = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCCI AdaptiveCCI (double alpha)
		{
			return _indicator.AdaptiveCCI (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCCI AdaptiveCCI (Data.IDataSeries input, double alpha)
		{
			return _indicator.AdaptiveCCI (input, alpha);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCCI AdaptiveCCI (double alpha)
		{
			return _indicator.AdaptiveCCI (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCCI AdaptiveCCI (Data.IDataSeries input, double alpha)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.AdaptiveCCI (input, alpha);
		}

	}
}
#endregion
