#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Adaptive Center of Gravity (from Cybernetic Analysis by John Ehlers)")]
	public class AdaptiveCG : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		// User defined variables (add any user defined variables below)
		#endregion

		HilbertTransform2 _ht;
		//WMA _wmaPeriod;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));

			Add (new Plot (Color.Red, PlotStyle.Line, "Center of Gravity"));
			Add (new Plot (Color.Blue, PlotStyle.Line, "Lag"));
			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;

			_ht = HilbertTransform2 (Input, Alpha);
			//_wmaPeriod = WMA (_ht.Period, 4);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			//int length = (int) Math.Floor (_wmaPeriod [0] / 2);
			int length = (int) Math.Floor (_ht.Period [0] / 2);
			if (CurrentBar < length || CurrentBar < 4)
			{
				Lag.Set (0);
				return;
			}

			double num = 0;
			double denom = 0;
			for (int i = 0; i < length && i < CurrentBar; i++)
			{
				num += (1 + i) * Input [i];
				denom += Input [i];
			}

			if (denom != 0)
				Value.Set ((length + 1.0) / 2 - num / denom);

			Lag.Set (Value [1]);
		}

		#region Properties

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Lag
		{
			get { return Values [1]; }
		}

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private AdaptiveCG [] cacheAdaptiveCG = null;

		private static AdaptiveCG checkAdaptiveCG = new AdaptiveCG ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCG AdaptiveCG (double alpha)
		{
			return AdaptiveCG (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public AdaptiveCG AdaptiveCG (Data.IDataSeries input, double alpha)
		{
			checkAdaptiveCG.Alpha = alpha;
			alpha = checkAdaptiveCG.Alpha;

			if (cacheAdaptiveCG != null)
				for (int idx = 0; idx < cacheAdaptiveCG.Length; idx++)
					if (Math.Abs (cacheAdaptiveCG [idx].Alpha - alpha) <= double.Epsilon && cacheAdaptiveCG [idx].EqualsInput (input))
						return cacheAdaptiveCG [idx];

			AdaptiveCG indicator = new AdaptiveCG ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.SetUp ();

			AdaptiveCG [] tmp = new AdaptiveCG [cacheAdaptiveCG == null ? 1 : cacheAdaptiveCG.Length + 1];
			if (cacheAdaptiveCG != null)
				cacheAdaptiveCG.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheAdaptiveCG = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCG AdaptiveCG (double alpha)
		{
			return _indicator.AdaptiveCG (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCG AdaptiveCG (Data.IDataSeries input, double alpha)
		{
			return _indicator.AdaptiveCG (input, alpha);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.AdaptiveCG AdaptiveCG (double alpha)
		{
			return _indicator.AdaptiveCG (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.AdaptiveCG AdaptiveCG (Data.IDataSeries input, double alpha)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.AdaptiveCG (input, alpha);
		}

	}
}
#endregion
