//#define SHOW_PERIOD

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Hilbert Transform (from Cybernetic Analysis by John Ehlers)")]
	public class HilbertTransform2 : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		// User defined variables (add any user defined variables below)		

		private DataSeries _smooth;
		private DataSeries _cycle;
		private DataSeries _instPeriod;
#if !SHOW_PERIOD
		private DataSeries _period;
#endif
		private DataSeries _deltaPhase;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));

			Add (new Plot (Color.Red, PlotStyle.Line, "InPhase"));
			Add (new Plot (Color.Blue, PlotStyle.Line, "Quadrature"));
#if SHOW_PERIOD
			Add (new Plot (Color.Green, PlotStyle.Line, "Period"));
#else
			_period = new DataSeries (this);
#endif

			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;

			_smooth = new DataSeries (this);// WMA (Input, alpha).Value;
			_cycle = new DataSeries (this);
			_instPeriod = new DataSeries (this);
			_deltaPhase = new DataSeries (this);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (this.CurrentBar < 7)
				return;

			Smooth.Set ((Input [0] + 2 * Input [1] + 2 * Input [2] + Input [3]) / 6.0);

			DataSeries I1 = Value;
			DataSeries Q1 = Quadrature;

			if (CurrentBar < 7)
				Cycle.Set ((Input [0] - 2 * Input [1] + Input [2]) / 4);
			else
				Cycle.Set (
					(1 - .5 * alpha) * (1 - .5 * alpha) * (Smooth [0] - 2 * Smooth [1] + Smooth [2]) +
					(1 - alpha) * 2 * Cycle [1] -
					(1 - alpha) * (1 - alpha) * Cycle [2]);

			Q1.Set ((0.0962 * Cycle [0] + 0.5769 * Cycle [2] - 0.5769 * Cycle [4] - 0.0962 * Cycle [6]) * (0.5 + 0.08 * _instPeriod [1]));
			I1.Set (Cycle [3]);

			double deltaPhase = 0;
			if (Q1 [0] != 0 && Q1 [1] != 0)
				deltaPhase = (I1 [0] / Q1 [0] - I1 [1] / Q1 [1]) / (1 + I1 [0] * I1 [1] / (Q1 [0] * Q1 [1]));

			if (deltaPhase < 0.1)
				deltaPhase = 0.1;
			else if (deltaPhase > 1.1)
				deltaPhase = 1.1;

			_deltaPhase.Set (deltaPhase);

			//double medianDelta = MedianIndicator (_deltaPhase, 5) [0];
			double medianDelta = MedianIndicator (_deltaPhase, 3) [0];
			//double medianDelta = WMA (_deltaPhase, 5) [0];
			double dc = (medianDelta == 0) ? 15 : 0.5 + Math.PI * 2 / medianDelta;

			_instPeriod.Set (dc / 3 + _instPeriod [1] * 2 / 3);
			Period.Set (0.15 * _instPeriod [0] + 0.85 * Period [1]);
		}

		#region Properties

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Quadrature
		{
			get { return Values [1]; }
		}

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Period
		{
#if SHOW_PERIOD
			get { return Values [2]; }
#else
			get { return _period; }
#endif
		}

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Cycle
		{
			get { return _cycle; }
		}

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Smooth
		{
			get { return _smooth; }
		}

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private HilbertTransform2 [] cacheHilbertTransform2 = null;

		private static HilbertTransform2 checkHilbertTransform2 = new HilbertTransform2 ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public HilbertTransform2 HilbertTransform2 (double alpha)
		{
			return HilbertTransform2 (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public HilbertTransform2 HilbertTransform2 (Data.IDataSeries input, double alpha)
		{
			checkHilbertTransform2.Alpha = alpha;
			alpha = checkHilbertTransform2.Alpha;

			if (cacheHilbertTransform2 != null)
				for (int idx = 0; idx < cacheHilbertTransform2.Length; idx++)
					if (cacheHilbertTransform2 [idx].Alpha == alpha && cacheHilbertTransform2 [idx].EqualsInput (input))
						return cacheHilbertTransform2 [idx];

			HilbertTransform2 indicator = new HilbertTransform2 ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.SetUp ();

			HilbertTransform2 [] tmp = new HilbertTransform2 [cacheHilbertTransform2 == null ? 1 : cacheHilbertTransform2.Length + 1];
			if (cacheHilbertTransform2 != null)
				cacheHilbertTransform2.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheHilbertTransform2 = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.HilbertTransform2 HilbertTransform2 (double alpha)
		{
			return _indicator.HilbertTransform2 (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.HilbertTransform2 HilbertTransform2 (Data.IDataSeries input, double alpha)
		{
			return _indicator.HilbertTransform2 (input, alpha);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.HilbertTransform2 HilbertTransform2 (double alpha)
		{
			return _indicator.HilbertTransform2 (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.HilbertTransform2 HilbertTransform2 (Data.IDataSeries input, double alpha)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.HilbertTransform2 (input, alpha);
		}

	}
}
#endregion
