#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Instantaneous Trend (from Cybernetic Analysis by John Ehlers)")]
	public class ITrend : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		// User defined variables (add any user defined variables below)
		#endregion


		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));

			Add (new Plot (Color.Red, PlotStyle.Line, "ITrend"));
			Add (new Plot (Color.Blue, PlotStyle.Line, "Lag"));
			CalculateOnBarClose = true;
			Overlay = true;
			PriceTypeSupported = true;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (CurrentBar < 3)
				Value.Set (Input [0]);
			else
			{
				if (CurrentBar < 7)
					Value.Set ((Input [0] + 2 * Input [1] * Input [2]) / 4);
				else
					Value.Set (
						(alpha - alpha * alpha / 4) * Input [0] +
						alpha * alpha * Input [1] / 2 -
						(alpha - 0.75 * alpha * alpha) * Input [2] +
						2 * (1 - alpha) * Value [1] -
						(1 - alpha) * (1 - alpha) * Value [2]
						);

				Lag.Set (2 * Value [0] - Value [2]);
			}
		}

		#region Properties

		[Browsable (false)]
		[XmlIgnore ()]
		public DataSeries Lag
		{
			get { return Values [1]; }
		}

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private ITrend [] cacheITrend = null;

		private static ITrend checkITrend = new ITrend ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public ITrend ITrend (double alpha)
		{
			return ITrend (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public ITrend ITrend (Data.IDataSeries input, double alpha)
		{
			checkITrend.Alpha = alpha;
			alpha = checkITrend.Alpha;

			if (cacheITrend != null)
				for (int idx = 0; idx < cacheITrend.Length; idx++)
					if (Math.Abs (cacheITrend [idx].Alpha - alpha) <= double.Epsilon && cacheITrend [idx].EqualsInput (input))
						return cacheITrend [idx];

			ITrend indicator = new ITrend ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.SetUp ();

			ITrend [] tmp = new ITrend [cacheITrend == null ? 1 : cacheITrend.Length + 1];
			if (cacheITrend != null)
				cacheITrend.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheITrend = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.ITrend ITrend (double alpha)
		{
			return _indicator.ITrend (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.ITrend ITrend (Data.IDataSeries input, double alpha)
		{
			return _indicator.ITrend (input, alpha);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.ITrend ITrend (double alpha)
		{
			return _indicator.ITrend (Input, alpha);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.ITrend ITrend (Data.IDataSeries input, double alpha)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.ITrend (input, alpha);
		}

	}
}
#endregion
