#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Laguerre Filter (from Cybernetic Analysis by John Ehlers)")]
	public class LaguerreFilter : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double gamma = 0.8; // Default setting for Gamma
		// User defined variables (add any user defined variables below)
		#endregion

		DataSeries L0;
		DataSeries L1;
		DataSeries L2;
		DataSeries L3;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Plot (Color.Red, PlotStyle.Line, "Laguerre Filter"));

			CalculateOnBarClose = true;
			Overlay = true;
			PriceTypeSupported = true;

			L0 = new DataSeries (this);
			L1 = new DataSeries (this);
			L2 = new DataSeries (this);
			L3 = new DataSeries (this);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (CurrentBar < 1)
				return;

			L0.Set ((1 - gamma) * Input [0] + gamma * L0 [1]);
			L1.Set (L0 [1] - gamma * L0 [0] + gamma * L1 [1]);
			L2.Set (L1 [1] - gamma * L1 [0] + gamma * L2 [1]);
			L3.Set (L2 [1] - gamma * L2 [0] + gamma * L3 [1]);

			Value.Set ((L0 [0] + 2 * L1 [0] + 2 * L2 [0] + L3 [0]) / 6);
		}

		#region Properties

		[Description ("")]
		[Category ("Parameters")]
		public double Gamma
		{
			get { return gamma; }
			set { gamma = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private LaguerreFilter [] cacheLaguerreFilter = null;

		private static LaguerreFilter checkLaguerreFilter = new LaguerreFilter ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public LaguerreFilter LaguerreFilter (double gamma)
		{
			return LaguerreFilter (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public LaguerreFilter LaguerreFilter (Data.IDataSeries input, double gamma)
		{
			checkLaguerreFilter.Gamma = gamma;
			gamma = checkLaguerreFilter.Gamma;

			if (cacheLaguerreFilter != null)
				for (int idx = 0; idx < cacheLaguerreFilter.Length; idx++)
					if (Math.Abs (cacheLaguerreFilter [idx].Gamma - gamma) <= double.Epsilon && cacheLaguerreFilter [idx].EqualsInput (input))
						return cacheLaguerreFilter [idx];

			LaguerreFilter indicator = new LaguerreFilter ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Gamma = gamma;
			indicator.SetUp ();

			LaguerreFilter [] tmp = new LaguerreFilter [cacheLaguerreFilter == null ? 1 : cacheLaguerreFilter.Length + 1];
			if (cacheLaguerreFilter != null)
				cacheLaguerreFilter.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheLaguerreFilter = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.LaguerreFilter LaguerreFilter (double gamma)
		{
			return _indicator.LaguerreFilter (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.LaguerreFilter LaguerreFilter (Data.IDataSeries input, double gamma)
		{
			return _indicator.LaguerreFilter (input, gamma);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.LaguerreFilter LaguerreFilter (double gamma)
		{
			return _indicator.LaguerreFilter (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.LaguerreFilter LaguerreFilter (Data.IDataSeries input, double gamma)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.LaguerreFilter (input, gamma);
		}

	}
}
#endregion
