#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Laguerre RSI (from Cybernetic Analysis by John Ehlers)")]
	public class LaguerreRSI : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double gamma = 0.8; // Default setting for Gamma
		// User defined variables (add any user defined variables below)
		#endregion

		DataSeries L0;
		DataSeries L1;
		DataSeries L2;
		DataSeries L3;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0.5, "ZeroLine"));
			Add (new Line (Color.LightGray, 0.2, "Low"));
			Add (new Line (Color.LightGray, 0.8, "High"));

			Add (new Plot (Color.Red, PlotStyle.Line, "Laguerre Filter"));

			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;
			HorizontalGridLines = false;

			L0 = new DataSeries (this);
			L1 = new DataSeries (this);
			L2 = new DataSeries (this);
			L3 = new DataSeries (this);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (CurrentBar < 1)
				return;

			double l0 = (1 - gamma) * Input [0] + gamma * L0 [1];
			double l1 = L0 [1] - gamma * l0 + gamma * L1 [1];
			double l2 = L1 [1] - gamma * l1 + gamma * L2 [1];
			double l3 = L2 [1] - gamma * l2 + gamma * L3 [1];

			double cu = 0;
			double cd = 0;

			if (l0 >= l1)
				cu = l0 - l1;
			else
				cd = l1 - l0;

			if (l1 >= l2)
				cu += l1 - l2;
			else
				cd += l2 - l1;

			if (l2 >= l3)
				cu += l2 - l3;
			else
				cd += l3 - l2;

			L0.Set (l0);
			L1.Set (l1);
			L2.Set (l2);
			L3.Set (l3);

			if (cu + cd != 0)
				Value.Set (cu / (cu + cd));
		}

		#region Properties

		[Description ("")]
		[Category ("Parameters")]
		public double Gamma
		{
			get { return gamma; }
			set { gamma = Math.Max (0.001, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private LaguerreRSI [] cacheLaguerreRSI = null;

		private static LaguerreRSI checkLaguerreRSI = new LaguerreRSI ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public LaguerreRSI LaguerreRSI (double gamma)
		{
			return LaguerreRSI (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public LaguerreRSI LaguerreRSI (Data.IDataSeries input, double gamma)
		{
			checkLaguerreRSI.Gamma = gamma;
			gamma = checkLaguerreRSI.Gamma;

			if (cacheLaguerreRSI != null)
				for (int idx = 0; idx < cacheLaguerreRSI.Length; idx++)
					if (Math.Abs (cacheLaguerreRSI [idx].Gamma - gamma) <= double.Epsilon && cacheLaguerreRSI [idx].EqualsInput (input))
						return cacheLaguerreRSI [idx];

			LaguerreRSI indicator = new LaguerreRSI ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Gamma = gamma;
			indicator.SetUp ();

			LaguerreRSI [] tmp = new LaguerreRSI [cacheLaguerreRSI == null ? 1 : cacheLaguerreRSI.Length + 1];
			if (cacheLaguerreRSI != null)
				cacheLaguerreRSI.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheLaguerreRSI = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.LaguerreRSI LaguerreRSI (double gamma)
		{
			return _indicator.LaguerreRSI (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.LaguerreRSI LaguerreRSI (Data.IDataSeries input, double gamma)
		{
			return _indicator.LaguerreRSI (input, gamma);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.LaguerreRSI LaguerreRSI (double gamma)
		{
			return _indicator.LaguerreRSI (Input, gamma);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.LaguerreRSI LaguerreRSI (Data.IDataSeries input, double gamma)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.LaguerreRSI (input, gamma);
		}

	}
}
#endregion
