// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// The Minimum shows the minimum of the last n bars.
	/// </summary>
	[Description("The Minimum shows the minimum of the last n bars.")]
	public class MedianIndicator : Indicator
	{
		#region Variables
		private int		period	= 14;
		#endregion

		double [] _rgValues;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add (new Plot (Color.Green, "MedianIndicator"));

			Overlay				= true;
			PriceTypeSupported	= true;

		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			int cBars = Math.Min(CurrentBar, Period - 1) + 1;
			double [] rgValues = new double [cBars];

			for (int i = 0; i < rgValues.Length; i ++)
				rgValues [i] = Input [i];

			Array.Sort<double> (rgValues);

			Value.Set (rgValues [rgValues.Length / 2]);
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
        #endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MedianIndicator[] cacheMedian = null;
        private static MedianIndicator checkMedian = new MedianIndicator();

        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
		public MedianIndicator MedianIndicator (int period)
        {
			return MedianIndicator (Input, period);
        }

        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
		public MedianIndicator MedianIndicator (Data.IDataSeries input, int period)
        {
            checkMedian.Period = period;
            period = checkMedian.Period;

            if (cacheMedian != null)
                for (int idx = 0; idx < cacheMedian.Length; idx++)
                    if (cacheMedian[idx].Period == period && cacheMedian[idx].EqualsInput(input))
                        return cacheMedian[idx];

            MedianIndicator indicator = new MedianIndicator();
			indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Period = period;
            indicator.SetUp();

            MedianIndicator[] tmp = new MedianIndicator[cacheMedian == null ? 1 : cacheMedian.Length + 1];
            if (cacheMedian != null)
                cacheMedian.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheMedian = tmp;
            Indicators.Add(indicator);

            return indicator;
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
		public Indicator.MedianIndicator MedianIndicator (int period)
        {
			return _indicator.MedianIndicator (Input, period);
        }

        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
		public Indicator.MedianIndicator MedianIndicator (Data.IDataSeries input, int period)
        {
			return _indicator.MedianIndicator (input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
		public Indicator.MedianIndicator MedianIndicator (int period)
        {
			return _indicator.MedianIndicator (Input, period);
        }

        /// <summary>
        /// The Minimum shows the minimum of the last n bars.
        /// </summary>
        /// <returns></returns>
		public Indicator.MedianIndicator MedianIndicator (Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.MedianIndicator (input, period);
        }
    }
}
#endregion
