#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// SmootheAdaptive Momentum
	/// </summary>
	[Description ("SmootheAdaptive Momentum")]
	public class SmoothedAdaptiveMomentum : Indicator
	{
		#region Variables
		// Wizard generated variables
		private double alpha = 0.07; // Default setting for Alpha
		private int cutoff = 8; // Default setting for Cutoff
		// User defined variables (add any user defined variables below)
		#endregion

		HilbertTransform2 _ht;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));

			Add (new Plot (Color.Orange, PlotStyle.Line, "SmoothedAdaptiveMomentum"));

			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;

			_ht = HilbertTransform2 (Input, Alpha);
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			double period = _ht.Period [0];
			if (period >= CurrentBar)
				return;

			double value = Input [0] - Input [(int) Math.Floor (period)];

			double a1 = Math.Exp (-Math.PI / Cutoff);
			double b1 = 2 * a1 * Math.Cos (1.738 * Math.PI / Cutoff);
			double c1 = a1 * a1;

			double coeff2 = b1 + c1;
			double coeff3 = -c1 * (1 + b1);
			double coeff4 = c1 * c1;
			double coeff1 = 1 - coeff2 - coeff3 - coeff4;

			if (CurrentBar < 4)
				Value.Set (value);
			else
				Value.Set (coeff1 * value + coeff2 * Value [1] + coeff3 * Value [2] + coeff4 * Value [3]);
		}

		#region Properties

		[Description ("")]
		[Category ("Parameters")]
		public double Alpha
		{
			get { return alpha; }
			set { alpha = Math.Max (0.001, value); }
		}

		[Description ("")]
		[Category ("Parameters")]
		public int Cutoff
		{
			get { return cutoff; }
			set { cutoff = Math.Max (1, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private SmoothedAdaptiveMomentum [] cacheSmoothedAdaptiveMomentum = null;

		private static SmoothedAdaptiveMomentum checkSmoothedAdaptiveMomentum = new SmoothedAdaptiveMomentum ();

		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		public SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (double alpha, int cutoff)
		{
			return SmoothedAdaptiveMomentum (Input, alpha, cutoff);
		}

		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		public SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (Data.IDataSeries input, double alpha, int cutoff)
		{
			checkSmoothedAdaptiveMomentum.Alpha = alpha;
			alpha = checkSmoothedAdaptiveMomentum.Alpha;
			checkSmoothedAdaptiveMomentum.Cutoff = cutoff;
			cutoff = checkSmoothedAdaptiveMomentum.Cutoff;

			if (cacheSmoothedAdaptiveMomentum != null)
				for (int idx = 0; idx < cacheSmoothedAdaptiveMomentum.Length; idx++)
					if (Math.Abs (cacheSmoothedAdaptiveMomentum [idx].Alpha - alpha) <= double.Epsilon && cacheSmoothedAdaptiveMomentum [idx].Cutoff == cutoff && cacheSmoothedAdaptiveMomentum [idx].EqualsInput (input))
						return cacheSmoothedAdaptiveMomentum [idx];

			SmoothedAdaptiveMomentum indicator = new SmoothedAdaptiveMomentum ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.Alpha = alpha;
			indicator.Cutoff = cutoff;
			indicator.SetUp ();

			SmoothedAdaptiveMomentum [] tmp = new SmoothedAdaptiveMomentum [cacheSmoothedAdaptiveMomentum == null ? 1 : cacheSmoothedAdaptiveMomentum.Length + 1];
			if (cacheSmoothedAdaptiveMomentum != null)
				cacheSmoothedAdaptiveMomentum.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheSmoothedAdaptiveMomentum = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (double alpha, int cutoff)
		{
			return _indicator.SmoothedAdaptiveMomentum (Input, alpha, cutoff);
		}

		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		public Indicator.SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (Data.IDataSeries input, double alpha, int cutoff)
		{
			return _indicator.SmoothedAdaptiveMomentum (input, alpha, cutoff);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (double alpha, int cutoff)
		{
			return _indicator.SmoothedAdaptiveMomentum (Input, alpha, cutoff);
		}

		/// <summary>
		/// SmootheAdaptive Momentum
		/// </summary>
		/// <returns></returns>
		public Indicator.SmoothedAdaptiveMomentum SmoothedAdaptiveMomentum (Data.IDataSeries input, double alpha, int cutoff)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.SmoothedAdaptiveMomentum (input, alpha, cutoff);
		}

	}
}
#endregion
