//###
//### Apply notes to your charts
//###
//### User		Date 		Description
//### ------	-------- 	-------------
//### Gaston	Jun 2010 	Created
//### Gaston	Jan 2011 	Fixed location bug
//### Gaston	Feb 2011 	Added selectable locations, colors, and fonts
//###
#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.Text.RegularExpressions;

#endregion

namespace NinjaTrader.Indicator
{
    [Description("Write Notes on Charts")]
    public class ChartNotes : Indicator
    {
		
        #region Variables

		int showLines=100;
		
		string[] note1Text={};
		public TextPosition note1Location = TextPosition.TopLeft;
		private System.Drawing.Font note1Font   = new Font("Courier", 10,System.Drawing.FontStyle.Regular);
		Color note1Color=Color.Blue;
		
		string[] note2Text={};
		public TextPosition note2Location = TextPosition.TopRight;
		private System.Drawing.Font note2Font   = new Font("Courier", 10,System.Drawing.FontStyle.Regular);
		Color note2Color=Color.Blue;
		
		string[] note3Text={};
		public TextPosition note3Location = TextPosition.BottomLeft;
		private System.Drawing.Font note3Font   = new Font("Courier", 10,System.Drawing.FontStyle.Regular);
		Color note3Color=Color.Blue;
		
		string[] note4Text={};
		public TextPosition note4Location = TextPosition.BottomRight;
		private System.Drawing.Font note4Font   = new Font("Courier", 10,System.Drawing.FontStyle.Regular);
		Color note4Color=Color.Blue;
		
		string[] note5Text={};
		public TextPosition note5Location = TextPosition.Center;
		private System.Drawing.Font note5Font   = new Font("Courier", 10,System.Drawing.FontStyle.Regular);
		Color note5Color=Color.Blue;

        #endregion

        protected override void Initialize() {
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= false;
        }

        protected override void OnBarUpdate() {

			if ( CurrentBar > 1 ) return;
			
			string str=""; int i = 0;
			
			if ( note1Text.Length > 0 ) {
				str = "";
				for ( i=0; i < note1Text.Length; i++ ) if (i <= showLines-1) str += note1Text[i] +"\n"; 				
				DrawTextFixed("TopLeft", str, note1Location, note1Color, note1Font, Color.Transparent, Color.Transparent, 0);
			}
			if ( note2Text.Length > 0 ) {
				str = "";
				for ( i=0; i < note2Text.Length; i++ ) if (i <= showLines-1) str += note2Text[i] +"\n"; 				
				DrawTextFixed("TopRight", str, note2Location, note2Color, note2Font, Color.Transparent, Color.Transparent, 0);
			}
			if ( note3Text.Length > 0 ) {
				str = "";
				for ( i=0; i < note3Text.Length; i++ ) if (i <= showLines-1) str += note3Text[i] +"\n";
				DrawTextFixed("BottomLeft", str, note3Location, note3Color, note3Font, Color.Transparent, Color.Transparent, 0);
			}
			if ( note4Text.Length > 0 ) {
				str = "";
				for ( i=0; i < note4Text.Length; i++ ) if (i <= showLines-1) str += note4Text[i] +"\n";
				DrawTextFixed("BottomRight", str, note4Location, note4Color, note4Font, Color.Transparent, Color.Transparent, 0);
			}
			if ( note5Text.Length > 0 ) {
				str = "";
				for ( i=0; i < note5Text.Length; i++ ) if (i <= showLines-1) str += note5Text[i] +"\n"; 				
				DrawTextFixed("Center", str, note5Location, note5Color, note5Font, Color.Transparent, Color.Transparent, 0);			
			}
        }

	#region Properties

		//###
		//### Note1 ###
		//###
        [Description("Note1 Text")]
		[Category("Note1")]
		[Gui.Design.DisplayName("1. Text")]
        public string[] Note1Text
        {
            get { return note1Text; }
            set { note1Text = value; }
        }
		
		[Description("Note1 Location")]
		[Category("Note1")]
		[Gui.Design.DisplayName("2. Location")]
		public TextPosition _Note1Location
		{
			get { return note1Location; }
			set { note1Location = value; }
		}

		[Description("Note1 Color")]
		[Category("Note1")]
        [Gui.Design.DisplayName("3. Color")]
        public Color Note1Color
        {
            get { return note1Color; }
            set { note1Color = value; }
        }
        [Browsable(false)]
        public string Note1ColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(Note1Color); }
            set { Note1Color = Gui.Design.SerializableColor.FromString(value); }
        }		
		
		[XmlIgnore()]	//### Need this for font serialization, or will get error when saving as template
		[Description("Note1 Font")]
		[Category("Note1")]
        [Gui.Design.DisplayName("4. Font")]
		public Font Note1Font
		{
			get { return note1Font; }
			set { note1Font = value; }
		}
        [Browsable(false)]
        public string Note1FontSerialize
        {
            get { return Gui.Design.SerializableFont.ToString(Note1Font); }
            set { Note1Font = Gui.Design.SerializableFont.FromString(value); }
        }		
		
		
		//###
		//### Note2 ###
		//###
        [Description("Note2 Text")]
		[Category("Note2")]
		[Gui.Design.DisplayName("1. Text")]
        public string[] Note2Text
        {
            get { return note2Text; }
            set { note2Text = value; }
        }
		
		[Description("Note2 Location")]
		[Category("Note2")]
		[Gui.Design.DisplayName("2. Location")]
		public TextPosition _Note2Location
		{
			get { return note2Location; }
			set { note2Location = value; }
		}

		[Description("Note2 Color")]
		[Category("Note2")]
        [Gui.Design.DisplayName("3. Color")]
        public Color Note2Color
        {
            get { return note2Color; }
            set { note2Color = value; }
        }
        [Browsable(false)]
        public string Note2ColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(Note2Color); }
            set { Note2Color = Gui.Design.SerializableColor.FromString(value); }
        }		
		
		[XmlIgnore()]	//### Need this for font serialization, or will get error when saving as template
		[Description("Note2 Font")]
		[Category("Note2")]
        [Gui.Design.DisplayName("4. Font")]
		public Font Note2Font
		{
			get { return note2Font; }
			set { note2Font = value; }
		}
        [Browsable(false)]
        public string Note2FontSerialize
        {
            get { return Gui.Design.SerializableFont.ToString(Note2Font); }
            set { Note2Font = Gui.Design.SerializableFont.FromString(value); }
        }				
		
		//###
		//### Note3 ###
		//###
        [Description("Note3 Text")]
		[Category("Note3")]
		[Gui.Design.DisplayName("1. Text")]
        public string[] Note3Text
        {
            get { return note3Text; }
            set { note3Text = value; }
        }
		
		[Description("Note3 Location")]
		[Category("Note3")]
		[Gui.Design.DisplayName("2. Location")]
		public TextPosition _Note3Location
		{
			get { return note3Location; }
			set { note3Location = value; }
		}

		[Description("Note3 Color")]
		[Category("Note3")]
        [Gui.Design.DisplayName("3. Color")]
        public Color Note3Color
        {
            get { return note3Color; }
            set { note3Color = value; }
        }
        [Browsable(false)]
        public string Note3ColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(Note3Color); }
            set { Note3Color = Gui.Design.SerializableColor.FromString(value); }
        }		
		
		[XmlIgnore()]	//### Need this for font serialization, or will get error when saving as template
		[Description("Note3 Font")]
		[Category("Note3")]
        [Gui.Design.DisplayName("4. Font")]
		public Font Note3Font
		{
			get { return note3Font; }
			set { note3Font = value; }
		}
        [Browsable(false)]
        public string Note3FontSerialize
        {
            get { return Gui.Design.SerializableFont.ToString(Note3Font); }
            set { Note3Font = Gui.Design.SerializableFont.FromString(value); }
        }		
				
		//###
		//### Note4 ###
		//###
        [Description("Note4 Text")]
		[Category("Note4")]
		[Gui.Design.DisplayName("1. Text")]
        public string[] Note4Text
        {
            get { return note4Text; }
            set { note4Text = value; }
        }
		
		[Description("Note4 Location")]
		[Category("Note4")]
		[Gui.Design.DisplayName("2. Location")]
		public TextPosition _Note4Location
		{
			get { return note4Location; }
			set { note4Location = value; }
		}

		[Description("Note4 Color")]
		[Category("Note4")]
        [Gui.Design.DisplayName("3. Color")]
        public Color Note4Color
        {
            get { return note4Color; }
            set { note4Color = value; }
        }
        [Browsable(false)]
        public string Note4ColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(Note4Color); }
            set { Note4Color = Gui.Design.SerializableColor.FromString(value); }
        }		
		
		[XmlIgnore()]	//### Need this for font serialization, or will get error when saving as template
		[Description("Note4 Font")]
		[Category("Note4")]
        [Gui.Design.DisplayName("4. Font")]
		public Font Note4Font
		{
			get { return note4Font; }
			set { note4Font = value; }
		}
        [Browsable(false)]
        public string Note4FontSerialize
        {
            get { return Gui.Design.SerializableFont.ToString(Note4Font); }
            set { Note4Font = Gui.Design.SerializableFont.FromString(value); }
        }		
		
		//###
		//### Note5 ###
		//###
        [Description("Note5 Text")]
		[Category("Note5")]
		[Gui.Design.DisplayName("1. Text")]
        public string[] Note5Text
        {
            get { return note5Text; }
            set { note5Text = value; }
        }
		
		[Description("Note5 Location")]
		[Category("Note5")]
		[Gui.Design.DisplayName("2. Location")]
		public TextPosition _Note5Location
		{
			get { return note5Location; }
			set { note5Location = value; }
		}

		[Description("Note5 Color")]
		[Category("Note5")]
        [Gui.Design.DisplayName("3. Color")]
        public Color Note5Color
        {
            get { return note5Color; }
            set { note5Color = value; }
        }
        [Browsable(false)]
        public string Note5ColorSerialize
        {
            get { return Gui.Design.SerializableColor.ToString(Note5Color); }
            set { Note5Color = Gui.Design.SerializableColor.FromString(value); }
        }		
		
		[XmlIgnore()]	//### Need this for font serialization, or will get error when saving as template
		[Description("Note5 Font")]
		[Category("Note5")]
        [Gui.Design.DisplayName("4. Font")]
		public Font Note5Font
		{
			get { return note5Font; }
			set { note5Font = value; }
		}
        [Browsable(false)]
        public string Note5FontSerialize
        {
            get { return Gui.Design.SerializableFont.ToString(Note5Font); }
            set { Note5Font = Gui.Design.SerializableFont.FromString(value); }
        }		
		
        [Description("Number of Lines to Show")]
		[Category("All")]
		[Gui.Design.DisplayName("8. Show Lines")]
        public int ShowLines
        {
            get { return showLines; }
            set { showLines = value; }
        }
		
	#endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ChartNotes[] cacheChartNotes = null;

        private static ChartNotes checkChartNotes = new ChartNotes();

        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        public ChartNotes ChartNotes()
        {
            return ChartNotes(Input);
        }

        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        public ChartNotes ChartNotes(Data.IDataSeries input)
        {
            if (cacheChartNotes != null)
                for (int idx = 0; idx < cacheChartNotes.Length; idx++)
                    if (cacheChartNotes[idx].EqualsInput(input))
                        return cacheChartNotes[idx];

            lock (checkChartNotes)
            {
                if (cacheChartNotes != null)
                    for (int idx = 0; idx < cacheChartNotes.Length; idx++)
                        if (cacheChartNotes[idx].EqualsInput(input))
                            return cacheChartNotes[idx];

                ChartNotes indicator = new ChartNotes();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                ChartNotes[] tmp = new ChartNotes[cacheChartNotes == null ? 1 : cacheChartNotes.Length + 1];
                if (cacheChartNotes != null)
                    cacheChartNotes.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheChartNotes = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChartNotes ChartNotes()
        {
            return _indicator.ChartNotes(Input);
        }

        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        public Indicator.ChartNotes ChartNotes(Data.IDataSeries input)
        {
            return _indicator.ChartNotes(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChartNotes ChartNotes()
        {
            return _indicator.ChartNotes(Input);
        }

        /// <summary>
        /// Write Notes on Charts
        /// </summary>
        /// <returns></returns>
        public Indicator.ChartNotes ChartNotes(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ChartNotes(input);
        }
    }
}
#endregion
