#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Draws color rectangles.....color,border,size are fully configurable
	///
    /// </summary>
    [Description("ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53")]
    public class ColorZone2 : Indicator
    {
        #region Variables
			private int opacity			= 3;
			//-----------------------------------------
			private double zone1a		= 1;
			private double zone1b		= 1;
			private Color zone1Clr 		= Color.LightCoral;
			private Color zone1ClrBdr	= Color.Red;
			private double zone2a		= 1;
			private double zone2b		= 1;
			private Color zone2Clr 		= Color.LightSkyBlue;
			private Color zone2ClrBdr	= Color.Blue;
			private double zone3a		= 1;
			private double zone3b		= 1;
			private Color zone3Clr 		= Color.LawnGreen;
			private Color zone3ClrBdr	= Color.LimeGreen;		
			private double zone4a		= 1;
			private double zone4b		= 1;
			private Color zone4Clr 		= Color.Yellow;
			private Color zone4ClrBdr	= Color.Gold;				
		
        // User defined variables (add any user defined variables below)
		
			private DataSeries myDataSeries1;
			private DataSeries myDataSeries2;
			private DataSeries myDataSeries3;
			private DataSeries myDataSeries4;
			private DataSeries myDataSeries5;
			private DataSeries myDataSeries6;
			private DataSeries myDataSeries7;
			private DataSeries myDataSeries8;

		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
        			
			myDataSeries1 = new DataSeries(this);
			myDataSeries2 = new DataSeries(this);
			myDataSeries3 = new DataSeries(this);
			myDataSeries4 = new DataSeries(this);			
			myDataSeries5 = new DataSeries(this);
			myDataSeries6 = new DataSeries(this);
			myDataSeries7 = new DataSeries(this);
			myDataSeries8 = new DataSeries(this);
		
		    
			
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= false;
			
						
        }
		

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			
			myDataSeries1.Set(zone1a);
			myDataSeries2.Set(zone1b);
			
			myDataSeries3.Set(zone2a);
			myDataSeries4.Set(zone2b);
			
			myDataSeries5.Set(zone3a);
			myDataSeries6.Set(zone3b);
			
			myDataSeries7.Set(zone4a);
			myDataSeries8.Set(zone4b);
			
		
			
			DrawRegion("Zone1", CurrentBar, 0, myDataSeries1, myDataSeries2, zone1ClrBdr, zone1Clr,opacity );			
			DrawRegion("Zone2", CurrentBar, 0, myDataSeries3, myDataSeries4, zone2ClrBdr, zone2Clr, opacity);
			DrawRegion("Zone3", CurrentBar, 0, myDataSeries5, myDataSeries6, zone3ClrBdr, zone3Clr, opacity);
			DrawRegion("Zone4", CurrentBar, 0, myDataSeries7, myDataSeries8, zone4ClrBdr, zone4Clr, opacity);
        }

        #region Properties
		[Description("Opacity level for zones....1=light   10= dark")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Opacity")]
		public int Opacity
        {
            get { return opacity; }
            set { opacity = Math.Max(1, value); }
        }
    //------------- Zone 1 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone1_a")]
		public double Zone1a
        {
            get { return zone1a; }
            set { zone1a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Plots")]
		[Gui.Design.DisplayName("Zone1_b")]
        public double Zone1b
        {
            get { return zone1b; }
            set { zone1b = Math.Max(1, value); }
        }
        [XmlIgnore()]
		[Description("Color for Zone 1")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone1 Color")]
	    public Color Zone1Clr
        {
            get { return zone1Clr; }
            set { zone1Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone1ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone1Clr);}
				    set {zone1Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("Color for Zone 1 Border")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone1 Color Border")]
	    public Color Zone1ClrBdr
        {
            get { return zone1ClrBdr; }
            set { zone1ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone1ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone1ClrBdr);}
				    set {zone1ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }       
    //------------- Zone 2 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone2_a")]
		public double Zone2a
        {
            get { return zone2a; }
            set { zone2a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Plots")]
		[Gui.Design.DisplayName("Zone2_b")]
        public double Zone2b
        {
            get { return zone2b; }
            set { zone2b = Math.Max(1, value); }
        }
        [XmlIgnore()]
		[Description("Color for Zone 2")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone2 Color")]
	    public Color Zone2Clr
        {
            get { return zone2Clr; }
            set { zone2Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone2ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone2Clr);}
				    set {zone2Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("Color for Zone 2 Border")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone2 Color Border")]
	    public Color Zone2ClrBdr
        {
            get { return zone2ClrBdr; }
            set { zone2ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone2ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone2ClrBdr);}
				    set {zone2ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }    
    //------------- Zone 3 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone3_a")]
		public double Zone3a
        {
            get { return zone3a; }
            set { zone3a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Plots")]
		[Gui.Design.DisplayName("Zone3_b")]
        public double Zone3b
        {
            get { return zone3b; }
            set { zone3b = Math.Max(1, value); }
        }
        [XmlIgnore()]
		[Description("Color for Zone 3")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone3 Color")]
	    public Color Zone3Clr
        {
            get { return zone3Clr; }
            set { zone3Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone3ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone3Clr);}
				    set {zone3Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("Color for Zone 3 Border")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone3 Color Border")]
	    public Color Zone3ClrBdr
        {
            get { return zone3ClrBdr; }
            set { zone3ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone3ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone3ClrBdr);}
				    set {zone3ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }       	
			
    //------------- Zone 4 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone4_a")]
		public double Zone4a
        {
            get { return zone4a; }
            set { zone4a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Plots")]
		[Gui.Design.DisplayName("Zone4_b")]
        public double Zone4b
        {
            get { return zone4b; }
            set { zone4b = Math.Max(1, value); }
        }
        [XmlIgnore()]
		[Description("Color for Zone 3")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone4 Color")]
	    public Color Zone4Clr
        {
            get { return zone4Clr; }
            set { zone4Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone4ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone4Clr);}
				    set {zone4Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("Color for Zone 3 Border")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone4 Color Border")]
	    public Color Zone4ClrBdr
        {
            get { return zone4ClrBdr; }
            set { zone4ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone4ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone4ClrBdr);}
				    set {zone4ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }       	
			
			
			
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ColorZone2[] cacheColorZone2 = null;

        private static ColorZone2 checkColorZone2 = new ColorZone2();

        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        public ColorZone2 ColorZone2()
        {
            return ColorZone2(Input);
        }

        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        public ColorZone2 ColorZone2(Data.IDataSeries input)
        {
            if (cacheColorZone2 != null)
                for (int idx = 0; idx < cacheColorZone2.Length; idx++)
                    if (cacheColorZone2[idx].EqualsInput(input))
                        return cacheColorZone2[idx];

            lock (checkColorZone2)
            {
                if (cacheColorZone2 != null)
                    for (int idx = 0; idx < cacheColorZone2.Length; idx++)
                        if (cacheColorZone2[idx].EqualsInput(input))
                            return cacheColorZone2[idx];

                ColorZone2 indicator = new ColorZone2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                ColorZone2[] tmp = new ColorZone2[cacheColorZone2 == null ? 1 : cacheColorZone2.Length + 1];
                if (cacheColorZone2 != null)
                    cacheColorZone2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheColorZone2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorZone2 ColorZone2()
        {
            return _indicator.ColorZone2(Input);
        }

        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorZone2 ColorZone2(Data.IDataSeries input)
        {
            return _indicator.ColorZone2(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorZone2 ColorZone2()
        {
            return _indicator.ColorZone2(Input);
        }

        /// <summary>
        /// ColorZone2  (Ver 1.1 ... 12-03-10) draws rectangles at desired levels, and allows changes to color, border, & size.    By photog53
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorZone2 ColorZone2(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ColorZone2(input);
        }
    }
}
#endregion
