#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.ComponentModel;
#endregion
	public enum BBPCTypeMA
	{
		SMA,
		EMA,
		WMA,
		HMA,
		DEMA,
		TMA,
		VMA,
		ZLEMA
	}

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
    /// </summary>
    [Description("This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.")]
    public class BollingerBandsPerCent : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int displace = 0; // Default setting for Displace
            private int length = 20; // Default setting for Length
            private double numDevDn = 2.000; // Default setting for NumDevDn
            private double numDevUp = 2.000; // Default setting for NumDevUp
			private BBPCTypeMA bollingerBandMA;
			private double maValue;
			private double stdDevValue;
		// User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.RoyalBlue), PlotStyle.Bar, "PercentB"));
            Add(new Line(Color.FromKnownColor(KnownColor.Gray), 0, "ZeroLine"));
            Add(new Line(Color.FromKnownColor(KnownColor.Gray), 50, "FiftyLine"));
            Add(new Line(Color.FromKnownColor(KnownColor.Gray), 100, "OneHundredLine"));
            Overlay				= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnStartUp()
		{
		}
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			
			switch (bollingerBandMA) 
			{
				case BBPCTypeMA.EMA:
					maValue    = EMA(length)[0];
					break;
				case BBPCTypeMA.HMA:
					maValue    = HMA(length)[0];
					break;
				case BBPCTypeMA.SMA:
					maValue    = SMA(length)[0];
					break;
				case BBPCTypeMA.WMA:
					maValue    = WMA(length)[0];
					break;
				case BBPCTypeMA.VMA:
					maValue    = VMA(length,length)[0];
					break;
				case BBPCTypeMA.DEMA:
					maValue    = DEMA(length)[0];
					break;
				case BBPCTypeMA.TMA:
					maValue    = TMA(length)[0];
					break;
				case BBPCTypeMA.ZLEMA:
					maValue    = ZLEMA(length)[0];
					break;
				default:
					break;
			}
			
			stdDevValue = StdDev(length)[0];
			double upperBand = maValue + numDevUp * stdDevValue;
			double lowerBand = maValue - numDevDn * stdDevValue;
            PercentB.Set((Input[displace] - lowerBand) / (upperBand - lowerBand) * 100);
//			Print(PercentB[0] + "-----" + upperBand + "-----" + lowerBand + "-----" + Input[0]);

			if(Rising(PercentB))
			{
				if(PercentB[0] > PercentB[Math.Min(CurrentBar,1)])  PlotColors[0][0] = Color.LimeGreen;
			}
			else if(Falling(PercentB))
			{
				if(PercentB[0] < PercentB[Math.Min(CurrentBar,1)])  PlotColors[0][0] = Color.Red;
			}
			else
				PlotColors[0][0] = Color.Gray;
}

        #region Properties
		[Description("The type of moving average the BB is derived from")]
        [GridCategory("Parameters")]
        public BBPCTypeMA BollingerBandMA
        {
            get { return bollingerBandMA; }
            set { bollingerBandMA = value; }
        }

		
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries PercentB
        {
            get { return Values[0]; }
        }

        [Description("The number of bars to displace the plot.")]
        [GridCategory("Parameters")]
        public int Displace
        {
            get { return displace; }
            set { displace = Math.Max(-10, value); }
        }

        [Description("BB moving average periods.")]
        [GridCategory("Parameters")]
        public int Length
        {
            get { return length; }
            set { length = Math.Max(1, value); }
        }

        [Description("Std Dev Down")]
        [GridCategory("Parameters")]
        public double NumDevDn
        {
            get { return numDevDn; }
            set { numDevDn = Math.Max(0.000, value); }
        }
        [Description("Std Dev Up")]
        [GridCategory("Parameters")]
        public double NumDevUp
        {
            get { return numDevUp; }
            set { numDevUp = Math.Max(0.000, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BollingerBandsPerCent[] cacheBollingerBandsPerCent = null;

        private static BollingerBandsPerCent checkBollingerBandsPerCent = new BollingerBandsPerCent();

        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        public BollingerBandsPerCent BollingerBandsPerCent(BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            return BollingerBandsPerCent(Input, bollingerBandMA, displace, length, numDevDn, numDevUp);
        }

        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        public BollingerBandsPerCent BollingerBandsPerCent(Data.IDataSeries input, BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            if (cacheBollingerBandsPerCent != null)
                for (int idx = 0; idx < cacheBollingerBandsPerCent.Length; idx++)
                    if (cacheBollingerBandsPerCent[idx].BollingerBandMA == bollingerBandMA && cacheBollingerBandsPerCent[idx].Displace == displace && cacheBollingerBandsPerCent[idx].Length == length && Math.Abs(cacheBollingerBandsPerCent[idx].NumDevDn - numDevDn) <= double.Epsilon && Math.Abs(cacheBollingerBandsPerCent[idx].NumDevUp - numDevUp) <= double.Epsilon && cacheBollingerBandsPerCent[idx].EqualsInput(input))
                        return cacheBollingerBandsPerCent[idx];

            lock (checkBollingerBandsPerCent)
            {
                checkBollingerBandsPerCent.BollingerBandMA = bollingerBandMA;
                bollingerBandMA = checkBollingerBandsPerCent.BollingerBandMA;
                checkBollingerBandsPerCent.Displace = displace;
                displace = checkBollingerBandsPerCent.Displace;
                checkBollingerBandsPerCent.Length = length;
                length = checkBollingerBandsPerCent.Length;
                checkBollingerBandsPerCent.NumDevDn = numDevDn;
                numDevDn = checkBollingerBandsPerCent.NumDevDn;
                checkBollingerBandsPerCent.NumDevUp = numDevUp;
                numDevUp = checkBollingerBandsPerCent.NumDevUp;

                if (cacheBollingerBandsPerCent != null)
                    for (int idx = 0; idx < cacheBollingerBandsPerCent.Length; idx++)
                        if (cacheBollingerBandsPerCent[idx].BollingerBandMA == bollingerBandMA && cacheBollingerBandsPerCent[idx].Displace == displace && cacheBollingerBandsPerCent[idx].Length == length && Math.Abs(cacheBollingerBandsPerCent[idx].NumDevDn - numDevDn) <= double.Epsilon && Math.Abs(cacheBollingerBandsPerCent[idx].NumDevUp - numDevUp) <= double.Epsilon && cacheBollingerBandsPerCent[idx].EqualsInput(input))
                            return cacheBollingerBandsPerCent[idx];

                BollingerBandsPerCent indicator = new BollingerBandsPerCent();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BollingerBandMA = bollingerBandMA;
                indicator.Displace = displace;
                indicator.Length = length;
                indicator.NumDevDn = numDevDn;
                indicator.NumDevUp = numDevUp;
                Indicators.Add(indicator);
                indicator.SetUp();

                BollingerBandsPerCent[] tmp = new BollingerBandsPerCent[cacheBollingerBandsPerCent == null ? 1 : cacheBollingerBandsPerCent.Length + 1];
                if (cacheBollingerBandsPerCent != null)
                    cacheBollingerBandsPerCent.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBollingerBandsPerCent = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BollingerBandsPerCent BollingerBandsPerCent(BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            return _indicator.BollingerBandsPerCent(Input, bollingerBandMA, displace, length, numDevDn, numDevUp);
        }

        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        public Indicator.BollingerBandsPerCent BollingerBandsPerCent(Data.IDataSeries input, BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            return _indicator.BollingerBandsPerCent(input, bollingerBandMA, displace, length, numDevDn, numDevUp);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BollingerBandsPerCent BollingerBandsPerCent(BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            return _indicator.BollingerBandsPerCent(Input, bollingerBandMA, displace, length, numDevDn, numDevUp);
        }

        /// <summary>
        /// This study plots the relative percentage that the price tracked has moved from the upper band to the lower band.
        /// </summary>
        /// <returns></returns>
        public Indicator.BollingerBandsPerCent BollingerBandsPerCent(Data.IDataSeries input, BBPCTypeMA bollingerBandMA, int displace, int length, double numDevDn, double numDevUp)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BollingerBandsPerCent(input, bollingerBandMA, displace, length, numDevDn, numDevUp);
        }
    }
}
#endregion
