#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. NT7 version uses one less dataseries.
    /// </summary>
    [Description("The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders")]
    public class HLCLines2 : Indicator //NT7 version
    {
        #region Variables
        private Color HighMark 	= Color.LightGreen;
		private Color LowMark 	= Color.Red;
		private	System.Drawing.Font		textFont;
		private	System.Drawing.Font		textFont1;
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Empty, 2), PlotStyle.Hash, "CloseMark"));//Plot0
			CalculateOnBarClose	= false;
            Overlay				= true;
			textFont = new Font("Wingdings 3",15);
			textFont1 = new Font("Webdings",10);
			
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            if(CurrentBar < 1) return;
			CloseMark.Set(Close[0]);
			if(Close[0] >= Open[0])
			//	PlotColors[0][0] = HighMark;
DrawLine("body"+CurrentBar, false, 1,Open[0],0,Open[0],HighMark,DashStyle.Solid, 2);
//DrawText(string tag, bool autoScale, string text, DateTime time, double y, int yPixelOffset, Color textColor, Font font, StringAlignment alignment, Color outlineColor, Color areaColor, int areaOpacity) 
//		DrawText("l1" + CurrentBar, true, "W", 0 , Open[0], 0, HighMark, 
//					textFont1, StringAlignment.Far, Color.Empty, Color.Empty, 5);
				
 			else
	//			PlotColors[0][0] = LowMark;
DrawLine("body"+CurrentBar, false,1,Open[0],0,Open[0],LowMark,DashStyle.Solid, 2);
				
        }

        #region Properties
        [Browsable(false)]
		[XmlIgnore()]
		public DataSeries CloseMark
		{
			get { return Values[0]; }
		}
		
		[Browsable(false)]
		public string HighMarkSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(HighMark); }
			set { HighMark = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Color of the High Close mark.")]
		[Category("Plots")]
		[Gui.Design.DisplayNameAttribute("High Close color")]
		public Color highMark
		{
			get { return HighMark; }
			set { HighMark = value; }
		}
		
		[Browsable(false)]
		public string LowMarkSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(LowMark); }
			set { LowMark = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Color of the Low Close mark.")]
		[Category("Plots")]
		[Gui.Design.DisplayNameAttribute("Low Close color")]
		public Color lowMark
		{
			get { return LowMark; }
			set { LowMark = value; }
		}
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private HLCLines2[] cacheHLCLines2 = null;

        private static HLCLines2 checkHLCLines2 = new HLCLines2();

        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        public HLCLines2 HLCLines2()
        {
            return HLCLines2(Input);
        }

        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        public HLCLines2 HLCLines2(Data.IDataSeries input)
        {
            if (cacheHLCLines2 != null)
                for (int idx = 0; idx < cacheHLCLines2.Length; idx++)
                    if (cacheHLCLines2[idx].EqualsInput(input))
                        return cacheHLCLines2[idx];

            lock (checkHLCLines2)
            {
                if (cacheHLCLines2 != null)
                    for (int idx = 0; idx < cacheHLCLines2.Length; idx++)
                        if (cacheHLCLines2[idx].EqualsInput(input))
                            return cacheHLCLines2[idx];

                HLCLines2 indicator = new HLCLines2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                HLCLines2[] tmp = new HLCLines2[cacheHLCLines2 == null ? 1 : cacheHLCLines2.Length + 1];
                if (cacheHLCLines2 != null)
                    cacheHLCLines2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheHLCLines2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HLCLines2 HLCLines2()
        {
            return _indicator.HLCLines2(Input);
        }

        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        public Indicator.HLCLines2 HLCLines2(Data.IDataSeries input)
        {
            return _indicator.HLCLines2(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HLCLines2 HLCLines2()
        {
            return _indicator.HLCLines2(Input);
        }

        /// <summary>
        /// The High-Low-Close Lines indicator plots a line at the close of the bar. Use with HiLo candle setting. Integrity-Traders
        /// </summary>
        /// <returns></returns>
        public Indicator.HLCLines2 HLCLines2(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.HLCLines2(input);
        }
    }
}
#endregion
