#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;              
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Draws Horizontal Line or Ray at current price
    /// </summary>
    [Description("Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53")]
    public class PriceLineWH : Indicator
    {
        #region Variables
        // Wizard generated variables
        	private Color	  lineColor = Color.Cyan;
			private int		  lineWidth = 2;
			private DashStyle lineStyle = DashStyle.Dot; 
			private bool useLine		= true; 
			private int rayLength		= 5;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			AutoScale			= false;
			 
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (rayLength > 20)
				rayLength = 20;
			
			if (useLine)
				DrawHorizontalLine("Currprice", false, Close[0], lineColor, lineStyle, lineWidth);
			else
				if (CurrentBar > 50)
					DrawRay("CurrRay", false, rayLength, Close[0], 0, Close[0], lineColor, lineStyle, lineWidth);
				
	    }

        #region Properties
		
		[Description("Use Line or Ray....True = Long Horizontal Line   ...  False = Short 'ray' with variable length")]
        [Category("Plots")]
		[Gui.Design.DisplayName ("1. Use Line or Ray")]
        public bool UseLine
        {
            get { return useLine; }
            set { useLine = value; }
        }

		
		[Description("LineStyle for Price Line")]
        [Category("Plots")]
		[Gui.Design.DisplayName ("2. Price Line Style")]
        public DashStyle LineStyle
        {
            get { return lineStyle; }
            set { lineStyle = value; }
        }
		 
	    [XmlIgnore()]
        [Description("Color of the Price Line")]
        [Category("Plots")]
		[Gui.Design.DisplayName ("3. Price Line Color")]
        public Color LineColor
        {
            get { return lineColor; }
            set { lineColor = value; }
        }
			[Browsable(false)]
			public string LineColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(lineColor); }//SerializableColor
				set { lineColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}	

			
    	[Description("Width of the Price Line")]
    	[Category("Plots")]
		[Gui.Design.DisplayName ("4. Price Line Width")]
        public int LineWidth
        {
            get { return lineWidth; }
			set { lineWidth = Math.Max(1, value); }
        }
		
     	[Description("Line length....(for Ray only)....# of bars from right edge  NOTE:  Only works if Use Line = false")]
    	[Category("Plots")]
		[Gui.Design.DisplayName ("5. Line Length for Ray")]
        public int RayLength
        {
            get { return rayLength; }
			set { rayLength = Math.Max(1, value); }
        }
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PriceLineWH[] cachePriceLineWH = null;

        private static PriceLineWH checkPriceLineWH = new PriceLineWH();

        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        public PriceLineWH PriceLineWH()
        {
            return PriceLineWH(Input);
        }

        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        public PriceLineWH PriceLineWH(Data.IDataSeries input)
        {
            if (cachePriceLineWH != null)
                for (int idx = 0; idx < cachePriceLineWH.Length; idx++)
                    if (cachePriceLineWH[idx].EqualsInput(input))
                        return cachePriceLineWH[idx];

            lock (checkPriceLineWH)
            {
                if (cachePriceLineWH != null)
                    for (int idx = 0; idx < cachePriceLineWH.Length; idx++)
                        if (cachePriceLineWH[idx].EqualsInput(input))
                            return cachePriceLineWH[idx];

                PriceLineWH indicator = new PriceLineWH();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                PriceLineWH[] tmp = new PriceLineWH[cachePriceLineWH == null ? 1 : cachePriceLineWH.Length + 1];
                if (cachePriceLineWH != null)
                    cachePriceLineWH.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePriceLineWH = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceLineWH PriceLineWH()
        {
            return _indicator.PriceLineWH(Input);
        }

        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceLineWH PriceLineWH(Data.IDataSeries input)
        {
            return _indicator.PriceLineWH(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceLineWH PriceLineWH()
        {
            return _indicator.PriceLineWH(Input);
        }

        /// <summary>
        /// Horizontal Line at Current Price....(Ver 2.1  12/02/2010 revised by Photog53
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceLineWH PriceLineWH(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PriceLineWH(input);
        }
    }
}
#endregion
