#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
	/// back-colors choosable areas in the pricechart via DrawRegion function
	/// Done by max-td - with help from NinjaTrader Support Forum - Ver. 01 - 09/13/2008
	///
    /// </summary>
    [Description("back-colors choosable areas in the pricechart")]
    public class ColoredZones01 : Indicator
    {
        #region Variables
        // Wizard generated variables
            private double level1a = 1; // Default setting for Level1a
            private double level1b = 1; // Default setting for Level1b
            private double level2a = 1; // Default setting for Level2a
            private double level2b = 1; // Default setting for Level2b
			private double level3a = 1; // Default setting for Level3a
            private double level3b = 1; // Default setting for Level3b		
		 	private double level4a = 1; // Default setting for Level1a
            private double level4b = 1; // Default setting for Level1b
            private double level5a = 1; // Default setting for Level2a
            private double level5b = 1; // Default setting for Level2b
			private double level6a = 1; // Default setting for Level3a
            private double level6b = 1; // Default setting for Level3b		
			private double level7a = 1; // Default setting for Level1a
            private double level7b = 1; // Default setting for Level1b
            private double level8a = 1; // Default setting for Level2a
            private double level8b = 1; // Default setting for Level2b
			private double level9a = 1; // Default setting for Level3a
            private double level9b = 1; // Default setting for Level3b		
		 	private double level10a = 1; // Default setting for Level1a
		 	private double level10b = 1; // Default setting for Level1a
		
		
        // User defined variables (add any user defined variables below)
		
			private DataSeries myDataSeries;
			private DataSeries myDataSeries2;
			private DataSeries myDataSeries3;
			private DataSeries myDataSeries4;
			private DataSeries myDataSeries5;
			private DataSeries myDataSeries6;		
			private DataSeries myDataSeries7;
			private DataSeries myDataSeries8;
			private DataSeries myDataSeries9;
			private DataSeries myDataSeries10;
			private DataSeries myDataSeries11;
			private DataSeries myDataSeries12;
			private DataSeries myDataSeries13;
			private DataSeries myDataSeries14;
			private DataSeries myDataSeries15;
			private DataSeries myDataSeries16;
			private DataSeries myDataSeries17;
			private DataSeries myDataSeries18;		
			private DataSeries myDataSeries19;
			private DataSeries myDataSeries20;
		
		
		        
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
        			
			myDataSeries = new DataSeries(this);
			myDataSeries2 = new DataSeries(this);
			myDataSeries3 = new DataSeries(this);
			myDataSeries4 = new DataSeries(this);			
			myDataSeries5 = new DataSeries(this);
			myDataSeries6 = new DataSeries(this);
			myDataSeries7 = new DataSeries(this);
			myDataSeries8 = new DataSeries(this);			
			myDataSeries9 = new DataSeries(this);
			myDataSeries10 = new DataSeries(this);
			myDataSeries11 = new DataSeries(this);
			myDataSeries12 = new DataSeries(this);
			myDataSeries13 = new DataSeries(this);
			myDataSeries14 = new DataSeries(this);
			myDataSeries15 = new DataSeries(this);
			myDataSeries16 = new DataSeries(this);					
			myDataSeries17 = new DataSeries(this);
			myDataSeries18 = new DataSeries(this);
			myDataSeries19 = new DataSeries(this);
			myDataSeries20 = new DataSeries(this);	
			
			
		    
			
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= false;
			
						
        }
		

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			
			myDataSeries.Set(level1a);
			myDataSeries2.Set(level1b);
			
			myDataSeries3.Set(level2a);
			myDataSeries4.Set(level2b);
			
			myDataSeries5.Set(level3a);
			myDataSeries6.Set(level3b);
			
			myDataSeries7.Set(level4a);
			myDataSeries8.Set(level4b);
			
			myDataSeries9.Set(level5a);
			myDataSeries10.Set(level5b);
			
			myDataSeries11.Set(level6a);
			myDataSeries12.Set(level6b);
			
			myDataSeries13.Set(level7a);
			myDataSeries14.Set(level7b);
			
			myDataSeries15.Set(level8a);
			myDataSeries16.Set(level8b);
			
			myDataSeries17.Set(level9a);
			myDataSeries18.Set(level9b);
			
			myDataSeries19.Set(level10a);
			myDataSeries20.Set(level10b);
			
			
			
			DrawRegion("Zone1", CurrentBar, 0, myDataSeries, myDataSeries2, Color.Empty, Color.DarkGray, 5 );			
			DrawRegion("Zone2", CurrentBar, 0, myDataSeries3, myDataSeries4, Color.Empty, Color.DarkGray, 5);
						
			DrawRegion("Zone3", CurrentBar, 0, myDataSeries5, myDataSeries6, Color.Empty, Color.DarkGray, 5);
						
			//DrawRegion("Zone3", CurrentBar, 0, myDataSeries5, myDataSeries6, Color.FromKnownColor(5),Color.FromKnownColor(5),5); 		
						
			DrawRegion("Zone4", CurrentBar, 0, myDataSeries7, myDataSeries8, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone5", CurrentBar, 0, myDataSeries9, myDataSeries10, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone6", CurrentBar, 0, myDataSeries11, myDataSeries12, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone7", CurrentBar, 0, myDataSeries13, myDataSeries14, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone8", CurrentBar, 0, myDataSeries15, myDataSeries16, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone9", CurrentBar, 0, myDataSeries17, myDataSeries18, Color.Empty, Color.DarkGray, 5);			
			DrawRegion("Zone10", CurrentBar, 0, myDataSeries19, myDataSeries20, Color.Empty, Color.DarkGray, 5);
			//PlotsConfigurable = true;
			//DrawRegion("test", CurrentBar, 0, myDataSeries7, myDataSeries8, Color.Black, Color.Blue, 2);

			
			
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
        }

        #region Properties

        [Description("")]
        [Category("Parameters")]
        public double Zone1a
        {
            get { return level1a; }
            set { level1a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone1b
        {
            get { return level1b; }
            set { level1b = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone2a
        {
            get { return level2a; }
            set { level2a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone2b
        {
            get { return level2b; }
            set { level2b = Math.Max(1, value); }
        }
		
		
		 [Description("")]
        [Category("Parameters")]
        public double Zone3a
        {
            get { return level3a; }
            set { level3a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone3b
        {
            get { return level3b; }
            set { level3b = Math.Max(1, value); }
        }
		
		
		   [Description("")]
        [Category("Parameters")]
        public double Zone4a
        {
            get { return level4a; }
            set { level4a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone4b
        {
            get { return level4b; }
            set { level4b = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone5a
        {
            get { return level5a; }
            set { level5a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone5b
        {
            get { return level5b; }
            set { level5b = Math.Max(1, value); }
        }
		
		
		 [Description("")]
        [Category("Parameters")]
        public double Zone6a
        {
            get { return level6a; }
            set { level6a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone6b
        {
            get { return level6b; }
            set { level6b = Math.Max(1, value); }
		}
      
		 [Description("")]
        [Category("Parameters")]
        public double Zone7a
        {
            get { return level7a; }
            set { level7a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone7b
        {
            get { return level7b; }
            set { level7b = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone8a
        {
            get { return level8a; }
            set { level8a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone8b
        {
            get { return level8b; }
            set { level8b = Math.Max(1, value); }
        }
		
		
		 [Description("")]
        [Category("Parameters")]
        public double Zone9a
        {
            get { return level9a; }
            set { level9a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone9b
        {
            get { return level9b; }
            set { level9b = Math.Max(1, value); }
        }
		
		
		   [Description("")]
        [Category("Parameters")]
        public double Zone10a
        {
            get { return level10a; }
            set { level10a = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public double Zone10b
        {
            get { return level10b; }
            set { level10b = Math.Max(1, value); }
		}		
		
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ColoredZones01[] cacheColoredZones01 = null;

        private static ColoredZones01 checkColoredZones01 = new ColoredZones01();

        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        public ColoredZones01 ColoredZones01(double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            return ColoredZones01(Input, zone10a, zone10b, zone1a, zone1b, zone2a, zone2b, zone3a, zone3b, zone4a, zone4b, zone5a, zone5b, zone6a, zone6b, zone7a, zone7b, zone8a, zone8b, zone9a, zone9b);
        }

        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        public ColoredZones01 ColoredZones01(Data.IDataSeries input, double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            checkColoredZones01.Zone10a = zone10a;
            zone10a = checkColoredZones01.Zone10a;
            checkColoredZones01.Zone10b = zone10b;
            zone10b = checkColoredZones01.Zone10b;
            checkColoredZones01.Zone1a = zone1a;
            zone1a = checkColoredZones01.Zone1a;
            checkColoredZones01.Zone1b = zone1b;
            zone1b = checkColoredZones01.Zone1b;
            checkColoredZones01.Zone2a = zone2a;
            zone2a = checkColoredZones01.Zone2a;
            checkColoredZones01.Zone2b = zone2b;
            zone2b = checkColoredZones01.Zone2b;
            checkColoredZones01.Zone3a = zone3a;
            zone3a = checkColoredZones01.Zone3a;
            checkColoredZones01.Zone3b = zone3b;
            zone3b = checkColoredZones01.Zone3b;
            checkColoredZones01.Zone4a = zone4a;
            zone4a = checkColoredZones01.Zone4a;
            checkColoredZones01.Zone4b = zone4b;
            zone4b = checkColoredZones01.Zone4b;
            checkColoredZones01.Zone5a = zone5a;
            zone5a = checkColoredZones01.Zone5a;
            checkColoredZones01.Zone5b = zone5b;
            zone5b = checkColoredZones01.Zone5b;
            checkColoredZones01.Zone6a = zone6a;
            zone6a = checkColoredZones01.Zone6a;
            checkColoredZones01.Zone6b = zone6b;
            zone6b = checkColoredZones01.Zone6b;
            checkColoredZones01.Zone7a = zone7a;
            zone7a = checkColoredZones01.Zone7a;
            checkColoredZones01.Zone7b = zone7b;
            zone7b = checkColoredZones01.Zone7b;
            checkColoredZones01.Zone8a = zone8a;
            zone8a = checkColoredZones01.Zone8a;
            checkColoredZones01.Zone8b = zone8b;
            zone8b = checkColoredZones01.Zone8b;
            checkColoredZones01.Zone9a = zone9a;
            zone9a = checkColoredZones01.Zone9a;
            checkColoredZones01.Zone9b = zone9b;
            zone9b = checkColoredZones01.Zone9b;

            if (cacheColoredZones01 != null)
                for (int idx = 0; idx < cacheColoredZones01.Length; idx++)
                    if (Math.Abs(cacheColoredZones01[idx].Zone10a - zone10a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone10b - zone10b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone1a - zone1a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone1b - zone1b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone2a - zone2a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone2b - zone2b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone3a - zone3a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone3b - zone3b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone4a - zone4a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone4b - zone4b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone5a - zone5a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone5b - zone5b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone6a - zone6a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone6b - zone6b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone7a - zone7a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone7b - zone7b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone8a - zone8a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone8b - zone8b) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone9a - zone9a) <= double.Epsilon && Math.Abs(cacheColoredZones01[idx].Zone9b - zone9b) <= double.Epsilon && cacheColoredZones01[idx].EqualsInput(input))
                        return cacheColoredZones01[idx];

            ColoredZones01 indicator = new ColoredZones01();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Zone10a = zone10a;
            indicator.Zone10b = zone10b;
            indicator.Zone1a = zone1a;
            indicator.Zone1b = zone1b;
            indicator.Zone2a = zone2a;
            indicator.Zone2b = zone2b;
            indicator.Zone3a = zone3a;
            indicator.Zone3b = zone3b;
            indicator.Zone4a = zone4a;
            indicator.Zone4b = zone4b;
            indicator.Zone5a = zone5a;
            indicator.Zone5b = zone5b;
            indicator.Zone6a = zone6a;
            indicator.Zone6b = zone6b;
            indicator.Zone7a = zone7a;
            indicator.Zone7b = zone7b;
            indicator.Zone8a = zone8a;
            indicator.Zone8b = zone8b;
            indicator.Zone9a = zone9a;
            indicator.Zone9b = zone9b;
            indicator.SetUp();

            ColoredZones01[] tmp = new ColoredZones01[cacheColoredZones01 == null ? 1 : cacheColoredZones01.Length + 1];
            if (cacheColoredZones01 != null)
                cacheColoredZones01.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheColoredZones01 = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColoredZones01 ColoredZones01(double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            return _indicator.ColoredZones01(Input, zone10a, zone10b, zone1a, zone1b, zone2a, zone2b, zone3a, zone3b, zone4a, zone4b, zone5a, zone5b, zone6a, zone6b, zone7a, zone7b, zone8a, zone8b, zone9a, zone9b);
        }

        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        public Indicator.ColoredZones01 ColoredZones01(Data.IDataSeries input, double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            return _indicator.ColoredZones01(input, zone10a, zone10b, zone1a, zone1b, zone2a, zone2b, zone3a, zone3b, zone4a, zone4b, zone5a, zone5b, zone6a, zone6b, zone7a, zone7b, zone8a, zone8b, zone9a, zone9b);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColoredZones01 ColoredZones01(double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            return _indicator.ColoredZones01(Input, zone10a, zone10b, zone1a, zone1b, zone2a, zone2b, zone3a, zone3b, zone4a, zone4b, zone5a, zone5b, zone6a, zone6b, zone7a, zone7b, zone8a, zone8b, zone9a, zone9b);
        }

        /// <summary>
        /// back-colors choosable areas in the pricechart
        /// </summary>
        /// <returns></returns>
        public Indicator.ColoredZones01 ColoredZones01(Data.IDataSeries input, double zone10a, double zone10b, double zone1a, double zone1b, double zone2a, double zone2b, double zone3a, double zone3b, double zone4a, double zone4b, double zone5a, double zone5b, double zone6a, double zone6b, double zone7a, double zone7b, double zone8a, double zone8b, double zone9a, double zone9b)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ColoredZones01(input, zone10a, zone10b, zone1a, zone1b, zone2a, zone2b, zone3a, zone3b, zone4a, zone4b, zone5a, zone5b, zone6a, zone6b, zone7a, zone7b, zone8a, zone8b, zone9a, zone9b);
        }

    }
}
#endregion
