// 
// Copyright (C) 2008, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Zero-Lagging Heiken-Ashi TEMA
    /// </summary>
    [Description("Zero-Lagging Heiken-Ashi TEMA")]
    public class ZeroLagTEMAandHATEMA : Indicator
    {
        #region Variables
		private int zLHATEMAperiod = 14; // Default setting for Period
		private int zLTEMAperiod = 14; // Default setting for Period
		private DataSeries haC;
		private DataSeries haO;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Black, 2), PlotStyle.Line, "Zero-Lagging Heiken-Ashi TEMA"));
			Add(new Plot(new Pen(Color.White, 2), PlotStyle.Line, "Zero-Lagging TEMA"));
			
			haC = new DataSeries(this);
			haO = new DataSeries(this);
			
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar == 0)
			{
				haC.Set(0);
				haO.Set(0);
				return;
			}
			
			if (CurrentBar < 1)
				return;
			
			haO.Set((((Open[1] + High[1] + Low[1] + Close[1]) / 4) + haO[1]) / 2);
			haC.Set((((Open[0] + High[0] + Low[0] + Close[0]) / 4) + haO[0] + Math.Max(High[0], haO[0]) + Math.Min(Low[0], haO[0])) / 4);
			
			double TEMA1 = TEMA(haC, zLHATEMAperiod)[0];
			double TEMA2 = TEMA(TEMA(haC, zLHATEMAperiod), zLHATEMAperiod)[0];
            ZeroHATEMA.Set(TEMA1 + (TEMA1 - TEMA2));
			
			double TEMA3 = TEMA(Input, zLTEMAperiod)[0];
			double TEMA4 = TEMA(TEMA(Input, zLTEMAperiod), zLTEMAperiod)[0];
            ZeroTEMA.Set(TEMA3 + (TEMA3 - TEMA4));
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ZeroHATEMA
        {
            get { return Values[0]; }
        }
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ZeroTEMA
        {
            get { return Values[1]; }
        }

        [Description("Numbers of bars used for ZeroLagTEMAandHATEMA calculations")]
        [Category("Parameters")]
        public int ZLHATEMAperiod
        {
            get { return zLHATEMAperiod; }
            set { zLHATEMAperiod = Math.Max(1, value); }
        }
		
		[Description("Numbers of bars used for ZeroLagTEMA calculations")]
        [Category("Parameters")]
        public int ZLTEMAperiod
        {
            get { return zLTEMAperiod; }
            set { zLTEMAperiod = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ZeroLagTEMAandHATEMA[] cacheZeroLagTEMAandHATEMA = null;

        private static ZeroLagTEMAandHATEMA checkZeroLagTEMAandHATEMA = new ZeroLagTEMAandHATEMA();

        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        public ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(int zLHATEMAperiod, int zLTEMAperiod)
        {
            return ZeroLagTEMAandHATEMA(Input, zLHATEMAperiod, zLTEMAperiod);
        }

        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        public ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(Data.IDataSeries input, int zLHATEMAperiod, int zLTEMAperiod)
        {
            checkZeroLagTEMAandHATEMA.ZLHATEMAperiod = zLHATEMAperiod;
            zLHATEMAperiod = checkZeroLagTEMAandHATEMA.ZLHATEMAperiod;
            checkZeroLagTEMAandHATEMA.ZLTEMAperiod = zLTEMAperiod;
            zLTEMAperiod = checkZeroLagTEMAandHATEMA.ZLTEMAperiod;

            if (cacheZeroLagTEMAandHATEMA != null)
                for (int idx = 0; idx < cacheZeroLagTEMAandHATEMA.Length; idx++)
                    if (cacheZeroLagTEMAandHATEMA[idx].ZLHATEMAperiod == zLHATEMAperiod && cacheZeroLagTEMAandHATEMA[idx].ZLTEMAperiod == zLTEMAperiod && cacheZeroLagTEMAandHATEMA[idx].EqualsInput(input))
                        return cacheZeroLagTEMAandHATEMA[idx];

            ZeroLagTEMAandHATEMA indicator = new ZeroLagTEMAandHATEMA();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.ZLHATEMAperiod = zLHATEMAperiod;
            indicator.ZLTEMAperiod = zLTEMAperiod;
            indicator.SetUp();

            ZeroLagTEMAandHATEMA[] tmp = new ZeroLagTEMAandHATEMA[cacheZeroLagTEMAandHATEMA == null ? 1 : cacheZeroLagTEMAandHATEMA.Length + 1];
            if (cacheZeroLagTEMAandHATEMA != null)
                cacheZeroLagTEMAandHATEMA.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheZeroLagTEMAandHATEMA = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(int zLHATEMAperiod, int zLTEMAperiod)
        {
            return _indicator.ZeroLagTEMAandHATEMA(Input, zLHATEMAperiod, zLTEMAperiod);
        }

        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        public Indicator.ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(Data.IDataSeries input, int zLHATEMAperiod, int zLTEMAperiod)
        {
            return _indicator.ZeroLagTEMAandHATEMA(input, zLHATEMAperiod, zLTEMAperiod);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(int zLHATEMAperiod, int zLTEMAperiod)
        {
            return _indicator.ZeroLagTEMAandHATEMA(Input, zLHATEMAperiod, zLTEMAperiod);
        }

        /// <summary>
        /// Zero-Lagging Heiken-Ashi TEMA
        /// </summary>
        /// <returns></returns>
        public Indicator.ZeroLagTEMAandHATEMA ZeroLagTEMAandHATEMA(Data.IDataSeries input, int zLHATEMAperiod, int zLTEMAperiod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ZeroLagTEMAandHATEMA(input, zLHATEMAperiod, zLTEMAperiod);
        }

    }
}
#endregion
