#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Stocks and Commmodities - May 2011 - In The Volume Zone")]
    public class VolumeZoneOscillator : Indicator
    {
        #region Variables
            private int 		period = 14; // Default setting for Period input
			private DataSeries 	R;
			private double 		VP;
			private double 		TV;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Black), PlotStyle.Line, "VZO"));
			Add(new Line(Color.FromKnownColor(KnownColor.LightSalmon), 60, "Line1"));
			Add(new Line(Color.FromKnownColor(KnownColor.LightSalmon), 40, "Line2"));
			Add(new Line(Color.FromKnownColor(KnownColor.LightSalmon), 15, "Line3"));
            Add(new Line(Color.FromKnownColor(KnownColor.Black), 0, "Line4"));
            Add(new Line(Color.FromKnownColor(KnownColor.LightGreen), -5, "Line5"));
			Add(new Line(Color.FromKnownColor(KnownColor.LightGreen), -40, "Line6"));
			Add(new Line(Color.FromKnownColor(KnownColor.LightGreen), -60, "Line7"));
                        
            Overlay				= false;
			R 					= new DataSeries (this);
			Plots[0].Pen.Width = 2;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            if (CurrentBar < 1) 
				return;
		
			R.Set(Close[0] > Close[1] ? Volume[0] : Volume[0] * -1);
			VP = EMA(R, Period)[0];
			TV = EMA(Volume, Period)[0];
			VZO.Set(100 * (VP / TV));	
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries VZO
        {
            get { return Values[0]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private VolumeZoneOscillator[] cacheVolumeZoneOscillator = null;

        private static VolumeZoneOscillator checkVolumeZoneOscillator = new VolumeZoneOscillator();

        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        public VolumeZoneOscillator VolumeZoneOscillator(int period)
        {
            return VolumeZoneOscillator(Input, period);
        }

        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        public VolumeZoneOscillator VolumeZoneOscillator(Data.IDataSeries input, int period)
        {
            if (cacheVolumeZoneOscillator != null)
                for (int idx = 0; idx < cacheVolumeZoneOscillator.Length; idx++)
                    if (cacheVolumeZoneOscillator[idx].Period == period && cacheVolumeZoneOscillator[idx].EqualsInput(input))
                        return cacheVolumeZoneOscillator[idx];

            lock (checkVolumeZoneOscillator)
            {
                checkVolumeZoneOscillator.Period = period;
                period = checkVolumeZoneOscillator.Period;

                if (cacheVolumeZoneOscillator != null)
                    for (int idx = 0; idx < cacheVolumeZoneOscillator.Length; idx++)
                        if (cacheVolumeZoneOscillator[idx].Period == period && cacheVolumeZoneOscillator[idx].EqualsInput(input))
                            return cacheVolumeZoneOscillator[idx];

                VolumeZoneOscillator indicator = new VolumeZoneOscillator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                VolumeZoneOscillator[] tmp = new VolumeZoneOscillator[cacheVolumeZoneOscillator == null ? 1 : cacheVolumeZoneOscillator.Length + 1];
                if (cacheVolumeZoneOscillator != null)
                    cacheVolumeZoneOscillator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheVolumeZoneOscillator = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeZoneOscillator VolumeZoneOscillator(int period)
        {
            return _indicator.VolumeZoneOscillator(Input, period);
        }

        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeZoneOscillator VolumeZoneOscillator(Data.IDataSeries input, int period)
        {
            return _indicator.VolumeZoneOscillator(input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeZoneOscillator VolumeZoneOscillator(int period)
        {
            return _indicator.VolumeZoneOscillator(Input, period);
        }

        /// <summary>
        /// Stocks and Commmodities - May 2011 - In The Volume Zone
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeZoneOscillator VolumeZoneOscillator(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VolumeZoneOscillator(input, period);
        }
    }
}
#endregion
