//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private COTReport[] cacheCOTReport = null;

        private static COTReport checkCOTReport = new COTReport();

        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        public COTReport COTReport()
        {
            return COTReport(Input);
        }

        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        public COTReport COTReport(Data.IDataSeries input)
        {

            if (cacheCOTReport != null)
                for (int idx = 0; idx < cacheCOTReport.Length; idx++)
                    if (cacheCOTReport[idx].EqualsInput(input))
                        return cacheCOTReport[idx];

            COTReport indicator = new COTReport();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.SetUp();

            COTReport[] tmp = new COTReport[cacheCOTReport == null ? 1 : cacheCOTReport.Length + 1];
            if (cacheCOTReport != null)
                cacheCOTReport.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheCOTReport = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.COTReport COTReport()
        {
            return _indicator.COTReport(Input);
        }

        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        public Indicator.COTReport COTReport(Data.IDataSeries input)
        {
            return _indicator.COTReport(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.COTReport COTReport()
        {
            return _indicator.COTReport(Input);
        }

        /// <summary>
        /// CFTC Commitments of Traders
        /// </summary>
        /// <returns></returns>
        public Indicator.COTReport COTReport(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.COTReport(input);
        }

    }
}
#endregion
