// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
// I started off with the HeikenAshi indicator as the template to build this indicator.

// MQ4 version "Copyright © 2006, Forex-TSD.com " "http://www.forex-tsd.com/"

//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
	/// HeikenAshiSmoothed in MQL4 translated to NT
	/// Extended drawing options added by Elliott Wave 03/03/09
    /// </summary>
    [Description("HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript")]
	public class HeikenAshiSmoothed : Indicator
    {
        #region Variables
		// user parmaters variables
		private Color	barColorUp 		= Color.RoyalBlue;
		private Color	barColorDown 	= Color.OrangeRed;
		private Color	saveDownColor	= Color.Empty;
		private Pen		savePen			= null;
		private Color	saveUpColor		= Color.Empty;
		private Color	shadowColor 	= Color.Black;
		private int		shadowWidth		= 2;
		private HAMA	matype1	= HAMA.SMA;
		private int				period1	= 1;
		private HAMA	matype2	= HAMA.SMMA;
		private int				period2	= 2;
		private double			amp = 0.7;
		// internal variables
		private double maOpen = 0.00;
		private double maClose =  0.00;
		private double maLow = 0.00;
		private double maHigh = 0.00;
		private double haOpen = 0.00;
		private double haClose =  0.00;
		private double haLow = 0.00;
		private double haHigh = 0.00;
		private DataSeries ExtMapBuffer5;	//haopen
		private DataSeries ExtMapBuffer6;	//haclose
		private DataSeries ExtMapBuffer7;	//hahigh or halow
		private DataSeries ExtMapBuffer8;	//hahigh or halow
		
		private bool hidePrice = true;
		private bool drawHACandles = true;
		private bool colorBars = true;
		private int barType = 1; // 1 for HeikenAshi 2 for regular.
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			Add(new Plot(Color.Transparent, PlotStyle.Line, "HAOpen"));
			Add(new Plot(Color.Transparent, PlotStyle.Line, "HAHigh"));
			Add(new Plot(Color.Transparent, PlotStyle.Line, "HALow"));
			Add(new Plot(Color.Transparent, PlotStyle.Line, "HAClose"));

			//ChartOnly			= true;
			PlotsConfigurable 	= false;
			//PaintPriceMarkers 	= false;
			Overlay				= true;
			
			ExtMapBuffer5 = new DataSeries(this);
			ExtMapBuffer6 = new DataSeries(this);
			ExtMapBuffer7 = new DataSeries(this);
			ExtMapBuffer8 = new DataSeries(this);
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {			
			if (ChartControl != null && saveDownColor == Color.Empty && ChartControl.ChartStyle.DownColor != Color.Transparent)
			{
				saveDownColor	= ChartControl.ChartStyle.DownColor;
				saveUpColor		= ChartControl.ChartStyle.UpColor;
				savePen			= ChartControl.ChartStyle.Pen;
			}
			// Calculate MA type 1 using period1
			switch (matype1)
			{
			// If the matype is defined as an EMA then...					
			case HAMA.EMA:
			{
			// Sets the plot to be equal to the EMA's plot
					maOpen = EMA(Open,Period1)[0];
					maClose = EMA(Close,Period1)[0];
					maHigh = EMA(High,Period1)[0];
					maLow = EMA(Low,Period1)[0];
					break;
				}
				
				// If the matype is defined as a HMA then...
				case HAMA.HMA:
				{
					// Sets the plot to be equal to the HMA's plot

					maOpen = HMA(Open,Period1)[0];
					maClose = HMA(Close,Period1)[0];
					maHigh = HMA(High,Period1)[0];
					maLow = HMA(Low,Period1)[0];
					break;
				}
				
				// If the matype is defined as a SMA then...
				case HAMA.SMA:
				{
					// Sets the plot to be equal to the SMA's plot

					maOpen = SMA(Open,Period1)[0];
					maClose = SMA(Close,Period1)[0];
					maHigh = SMA(High,Period1)[0];
					maLow = SMA(Low,Period1)[0];
					break;
				}
				
				// If the matype is defined as a WMA then...
				case HAMA.WMA:
				{
					// Sets the plot to be equal to the WMA's plot

					maOpen = WMA(Open,Period1)[0];
					maClose = WMA(Close,Period1)[0];
					maHigh = WMA(High,Period1)[0];
					maLow = WMA(Low,Period1)[0];					
					break;
				}
				// If the matype is defined as a T3 then...
				case HAMA.T3:
				{
					// Sets the plot to be equal to the T3's plot

					maOpen = T3(Open,amp,Period1)[0];
					maClose = T3(Close,amp,Period1)[0];
					maHigh = T3(High,amp,Period1)[0];
					maLow = T3(Low,amp,Period1)[0];					
					break;
				}
				// If the matype is defined as a ADXVMA then...
				case HAMA.ADXVMA:
				{
					// Sets the plot to be equal to the ADXVMA's plot
					maOpen = ADXVMA(Open,Period1)[0];
					maClose = ADXVMA(Close,Period1)[0];
					maHigh = ADXVMA(High,Period1)[0];
					maLow = ADXVMA(Low,Period1)[0];					
					break;
				}
				// If the matype is defined as a ZeroLagEMA then...
				case HAMA.ZLEMA:
				{
					// Sets the plot to be equal to the ZeroLagEMA's plot

					maOpen = ZeroLagEMA(Open,Period1)[0];
					maClose = ZeroLagEMA(Close,Period1)[0];
					maHigh = ZeroLagEMA(High,Period1)[0];
					maLow = ZeroLagEMA(Low,Period1)[0];						
					break;
				}
				// If the matype is defined as a ZeroLagTEMA then...
				case HAMA.ZLTEMA:
				{
					// Sets the plot to be equal to the ZeroLagTEMA's plot

					maOpen = ZeroLagTEMA(Open,Period1)[0];
					maClose = ZeroLagTEMA(Close,Period1)[0];
					maHigh = ZeroLagTEMA(High,Period1)[0];
					maLow = ZeroLagTEMA(Low,Period1)[0];							
					break;
				}
				// If the matype is defined as a Triangular Moving Average  then...
				case HAMA.TMA:
				{
					// Sets the plot to be equal to the Triangular Moving Average's plot
					maOpen = TMA(Open,Period1)[0];
					maClose = TMA(Close,Period1)[0];
					maHigh = TMA(High,Period1)[0];
					maLow = TMA(Low,Period1)[0];						
					break;
				}
				// If the matype is defined as a Triple Exponential Moving Average  then...
				case HAMA.TEMA:
				{
					// Sets the plot to be equal to the Triple Exponential Moving Averagr's plot
					maOpen = TEMA(Open,Period1)[0];
					maClose = TEMA(Close,Period1)[0];
					maHigh = TEMA(High,Period1)[0];
					maLow = TEMA(Low,Period1)[0];	
					break;
				}	
				// If the matype is defined as a Ehler's Filter   then...
				case HAMA.EhlersFilter:
				{
					// Sets the plot to be equal to the Ehler's Filter plot
					maOpen = EhlersFilter(Open,Period1)[0];
					maClose = EhlersFilter(Close,Period1)[0];
					maHigh = EhlersFilter(High,Period1)[0];
					maLow = EhlersFilter(Low,Period1)[0];	
					break;
				}	
				// If the matype is defined as a SMMA   then...
				case HAMA.SMMA:
				{
					// Sets the plot to be equal to the SMMA plot

					maOpen = SMMA(Open,Period1)[0];
					maClose = SMMA(Close,Period1)[0];
					maHigh = SMMA(High,Period1)[0];
					maLow = SMMA(Low,Period1)[0];						
					break;
				}	
			}	//end of switch
			if (CurrentBar == 0)
			{
				Values[0].Set(0);
				Values[1].Set(0);
				Values[2].Set(0);
				Values[3].Set(0);
				
				ExtMapBuffer5.Set(Open[0]);
				ExtMapBuffer6.Set(Close[0]);
				ExtMapBuffer7.Set(High[0]);
				ExtMapBuffer8.Set(Low[0]);
				return;
			}
			
			haClose = (maOpen + maHigh + maLow + maClose) / 4; // Calculate the close
			haOpen = (ExtMapBuffer5[1] + ExtMapBuffer6[1]) / 2; // Calculate the open
			haHigh = Math.Max( maHigh, Math.Max(haOpen, haClose)); // Calculate the high
			haLow = Math.Min( maLow, Math.Min(haOpen, haClose)); // Calculate the low
			
			if (haOpen < haClose)
			{
				ExtMapBuffer7.Set(haLow);
				ExtMapBuffer8.Set(haHigh);
			}
			else
			{
				ExtMapBuffer7.Set(haHigh);
				ExtMapBuffer8.Set(haLow);
			}
			ExtMapBuffer5.Set(haOpen);
			ExtMapBuffer6.Set(haClose);

			// Calculate MA type 2 using period2
			switch (matype2)
			{
			// If the matype is defined as an EMA then...					
			case HAMA.EMA:
			{
			// Sets the plot to be equal to the EMA's plot
					Values[0].Set( EMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( EMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( EMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( EMA(ExtMapBuffer8,Period2)[0] );
					break;
				}
				
				// If the matype is defined as a HMA then...
				case HAMA.HMA:
				{
					// Sets the plot to be equal to the HMA's plot

					Values[0].Set( HMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( HMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( HMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( HMA(ExtMapBuffer8,Period2)[0] );
					break;
				}
				
//				// If the matype is defined as a JMA then...
//				case HAMA.JMA:
//				{
//					// Sets the plot to be equal to the JMA's plot
//
//					Values[0].Set( JMAq(ExtMapBuffer5,50,Period2)[0] );
//					Values[3].Set( JMAq(ExtMapBuffer6,50,Period2)[0] );
//					Values[1].Set( JMAq(ExtMapBuffer7,50,Period2)[0] );
//					Values[2].Set( JMAq(ExtMapBuffer8,50,Period2)[0] );
//					break;
//				}
				
				// If the matype is defined as a SMA then...
				case HAMA.SMA:
				{
					// Sets the plot to be equal to the SMA's plot

					Values[0].Set( SMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( SMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( SMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( SMA(ExtMapBuffer8,Period2)[0] );
					break;
				}
				
				// If the matype is defined as a WMA then...
				case HAMA.WMA:
				{
					// Sets the plot to be equal to the WMA's plot

					Values[0].Set( WMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( WMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( WMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( WMA(ExtMapBuffer8,Period2)[0] );					
					break;
				}
				// If the matype is defined as a T3 then...
				case HAMA.T3:
				{
					// Sets the plot to be equal to the T3's plot

					Values[0].Set( T3(ExtMapBuffer5,amp,Period2)[0] );
					Values[3].Set( T3(ExtMapBuffer6,amp,Period2)[0] );
					Values[1].Set( T3(ExtMapBuffer7,amp,Period2)[0] );
					Values[2].Set( T3(ExtMapBuffer8,amp,Period2)[0] );					
					break;
				}
				// If the matype is defined as a ADXVMA then...
				case HAMA.ADXVMA:
				{
					// Sets the plot to be equal to the ADXVMA's plot
					Values[0].Set( ADXVMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( ADXVMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( ADXVMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( ADXVMA(ExtMapBuffer8,Period2)[0] );					
					break;
				}
				// If the matype is defined as a ZeroLagEMA then...
				case HAMA.ZLEMA:
				{
					// Sets the plot to be equal to the ZeroLagEMA's plot

					Values[0].Set( ZeroLagEMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( ZeroLagEMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( ZeroLagEMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( ZeroLagEMA(ExtMapBuffer8,Period2)[0] );						
					break;
				}
				// If the matype is defined as a ZeroLagTEMA then...
				case HAMA.ZLTEMA:
				{
					// Sets the plot to be equal to the ZeroLagTEMA's plot

					Values[0].Set( ZeroLagTEMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( ZeroLagTEMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( ZeroLagTEMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( ZeroLagTEMA(ExtMapBuffer8,Period2)[0] );							
					break;
				}
				// If the matype is defined as a Triangular Moving Average  then...
				case HAMA.TMA:
				{
					// Sets the plot to be equal to the Triangular Moving Average's plot
					Values[0].Set( TMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( TMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( TMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( TMA(ExtMapBuffer8,Period2)[0] );						
					break;
				}
				// If the matype is defined as a Triple Exponential Moving Average  then...
				case HAMA.TEMA:
				{
					// Sets the plot to be equal to the Triple Exponential Moving Averagr's plot
					Values[0].Set( TEMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( TEMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( TEMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( TEMA(ExtMapBuffer8,Period2)[0] );	
					break;
				}	
				// If the matype is defined as a Ehler's Filter   then...
				case HAMA.EhlersFilter:
				{
					// Sets the plot to be equal to the Ehler's Filter plot
					Values[0].Set( EhlersFilter(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( EhlersFilter(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( EhlersFilter(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( EhlersFilter(ExtMapBuffer8,Period2)[0] );	
					break;
				}	
				// If the matype is defined as a SMMA   then...
				case HAMA.SMMA:
				{
					// Sets the plot to be equal to the SMMA plot

					Values[0].Set( SMMA(ExtMapBuffer5,Period2)[0] );
					Values[3].Set( SMMA(ExtMapBuffer6,Period2)[0] );
					Values[1].Set( SMMA(ExtMapBuffer7,Period2)[0] );
					Values[2].Set( SMMA(ExtMapBuffer8,Period2)[0] );						
					break;
				}	
			}	//end of switch			
			Color barColor = (Values[3][0] > Values[0][0] ? BarColorUp : BarColorDown);
			
			if (barType == 1)
			{
				DrawLine(CurrentBar.ToString(), 0, Values[1][0], 0, Values[2][0], ShadowColor, DashStyle.Solid, ShadowWidth);
				DrawLine(CurrentBar.ToString() + "OC", 0, Values[0][0], 0, Values[3][0], barColor, DashStyle.Solid, ShadowWidth * 3);
			
				ChartControl.ChartStyle.DownColor	= Color.Transparent; 
				ChartControl.ChartStyle.UpColor		= Color.Transparent;
				ChartControl.ChartStyle.Pen			= new Pen(Color.Transparent); 
			}
			else if (barType == 2)
			{
				BarColor = barColor;
				CandleOutlineColor = ShadowColor;
			}
			else
			{
				DrawLine(CurrentBar.ToString(), 0, Values[1][0], 0, Values[2][0], ShadowColor, DashStyle.Solid, ShadowWidth);
				DrawLine(CurrentBar.ToString() + "OC", 0, Values[0][0], 0, Values[3][0], barColor, DashStyle.Solid, ShadowWidth * 3);
			}
				
			
//			if (colorBars)
//			{
//				BarColor = barColor;
//			}
			
//			if (hidePrice)
//				{
//				ChartControl.ChartStyle.DownColor	= Color.Transparent; 
//				ChartControl.ChartStyle.UpColor		= Color.Transparent; 
//				//ChartControl.ChartStyle.Pen			= new Pen(Color.Transparent); 
//				}
			
		}

        #region Properties
		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Color of down bars.")]
		[Category("Visual")]
		[Gui.Design.DisplayNameAttribute("03. Down color")]
		public Color BarColorDown
		{
			get { return barColorDown; }
			set { barColorDown = value; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		public string BarColorDownSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(barColorDown); }
			set { barColorDown = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Color of up bars.")]
		[Category("Visual")]
		[Gui.Design.DisplayNameAttribute("02. Up color")]
		public Color BarColorUp
		{
			get { return barColorUp; }
			set { barColorUp = value; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		public string BarColorUpSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(barColorUp); }
			set { barColorUp = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Color of shadow line.")]
		[Category("Visual")]
		[Gui.Design.DisplayNameAttribute("04. Shadow color")]
		public Color ShadowColor
		{
			get { return shadowColor; }
			set { shadowColor = value; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		public string ShadowColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(shadowColor); }
			set { shadowColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("Bar type to draw. Use 1 for Heiken Ashi, 2 for regular candles, 3 for both.")]
		[Category("Visual")]
		[Gui.Design.DisplayNameAttribute("01. BarType")]
		public int BarType
		{
			get { return barType; }
			set { barType = Math.Max(value, 1); }
		}
		
		/// <summary>
		/// </summary>
//		[XmlIgnore()]
//		[Description("Hide normal price bars?")]
//		[Category("Visual")]
//		[Gui.Design.DisplayNameAttribute("01. Hide Price")]
//		public bool HidePrice
//		{
//			get { return hidePrice; }
//			set { hidePrice = value; }
//		}
//		
//		/// <summary>
//		/// </summary>
//		[XmlIgnore()]
//		[Description("Color normal price bars?")]
//		[Category("Visual")]
//		[Gui.Design.DisplayNameAttribute("02. Color regular bars?")]
//		public bool ColorBars
//		{
//			get { return colorBars; }
//			set { colorBars = value; }
//		}
//		
//		/// <summary>
//		/// </summary>
//		[XmlIgnore()]
//		[Description("Draw Heiken Ashi bars?")]
//		[Category("Visual")]
//		[Gui.Design.DisplayNameAttribute("03. Draw HA bars?")]
//		public bool DrawHACandles
//		{
//			get { return drawHACandles; }
//			set { drawHACandles = value; }
//		}
		/// <summary>
		/// </summary>
		[Description("Width of shadow line.")]
		[Category("Visual")]
		[Gui.Design.DisplayNameAttribute("05. Shadow width")]
		public int ShadowWidth
		{
			get { return shadowWidth; }
			set { shadowWidth = Math.Max(value, 1); }
		}
		
		/// <summary>
		/// Gets the HeikenAshiSmoothed Open value.
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries HAOpen
		{
			get { return Values[0]; }
		}
				
		/// <summary>
		/// Gets the HeikenAshiSmoothed High value.
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries HAHigh
		{
			get { return Values[1]; }
		}

		/// <summary>
		/// Gets the HeikenAshiSmoothed Low value.
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries HALow
		{
			get { return Values[2]; }
		}

		/// <summary>
		/// Gets the HeikenAshiSmoothed Close value.
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries HAClose
		{
			get { return Values[3]; }
		}
		
		// Creates the user definable parameter for the 1st moving average type.
		[Description("Choose a Moving Average type 1.")]
		[Category("Parameters")]
		public HAMA MAType1
		{
			get { return matype1; }
			set { matype1 = value; }
		}
		
		[Description("Numbers of bars used for MA Type 1")]
		[Category("Parameters")]
		public int Period1
		{
			get { return period1; }
			set { period1 = Math.Max(1, value); }
		}	
		// Creates the user definable parameter for the 2nd moving average type.
		[Description("Choose a Moving Average type 2.")]
		[Category("Parameters")]
		public HAMA MAType2
		{
			get { return matype2; }
			set { matype2 = value; }
		}
		
		[Description("Numbers of bars used for MA Type 2")]
		[Category("Parameters")]
		public int Period2
		{
			get { return period2; }
			set { period2 = Math.Max(1, value); }
		}	
		[Description("Amplifaction for T3")]
		[Category("Parameters")]
		public double Amp
		{
			get { return amp; }
			set { amp = Math.Max(0.1, value); }
		}			
        #endregion

        #region Miscellaneous
        public override void Dispose()
        {
            if (ChartControl != null && saveDownColor != Color.Empty && ChartControl.ChartStyle.DownColor == Color.Transparent)
            {
				ChartControl.ChartStyle.DownColor	= saveDownColor;
				ChartControl.ChartStyle.UpColor		= saveUpColor;
				ChartControl.ChartStyle.Pen			= savePen;
            }
            base.Dispose();
        }
		#endregion
    }
}
public enum HAMA
{
	ADXVMA,
	EhlersFilter,
	EMA,
	HMA,
//	JMA,
	SMA,
	SMMA,
	T3,
	TEMA,
	TMA,
	WMA,
	ZLEMA,
	ZLTEMA
}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private HeikenAshiSmoothed[] cacheHeikenAshiSmoothed = null;

        private static HeikenAshiSmoothed checkHeikenAshiSmoothed = new HeikenAshiSmoothed();

        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        public HeikenAshiSmoothed HeikenAshiSmoothed(double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            return HeikenAshiSmoothed(Input, amp, mAType1, mAType2, period1, period2);
        }

        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        public HeikenAshiSmoothed HeikenAshiSmoothed(Data.IDataSeries input, double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            checkHeikenAshiSmoothed.Amp = amp;
            amp = checkHeikenAshiSmoothed.Amp;
            checkHeikenAshiSmoothed.MAType1 = mAType1;
            mAType1 = checkHeikenAshiSmoothed.MAType1;
            checkHeikenAshiSmoothed.MAType2 = mAType2;
            mAType2 = checkHeikenAshiSmoothed.MAType2;
            checkHeikenAshiSmoothed.Period1 = period1;
            period1 = checkHeikenAshiSmoothed.Period1;
            checkHeikenAshiSmoothed.Period2 = period2;
            period2 = checkHeikenAshiSmoothed.Period2;

            if (cacheHeikenAshiSmoothed != null)
                for (int idx = 0; idx < cacheHeikenAshiSmoothed.Length; idx++)
                    if (Math.Abs(cacheHeikenAshiSmoothed[idx].Amp - amp) <= double.Epsilon && cacheHeikenAshiSmoothed[idx].MAType1 == mAType1 && cacheHeikenAshiSmoothed[idx].MAType2 == mAType2 && cacheHeikenAshiSmoothed[idx].Period1 == period1 && cacheHeikenAshiSmoothed[idx].Period2 == period2 && cacheHeikenAshiSmoothed[idx].EqualsInput(input))
                        return cacheHeikenAshiSmoothed[idx];

            HeikenAshiSmoothed indicator = new HeikenAshiSmoothed();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Amp = amp;
            indicator.MAType1 = mAType1;
            indicator.MAType2 = mAType2;
            indicator.Period1 = period1;
            indicator.Period2 = period2;
            indicator.SetUp();

            HeikenAshiSmoothed[] tmp = new HeikenAshiSmoothed[cacheHeikenAshiSmoothed == null ? 1 : cacheHeikenAshiSmoothed.Length + 1];
            if (cacheHeikenAshiSmoothed != null)
                cacheHeikenAshiSmoothed.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheHeikenAshiSmoothed = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HeikenAshiSmoothed HeikenAshiSmoothed(double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            return _indicator.HeikenAshiSmoothed(Input, amp, mAType1, mAType2, period1, period2);
        }

        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        public Indicator.HeikenAshiSmoothed HeikenAshiSmoothed(Data.IDataSeries input, double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            return _indicator.HeikenAshiSmoothed(input, amp, mAType1, mAType2, period1, period2);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HeikenAshiSmoothed HeikenAshiSmoothed(double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            return _indicator.HeikenAshiSmoothed(Input, amp, mAType1, mAType2, period1, period2);
        }

        /// <summary>
        /// HeikenAshiSmoothed.  Converted from MetaTrader to NinjaScript
        /// </summary>
        /// <returns></returns>
        public Indicator.HeikenAshiSmoothed HeikenAshiSmoothed(Data.IDataSeries input, double amp, HAMA mAType1, HAMA mAType2, int period1, int period2)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.HeikenAshiSmoothed(input, amp, mAType1, mAType2, period1, period2);
        }

    }
}
#endregion
