#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// T3
	/// </summary>
	[Description("T3 Indicator.")]
	[Gui.Design.DisplayName("T3")]
	public class T3 : Indicator
	{
		#region Variables
		private double amp = 0.7;
 		private int smooth = 2;

		private	DataSeries		e1;
		private	DataSeries		e2;
		private	DataSeries		e3;
		private	DataSeries		e4;
		private	DataSeries		e5;
		private	DataSeries		e6;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.Red, "Plot1"));
			

			e1	= new DataSeries(this);
			e2	= new DataSeries(this);
			e3	= new DataSeries(this);
			e4	= new DataSeries(this);
			e5	= new DataSeries(this);
			e6	= new DataSeries(this);
			
			Overlay				= true;
		}

		/// <summary>
		/// Calculates the indicator value(s) at the current index.
		/// </summary>
		protected override void OnBarUpdate()
		{		
			int period=smooth;
			
			e1.Set(EMA(Close,period)[0]);
			e2.Set(EMA(e1,period)[0]);
			e3.Set(EMA(e2,period)[0]);
			e4.Set(EMA(e3,period)[0]);
			e5.Set(EMA(e4,period)[0]);
			e6.Set(EMA(e5,period)[0]);
			
			double c1=-amp*amp*amp;
			double c2=(3*amp*amp)+(3*amp*amp*amp);
			double c3=(-6*amp*amp)-(3*amp)-(3*amp*amp*amp);
			double c4=1+(3*amp)+(amp*amp*amp)+(3*amp*amp);
		
			Plot1.Set((c1*e6[0])+(c2*e5[0])+(c3*e4[0])+(c4*e3[0]));
			
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Plot1
		{
			get { return Values[0]; }
		}


		/// <summary>
		/// </summary>
		[Description("")]
		[Category("Parameters")]
		public double Amplification
		{
			get { return amp; }
			set { amp = value; }
		}

		/// <summary>
		/// </summary>
		[Description("")]
		[Category("Parameters")]
		public int Smooth
		{
			get { return smooth; }
			set { smooth = Math.Max(1, value); }
		}
		

		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private T3[] cacheT3 = null;

        private static T3 checkT3 = new T3();

        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        public T3 T3(double amplification, int smooth)
        {
            return T3(Input, amplification, smooth);
        }

        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        public T3 T3(Data.IDataSeries input, double amplification, int smooth)
        {
            checkT3.Amplification = amplification;
            amplification = checkT3.Amplification;
            checkT3.Smooth = smooth;
            smooth = checkT3.Smooth;

            if (cacheT3 != null)
                for (int idx = 0; idx < cacheT3.Length; idx++)
                    if (Math.Abs(cacheT3[idx].Amplification - amplification) <= double.Epsilon && cacheT3[idx].Smooth == smooth && cacheT3[idx].EqualsInput(input))
                        return cacheT3[idx];

            T3 indicator = new T3();
            indicator.SetUp();
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Amplification = amplification;
            indicator.Smooth = smooth;

            T3[] tmp = new T3[cacheT3 == null ? 1 : cacheT3.Length + 1];
            if (cacheT3 != null)
                cacheT3.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheT3 = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.T3 T3(double amplification, int smooth)
        {
            return _indicator.T3(Input, amplification, smooth);
        }

        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        public Indicator.T3 T3(Data.IDataSeries input, double amplification, int smooth)
        {
            return _indicator.T3(input, amplification, smooth);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.T3 T3(double amplification, int smooth)
        {
            return _indicator.T3(Input, amplification, smooth);
        }

        /// <summary>
        /// T3 Indicator.
        /// </summary>
        /// <returns></returns>
        public Indicator.T3 T3(Data.IDataSeries input, double amplification, int smooth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.T3(input, amplification, smooth);
        }

    }
}
#endregion
