#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.Collections;
using System.Collections.Generic;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.")]
    public class PKPriceAlert2 : Indicator
    {
        #region Variables
        // Wizard generated variables
            
		    private DateTime				startTime;
		    private bool uptrend = true;
		private string 	breakFloor	= "BreakFloor.wav"; 	// Price Breaking Down thru horizontal line alert wav file
		private string 	breakCeiling	= "BreakCeiling.wav"; 	// Price Breaking Up thru horizontal line alert wav file		
		
		
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            CalculateOnBarClose	= true;
            Overlay				= true;
            this.startTime			= DateTime.Now;
			
			 
			
			 
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            
			try {
				
				if (CurrentBar < 1)
					return;
				
			    if (startTime.Ticks > Time[0].Ticks ) 
					return;
					
				//Print("ChartObjectCount= " + this.ChartControl.ChartObjects.Count + " " + Time[0]);
			    
				List<ChartHorizontalLine> ChartObjectArrayList = new List<ChartHorizontalLine>();
			    foreach(ChartObject CO in this.ChartControl.ChartObjects) {
					//Print("ChartObjectType: " + CO.GetType().Name );
				   	if ( CO is NinjaTrader.Gui.Chart.ChartHorizontalLine) 	{	
						//Print("Horizontal Line Value= " + CO.Value);
				   		ChartObjectArrayList.Add((ChartHorizontalLine)CO);
					}
				}
				
				//Print("HorizontalLineCount= " + ChartObjectArrayList.Count );
					
			    foreach(ChartHorizontalLine CO in ChartObjectArrayList) {
				  
					double PriceAlert = Instrument.MasterInstrument.Round2TickSize(CO.Y);
					
					 
					//Print("Horizontal Line Value= " + CO.Value);
					
					if ( (this.uptrend == false) &&
						 (Close[0] < Close[1])   && 
						 (Close[0] < PriceAlert) &&
						 (Close[1] > PriceAlert)    ) {
							 
							Print("********************PriceAlert DOWN. AlertPrice=" + PriceAlert + " \t Close[0]=" + Close[0] + " \t Close[1]=" + Close[1] + " \t Time[0]=" + Time[0] );
							//DrawArrowDown("MyArrowDOWN" + CurrentBar , 0,  High[0] + .05 , Color.Blue);	
							Alert(this.GetType().Name + Instrument.FullName,Priority.High,"Price Alert. Ticker=" + Instrument.FullName + "  Price=" + PriceAlert , breakFloor , 60, Color.Blue,Color.White);
				            	
							
					}
					
					if ( (this.uptrend == true) &&
						 (Close[0] > Close[1])   && 
						 (Close[0] > PriceAlert) &&
						 (Close[1] < PriceAlert)    ) {
						 	
							Print("********************PriceAlert   UP. AlertPrice=" + PriceAlert + " \t Close[0]=" + Close[0] + " \t Close[1]=" + Close[1] + " \t Time[0]=" + Time[0] );	
						 	//DrawArrowUp("MyArrowUP" + CurrentBar , 0,  Low[0] - .05 , Color.Blue);	
							Alert(this.GetType().Name + Instrument.FullName,Priority.High,"Price Alert. Ticker=" + Instrument.FullName + "  Price=" + PriceAlert , breakCeiling , 60, Color.Blue,Color.White);
							 
					}
												
						
					 
				}
 
				 
			}
			catch( Exception e) {
				Print("EXCEPTION Instrument=" + Instrument +  e.ToString() );
				 
				Print(e.Message);
				 
				Alert(this.GetType().Name + Instrument.FullName,Priority.High,"Instrument=" + Instrument + "   **************EXCEPTION" + e.ToString(),"C:\\Program Files\\NinjaTrader 6.5\\sounds\\test.wav", 60, Color.Red,Color.White);
				
				
			}			
				
		 
			 
        }

        #region Properties

        [Description("")]
        [Category("Parameters")]
        public bool Uptrend
        {
            get { return uptrend; }
            set { uptrend = value; }
		}	
			[Description("Price Breaking Down thru horizontal line alert wav file")]
        [Category("Alert")]
        public string BreakFloor
        {
            get { return breakFloor; }
            set { breakFloor = value; }
        }	
		
		[Description("Price Breaking Down thru horizontal line alert wav file")]
        [Category("Alert")]
        public string BreakCeiling
        {
            get { return breakCeiling; }
            set { breakCeiling = value; }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PKPriceAlert2[] cachePKPriceAlert2 = null;

        private static PKPriceAlert2 checkPKPriceAlert2 = new PKPriceAlert2();

        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        public PKPriceAlert2 PKPriceAlert2(bool uptrend)
        {
            return PKPriceAlert2(Input, uptrend);
        }

        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        public PKPriceAlert2 PKPriceAlert2(Data.IDataSeries input, bool uptrend)
        {
            if (cachePKPriceAlert2 != null)
                for (int idx = 0; idx < cachePKPriceAlert2.Length; idx++)
                    if (cachePKPriceAlert2[idx].Uptrend == uptrend && cachePKPriceAlert2[idx].EqualsInput(input))
                        return cachePKPriceAlert2[idx];

            lock (checkPKPriceAlert2)
            {
                checkPKPriceAlert2.Uptrend = uptrend;
                uptrend = checkPKPriceAlert2.Uptrend;

                if (cachePKPriceAlert2 != null)
                    for (int idx = 0; idx < cachePKPriceAlert2.Length; idx++)
                        if (cachePKPriceAlert2[idx].Uptrend == uptrend && cachePKPriceAlert2[idx].EqualsInput(input))
                            return cachePKPriceAlert2[idx];

                PKPriceAlert2 indicator = new PKPriceAlert2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Uptrend = uptrend;
                Indicators.Add(indicator);
                indicator.SetUp();

                PKPriceAlert2[] tmp = new PKPriceAlert2[cachePKPriceAlert2 == null ? 1 : cachePKPriceAlert2.Length + 1];
                if (cachePKPriceAlert2 != null)
                    cachePKPriceAlert2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePKPriceAlert2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PKPriceAlert2 PKPriceAlert2(bool uptrend)
        {
            return _indicator.PKPriceAlert2(Input, uptrend);
        }

        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        public Indicator.PKPriceAlert2 PKPriceAlert2(Data.IDataSeries input, bool uptrend)
        {
            return _indicator.PKPriceAlert2(input, uptrend);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PKPriceAlert2 PKPriceAlert2(bool uptrend)
        {
            return _indicator.PKPriceAlert2(Input, uptrend);
        }

        /// <summary>
        /// Sends an alert to the alert window when the price crosses any horizontal line manually drawn on the screen.
        /// </summary>
        /// <returns></returns>
        public Indicator.PKPriceAlert2 PKPriceAlert2(Data.IDataSeries input, bool uptrend)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PKPriceAlert2(input, uptrend);
        }
    }
}
#endregion
