#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using VC.NinjaScript.Utility;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Detrend Oscillator for NinjaTrader by Elliott Wave
    /// </summary>
    [Description("Detrend Oscillator for NinjaTrader by Elliott Wave")]
    public class DetrendOscillator : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 5; // Default setting for Period
			private MovingAverageType maType = MovingAverageType.SMA;
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkCyan), PlotStyle.Bar, "Detrend"));
            Add(new Line(Color.DarkGray, 0, "0")); 
			CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
			Plots[0].Pen.Width = 4;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			// Do not calculate if we don't have enough bars 
			if (CurrentBar < period) 
				return;
				Detrend.Set(Close[0] - MA(MaType, period, 0));
			
			  }

				private double MA(VC.NinjaScript.Utility.MovingAverageType maType, int period, int barsAgo)
			
		{			
			switch (maType)
			{
				
				case VC.NinjaScript.Utility.MovingAverageType.ADXVMA:
				{
					return ADXVMA(period)[barsAgo];
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.EMA:
				{
					return EMA(period)[barsAgo];
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.HMA:
				{
					return HMA(period)[barsAgo];				
					break;
				}
				
//				case VC.NinjaScript.Utility.MovingAverageType.JMAq:
//				{
//					return JMAq(0, period)[barsAgo];
//					break;
//				}
				
				case VC.NinjaScript.Utility.MovingAverageType.SMA:
				{
					return SMA(period)[barsAgo];									
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.SMMA:
				{
					return SMA(period)[barsAgo];									
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.T3:
				{
					return T3(period, period, 0.618)[barsAgo];									
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.VMA:
				{
					return VMA(period, period)[barsAgo];									
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.VWMA:
				{
					return VWMA(period)[barsAgo];													
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.WMA:
				{
					return WMA(period)[barsAgo];													
					break;
				}	
				
				case VC.NinjaScript.Utility.MovingAverageType.TMA:
				{
					return TMA(period)[barsAgo];													
					break;
				}
				
				case VC.NinjaScript.Utility.MovingAverageType.TEMA:
				{
					return TEMA(period)[barsAgo];													
					break;
				}
			}
			
			return 0;
		}


        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Detrend
        {
            get { return Values[0]; }
        }

        [Description("Moving average period")]
        [Category("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }
		
			[Description("Choose a Moving Average type.")]
		[Category("Parameters")]
		public MovingAverageType MaType
		{
			get { return maType; }
			set { maType = value; }
		}
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DetrendOscillator[] cacheDetrendOscillator = null;

        private static DetrendOscillator checkDetrendOscillator = new DetrendOscillator();

        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        public DetrendOscillator DetrendOscillator(MovingAverageType maType, int period)
        {
            return DetrendOscillator(Input, maType, period);
        }

        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        public DetrendOscillator DetrendOscillator(Data.IDataSeries input, MovingAverageType maType, int period)
        {
            if (cacheDetrendOscillator != null)
                for (int idx = 0; idx < cacheDetrendOscillator.Length; idx++)
                    if (cacheDetrendOscillator[idx].MaType == maType && cacheDetrendOscillator[idx].Period == period && cacheDetrendOscillator[idx].EqualsInput(input))
                        return cacheDetrendOscillator[idx];

            lock (checkDetrendOscillator)
            {
                checkDetrendOscillator.MaType = maType;
                maType = checkDetrendOscillator.MaType;
                checkDetrendOscillator.Period = period;
                period = checkDetrendOscillator.Period;

                if (cacheDetrendOscillator != null)
                    for (int idx = 0; idx < cacheDetrendOscillator.Length; idx++)
                        if (cacheDetrendOscillator[idx].MaType == maType && cacheDetrendOscillator[idx].Period == period && cacheDetrendOscillator[idx].EqualsInput(input))
                            return cacheDetrendOscillator[idx];

                DetrendOscillator indicator = new DetrendOscillator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MaType = maType;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                DetrendOscillator[] tmp = new DetrendOscillator[cacheDetrendOscillator == null ? 1 : cacheDetrendOscillator.Length + 1];
                if (cacheDetrendOscillator != null)
                    cacheDetrendOscillator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDetrendOscillator = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DetrendOscillator DetrendOscillator(MovingAverageType maType, int period)
        {
            return _indicator.DetrendOscillator(Input, maType, period);
        }

        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        public Indicator.DetrendOscillator DetrendOscillator(Data.IDataSeries input, MovingAverageType maType, int period)
        {
            return _indicator.DetrendOscillator(input, maType, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DetrendOscillator DetrendOscillator(MovingAverageType maType, int period)
        {
            return _indicator.DetrendOscillator(Input, maType, period);
        }

        /// <summary>
        /// Detrend Oscillator for NinjaTrader by Elliott Wave
        /// </summary>
        /// <returns></returns>
        public Indicator.DetrendOscillator DetrendOscillator(Data.IDataSeries input, MovingAverageType maType, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DetrendOscillator(input, maType, period);
        }
    }
}
#endregion
