

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


////////////////////////////////////////////////////////////////////
//                                                                //
//    (c)Jurbol                                                   // 
//    For more trading indicators, visit www.jurbol.com           //
//                                                                //
//////////////////////////////////////////////////////////////////// 


namespace NinjaTrader.Indicator
{
    [Description("Multi MA indicator with selectable slope color..")]
    public class _Jurbol_MultiMA_ColorSlope : Indicator
    {
        #region Variables
		// Create a variable that stores the user's selection for a moving average 
		private JTSUniversalMovingAverage	matype	= JTSUniversalMovingAverage.SMA;
		
		private int			period					= 14;
		private Color		risingMA        		= Color.Chartreuse;
		private Color		fallingMA        		= Color.Red;
		private Color		flatMA          		= Color.Yellow;
		private bool		SlopeColor				= true;			
		
		#endregion

        protected override void Initialize()
        {
			
			Add(new Plot(Color.Orange, "MA"));
			Plots[0].Pen.Width = 2;
			
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= true;
        }

        protected override void OnBarUpdate()
        {
			
				
			if (CurrentBar < 20) 
				return;
			double EmaH = EMA(High, period)[0];

			
			switch (matype)
			{
				case JTSUniversalMovingAverage.EMA:
				{
					Value.Set(EMA(period)[0]);
					
					break;
				}
				
				case JTSUniversalMovingAverage.HMA:
				{
					Value.Set(HMA(period)[0]);
					break;
				}
				
				case JTSUniversalMovingAverage.SMA:
				{
					Value.Set(SMA(period)[0]);
					break;
				}
				
				case JTSUniversalMovingAverage.WMA:
				{
					Value.Set(WMA(period)[0]);
					break;
				}
				case JTSUniversalMovingAverage.DEMA:
				{
					Value.Set(DEMA(period)[0]);
					break;
				}
				case JTSUniversalMovingAverage.TEMA:
				{
					Value.Set(TEMA(period)[0]);
					break;
				}
				
			
					
			
			}
			
		
			//*******************************************************
			// SLOPE COLORS
			//*******************************************************
			if(SlopeColor == true)
			if(Rising(Value)) {PlotColors[0][0] = risingMA;}
			else if(Falling(Value)) {PlotColors[0][0] = fallingMA;}
			else {PlotColors[0][0] = flatMA;}
        }

        #region Properties
		// Creates the user definable parameter for the moving average type.
		[Description("Choose a Moving Average type.")]
		[GridCategory("01. Parameters")]
		[Gui.Design.DisplayNameAttribute("01. Select MA Type")]
		public JTSUniversalMovingAverage MAType
		{
			get { return matype; }
			set { matype = value; }
		}
		
		[Description("Numbers of bars used for calculations")]
		[GridCategory("01. Parameters")]
		[Gui.Design.DisplayNameAttribute("02. MA Period")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
		
		[Description("Use colored slope")]
		[Gui.Design.DisplayName ("01. Colored Slope?")]
        [GridCategory("02.Slope")]
        public bool slopeColor
        {
            get { return SlopeColor; }
            set { SlopeColor = value; }
        }
		
		[XmlIgnore()]
        [Description("Color for rising MA")]
        [GridCategory("02.Slope")]
		[Gui.Design.DisplayNameAttribute("02. Rising MA Color")]
        public Color RisingMA
        {
            get { return risingMA; }
            set { risingMA = value; }
        }
		[Browsable(false)]
		public string RisingMASerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(RisingMA); }
			set { RisingMA = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
        [Description("Color for falling MA")]
        [GridCategory("02.Slope")]
		[Gui.Design.DisplayNameAttribute("03. Falling MA Color")]
        public Color FallingMA
        {
            get { return fallingMA; }
            set { fallingMA = value; }
        }
		[Browsable(false)]
		public string FallingMASerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(FallingMA); }
			set { FallingMA = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
        [Description("Color for flat MA")]
        [GridCategory("02.Slope")]
		[Gui.Design.DisplayNameAttribute("04. Flat MA Color")]
        public Color FlatMA
        {
            get { return flatMA; }
            set { flatMA = value; }
        }
		[Browsable(false)]
		public string FlatMASerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(FlatMA); }
			set { FlatMA = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		
        #endregion
    }
}


public enum JTSUniversalMovingAverage
{
	EMA,
	HMA,
	SMA,
	WMA,
	DEMA,
	TEMA
}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private _Jurbol_MultiMA_ColorSlope[] cache_Jurbol_MultiMA_ColorSlope = null;

        private static _Jurbol_MultiMA_ColorSlope check_Jurbol_MultiMA_ColorSlope = new _Jurbol_MultiMA_ColorSlope();

        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        public _Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            return _Jurbol_MultiMA_ColorSlope(Input, fallingMA, flatMA, mAType, period, risingMA, slopeColor);
        }

        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        public _Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Data.IDataSeries input, Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            if (cache_Jurbol_MultiMA_ColorSlope != null)
                for (int idx = 0; idx < cache_Jurbol_MultiMA_ColorSlope.Length; idx++)
                    if (cache_Jurbol_MultiMA_ColorSlope[idx].FallingMA == fallingMA && cache_Jurbol_MultiMA_ColorSlope[idx].FlatMA == flatMA && cache_Jurbol_MultiMA_ColorSlope[idx].MAType == mAType && cache_Jurbol_MultiMA_ColorSlope[idx].Period == period && cache_Jurbol_MultiMA_ColorSlope[idx].RisingMA == risingMA && cache_Jurbol_MultiMA_ColorSlope[idx].slopeColor == slopeColor && cache_Jurbol_MultiMA_ColorSlope[idx].EqualsInput(input))
                        return cache_Jurbol_MultiMA_ColorSlope[idx];

            lock (check_Jurbol_MultiMA_ColorSlope)
            {
                check_Jurbol_MultiMA_ColorSlope.FallingMA = fallingMA;
                fallingMA = check_Jurbol_MultiMA_ColorSlope.FallingMA;
                check_Jurbol_MultiMA_ColorSlope.FlatMA = flatMA;
                flatMA = check_Jurbol_MultiMA_ColorSlope.FlatMA;
                check_Jurbol_MultiMA_ColorSlope.MAType = mAType;
                mAType = check_Jurbol_MultiMA_ColorSlope.MAType;
                check_Jurbol_MultiMA_ColorSlope.Period = period;
                period = check_Jurbol_MultiMA_ColorSlope.Period;
                check_Jurbol_MultiMA_ColorSlope.RisingMA = risingMA;
                risingMA = check_Jurbol_MultiMA_ColorSlope.RisingMA;
                check_Jurbol_MultiMA_ColorSlope.slopeColor = slopeColor;
                slopeColor = check_Jurbol_MultiMA_ColorSlope.slopeColor;

                if (cache_Jurbol_MultiMA_ColorSlope != null)
                    for (int idx = 0; idx < cache_Jurbol_MultiMA_ColorSlope.Length; idx++)
                        if (cache_Jurbol_MultiMA_ColorSlope[idx].FallingMA == fallingMA && cache_Jurbol_MultiMA_ColorSlope[idx].FlatMA == flatMA && cache_Jurbol_MultiMA_ColorSlope[idx].MAType == mAType && cache_Jurbol_MultiMA_ColorSlope[idx].Period == period && cache_Jurbol_MultiMA_ColorSlope[idx].RisingMA == risingMA && cache_Jurbol_MultiMA_ColorSlope[idx].slopeColor == slopeColor && cache_Jurbol_MultiMA_ColorSlope[idx].EqualsInput(input))
                            return cache_Jurbol_MultiMA_ColorSlope[idx];

                _Jurbol_MultiMA_ColorSlope indicator = new _Jurbol_MultiMA_ColorSlope();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.FallingMA = fallingMA;
                indicator.FlatMA = flatMA;
                indicator.MAType = mAType;
                indicator.Period = period;
                indicator.RisingMA = risingMA;
                indicator.slopeColor = slopeColor;
                Indicators.Add(indicator);
                indicator.SetUp();

                _Jurbol_MultiMA_ColorSlope[] tmp = new _Jurbol_MultiMA_ColorSlope[cache_Jurbol_MultiMA_ColorSlope == null ? 1 : cache_Jurbol_MultiMA_ColorSlope.Length + 1];
                if (cache_Jurbol_MultiMA_ColorSlope != null)
                    cache_Jurbol_MultiMA_ColorSlope.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cache_Jurbol_MultiMA_ColorSlope = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator._Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            return _indicator._Jurbol_MultiMA_ColorSlope(Input, fallingMA, flatMA, mAType, period, risingMA, slopeColor);
        }

        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        public Indicator._Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Data.IDataSeries input, Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            return _indicator._Jurbol_MultiMA_ColorSlope(input, fallingMA, flatMA, mAType, period, risingMA, slopeColor);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator._Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            return _indicator._Jurbol_MultiMA_ColorSlope(Input, fallingMA, flatMA, mAType, period, risingMA, slopeColor);
        }

        /// <summary>
        /// Multi MA indicator with selectable slope color..
        /// </summary>
        /// <returns></returns>
        public Indicator._Jurbol_MultiMA_ColorSlope _Jurbol_MultiMA_ColorSlope(Data.IDataSeries input, Color fallingMA, Color flatMA, JTSUniversalMovingAverage mAType, int period, Color risingMA, bool slopeColor)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator._Jurbol_MultiMA_ColorSlope(input, fallingMA, flatMA, mAType, period, risingMA, slopeColor);
        }
    }
}
#endregion
