#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// 
    /// </summary>
    [Description("")]
    public class EmaOscillator : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int   slow; // Default setting for Slow
            private int   fast; // Default setting for Fast
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.SeaGreen), PlotStyle.Bar, "Plot0"));
            Add(new Line(Color.FromKnownColor(KnownColor.MidnightBlue), 0, "ZeroLine"));
            Overlay				= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
            Plot0.Set((EMA(fast)[0]) - (EMA(slow)[0]));
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Slow
        {
            get { return slow; }
            set { slow = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Fast
        {
            get { return fast; }
            set { fast = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EmaOscillator[] cacheEmaOscillator = null;

        private static EmaOscillator checkEmaOscillator = new EmaOscillator();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public EmaOscillator EmaOscillator(int fast, int slow)
        {
            return EmaOscillator(Input, fast, slow);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public EmaOscillator EmaOscillator(Data.IDataSeries input, int fast, int slow)
        {
            if (cacheEmaOscillator != null)
                for (int idx = 0; idx < cacheEmaOscillator.Length; idx++)
                    if (cacheEmaOscillator[idx].Fast == fast && cacheEmaOscillator[idx].Slow == slow && cacheEmaOscillator[idx].EqualsInput(input))
                        return cacheEmaOscillator[idx];

            lock (checkEmaOscillator)
            {
                checkEmaOscillator.Fast = fast;
                fast = checkEmaOscillator.Fast;
                checkEmaOscillator.Slow = slow;
                slow = checkEmaOscillator.Slow;

                if (cacheEmaOscillator != null)
                    for (int idx = 0; idx < cacheEmaOscillator.Length; idx++)
                        if (cacheEmaOscillator[idx].Fast == fast && cacheEmaOscillator[idx].Slow == slow && cacheEmaOscillator[idx].EqualsInput(input))
                            return cacheEmaOscillator[idx];

                EmaOscillator indicator = new EmaOscillator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Fast = fast;
                indicator.Slow = slow;
                Indicators.Add(indicator);
                indicator.SetUp();

                EmaOscillator[] tmp = new EmaOscillator[cacheEmaOscillator == null ? 1 : cacheEmaOscillator.Length + 1];
                if (cacheEmaOscillator != null)
                    cacheEmaOscillator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheEmaOscillator = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EmaOscillator EmaOscillator(int fast, int slow)
        {
            return _indicator.EmaOscillator(Input, fast, slow);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.EmaOscillator EmaOscillator(Data.IDataSeries input, int fast, int slow)
        {
            return _indicator.EmaOscillator(input, fast, slow);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EmaOscillator EmaOscillator(int fast, int slow)
        {
            return _indicator.EmaOscillator(Input, fast, slow);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.EmaOscillator EmaOscillator(Data.IDataSeries input, int fast, int slow)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EmaOscillator(input, fast, slow);
        }
    }
}
#endregion
