#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Displays Price on Horizontal Lines
    /// </summary>
    [Description("Displays Price on Horizontal Lines")]
    public class PriceonLine : Indicator
    {
        #region Variables
			double yvalue = 0;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			CalculateOnBarClose = true;
			Overlay = true;
			

        }
		protected override void OnStartUp()
		{
			Font textFont = new Font("Arial", 8);
			foreach (IDrawObject draw in DrawObjects)
			{
				
				if (draw.DrawType == DrawType.HorizontalLine && draw.UserDrawn)
				{
					IHorizontalLine hLine = (IHorizontalLine) draw;
					yvalue = Math.Round(hLine.Y, 5);
					DrawText("TextTag"+draw.Tag, false, yvalue.ToString(), 0, yvalue, 7, Color.Orange, textFont, StringAlignment.Near, Color.Transparent, Color.Transparent, 0);
 				}
			}
		}
 

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			foreach (IDrawObject draw in DrawObjects)
			{
				if (draw.Tag.Contains("TextTag"))
				{
					IText text = (IText) draw; 
					text.BarsAgo = 0;
				}
			}
        }

        #region Properties

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PriceonLine[] cachePriceonLine = null;

        private static PriceonLine checkPriceonLine = new PriceonLine();

        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        public PriceonLine PriceonLine()
        {
            return PriceonLine(Input);
        }

        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        public PriceonLine PriceonLine(Data.IDataSeries input)
        {
            if (cachePriceonLine != null)
                for (int idx = 0; idx < cachePriceonLine.Length; idx++)
                    if (cachePriceonLine[idx].EqualsInput(input))
                        return cachePriceonLine[idx];

            lock (checkPriceonLine)
            {
                if (cachePriceonLine != null)
                    for (int idx = 0; idx < cachePriceonLine.Length; idx++)
                        if (cachePriceonLine[idx].EqualsInput(input))
                            return cachePriceonLine[idx];

                PriceonLine indicator = new PriceonLine();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                PriceonLine[] tmp = new PriceonLine[cachePriceonLine == null ? 1 : cachePriceonLine.Length + 1];
                if (cachePriceonLine != null)
                    cachePriceonLine.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePriceonLine = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceonLine PriceonLine()
        {
            return _indicator.PriceonLine(Input);
        }

        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceonLine PriceonLine(Data.IDataSeries input)
        {
            return _indicator.PriceonLine(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceonLine PriceonLine()
        {
            return _indicator.PriceonLine(Input);
        }

        /// <summary>
        /// Displays Price on Horizontal Lines
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceonLine PriceonLine(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PriceonLine(input);
        }
    }
}
#endregion
