//----------------------------------------------------------------------------------------
//        Name:  BalanceLine
//        Type:  Indicator
// Description:  BalanceLine Indicator
//     Credits:  borrow some code from Mike Winfrey
//               idea by perryg
//    Comments:  
//    Versions:  
///// 1.0      Khoi(Cory) Nguyen     4/17/2010
//----------------------------------------------------------------------------------------
//
#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Text;
using System.IO;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Logs the current instrument prices
    /// </summary>
    [Description("Fifty percent line for a day using prev days H and L ")]
    [Gui.Design.DisplayName("BalanceLine")]
    public class BalanceLine : Indicator
    {
        #region Variables
 			private DateTime 	now;
			private DateTime 	startDay;
		
			private int		firstBarOfDay			= 0;
			private int		firstBarOfSession		= 0;
			private int		lastBarOfSession		= 0;
			private int 	lastBarForGrid 			= 0;
			private double 	maxFibGridHigh 			= 0;
			private double 	minFibGridLow 			= 999999999.99;
			private double 	fibGridLow 				= 0;
			private double 	fibGridHigh 			= 0;
			private double 	fibGridMid 				= 0;
			private bool	enableORB 				= false;
			private bool	onPricePanel 			= true;
			
			private double 	maxTodaysHigh 			= 0;
			private double 	todaysOpen				= 0;
			private double 	minTodaysLow 			= 999999999.99;
			private double 	todaysLow 				= 0;
			private double 	todaysHigh 				= 0;
			private double	todaysMidLine 			= 0;
			private bool	enableTodaysHiLoMidLine	= true;
		
			private int 	firstBarOfYesterdaysSession	= 0;
			private double 	maxYesterdaysHigh 			= 0;
			private double 	minYesterdaysLow 			= 999999999.99;
			private double 	yesterdaysLow 				= 0;
			private double 	yesterdaysHigh 				= 0;
			private double	yesterdaysMidLine 			= 0;
			private bool	enableYesterdaysHiLoMidLine	= true;
		
		    private DataSeries  TodaysHigh;
			private DataSeries  TodaysMidLine;
			private DataSeries  TodaysLow;
			private DataSeries  TodaysOpen;
			private DataSeries  LastBarOfToday;
		
			private DataSeries  YesterdaysHigh;
			private DataSeries  YesterdaysMidLine;
			private DataSeries  YesterdaysLow;
			private DataSeries  FirstBarOfYesterdaysSession;
		
			private DataSeries  FibGridLow;
			private DataSeries  FibGridHigh; 
			private DataSeries  LastBarForFib;
		
		    private SolidBrush FibBrush;
		
			private Pen bigLimePen;
			private Pen limePen;
			private Pen bigMagentaPen;
			private Pen magentaPen;
			private Pen bigRedPen;
			private Pen redPen;
			private Pen bigYellow;
			private Pen yellowPen;
		
			private	Font					textFont		= new Font("Arial",8);
			private	SolidBrush				textBrush		= new SolidBrush(Color.LightYellow);
			private StringFormat			stringFormat	= new StringFormat();
		
		private double[] arrayH = new double[1000];
		private double[] arrayL = new double[1000];
		private int[] arrayHbar = new int[1000];
		private int[] arrayLbar = new int[1000];		
		private    int[] arrayBar = new int[1000];
		private double[] arrayRay = new double[1000];
	    int cnt = 1;
		int daysBack = 2;
		    private int hBar =0;
		    private int lBar =0;
		    private Color rangeColor = Color.DarkGoldenrod;
			int lw = 5;
			private DashStyle ls = DashStyle.DashDotDot;
		    int lsp = 20;

		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			AutoScale			= false;
			DisplayInDataBox 	= false; 
            CalculateOnBarClose	= false;
			PaintPriceMarkers 	= false; 
			if (onPricePanel)
			{
				Overlay				= true;
			}
			else
			{
				Overlay     		= false;
				DrawOnPricePanel    = false; 		
			}
			
						
			TodaysHigh = new DataSeries(this);
			TodaysMidLine = new DataSeries(this);
			TodaysLow = new DataSeries(this);
			TodaysOpen = new DataSeries(this);
			LastBarOfToday = new DataSeries(this);
			
			now = DateTime.Today;     // today date
			startDay = now.AddDays(-daysBack);  // days back
		}

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {

					
			if (CurrentBar < 1)
				return;
			
	
			int sessionsBarsAgo = 0;
			//DateTime bar = new DateTime(Bars.GetSessionBar(sessionsBarsAgo).Time.Year, Bars.GetSessionBar(sessionsBarsAgo).Time.Month, Bars.GetSessionBar(sessionsBarsAgo).Time.Day, Bars.SessionBegin.Hour, Bars.SessionBegin.Minute, Bars.SessionBegin.Second);
			DateTime bar = Time[0].Date;
			string format = "MM/dd/yyyy";

			
			// draw balance line if today start
			if (bar.ToString(format) == now.ToString(format))
			 {		
				
				if (cnt <= daysBack - 1)
				{
				DrawTextFixed("error msg", "not enough days for days back calculation", TextPosition.BottomRight);
				return;
				}
				

				
				
				if (arrayH[cnt-daysBack] > arrayH[cnt-(daysBack-1)])
				{
				DrawTriangleDown("Stop High" ,true,CurrentBar-arrayHbar[cnt-daysBack], arrayH[cnt-daysBack] + TickSize, Color.Red);
				maxTodaysHigh = arrayH[cnt-daysBack];
					hBar = CurrentBar-arrayHbar[cnt-daysBack];
				}
				else
				{
				DrawTriangleDown("Stop High" ,true, CurrentBar-arrayHbar[cnt-(daysBack-1)], arrayH[cnt-(daysBack-1)] + TickSize, Color.Red);
				maxTodaysHigh = arrayH[cnt-(daysBack-1)];
					hBar = CurrentBar-arrayHbar[cnt-(daysBack-1)];
				}
				
				if (arrayL[cnt-daysBack] < arrayL[cnt-(daysBack-1)])
				{
				DrawTriangleUp("Stop Low" ,true, CurrentBar-arrayLbar[cnt-daysBack], arrayL[cnt-daysBack] - TickSize, Color.Blue);
				minTodaysLow = arrayL[cnt-daysBack];
					lBar = CurrentBar-arrayLbar[cnt-daysBack];
				}
				else
				{
				DrawTriangleUp("Stop Low" , true,CurrentBar-arrayLbar[cnt-(daysBack-1)], arrayL[cnt-(daysBack-1)] + TickSize, Color.Blue);
				minTodaysLow = arrayL[cnt-(daysBack-1)];
					lBar = CurrentBar-arrayLbar[cnt-(daysBack-1)];
				}
				
				todaysLow = minTodaysLow; 
				todaysHigh = maxTodaysHigh; 
				todaysMidLine = ((todaysHigh - todaysLow)/2)+todaysLow;
				double value = Instrument.MasterInstrument.Round2TickSize(todaysMidLine); 
				if (lBar > hBar)
				DrawRay("ray"+daysBack,true, lBar, value, 0, value, rangeColor,ls,lw);
				else
				DrawRay("ray"+daysBack, true, hBar, value, 0, value, rangeColor,ls,lw);
				
				DrawText("days"+daysBack, true, " Days back: "+daysBack + "  Level "+ value.ToString(), lsp, value, 10, Color.Black, textFont, 
				     StringAlignment.Center, Color.Empty, Color.Empty, 100) ;
				
			}
			
		else {
			
						if (High[0]>maxTodaysHigh) 
						{
							maxTodaysHigh = High[0];
							hBar = CurrentBar;
				DrawTriangleDown("Stop High"+cnt , true, 0, High[0] + TickSize, Color.LightGray);
							arrayH[cnt] = High[0];
							arrayHbar[cnt] = CurrentBar;
						}
						if (Low[0]<minTodaysLow) 
						{
							minTodaysLow = Low[0];
							lBar = CurrentBar;
				DrawTriangleUp("Stop Low" +cnt ,true, 0, Low[0] - TickSize, Color.LightGray);
							arrayL[cnt] = Low[0];
							arrayLbar[cnt] = CurrentBar;
						}
						
						todaysLow = minTodaysLow; 
						todaysHigh = maxTodaysHigh; 
						todaysMidLine = ((todaysHigh - todaysLow)/2)+todaysLow;
								
			//load today mid-line value into array

			if (todaysMidLine > 0 )
			{
				arrayRay[cnt] = todaysMidLine;
				if (arrayRay[cnt] <= 0 )
				    arrayBar[cnt] = CurrentBar;
			}	

	
		// new session initialize H/L start position
		if (Bars.SessionBreak )           // new session 
			{
			arrayBar[cnt] = CurrentBar;  // starting position of an array
            cnt = cnt + 1;
			maxTodaysHigh 			= 0;
			minTodaysLow 			= 999999999.99;	
		    }	
			

			}
							
  	    }
		


        #region Properties
      

 		[Description("Specify which day from today to see balance line")]
		[Category("Parameters")]
		[Gui.Design.DisplayName("Days back")]
		public int DayBack
		{
			get { return daysBack; }
			set { daysBack = Math.Max(value, 0); }
		}
 			[XmlIgnore()]
		[Description("Line Color")]
		[Category("Visual")]
		[Gui.Design.DisplayName("Line Color")]
		public Color LineColor
		{
			get { return rangeColor; }
			set { rangeColor = value; }
		}
	
        [Description("Line Width")]
        [Category("Visual")]
        public int LineWidth
        {
        get { return lw; }
        set { lw = Math.Max(1, value); }
        }
		[Description("Right margin for text")]
        [Category("Visual")]
        public int RightMargin
        {
        get { return lsp; }
        set { lsp = Math.Max(1, value); }
        }
		[XmlIgnore()]
        [Description("Line Style")]
        [Category("Visual")]
        public DashStyle LineStyle
        {
    		get { return ls; }
			set { ls = value; }
		}
		[Browsable(false)]
		public string RangeColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(rangeColor); }
			set { rangeColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BalanceLine[] cacheBalanceLine = null;

        private static BalanceLine checkBalanceLine = new BalanceLine();

        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        public BalanceLine BalanceLine(int dayBack)
        {
            return BalanceLine(Input, dayBack);
        }

        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        public BalanceLine BalanceLine(Data.IDataSeries input, int dayBack)
        {
            if (cacheBalanceLine != null)
                for (int idx = 0; idx < cacheBalanceLine.Length; idx++)
                    if (cacheBalanceLine[idx].DayBack == dayBack && cacheBalanceLine[idx].EqualsInput(input))
                        return cacheBalanceLine[idx];

            lock (checkBalanceLine)
            {
                checkBalanceLine.DayBack = dayBack;
                dayBack = checkBalanceLine.DayBack;

                if (cacheBalanceLine != null)
                    for (int idx = 0; idx < cacheBalanceLine.Length; idx++)
                        if (cacheBalanceLine[idx].DayBack == dayBack && cacheBalanceLine[idx].EqualsInput(input))
                            return cacheBalanceLine[idx];

                BalanceLine indicator = new BalanceLine();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.DayBack = dayBack;
                Indicators.Add(indicator);
                indicator.SetUp();

                BalanceLine[] tmp = new BalanceLine[cacheBalanceLine == null ? 1 : cacheBalanceLine.Length + 1];
                if (cacheBalanceLine != null)
                    cacheBalanceLine.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBalanceLine = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BalanceLine BalanceLine(int dayBack)
        {
            return _indicator.BalanceLine(Input, dayBack);
        }

        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        public Indicator.BalanceLine BalanceLine(Data.IDataSeries input, int dayBack)
        {
            return _indicator.BalanceLine(input, dayBack);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BalanceLine BalanceLine(int dayBack)
        {
            return _indicator.BalanceLine(Input, dayBack);
        }

        /// <summary>
        /// Fifty percent line for a day using prev days H and L 
        /// </summary>
        /// <returns></returns>
        public Indicator.BalanceLine BalanceLine(Data.IDataSeries input, int dayBack)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BalanceLine(input, dayBack);
        }
    }
}
#endregion
