/*

Date: 20091024 Version: 0.4
Added audio alert for minute chart - will alert 1 minute before close and on the close
Thanks to Prtester for the code

Date: 20091024 Version: 0.3
Added option to display volume or not

Date: 20091018 Version: 0.2
Added an audio alert for HVC for tick charts. Will do it for minute charts soon. 

Date: 20090914 Version: 0.1p2
Fixed bug where paintbars are yellow instead of default color

Date: 20090912 Version: 0.1p1
Added CurrentBar < 2 return 

Date: 20090912 Version: 0.1
Initial version




This is a port of the Better Volume indicator for NinjaTrader.

Tradestation supports historical upticks & downticks but Ninjatrader doesn't (in v6.5).

Since I only use LV & HVC bars in my daytrading and these do not require upticks & downticks,
I ported the algorithm for these two patterns only.  Supporting Climax bars would require
upticks & downticks which can be done in Ninjatrader but it only works real time.  If you need
this I encourage you to buy the Ninjatrader version from eminiwatch.

See eminiwatch for details on how to use this indicator, including videos and examples:

http://emini-watch.com/free-stuff/volume-indicator/

And see "Learn to use Volume in your trading" at BigMikeTrading for a discussion on using this indicator:

http://forum.bigmiketrading.com/general-discussion/634-how-use-volume-your-trading.html

and most importantly thanks to Barry for giving us this wonderful tool.

-cunparis

*/

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Volume Patterns based on Better Volume from emini watch
    /// </summary>
    [Description("Volume Patterns based on Better Volume from emini watch")]
    public class VolumePatterns : Indicator
    {
        #region Variables
            private int lookback = 20; // Default setting for Lookback
			private bool paintbars = true; // Default setting for Paintbars
			private DataSeries hvcRatio;
			private DataSeries hvcRatio2;
			private DataSeries volume2;
		
			private String  hvcWavFile = "HVC.wav";
			private bool hvcAlert = true;
			private bool showVolume = true;
			private int volumeMaPeriod = 20;
			private int lastSoundAfterClose = 0;	
			private int lastSoundBeforeClose = 0;	
			
			private const int LV = 1;
			private const int HVC = 2;

        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			Add(new Plot(new Pen(Color.Cyan, 2), PlotStyle.Bar, "VBar"));
			Add(new Plot(new Pen(Color.Yellow, 2), PlotStyle.Bar, "LVBar"));
			Add(new Plot(new Pen(Color.Blue, 2), PlotStyle.Bar, "HVCBar"));
			Add(new Plot(Color.Red, "VOLMA"));

			hvcRatio = new DataSeries(this);
			hvcRatio2 = new DataSeries(this);
			volume2 = new DataSeries(this);
			
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if(CurrentBar < 2) {
				return;
			}
			
			int plotIndex = 0;
			
			hvcRatio.Set(Volume[0] / (High[0] - Low[0]));
			if(HighestBar(hvcRatio, lookback) == 0) {
				plotIndex = HVC;
			}
			hvcRatio2.Set((Volume[0] + Volume[1]) / (MAX(High,2)[0] - MIN(Low,2)[0]));
			if(HighestBar(hvcRatio2, lookback) == 0) {
				plotIndex = HVC;
			}
			if(LowestBar(Volume, lookback) == 0) {
				plotIndex = LV;
			}
			volume2.Set(Volume[0] + Volume[1]);
			if(LowestBar(volume2, lookback) == 0) {
				plotIndex = LV;
			}

			// still working on this one
//			if Volume[0] > 1.1*SMA(Volume, 10) && Math.Abs(Close[0]-Open[0]) <= 0.25 & Range <= Average(Range, 10) then
//				BarColor = DarkBlue;
			
			if(showVolume) {
				Values[plotIndex].Set(Volume[0]); 
				Values[3].Set(SMA(Volume, volumeMaPeriod)[0]);
			}
			if (paintbars && plotIndex > 0) {
				BarColor = Plots[plotIndex].Pen.Color;
			} else {
				BarColor = Color.Empty;
			}
			
			if(hvcAlert && plotIndex == HVC) {
				if(Bars.Period.Id == PeriodType.Tick) {
					float warning = (int)((float)Bars.Period.Value*0.75);
					if(Bars.TickCount == warning || Bars.TickCount == Bars.Period.Value) {
						PlaySound(hvcWavFile);
					}
				}
				if(Bars.Period.Id == PeriodType.Minute) {
					int now = ToTime(DateTime.Now) / 100;
					int lastBarTime = ToTime(Time[1]) / 100;
					int warning = Bars.Period.Value - 1;
					if(now - lastBarTime == warning && lastSoundBeforeClose != CurrentBar) {
						lastSoundBeforeClose = CurrentBar;
						PlaySound(hvcWavFile);
					}
					if(now - lastBarTime == Bars.Period.Value && lastSoundAfterClose != CurrentBar) {
						lastSoundAfterClose = CurrentBar;
						PlaySound(hvcWavFile);
					}
				}
			}
			
	       }

        #region Properties

        [Description("VolumeMaPeriod")]
        [Category("Parameters")]
        public int VolumeMaPeriod
        {
            get { return volumeMaPeriod; }
            set { volumeMaPeriod = value; }
        }

		[Description("ShowVolume")]
        [Category("Parameters")]
        public bool ShowVolume
        {
            get { return showVolume; }
            set { showVolume = value; }
        }

        [Description("HvcWavFile")]
        [Category("Parameters")]
        public string HvcWavFile
        {
            get { return hvcWavFile; }
            set { hvcWavFile = value; }
        }

        [Description("HvcAlert")]
        [Category("Parameters")]
        public bool HvcAlert
        {
            get { return hvcAlert; }
            set { hvcAlert = value; }
        }
		
//		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
//        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
//        public DataSeries VBar
//        {
//            get { return Values[0]; }
//        }
//
//        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
//        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
//        public DataSeries LVBar
//        {
//            get { return Values[1]; }
//        }
//
//        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
//        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
//        public DataSeries HVCBar
//        {
//            get { return Values[2]; }
//        }
//
//	    [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
//        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
//        public DataSeries VolEMA
//        {
//            get { return Values[3]; }
//        }
//
        [Description("Lookback")]
        [Category("Parameters")]
        public int Lookback
        {
            get { return lookback; }
            set { lookback = Math.Max(2, value); }
        }

		[Description("True=show paintbars, false=leave price bars alone.")]
        [Category("Parameters")]
        public bool Paintbars
        {
            get { return paintbars; }
            set { paintbars = value; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private VolumePatterns[] cacheVolumePatterns = null;

        private static VolumePatterns checkVolumePatterns = new VolumePatterns();

        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        public VolumePatterns VolumePatterns(bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            return VolumePatterns(Input, hvcAlert, hvcWavFile, lookback, paintbars, showVolume, volumeMaPeriod);
        }

        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        public VolumePatterns VolumePatterns(Data.IDataSeries input, bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            checkVolumePatterns.HvcAlert = hvcAlert;
            hvcAlert = checkVolumePatterns.HvcAlert;
            checkVolumePatterns.HvcWavFile = hvcWavFile;
            hvcWavFile = checkVolumePatterns.HvcWavFile;
            checkVolumePatterns.Lookback = lookback;
            lookback = checkVolumePatterns.Lookback;
            checkVolumePatterns.Paintbars = paintbars;
            paintbars = checkVolumePatterns.Paintbars;
            checkVolumePatterns.ShowVolume = showVolume;
            showVolume = checkVolumePatterns.ShowVolume;
            checkVolumePatterns.VolumeMaPeriod = volumeMaPeriod;
            volumeMaPeriod = checkVolumePatterns.VolumeMaPeriod;

            if (cacheVolumePatterns != null)
                for (int idx = 0; idx < cacheVolumePatterns.Length; idx++)
                    if (cacheVolumePatterns[idx].HvcAlert == hvcAlert && cacheVolumePatterns[idx].HvcWavFile == hvcWavFile && cacheVolumePatterns[idx].Lookback == lookback && cacheVolumePatterns[idx].Paintbars == paintbars && cacheVolumePatterns[idx].ShowVolume == showVolume && cacheVolumePatterns[idx].VolumeMaPeriod == volumeMaPeriod && cacheVolumePatterns[idx].EqualsInput(input))
                        return cacheVolumePatterns[idx];

            VolumePatterns indicator = new VolumePatterns();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.HvcAlert = hvcAlert;
            indicator.HvcWavFile = hvcWavFile;
            indicator.Lookback = lookback;
            indicator.Paintbars = paintbars;
            indicator.ShowVolume = showVolume;
            indicator.VolumeMaPeriod = volumeMaPeriod;
            indicator.SetUp();

            VolumePatterns[] tmp = new VolumePatterns[cacheVolumePatterns == null ? 1 : cacheVolumePatterns.Length + 1];
            if (cacheVolumePatterns != null)
                cacheVolumePatterns.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheVolumePatterns = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumePatterns VolumePatterns(bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            return _indicator.VolumePatterns(Input, hvcAlert, hvcWavFile, lookback, paintbars, showVolume, volumeMaPeriod);
        }

        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumePatterns VolumePatterns(Data.IDataSeries input, bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            return _indicator.VolumePatterns(input, hvcAlert, hvcWavFile, lookback, paintbars, showVolume, volumeMaPeriod);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumePatterns VolumePatterns(bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            return _indicator.VolumePatterns(Input, hvcAlert, hvcWavFile, lookback, paintbars, showVolume, volumeMaPeriod);
        }

        /// <summary>
        /// Volume Patterns based on Better Volume from emini watch
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumePatterns VolumePatterns(Data.IDataSeries input, bool hvcAlert, string hvcWavFile, int lookback, bool paintbars, bool showVolume, int volumeMaPeriod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VolumePatterns(input, hvcAlert, hvcWavFile, lookback, paintbars, showVolume, volumeMaPeriod);
        }

    }
}
#endregion
