
#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// historic volatility indicator by Michael Krause, scriabinop23@gmail.com. http://scriabinop23.blogspot.com
	/// 2/1/2008
    /// </summary>
    [Description("historical volatility")]
    public class HistVolAny : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 9; // Default setting for Period
            private int interval = 6; // Default setting for Interval
			private double sumsqdev = 0;
			private double sumnatlog = 0;
			private double closeratio = 0;
			private double mean = 0;
			private int sessioncount = 0;
			private double histvolatile = 0 ;
			private double[] natlog;
			private double[] squareddeviation;
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.Red, PlotStyle.Line, "Historic Volatility of any timeframe"));
            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= true;
			natlog = new double[period];
		    squareddeviation = new double[period];

        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			// Only allow this to run in a minute type period.  
			if (CurrentBar < period+1 ||
				(Bars.Period.Id == PeriodType.Tick)
				||(Bars.Period.Id == PeriodType.Range)
				||(Bars.Period.Id == PeriodType.Second)
				||(Bars.Period.Id == PeriodType.Volume)
				||(Bars.Period.Id == PeriodType.Year))
			{Value.Set(0);
				return;}
			for (int i=0; i < period; i++)
			{
				closeratio = Close[i]/Close[i+1];
				natlog[i] = Math.Log(closeratio);
			}
			for (int i=0; i < period; i++)
				sumnatlog += natlog[i];
			mean = sumnatlog / period;
			for (int i=0; i < period; i++)
				squareddeviation[i] = Math.Pow(natlog[i] - mean,2) ;
			for (int i=0; i < period; i++)
				sumsqdev += squareddeviation[i];
			if (Bars.Period.Id == PeriodType.Minute)
				histvolatile = Math.Sqrt(Math.Abs(sumsqdev/ period)) * Math.Sqrt(252*1440/Bars.Period.Value)*100;
			else
			if (Bars.Period.Id == PeriodType.Day)
				histvolatile = Math.Sqrt(Math.Abs(sumsqdev/ period)) * Math.Sqrt(252/Bars.Period.Value)*100;
			else
			if (Bars.Period.Id == PeriodType.Week)
				histvolatile = Math.Sqrt(Math.Abs(sumsqdev/ period)) * Math.Sqrt(52/Bars.Period.Value)*100;
			if (Bars.Period.Id == PeriodType.Month)
				histvolatile = Math.Sqrt(Math.Abs(sumsqdev/ period)) * Math.Sqrt(12/Bars.Period.Value)*100;
			
			sumnatlog =0; //reset variables for next iteration
			sumsqdev  =0; //ditto

		Value.Set(histvolatile);
			
      
		}
		
        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Value
        {
            get { return Values[0]; }
        }

        [Description("period")]
        [Category("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private HistVolAny[] cacheHistVolAny = null;

        private static HistVolAny checkHistVolAny = new HistVolAny();

        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        public HistVolAny HistVolAny(int period)
        {
            return HistVolAny(Input, period);
        }

        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        public HistVolAny HistVolAny(Data.IDataSeries input, int period)
        {
            checkHistVolAny.Period = period;
            period = checkHistVolAny.Period;

            if (cacheHistVolAny != null)
                for (int idx = 0; idx < cacheHistVolAny.Length; idx++)
                    if (cacheHistVolAny[idx].Period == period && cacheHistVolAny[idx].EqualsInput(input))
                        return cacheHistVolAny[idx];

            HistVolAny indicator = new HistVolAny();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Period = period;
            indicator.SetUp();

            HistVolAny[] tmp = new HistVolAny[cacheHistVolAny == null ? 1 : cacheHistVolAny.Length + 1];
            if (cacheHistVolAny != null)
                cacheHistVolAny.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheHistVolAny = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HistVolAny HistVolAny(int period)
        {
            return _indicator.HistVolAny(Input, period);
        }

        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        public Indicator.HistVolAny HistVolAny(Data.IDataSeries input, int period)
        {
            return _indicator.HistVolAny(input, period);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HistVolAny HistVolAny(int period)
        {
            return _indicator.HistVolAny(Input, period);
        }

        /// <summary>
        /// historical volatility
        /// </summary>
        /// <returns></returns>
        public Indicator.HistVolAny HistVolAny(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.HistVolAny(input, period);
        }

    }
}
#endregion
