#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Original: GomCDSMA by "gomifromparis"
	/// Link: http://www.ninjatrader-support2.com/vb/showthread.php?t=23283&highlight=gomcd
	/// Modified by: "betaride"; added code for rising/falling GomCDSMA plot color; added "zero line" plot; 
	/// Date: 2/17/2010
    /// </summary>
    [Description("Paint the GomCDSMA plot in different color if it's rising or falling.")]
     public class GomCDSMA_UpDown : Indicator
{
#region Variables 
		Indicator indic;
		GomCD gcd;
		bool initdone=false; 
	
		int period=5;
			
		private DataSeries GCDSMA;
#endregion
 
protected override void Initialize()
{
		// Adds a plot for the GomCDSMA values to be stored in
		Add(new Plot(Color.Lime, PlotStyle.Line, "MARising"));
		Add(new Plot(Color.Red, PlotStyle.Line, "MAFalling"));
		Add(new Line(Color.Transparent, 0, "Zero Line"));
	
		GCDSMA = new DataSeries(this);	
			
		CalculateOnBarClose = true;
		Overlay = false;
		PriceTypeSupported = false; 
		
		indic=SMA(GomCD(GomCDCalculationModeType.BidAsk,GomCDChartType.CumulativeChart,GomFileFormat.Binary,GomFilterModeType.None,1,false).DeltaClose,period);
}
 
protected override void OnBarUpdate()
{ 	
		// Make sure we have at least two bars
		if ( CurrentBar < 2 )
		return;

		// Sets the plot to be equal to the GomCDSMA plot
		GCDSMA.Set(indic[0]);
		

		if (GCDSMA[1] < GCDSMA[0])
		{
			MARising[1] = GCDSMA[1];
			MARising.Set(GCDSMA[0]);
		}
			else
		{
			MAFalling[1] = GCDSMA[1];
			MAFalling.Set(GCDSMA[0]);
		}
}
 

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
        [Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MAFalling
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MARising
        {
            get { return Values[0]; }
        }
        #endregion
}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomCDSMA_UpDown[] cacheGomCDSMA_UpDown = null;

        private static GomCDSMA_UpDown checkGomCDSMA_UpDown = new GomCDSMA_UpDown();

        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public GomCDSMA_UpDown GomCDSMA_UpDown(int period)
        {
            return GomCDSMA_UpDown(Input, period);
        }

        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public GomCDSMA_UpDown GomCDSMA_UpDown(Data.IDataSeries input, int period)
        {
            checkGomCDSMA_UpDown.Period = period;
            period = checkGomCDSMA_UpDown.Period;

            if (cacheGomCDSMA_UpDown != null)
                for (int idx = 0; idx < cacheGomCDSMA_UpDown.Length; idx++)
                    if (cacheGomCDSMA_UpDown[idx].Period == period && cacheGomCDSMA_UpDown[idx].EqualsInput(input))
                        return cacheGomCDSMA_UpDown[idx];

            GomCDSMA_UpDown indicator = new GomCDSMA_UpDown();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Period = period;
            indicator.SetUp();

            GomCDSMA_UpDown[] tmp = new GomCDSMA_UpDown[cacheGomCDSMA_UpDown == null ? 1 : cacheGomCDSMA_UpDown.Length + 1];
            if (cacheGomCDSMA_UpDown != null)
                cacheGomCDSMA_UpDown.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheGomCDSMA_UpDown = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomCDSMA_UpDown GomCDSMA_UpDown(int period)
        {
            return _indicator.GomCDSMA_UpDown(Input, period);
        }

        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public Indicator.GomCDSMA_UpDown GomCDSMA_UpDown(Data.IDataSeries input, int period)
        {
            return _indicator.GomCDSMA_UpDown(input, period);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomCDSMA_UpDown GomCDSMA_UpDown(int period)
        {
            return _indicator.GomCDSMA_UpDown(Input, period);
        }

        /// <summary>
        /// Paint the GomCDSMA plot in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public Indicator.GomCDSMA_UpDown GomCDSMA_UpDown(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomCDSMA_UpDown(input, period);
        }

    }
}
#endregion
