#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
	/// Original: GomDeltaVolume by "gomifromparis"
	/// Link: http://www.ninjatrader-support2.com/vb/showthread.php?t=23283&highlight=gomcd
	/// Modified by: "betaride"; added option for "negative delta" plot below zero line; added "zero line" plot; disabled TotalVolume plot/calc 
	/// Date: 2/17/2010
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class GomDeltaVol_UpDown : GomRecorderIndicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
		
		int lastcalcbar;
//		int totalvolume, upvolume,downvolume,deltavolume;
		int upvolume,downvolume,deltavolume;
		
//		bool Showtotalvolume=true;
//		bool Deltamode=true;
		bool NegativeBelowZero=true;
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void GomInitialize()
        {
            Add(new Plot(new Pen(Color.Green, 3), PlotStyle.Bar, "UpVolume"));
            Add(new Plot(new Pen(Color.Red, 3), PlotStyle.Bar, "DownVolume"));
//			Add(new Plot(new Pen(Color.Blue, 3), PlotStyle.Bar, "TotalVolume"));
			Add(new Line(Color.DimGray, 0, "Zero Line"));
			
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

		
		void PlotChart()
//		{
//			if (Showtotalvolume)
//				TotalVolume.Set(totalvolume);
//			
//			if (deltamode)
			{
				if (deltavolume>0)
				{
					UpVolume.Set(deltavolume);
					DownVolume.Set(0);
				}
				else if (deltavolume<0)
				{
					if (NegativeBelowZero)
					{
					UpVolume.Set(0);
					DownVolume.Set(-deltavolume);
					}
					else
					{					
					UpVolume.Set(0);
					DownVolume.Set(deltavolume);
					}
				}
				else
				{
					UpVolume.Set(0);
					DownVolume.Set(0);
				}
			}
//			else
//			{
//				UpVolume.Set(upvolume);
//				DownVolume.Set(downvolume);
//			}
//
//			
//		}
		
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void GomOnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			
			
			if ((lastcalcbar<CurrentBar)&&(lastcalcbar>0)&&(CurrentBar>1))

            {
//				totalvolume=0;
            	upvolume=0;
           		downvolume=0;
				deltavolume=0;
			}
			
			PlotChart();
			
        }
		
		protected override void GomOnMarketData(TickTypeEnum tickType,double price,int volume,bool firstTickOfBar)	
		{									
			int delta=0;
			
			if ((tickType==TickTypeEnum.BelowBid)||(tickType==TickTypeEnum.AtBid))
				delta =-volume;
			else if ((tickType==TickTypeEnum.AboveAsk)||(tickType==TickTypeEnum.AtAsk))
				delta=volume;

//			totalvolume += volume;
		
			if (delta>0)
				upvolume+=delta;
			if (delta<0)
				downvolume+=delta;
			
			deltavolume +=delta;
			
			PlotChart();

			lastcalcbar=CurrentBar;
		
		}

		

        #region Properties
//        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
//        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
//        public DataSeries TotalVolume
//        {
//            get { return Values[2]; }
//        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries UpVolume
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DownVolume
        {
            get { return Values[1]; }
        }

		
//		[Description("Show Total Volume")]
//        [Category("Settings")]
//		[Gui.Design.DisplayNameAttribute("Show Total Volume")]
//        public bool showtotalvolume 
//        {
//            get { return Showtotalvolume; }
//            set { Showtotalvolume = value; }
//        }
		
//		[Description("Delta Mode: Show AskVol-BidVol")]
//        [Category("Settings")]
//		[Gui.Design.DisplayNameAttribute("Delta Mode")]
//        public bool deltamode 
//        {
//            get { return Deltamode; }
//            set { Deltamode = value; }
//        }
		
		[Description("Delta Mode: Negative delta above zero line")]
        [Category("Settings")]
		[Gui.Design.DisplayNameAttribute("Negative delta above zero line")]
        public bool negativebelowzero 
        {
            get { return NegativeBelowZero; }
            set { NegativeBelowZero = value; }
        }
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomDeltaVol_UpDown[] cacheGomDeltaVol_UpDown = null;

        private static GomDeltaVol_UpDown checkGomDeltaVol_UpDown = new GomDeltaVol_UpDown();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomDeltaVol_UpDown GomDeltaVol_UpDown()
        {
            return GomDeltaVol_UpDown(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomDeltaVol_UpDown GomDeltaVol_UpDown(Data.IDataSeries input)
        {

            if (cacheGomDeltaVol_UpDown != null)
                for (int idx = 0; idx < cacheGomDeltaVol_UpDown.Length; idx++)
                    if (cacheGomDeltaVol_UpDown[idx].EqualsInput(input))
                        return cacheGomDeltaVol_UpDown[idx];

            GomDeltaVol_UpDown indicator = new GomDeltaVol_UpDown();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.SetUp();

            GomDeltaVol_UpDown[] tmp = new GomDeltaVol_UpDown[cacheGomDeltaVol_UpDown == null ? 1 : cacheGomDeltaVol_UpDown.Length + 1];
            if (cacheGomDeltaVol_UpDown != null)
                cacheGomDeltaVol_UpDown.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheGomDeltaVol_UpDown = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomDeltaVol_UpDown GomDeltaVol_UpDown()
        {
            return _indicator.GomDeltaVol_UpDown(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomDeltaVol_UpDown GomDeltaVol_UpDown(Data.IDataSeries input)
        {
            return _indicator.GomDeltaVol_UpDown(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomDeltaVol_UpDown GomDeltaVol_UpDown()
        {
            return _indicator.GomDeltaVol_UpDown(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomDeltaVol_UpDown GomDeltaVol_UpDown(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomDeltaVol_UpDown(input);
        }

    }
}
#endregion
