#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class BuySellStrength : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int myInput0 = 1; // Default setting for MyInput0

        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Bar, "Plot0"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Green), PlotStyle.Bar, "Plot1"));
            Add(new Line(Color.FromKnownColor(KnownColor.Black), 0, "Zero"));
            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			
			
			if (CurrentBar < 1)
	        return;
						
			
			// bid is buyers
			// ask is sellers
			long bidvol = GetCurrentBidVolume();
			long askvol = GetCurrentAskVolume();

			int buysellstrength =  (int) askvol - (int) bidvol;
			
			//Print ("buysellstrength is "+buysellstrength+" bidvol = "+bidvol+" askvol = "+askvol);
			
			
			if( askvol > bidvol )
			{
				Plot1.Set(buysellstrength);  // green 			
			}
			else
			{
				Plot0.Set(buysellstrength);  // red 
			}
            //Plot0.Set(Close[0]); //red
            //Plot1.Set(Close[0]); //green
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot1
        {
            get { return Values[1]; }
        }

        [Description("")]
        [Category("Parameters")]
        public int MyInput0
        {
            get { return myInput0; }
            set { myInput0 = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BuySellStrength[] cacheBuySellStrength = null;

        private static BuySellStrength checkBuySellStrength = new BuySellStrength();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public BuySellStrength BuySellStrength(int myInput0)
        {
            return BuySellStrength(Input, myInput0);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public BuySellStrength BuySellStrength(Data.IDataSeries input, int myInput0)
        {
            if (cacheBuySellStrength != null)
                for (int idx = 0; idx < cacheBuySellStrength.Length; idx++)
                    if (cacheBuySellStrength[idx].MyInput0 == myInput0 && cacheBuySellStrength[idx].EqualsInput(input))
                        return cacheBuySellStrength[idx];

            lock (checkBuySellStrength)
            {
                checkBuySellStrength.MyInput0 = myInput0;
                myInput0 = checkBuySellStrength.MyInput0;

                if (cacheBuySellStrength != null)
                    for (int idx = 0; idx < cacheBuySellStrength.Length; idx++)
                        if (cacheBuySellStrength[idx].MyInput0 == myInput0 && cacheBuySellStrength[idx].EqualsInput(input))
                            return cacheBuySellStrength[idx];

                BuySellStrength indicator = new BuySellStrength();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MyInput0 = myInput0;
                Indicators.Add(indicator);
                indicator.SetUp();

                BuySellStrength[] tmp = new BuySellStrength[cacheBuySellStrength == null ? 1 : cacheBuySellStrength.Length + 1];
                if (cacheBuySellStrength != null)
                    cacheBuySellStrength.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBuySellStrength = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BuySellStrength BuySellStrength(int myInput0)
        {
            return _indicator.BuySellStrength(Input, myInput0);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.BuySellStrength BuySellStrength(Data.IDataSeries input, int myInput0)
        {
            return _indicator.BuySellStrength(input, myInput0);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BuySellStrength BuySellStrength(int myInput0)
        {
            return _indicator.BuySellStrength(Input, myInput0);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.BuySellStrength BuySellStrength(Data.IDataSeries input, int myInput0)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BuySellStrength(input, myInput0);
        }
    }
}
#endregion
