/* 
Clock & Lapsed Bar Time in Minutes & Seconds ONLY on Intraday charts - Mindset June 2010
Windows Start-Run "charmap" for symbols lookup if the separator dot fails to appear
Update timer keeps clock independent of OnBarUpdate() NB Lapsed time however still requires FirstTickOfBar to initiate.
If sound doesn't play there may be an error with the sound path - I found double slashes works on Windows 7 but try single slashes or @/ instead.
There can also be an error when your .wav file isn't a pcm type .wav file see 
http://www.ninjatrader.com/support/forum/showthread.php?t=28025&highlight=pcm+wav+file
July 2 - More user friendly clock positioning via enum.
error on 30s chart - requires F5 before Clock appears. 
*/

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
using System.Windows.Forms;
using NinjaTrader.Strategy;
#endregion
namespace NinjaTrader.Indicator
{
	[Description("Displays time countdown of interval based bar series")]
	public class BarTimerFlash3 : Indicator
	{
		#region Variables
				
		private	string						errorDisabled		= "Bar timer disabled since either you are disconnected or current time is outside session time or chart end date";
		private	string						errorIntraday		= "Bar timer only works on intraday TIME based intervals";
		private string 						timeLeft 			= String.Empty;
		private StringFormat				stringFormat		= new StringFormat();
		Font								textFont	        = new Font("Verdana", 8F);
		Font 								textFont2			 = new Font("Bodoni MT Condensed", 69F);
		private int							textWidth			= 0;
		private int							textHeight			= 0;
		private float						noTickTextWidth		= 0;
        private float						noTickTextHeight	= 0;
		private float						noConTextWidth		= 0;
		private float						noConTextHeight		= 0;
		private SizeF						size				   ;
		private SizeF						noConSize			   ;
		
		private Rectangle bounds;
		private int max;
		private int min;
		private Graphics graphics;
				
		private Timer updateTimer 								= new Timer();
		private bool 						update				= true;//else error messages
		private String						separator			= ":";
		private	DateTime					lastTimePlot		= Cbi.Globals.MinDate;
		
		private Color FlashColor 								= Color.HotPink;
		private Color TextColor									= Color.Blue;
		private Color Flash_Color2 								= Color.AntiqueWhite;
		private Color Flash_Color1								= Color.DarkGray;
		private SolidBrush					textBrush			= new SolidBrush(Color.Transparent);
		private ObjectPosition 				thisPosition		= ObjectPosition.TopLeft;
		#endregion
		
	

		#region Initialize and Terminate
		protected override void Initialize()
		{
			ChartOnly				  = true;
			Overlay					  = true;
			CalculateOnBarClose 	  = false;
			AllowRemovalOfDrawObjects = true;
		}
	
			protected override void OnStartUp()
		{
			textFont2			 = new Font(textFont, FontStyle.Bold);
			textBrush			 = new SolidBrush(TextColor);
			updateTimer.Tick 	+= new EventHandler(OnUpdateTimerTick);
			updateTimer.Interval = 100;// lower this you get a smoother clock but at the expense of more resources
			updateTimer.Start();
			this.ZOrder 		 = 1;//clock always on top
			
		}
		
			protected override void OnTermination()
        {
			updateTimer.Dispose();
			updateTimer.Tick -= new EventHandler(OnUpdateTimerTick);
		    if (updateTimer != null)
            {
                updateTimer.Enabled = false;
                updateTimer = null;
            }
			textFont2.Dispose();
			textBrush.Dispose();
			stringFormat.Dispose();
			
			
		}
		
		#endregion
		
		#region OnBarUpdate() 
			protected override void OnBarUpdate() 
			{ 
				
				if ( CurrentBar < 20  ) return;
				if(FirstTickOfBar) 
				{
				if (playsound)
				PlaySound(Cbi.Core.InstallDir.ToString()+"\\sounds\\Alert1.wav");//Beep.wav");//
				}

			}
		
		#endregion	

        #region Plot Override
        public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
{
            if (Bars == null)
                return;
			int ClockPlaceX = 0;
			int ClockPlaceY = 0;

		
switch (thisPosition)
			{			
		
				case ObjectPosition.BottomRight:
				ClockPlaceX = bounds.Right -  textWidth ;
				ClockPlaceY = bounds.Bottom - textHeight;
				break;
						
				case ObjectPosition.BottomLeft:
				ClockPlaceX = bounds.Left+5;
				ClockPlaceY = bounds.Bottom - textHeight;
				break;
		
				case ObjectPosition.TopRight:
				ClockPlaceX = bounds.Right -  textWidth ;
				ClockPlaceY = bounds.Y+5;
				break;
		
				case ObjectPosition.TopLeft:
				ClockPlaceX = bounds.Left + 5;
				ClockPlaceY = bounds.Y+5;
				break;
		
				case ObjectPosition.Centre:
				ClockPlaceX = bounds.Right - ((bounds.Right - bounds.Left)/2)- textWidth/2;
				ClockPlaceY = bounds.Bottom - ((bounds.Bottom - bounds.Top)/2)- textHeight/2;
				break;
		
				case ObjectPosition.TopCentre:
				ClockPlaceY = bounds.Top +7;
				ClockPlaceX = bounds.Right -bounds.Width/2;
				break;
		
				case ObjectPosition.BottomCentre:
				ClockPlaceY = bounds.Bottom -textHeight - 1;
				ClockPlaceX = bounds.Right -bounds.Width/2;
				break;
				
			}
			{
				SizeF noConSize = graphics.MeasureString(errorDisabled, textFont2);
				noConTextWidth	= noConSize.Width + 5;
				noConTextHeight = noConSize.Height + 5;
				
				SizeF noTickSize = graphics.MeasureString(errorIntraday, textFont2);
                noTickTextWidth = noTickSize.Width + 5;
                noTickTextHeight = noTickSize.Height + 5;
				
				SizeF size = graphics.MeasureString(timeLeft,textFont2);
                textWidth = (int)size.Width + 5 ;
                textHeight = (int)size.Height;// + 5;
			}	
           
            //## Plot the time remaining text
			if (Bars.Period.Id == PeriodType.Minute || Bars.Period.Id == PeriodType.Second)//only on minute or sub minute charts
			{
		
			if(update)
	{
					TimeSpan	barTimeLeft = Bars.Get(Bars.Count - 1).Time.Subtract(Now);
					
				if(DisplayType == DisplayType.LapsedTimeOnly)
						
				if(Bars.Period.Id == PeriodType.Second)
					timeLeft = (barTimeLeft.Ticks < 0 ? "•00" : "" + barTimeLeft.Seconds.ToString("00"));
				else
					timeLeft	= (barTimeLeft.Ticks < 0 ? "00•00" : "" + barTimeLeft.Minutes.ToString("00") +separator + barTimeLeft.Seconds.ToString("00"));
					
				if(DisplayType == DisplayType.All)
						
					timeLeft	= DateTime.Now.ToString("T")+ "\n[" + (barTimeLeft.Ticks < 0 ? "00"+separator+ "00]" : "" + barTimeLeft.Minutes.ToString("00")   + separator + barTimeLeft.Seconds.ToString("00")+"]");
				
				if(DisplayType == DisplayType.ClockOnly)
				timeLeft = DateTime.Now.ToString("T");
				
				if(playsound)
					{
					separator =  "•";//helps identify 'alarmed' charts		
					}
			
				if(FlashType != FlashType.None)
		{	
				float[] relativeIntensities = { 0.0f, 0.25f,0.5f,0.75f, 1.0f };// only really affects whole panel colourings
				//float[] relativePositions = { 0.0f, 0.25f,0.5f,0.75f, 1.0f };// higher nos increase grey intensity
				float[] relativePositions = { 0.0f, 0.1f,0.3f,0.7f, 1.0f };

				Blend myBlend 		= new Blend();
				myBlend.Factors 	= relativeIntensities;
				myBlend.Positions	= relativePositions;
		
				LinearGradientBrush linGrBrush = new LinearGradientBrush(
				new Point(0, bounds.X),
				new Point(0,bounds.Right),
	//				new PointF(z,a),//y1 for z pushes gray to upper right corner , for a switches diagonal around from top left to bottom right, to top right bottom left
	//				new PointF(a,z),//y1 for a = all grey, for z = all white
				Flash_Color1,//grey
				Flash_Color2);
		
				linGrBrush.Blend = myBlend;
						
				Pen pen = new Pen(linGrBrush);	
					graphics.DrawString( timeLeft, textFont2, textBrush,ClockPlaceX , ClockPlaceY, stringFormat);
				
					if (Alert > (int)barTimeLeft.TotalSeconds )
			{

				if((int)barTimeLeft.TotalSeconds % 2 < 1 )//alternate colors every second
				{
				if(FlashType == FlashType.WholePanel)
				graphics.FillRectangle(linGrBrush, bounds.X , bounds.Y, bounds.Right,  bounds.Height);//flashes the whole area
				
				if(FlashType == FlashType.ClockFaceOnly)
				graphics.FillRectangle(linGrBrush,ClockPlaceX, ClockPlaceY, textWidth,textHeight);//size.Width,  size.Height);//flashes rectangle only	
				
				if(FlashType == FlashType.TextOnly)
				graphics.DrawString( timeLeft, textFont2, linGrBrush,ClockPlaceX , ClockPlaceY, stringFormat);//Flashes Clock Text
				}
					
			}
	}
	
			if(FlashType != FlashType.TextOnly)//corrects bug for Text only flashing
					graphics.DrawString( timeLeft, textFont2, textBrush,ClockPlaceX , ClockPlaceY, stringFormat);
	}
			else
				graphics.DrawString(errorDisabled, textFont2, textBrush, bounds.X + bounds.Width - noConTextWidth, bounds.Y + bounds.Height - noConTextHeight, stringFormat);
			}
			else//if not seconds or minute charts
			{
				graphics.DrawString(errorIntraday, textFont2, textBrush, bounds.X + bounds.Width - noTickTextWidth, bounds.Y + bounds.Height - noTickTextHeight, stringFormat);
				if (updateTimer != null)
					updateTimer.Enabled = false;
			
			}
			
}

#endregion

		#region Timer Methods
        private bool DisplayTime()
        {
			if (ChartControl != null
					&& Bars != null
					&& Bars.Count > 0
					&& Bars.MarketData != null
					&& Bars.MarketData.Connection.PriceStatus == Cbi.ConnectionStatus.Connected
					&& (Bars.MarketData.Connection.Options.Provider != Cbi.Provider.OpenTick || !(Bars.MarketData.Connection.Options as Cbi.OpenTickOptions).UseDelayedData))
				return true;

            return false;
        }

		
		private void OnUpdateTimerTick(object sender, EventArgs e)
		{
		if (DateTime.Now.Subtract(lastTimePlot).Seconds >= 1 && DisplayTime())
			{
			    ChartControl.ChartPanel.Invalidate();//required???
				lastTimePlot = DateTime.Now;
			}	
		}
		

		private DateTime Now
		{
			get 
			{ 
				DateTime now = (Bars.MarketData.Connection.Options.Provider == Cbi.Provider.Replay ? Bars.MarketData.Connection.Now : DateTime.Now); 

				if (now.Millisecond > 0)
					now = Cbi.Globals.MinDate.AddSeconds((long) System.Math.Floor(now.Subtract(Cbi.Globals.MinDate).TotalSeconds));

				return now;
			}
		}
#endregion
		
        #region Properties
		
		
		[XmlIgnore]// very important
		[GridCategory("Text & Colors")]
		public Color flash_Color1
        {
            get { return Flash_Color1; }
            set { Flash_Color1 = value; }
        }
		
		[XmlIgnore]
		[Browsable(false)]
		public string Flash_Color1Serialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(Flash_Color1); }
			set { Flash_Color1 = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore]
		[GridCategory("Text & Colors")]
		public Color flash_Color2
        {
            get { return Flash_Color2; }
            set { Flash_Color2 = value; }
        }
		
		[XmlIgnore]
		[Browsable(false)]
		public string Flash_Color2Serialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(Flash_Color2); }
			set { Flash_Color2 = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		private bool playsound = false;
		[Description("Play sound file at start of each new bar")]
        [Category("Parameters")]
        [NinjaTrader.Gui.Design.DisplayNameAttribute("Sound Alert")]
        public bool Playsound
        {
            get { return this.playsound; }
            set { this.playsound = value; }
        }
		
		
		private FlashType flashType = FlashType.WholePanel;
        [Description("Select Clock Face or Whole Panel.\nNone disables flashing.")]
        [Category("Parameters")]
        public FlashType FlashType
        {
            get { return flashType; }
            set { flashType = value; }
        }
		
		private DisplayType displayType = DisplayType.LapsedTimeOnly;
        [Description("Show lapsed time only or with Actual time")]
        [Category("Parameters")]
        public DisplayType DisplayType
        {
            get { return displayType; }
            set { displayType = value; }
        }
		 
		private int alert = 5;
		[Description("Alert Time Interval")]
        [Category("Parameters")]
		[NinjaTrader.Gui.Design.DisplayNameAttribute("Alert(seconds)")]
        public int Alert
        {
            get { return alert; }
            set { alert = value; }
        }
		
       	[Description("Font")]
        [GridCategory("Text & Colors")]
        [Gui.Design.DisplayName("Font")]
        [VisualizationOnly, XmlIgnore]
        public System.Drawing.Font TextFont
        {
            get {return this.textFont;}
            set {this.textFont = value;}
        }  
		[Browsable(false)]
		public string FlashColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(FlashColor); }
			set { FlashColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		
		[Browsable(false)]
		public string TextColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(TextColor); }
			set { TextColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore]
		[GridCategory("Text & Colors")]
        [Gui.Design.DisplayName("Text Colour")]
		public Color textColor
        {
            get { return TextColor; }
            set { TextColor = value; }
        }
		
		[Description("Chart Position for the lapsed time & Clock")]
        [GridCategory("Position")]
		[NinjaTrader.Gui.Design.DisplayName("Clock position")]
		public ObjectPosition BoxPosition
		{
			get { return thisPosition; }
            set { thisPosition = value; }
		}
		

		

	  #endregion	
		
    }
	
}
public enum FlashType {None,WholePanel,ClockFaceOnly,TextOnly};
public enum DisplayType {All,LapsedTimeOnly,ClockOnly};
public enum ObjectPosition {	BottomRight,BottomLeft,TopRight,TopLeft,Centre,TopCentre,BottomCentre}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BarTimerFlash3[] cacheBarTimerFlash3 = null;

        private static BarTimerFlash3 checkBarTimerFlash3 = new BarTimerFlash3();

        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        public BarTimerFlash3 BarTimerFlash3(int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            return BarTimerFlash3(Input, alert, boxPosition, displayType, flash_Color1, flash_Color2, flashType, playsound, textColor, textFont);
        }

        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        public BarTimerFlash3 BarTimerFlash3(Data.IDataSeries input, int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            if (cacheBarTimerFlash3 != null)
                for (int idx = 0; idx < cacheBarTimerFlash3.Length; idx++)
                    if (cacheBarTimerFlash3[idx].Alert == alert && cacheBarTimerFlash3[idx].BoxPosition == boxPosition && cacheBarTimerFlash3[idx].DisplayType == displayType && cacheBarTimerFlash3[idx].flash_Color1 == flash_Color1 && cacheBarTimerFlash3[idx].flash_Color2 == flash_Color2 && cacheBarTimerFlash3[idx].FlashType == flashType && cacheBarTimerFlash3[idx].Playsound == playsound && cacheBarTimerFlash3[idx].textColor == textColor && cacheBarTimerFlash3[idx].TextFont == textFont && cacheBarTimerFlash3[idx].EqualsInput(input))
                        return cacheBarTimerFlash3[idx];

            lock (checkBarTimerFlash3)
            {
                checkBarTimerFlash3.Alert = alert;
                alert = checkBarTimerFlash3.Alert;
                checkBarTimerFlash3.BoxPosition = boxPosition;
                boxPosition = checkBarTimerFlash3.BoxPosition;
                checkBarTimerFlash3.DisplayType = displayType;
                displayType = checkBarTimerFlash3.DisplayType;
                checkBarTimerFlash3.flash_Color1 = flash_Color1;
                flash_Color1 = checkBarTimerFlash3.flash_Color1;
                checkBarTimerFlash3.flash_Color2 = flash_Color2;
                flash_Color2 = checkBarTimerFlash3.flash_Color2;
                checkBarTimerFlash3.FlashType = flashType;
                flashType = checkBarTimerFlash3.FlashType;
                checkBarTimerFlash3.Playsound = playsound;
                playsound = checkBarTimerFlash3.Playsound;
                checkBarTimerFlash3.textColor = textColor;
                textColor = checkBarTimerFlash3.textColor;
                checkBarTimerFlash3.TextFont = textFont;
                textFont = checkBarTimerFlash3.TextFont;

                if (cacheBarTimerFlash3 != null)
                    for (int idx = 0; idx < cacheBarTimerFlash3.Length; idx++)
                        if (cacheBarTimerFlash3[idx].Alert == alert && cacheBarTimerFlash3[idx].BoxPosition == boxPosition && cacheBarTimerFlash3[idx].DisplayType == displayType && cacheBarTimerFlash3[idx].flash_Color1 == flash_Color1 && cacheBarTimerFlash3[idx].flash_Color2 == flash_Color2 && cacheBarTimerFlash3[idx].FlashType == flashType && cacheBarTimerFlash3[idx].Playsound == playsound && cacheBarTimerFlash3[idx].textColor == textColor && cacheBarTimerFlash3[idx].TextFont == textFont && cacheBarTimerFlash3[idx].EqualsInput(input))
                            return cacheBarTimerFlash3[idx];

                BarTimerFlash3 indicator = new BarTimerFlash3();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Alert = alert;
                indicator.BoxPosition = boxPosition;
                indicator.DisplayType = displayType;
                indicator.flash_Color1 = flash_Color1;
                indicator.flash_Color2 = flash_Color2;
                indicator.FlashType = flashType;
                indicator.Playsound = playsound;
                indicator.textColor = textColor;
                indicator.TextFont = textFont;
                Indicators.Add(indicator);
                indicator.SetUp();

                BarTimerFlash3[] tmp = new BarTimerFlash3[cacheBarTimerFlash3 == null ? 1 : cacheBarTimerFlash3.Length + 1];
                if (cacheBarTimerFlash3 != null)
                    cacheBarTimerFlash3.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBarTimerFlash3 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BarTimerFlash3 BarTimerFlash3(int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            return _indicator.BarTimerFlash3(Input, alert, boxPosition, displayType, flash_Color1, flash_Color2, flashType, playsound, textColor, textFont);
        }

        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        public Indicator.BarTimerFlash3 BarTimerFlash3(Data.IDataSeries input, int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            return _indicator.BarTimerFlash3(input, alert, boxPosition, displayType, flash_Color1, flash_Color2, flashType, playsound, textColor, textFont);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BarTimerFlash3 BarTimerFlash3(int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            return _indicator.BarTimerFlash3(Input, alert, boxPosition, displayType, flash_Color1, flash_Color2, flashType, playsound, textColor, textFont);
        }

        /// <summary>
        /// Displays time countdown of interval based bar series
        /// </summary>
        /// <returns></returns>
        public Indicator.BarTimerFlash3 BarTimerFlash3(Data.IDataSeries input, int alert, ObjectPosition boxPosition, DisplayType displayType, Color flash_Color1, Color flash_Color2, FlashType flashType, bool playsound, Color textColor, System.Drawing.Font textFont)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BarTimerFlash3(input, alert, boxPosition, displayType, flash_Color1, flash_Color2, flashType, playsound, textColor, textFont);
        }
    }
}
#endregion
